/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.WindowStateServiceImpl;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

@State(name="WindowStateApplicationService", storages={@Storage(value="window.state.xml", roamingType=RoamingType.DISABLED)})
final class WindowStateApplicationService
extends WindowStateServiceImpl {
    WindowStateApplicationService() {
    }

    @Override
    Point getDefaultLocationFor(@NotNull String key2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/WindowStateApplicationService", "getDefaultLocationFor"));
        }
        return DimensionService.getInstance().getLocation(key2);
    }

    @Override
    Dimension getDefaultSizeFor(@NotNull String key2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/WindowStateApplicationService", "getDefaultSizeFor"));
        }
        return DimensionService.getInstance().getSize(key2);
    }

    @Override
    Rectangle getDefaultBoundsFor(@NotNull String key2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/WindowStateApplicationService", "getDefaultBoundsFor"));
        }
        Point location = this.getDefaultLocationFor(key2);
        if (location == null) {
            return null;
        }
        Dimension size = this.getDefaultSizeFor(key2);
        if (size == null) {
            return null;
        }
        return new Rectangle(location, size);
    }

    @Override
    boolean getDefaultMaximizedFor(Object object, @NotNull String key2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/WindowStateApplicationService", "getDefaultMaximizedFor"));
        }
        return 6 == DimensionService.getInstance().getExtendedState(key2);
    }
}

