/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.FrameState;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class WindowStateServiceImpl
extends WindowStateService
implements PersistentStateComponent<Element> {
    @NonNls
    private static final String KEY = "key";
    @NonNls
    private static final String STATE = "state";
    @NonNls
    private static final String X = "x";
    @NonNls
    private static final String Y = "y";
    @NonNls
    private static final String WIDTH = "width";
    @NonNls
    private static final String HEIGHT = "height";
    @NonNls
    private static final String MAXIMIZED = "maximized";
    @NonNls
    private static final String FULL_SCREEN = "full-screen";
    private static final Logger LOG = Logger.getInstance(WindowStateService.class);
    private final Map<String, WindowState> myStateMap = new TreeMap<String, WindowState>();

    WindowStateServiceImpl() {
    }

    abstract Point getDefaultLocationFor(@NotNull String var1);

    abstract Dimension getDefaultSizeFor(@NotNull String var1);

    abstract Rectangle getDefaultBoundsFor(@NotNull String var1);

    abstract boolean getDefaultMaximizedFor(Object var1, @NotNull String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Element getState() {
        Element element = new Element(STATE);
        Map<String, WindowState> map2 = this.myStateMap;
        synchronized (map2) {
            for (Map.Entry<String, WindowState> entry : this.myStateMap.entrySet()) {
                String key2 = entry.getKey();
                if (key2 == null) continue;
                WindowState state = entry.getValue();
                Element child = new Element(STATE);
                if (state.myLocation != null) {
                    child.setAttribute(X, Integer.toString(((WindowState)state).myLocation.x));
                    child.setAttribute(Y, Integer.toString(((WindowState)state).myLocation.y));
                }
                if (state.mySize != null) {
                    child.setAttribute(WIDTH, Integer.toString(((WindowState)state).mySize.width));
                    child.setAttribute(HEIGHT, Integer.toString(((WindowState)state).mySize.height));
                }
                if (state.myMaximized) {
                    child.setAttribute(MAXIMIZED, Boolean.toString(true));
                }
                if (state.myFullScreen) {
                    child.setAttribute(FULL_SCREEN, Boolean.toString(true));
                }
                child.setAttribute(KEY, key2);
                element.addContent(child);
            }
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadState(Element element) {
        Map<String, WindowState> map2 = this.myStateMap;
        synchronized (map2) {
            this.myStateMap.clear();
            for (Element child : element.getChildren()) {
                String key2;
                if (!STATE.equals(child.getName()) || (key2 = child.getAttributeValue(KEY)) == null) continue;
                Point location = null;
                try {
                    location = new Point(Integer.parseInt(child.getAttributeValue(X)), Integer.parseInt(child.getAttributeValue(Y)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                Dimension size = null;
                try {
                    size = new Dimension(Integer.parseInt(child.getAttributeValue(WIDTH)), Integer.parseInt(child.getAttributeValue(HEIGHT)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (location == null && size == null) continue;
                WindowState state = new WindowState();
                state.myLocation = location;
                state.mySize = size;
                state.myMaximized = Boolean.parseBoolean(child.getAttributeValue(MAXIMIZED));
                state.myFullScreen = Boolean.parseBoolean(child.getAttributeValue(FULL_SCREEN));
                this.myStateMap.put(key2, state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadStateFor(Object object, @NotNull String key2, @NotNull Component component) {
        Frame frame;
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY, "com/intellij/openapi/util/WindowStateServiceImpl", "loadStateFor"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/util/WindowStateServiceImpl", "loadStateFor"));
        }
        Point location = null;
        Dimension size = null;
        boolean maximized = false;
        Map<String, WindowState> map2 = this.myStateMap;
        synchronized (map2) {
            WindowState state = this.getFor(object, key2, WindowState.class);
            if (state != null) {
                location = state.myLocation;
                size = state.mySize;
                maximized = state.myMaximized;
            }
        }
        if (location == null && size == null) {
            location = this.getDefaultLocationFor(key2);
            if (!WindowStateServiceImpl.isVisible(location, size = this.getDefaultSizeFor(key2))) {
                return false;
            }
            maximized = this.getDefaultMaximizedFor(object, key2);
        }
        Frame frame2 = frame = component instanceof Frame ? (Frame)component : null;
        if (frame != null && 0 != frame.getExtendedState()) {
            frame.setExtendedState(0);
        }
        Rectangle bounds = component.getBounds();
        if (location != null) {
            bounds.setLocation(location);
        }
        if (size != null) {
            bounds.setSize(size);
        }
        if (bounds.isEmpty()) {
            bounds.setSize(component.getPreferredSize());
        }
        component.setBounds(bounds);
        if (maximized && frame != null) {
            frame.setExtendedState(6);
        }
        return true;
    }

    public void saveStateFor(Object object, @NotNull String key2, @NotNull Component component) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY, "com/intellij/openapi/util/WindowStateServiceImpl", "saveStateFor"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/util/WindowStateServiceImpl", "saveStateFor"));
        }
        FrameState state = FrameState.getFrameState(component);
        this.putFor(object, key2, state.getLocation(), true, state.getSize(), true, state.isMaximized(), true, state.isFullScreen(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getLocationFor(Object object, @NotNull String key2) {
        Point location;
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY, "com/intellij/openapi/util/WindowStateServiceImpl", "getLocationFor"));
        }
        Map<String, WindowState> map2 = this.myStateMap;
        synchronized (map2) {
            location = this.getFor(object, key2, Point.class);
        }
        return location != null ? location : this.getDefaultLocationFor(key2);
    }

    public void putLocationFor(Object object, @NotNull String key2, Point location) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY, "com/intellij/openapi/util/WindowStateServiceImpl", "putLocationFor"));
        }
        this.putFor(object, key2, location, true, null, false, false, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getSizeFor(Object object, @NotNull String key2) {
        Dimension size;
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY, "com/intellij/openapi/util/WindowStateServiceImpl", "getSizeFor"));
        }
        Map<String, WindowState> map2 = this.myStateMap;
        synchronized (map2) {
            size = this.getFor(object, key2, Dimension.class);
        }
        return size != null ? size : this.getDefaultSizeFor(key2);
    }

    public void putSizeFor(Object object, @NotNull String key2, Dimension size) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY, "com/intellij/openapi/util/WindowStateServiceImpl", "putSizeFor"));
        }
        this.putFor(object, key2, null, false, size, true, false, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getBoundsFor(Object object, @NotNull String key2) {
        Rectangle bounds;
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY, "com/intellij/openapi/util/WindowStateServiceImpl", "getBoundsFor"));
        }
        Map<String, WindowState> map2 = this.myStateMap;
        synchronized (map2) {
            bounds = this.getFor(object, key2, Rectangle.class);
        }
        return bounds != null ? bounds : this.getDefaultBoundsFor(key2);
    }

    public void putBoundsFor(Object object, @NotNull String key2, Rectangle bounds) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY, "com/intellij/openapi/util/WindowStateServiceImpl", "putBoundsFor"));
        }
        Point location = bounds == null ? null : bounds.getLocation();
        Dimension size = bounds == null ? null : bounds.getSize();
        this.putFor(object, key2, location, true, size, true, false, false, false, false);
    }

    private <T> T getFor(Object object, @NotNull String key2, @NotNull Class<T> type2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY, "com/intellij/openapi/util/WindowStateServiceImpl", "getFor"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/util/WindowStateServiceImpl", "getFor"));
        }
        GraphicsDevice screen = WindowStateServiceImpl.getScreen(object);
        float scale = WindowStateServiceImpl.getSysScale(screen);
        Function<String, Object> getState2 = myKey -> {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/util/WindowStateServiceImpl", "lambda$getFor$0"));
            }
            WindowState state = this.myStateMap.get(myKey);
            if (state == null) {
                return null;
            }
            if (WindowStateServiceImpl.isVisible(state = state.copy().scaleDown(scale))) {
                if (type2 == WindowState.class) {
                    return state;
                }
                if (type2 == Point.class) {
                    return state.getLocation();
                }
                if (type2 == Dimension.class) {
                    return state.getSize();
                }
                if (type2 == Rectangle.class) {
                    return state.getBounds();
                }
            }
            return null;
        };
        Object state = getState2.apply(WindowStateServiceImpl.getKey(screen, key2));
        if (state == null) {
            state = getState2.apply(WindowStateServiceImpl.getOldKey(screen, key2));
        }
        if (state != null) {
            return (T)state;
        }
        if (object != null) {
            return this.getFor(null, key2, type2);
        }
        return (T)getState2.apply(key2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putFor(Object object, @NotNull String key2, Point location, boolean locationSet, Dimension size, boolean sizeSet, boolean maximized, boolean maximizedSet, boolean fullScreen, boolean fullScreenSet) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY, "com/intellij/openapi/util/WindowStateServiceImpl", "putFor"));
        }
        Map<String, WindowState> map2 = this.myStateMap;
        synchronized (map2) {
            GraphicsDevice screen = WindowStateServiceImpl.getScreen(object);
            float scale = WindowStateServiceImpl.getSysScale(screen);
            BiFunction<String, String, Void> putState = (myNewKey, myOldKey) -> {
                WindowState state;
                WindowState oldState;
                WindowState windowState = oldState = myOldKey != null ? this.myStateMap.remove(myOldKey) : null;
                if (oldState != null) {
                    oldState.scaleDown(scale);
                    WindowState newState = this.myStateMap.get(myNewKey);
                    if (newState != null) {
                        newState.merge(oldState);
                    } else {
                        this.myStateMap.put((String)myNewKey, oldState);
                    }
                }
                if ((state = this.myStateMap.get(myNewKey)) != null) {
                    if (state.set(location, locationSet, size, sizeSet, maximized, maximizedSet, fullScreen, fullScreenSet)) {
                        state.scaleUp(scale);
                    } else {
                        this.myStateMap.remove(myNewKey);
                    }
                } else {
                    state = new WindowState();
                    if (state.set(location, locationSet, size, sizeSet, maximized, maximizedSet, fullScreen, fullScreenSet)) {
                        state.scaleUp(scale);
                        this.myStateMap.put((String)myNewKey, state);
                    }
                }
                return null;
            };
            putState.apply(WindowStateServiceImpl.getKey(screen, key2), WindowStateServiceImpl.getOldKey(screen, key2));
            if (screen != null) {
                putState.apply(WindowStateServiceImpl.getKey(null, key2), WindowStateServiceImpl.getOldKey(null, key2));
            }
            putState.apply(key2, null);
        }
    }

    private static float getSysScale(GraphicsDevice screen) {
        return UIUtil.isJreHiDPIEnabled() && screen != null ? JBUI.sysScale((GraphicsConfiguration)screen.getDefaultConfiguration()) : 1.0f;
    }

    @NotNull
    private static String getOldKey(@Nullable GraphicsDevice screen, String key2) {
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (environment.isHeadlessInstance()) {
            String string = key2 + ".headless";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/WindowStateServiceImpl", "getOldKey"));
            }
            return string;
        }
        StringBuilder sb = new StringBuilder(key2);
        for (GraphicsDevice device : environment.getScreenDevices()) {
            Rectangle bounds = device.getDefaultConfiguration().getBounds();
            WindowStateServiceImpl.normalizeSize(device, bounds);
            sb.append('/').append(bounds.x);
            sb.append('.').append(bounds.y);
            sb.append('.').append(bounds.width);
            sb.append('.').append(bounds.height);
        }
        if (screen != null) {
            Rectangle bounds = screen.getDefaultConfiguration().getBounds();
            WindowStateServiceImpl.normalizeSize(screen, bounds);
            sb.append('@').append(bounds.x);
            sb.append('.').append(bounds.y);
            sb.append('.').append(bounds.width);
            sb.append('.').append(bounds.height);
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/WindowStateServiceImpl", "getOldKey"));
        }
        return string;
    }

    @NotNull
    private static String getKey(@Nullable GraphicsDevice screen, String key2) {
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (environment.isHeadlessInstance()) {
            String string = key2 + ".headless";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/WindowStateServiceImpl", "getKey"));
            }
            return string;
        }
        StringBuilder sb = new StringBuilder(key2);
        if (screen == null) {
            for (GraphicsDevice device : environment.getScreenDevices()) {
                Rectangle bounds = device.getDefaultConfiguration().getBounds();
                WindowStateServiceImpl.normalizeSize(device, bounds);
                sb.append('/').append(bounds.width);
                sb.append('.').append(bounds.height);
            }
        } else {
            Rectangle bounds = screen.getDefaultConfiguration().getBounds();
            WindowStateServiceImpl.normalizeSize(screen, bounds);
            sb.append('@').append(bounds.width);
            sb.append('.').append(bounds.height);
            if (JBUI.isPixHiDPI((GraphicsConfiguration)screen.getDefaultConfiguration())) {
                int dpi = (int)(96.0f * JBUI.pixScale((GraphicsConfiguration)screen.getDefaultConfiguration()));
                sb.append("@").append(dpi).append("dpi");
            }
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/WindowStateServiceImpl", "getKey"));
        }
        return string;
    }

    private static void normalizeSize(GraphicsDevice screen, Rectangle bounds) {
        if (UIUtil.isJreHiDPIEnabled()) {
            float scale = JBUI.sysScale((GraphicsConfiguration)screen.getDefaultConfiguration());
            bounds.setSize((int)Math.ceil((float)bounds.width * scale), (int)Math.ceil((float)bounds.height * scale));
        }
    }

    private static GraphicsDevice getScreen(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Project) {
            Project project2 = (Project)object;
            object = WindowManager.getInstance().getFrame(project2);
            if (object == null) {
                LOG.warn("cannot find a project frame for " + project2);
                return null;
            }
        }
        if (object instanceof Window) {
            GraphicsDevice device;
            Window window = (Window)object;
            GraphicsConfiguration gc = window.getGraphicsConfiguration();
            GraphicsDevice graphicsDevice = device = gc != null ? window.getGraphicsConfiguration().getDevice() : ScreenUtil.getScreenDevice((Rectangle)window.getBounds());
            if (device != null) {
                return device;
            }
        }
        LOG.warn("cannot find a screen for " + object);
        return null;
    }

    private static boolean isVisible(WindowState state) {
        return state != null && WindowStateServiceImpl.isVisible(state.myLocation, state.mySize);
    }

    private static boolean isVisible(Point location, Dimension size) {
        if (location == null) {
            return size != null;
        }
        if (ScreenUtil.isVisible((Point)location)) {
            return true;
        }
        if (size == null) {
            return false;
        }
        return ScreenUtil.isVisible((Rectangle)new Rectangle(location, size));
    }

    private static final class WindowState {
        private Point myLocation;
        private Dimension mySize;
        private boolean myMaximized;
        private boolean myFullScreen;

        private WindowState() {
        }

        private Point getLocation() {
            return this.myLocation == null ? null : new Point(this.myLocation);
        }

        private Dimension getSize() {
            return this.mySize == null ? null : new Dimension(this.mySize);
        }

        private Rectangle getBounds() {
            return this.myLocation == null || this.mySize == null ? null : new Rectangle(this.myLocation, this.mySize);
        }

        private WindowState scaleDown(float scale) {
            if (scale == 1.0f) {
                return this;
            }
            if (this.myLocation != null) {
                this.myLocation.setLocation((float)this.myLocation.x / scale, (float)this.myLocation.y / scale);
            }
            if (this.mySize != null) {
                this.mySize.setSize((float)this.mySize.width / scale, (float)this.mySize.height / scale);
            }
            return this;
        }

        public WindowState scaleUp(float scale) {
            if (scale == 1.0f) {
                return this;
            }
            if (this.myLocation != null) {
                this.myLocation.setLocation((float)this.myLocation.x * scale, (float)this.myLocation.y * scale);
            }
            if (this.mySize != null) {
                this.mySize.setSize((float)this.mySize.width * scale, (float)this.mySize.height * scale);
            }
            return this;
        }

        private WindowState copy() {
            WindowState ws = new WindowState();
            ws.myLocation = this.myLocation == null ? null : this.myLocation.getLocation();
            ws.mySize = this.mySize == null ? null : this.mySize.getSize();
            ws.myMaximized = this.myMaximized;
            ws.myFullScreen = this.myFullScreen;
            return ws;
        }

        private boolean set(Point location, boolean locationSet, Dimension size, boolean sizeSet, boolean maximized, boolean maximizedSet, boolean fullScreen, boolean fullScreenSet) {
            if (locationSet) {
                Point point = this.myLocation = location == null ? null : new Point(location);
            }
            if (sizeSet) {
                Dimension dimension = this.mySize = size == null ? null : new Dimension(size);
            }
            if (maximizedSet) {
                this.myMaximized = maximized;
            }
            if (fullScreenSet) {
                this.myFullScreen = fullScreen;
            }
            return this.myLocation != null || this.mySize != null;
        }

        private void merge(@NotNull WindowState state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", WindowStateServiceImpl.STATE, "com/intellij/openapi/util/WindowStateServiceImpl$WindowState", "merge"));
            }
            if (this.myLocation == null && state.myLocation != null) {
                this.myLocation = state.myLocation.getLocation();
            }
            if (this.mySize == null && state.mySize != null) {
                this.mySize = state.mySize.getSize();
            }
        }
    }
}

