/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsCheckoutProcessor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectSetProcessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class VcsProjectSetProcessor
extends ProjectSetProcessor {
    private static final Logger LOG = Logger.getInstance(VcsProjectSetProcessor.class);

    public String getId() {
        return "vcs";
    }

    public void processEntries(final @NotNull List<Pair<String, String>> entries, final @NotNull ProjectSetProcessor.Context context, final @NotNull Runnable runNext) {
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "com/intellij/openapi/vcs/VcsProjectSetProcessor", "processEntries"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/VcsProjectSetProcessor", "processEntries"));
        }
        if (runNext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runNext", "com/intellij/openapi/vcs/VcsProjectSetProcessor", "processEntries"));
        }
        if (!VcsProjectSetProcessor.getDirectory(context)) {
            return;
        }
        if (!VcsProjectSetProcessor.getDirectoryName(context)) {
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, "Hey", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/VcsProjectSetProcessor$1", "run"));
                }
                for (Pair pair2 : entries) {
                    String vcs = (String)pair2.getFirst();
                    VcsCheckoutProcessor processor2 = VcsCheckoutProcessor.getProcessor((String)vcs);
                    if (processor2 == null) {
                        LOG.error("Checkout processor not found for " + vcs);
                        return;
                    }
                    JsonElement element = new JsonParser().parse((String)pair2.getSecond());
                    HashMap parameters2 = new HashMap();
                    for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
                        JsonElement value2 = (JsonElement)entry.getValue();
                        parameters2.put(entry.getKey(), value2 instanceof JsonPrimitive ? value2.getAsString() : value2.toString());
                    }
                    String directoryName = context.directoryName;
                    if (parameters2.get("targetDir") != null) {
                        directoryName = directoryName + "/" + (String)parameters2.get("targetDir");
                    }
                    if (processor2.checkout(parameters2, context.directory, directoryName)) continue;
                    return;
                }
                runNext.run();
            }
        });
    }

    private static boolean getDirectoryName(@NotNull ProjectSetProcessor.Context context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/VcsProjectSetProcessor", "getDirectoryName"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            context.directoryName = "test";
            return true;
        }
        context.directoryName = Messages.showInputDialog((Project)null, (String)("Enter directory name for created project. Leave blank to checkout directly into \"" + context.directory.getName() + "\"."), (String)"Project Directory Name", null, (String)context.directoryName, null);
        return context.directoryName != null;
    }

    private static boolean getDirectory(@NotNull ProjectSetProcessor.Context context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/VcsProjectSetProcessor", "getDirectory"));
        }
        if (context.directory != null) {
            return true;
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false);
        descriptor.setTitle("Select Destination Folder");
        descriptor.setDescription("");
        VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, null, null);
        context.directory = files.length == 0 ? null : files[0];
        return context.directory != null;
    }
}

