/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.DescindingFilesFilter;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.UtilKt;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCommonCheckinAction
extends AbstractVcsAction {
    private static final Logger LOG = Logger.getInstance(AbstractCommonCheckinAction.class);

    @Override
    public void actionPerformed(@NotNull VcsContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/AbstractCommonCheckinAction", "actionPerformed"));
        }
        LOG.debug("actionPerformed. ");
        Project project2 = (Project)ObjectUtils.notNull((Object)context.getProject());
        if (ChangeListManager.getInstance((Project)project2).isFreezedWithNotification("Can not " + this.getMnemonicsFreeActionName(context) + " now")) {
            LOG.debug("ChangeListManager is freezed. returning.");
        } else if (ProjectLevelVcsManager.getInstance((Project)project2).isBackgroundVcsOperationRunning()) {
            LOG.debug("Background operation is running. returning.");
        } else {
            FilePath[] roots = this.prepareRootsForCommit(this.getRoots(context), project2);
            ChangeListManager.getInstance((Project)project2).invokeAfterUpdate(() -> {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/AbstractCommonCheckinAction", "lambda$actionPerformed$0"));
                }
                this.performCheckIn(context, project2, roots);
            }, InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE, VcsBundle.message((String)"waiting.changelists.update.for.show.commit.dialog.message", (Object[])new Object[0]), ModalityState.current());
        }
    }

    protected void performCheckIn(@NotNull VcsContext context, @NotNull Project project2, @NotNull FilePath[] roots) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/AbstractCommonCheckinAction", "performCheckIn"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/AbstractCommonCheckinAction", "performCheckIn"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/openapi/vcs/actions/AbstractCommonCheckinAction", "performCheckIn"));
        }
        LOG.debug("invoking commit dialog after update");
        LocalChangeList initialSelection = this.getInitiallySelectedChangeList(context, project2);
        Object[] selectedChanges = context.getSelectedChanges();
        Collection<Object> changesToCommit = !ArrayUtil.isEmpty((Object[])selectedChanges) ? Arrays.asList(selectedChanges) : AbstractCommonCheckinAction.getChangesIn(project2, roots);
        CommitChangeListDialog.commitChanges(project2, changesToCommit, initialSelection, this.getExecutor(project2), null);
    }

    @NotNull
    private static Set<Change> getChangesIn(@NotNull Project project2, @NotNull FilePath[] roots) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/AbstractCommonCheckinAction", "getChangesIn"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/openapi/vcs/actions/AbstractCommonCheckinAction", "getChangesIn"));
        }
        ChangeListManager manager = ChangeListManager.getInstance((Project)project2);
        Set<Change> set2 = UtilKt.stream(roots).flatMap(path -> manager.getChangesIn(path).stream()).collect(Collectors.toSet());
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/AbstractCommonCheckinAction", "getChangesIn"));
        }
        return set2;
    }

    @NotNull
    protected FilePath[] prepareRootsForCommit(@NotNull FilePath[] roots, @NotNull Project project2) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/openapi/vcs/actions/AbstractCommonCheckinAction", "prepareRootsForCommit"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/AbstractCommonCheckinAction", "prepareRootsForCommit"));
        }
        ApplicationManager.getApplication().saveAll();
        FilePath[] filePathArray = DescindingFilesFilter.filterDescindingFiles(roots, project2);
        if (filePathArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/AbstractCommonCheckinAction", "prepareRootsForCommit"));
        }
        return filePathArray;
    }

    protected String getMnemonicsFreeActionName(@NotNull VcsContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/AbstractCommonCheckinAction", "getMnemonicsFreeActionName"));
        }
        return this.getActionName(context);
    }

    @Nullable
    protected CommitExecutor getExecutor(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/AbstractCommonCheckinAction", "getExecutor"));
        }
        return null;
    }

    @Nullable
    protected LocalChangeList getInitiallySelectedChangeList(@NotNull VcsContext context, @NotNull Project project2) {
        Object[] changes;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/AbstractCommonCheckinAction", "getInitiallySelectedChangeList"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/AbstractCommonCheckinAction", "getInitiallySelectedChangeList"));
        }
        ChangeListManager manager = ChangeListManager.getInstance((Project)project2);
        Object[] changeLists = context.getSelectedChangeLists();
        LocalChangeList result2 = !ArrayUtil.isEmpty((Object[])changeLists) ? manager.findChangeList(changeLists[0].getName()) : (!ArrayUtil.isEmpty((Object[])(changes = context.getSelectedChanges())) ? manager.getChangeList((Change)changes[0]) : manager.getDefaultChangeList());
        return result2;
    }

    protected abstract String getActionName(@NotNull VcsContext var1);

    @NotNull
    protected abstract FilePath[] getRoots(@NotNull VcsContext var1);

    protected abstract boolean approximatelyHasRoots(@NotNull VcsContext var1);

    @Override
    protected void update(@NotNull VcsContext vcsContext, @NotNull Presentation presentation) {
        if (vcsContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsContext", "com/intellij/openapi/vcs/actions/AbstractCommonCheckinAction", "update"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/vcs/actions/AbstractCommonCheckinAction", "update"));
        }
        Project project2 = vcsContext.getProject();
        if (project2 == null || !ProjectLevelVcsManager.getInstance((Project)project2).hasActiveVcss()) {
            presentation.setEnabledAndVisible(false);
        } else if (!this.approximatelyHasRoots(vcsContext)) {
            presentation.setEnabled(false);
        } else {
            presentation.setText(this.getActionName(vcsContext) + "...");
            presentation.setEnabled(!ProjectLevelVcsManager.getInstance((Project)project2).isBackgroundVcsOperationRunning());
            presentation.setVisible(true);
        }
    }

    @NotNull
    protected static FilePath[] getAllContentRoots(@NotNull VcsContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/AbstractCommonCheckinAction", "getAllContentRoots"));
        }
        FilePath[] filePathArray = (FilePath[])Stream.of(ProjectLevelVcsManager.getInstance((Project)context.getProject()).getAllVersionedRoots()).map(VcsUtil::getFilePath).toArray(FilePath[]::new);
        if (filePathArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/AbstractCommonCheckinAction", "getAllContentRoots"));
        }
        return filePathArray;
    }
}

