/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffContextEx;
import com.intellij.diff.DiffExtension;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.merge.TextMergeViewer;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.fragmented.UnifiedDiffViewer;
import com.intellij.diff.tools.simple.SimpleThreesideDiffViewer;
import com.intellij.diff.tools.simple.ThreesideTextDiffViewerEx;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.base.DiffViewerBase;
import com.intellij.diff.tools.util.base.DiffViewerListener;
import com.intellij.diff.tools.util.side.OnesideTextDiffViewer;
import com.intellij.diff.tools.util.side.TwosideTextDiffViewer;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.localVcs.UpToDateLineNumberProvider;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.actions.AnnotateToggleAction;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vcs.impl.UpToDateLineNumberProviderImpl;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.AnnotationProviderEx;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotateDiffViewerAction {
    private static final Logger LOG = Logger.getInstance(AnnotateDiffViewerAction.class);
    private static final Key<boolean[]> ANNOTATIONS_SHOWN_KEY = Key.create((String)"Diff.AnnotateAction.AnnotationShown");
    private static final ViewerAnnotatorFactory[] ANNOTATORS = new ViewerAnnotatorFactory[]{new TwosideAnnotatorFactory(), new OnesideAnnotatorFactory(), new UnifiedAnnotatorFactory(), new ThreesideAnnotatorFactory(), new TextMergeAnnotatorFactory()};

    @Nullable
    private static ViewerAnnotator getAnnotator(@NotNull DiffViewerBase viewer, @NotNull Editor editor) {
        if (viewer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "getAnnotator"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "getAnnotator"));
        }
        for (ViewerAnnotatorFactory annotator : ANNOTATORS) {
            if (!annotator.getViewerClass().isInstance(viewer)) continue;
            return annotator.createAnnotator(viewer, editor);
        }
        return null;
    }

    @Nullable
    private static EventData collectEventData(AnActionEvent e) {
        DiffViewerBase viewer = AnnotateDiffViewerAction.getViewer(e);
        if (viewer == null) {
            return null;
        }
        if (viewer.getProject() == null) {
            return null;
        }
        if (viewer.isDisposed()) {
            return null;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return null;
        }
        ViewerAnnotator annotator = AnnotateDiffViewerAction.getAnnotator(viewer, editor);
        if (annotator == null) {
            return null;
        }
        return new EventData(viewer, annotator);
    }

    @Nullable
    private static DiffViewerBase getViewer(AnActionEvent e) {
        DiffViewerBase diffViewer = (DiffViewerBase)ObjectUtils.tryCast((Object)e.getData(DiffDataKeys.DIFF_VIEWER), DiffViewerBase.class);
        if (diffViewer != null) {
            return diffViewer;
        }
        TextMergeViewer mergeViewer = (TextMergeViewer)ObjectUtils.tryCast((Object)e.getData(DiffDataKeys.MERGE_VIEWER), TextMergeViewer.class);
        if (mergeViewer != null) {
            return mergeViewer.getViewer();
        }
        return null;
    }

    private static boolean isEnabled(AnActionEvent e) {
        EventData data = AnnotateDiffViewerAction.collectEventData(e);
        if (data == null) {
            return false;
        }
        if (data.annotator.isAnnotationShown()) {
            return true;
        }
        return data.annotator.createAnnotationsLoader() != null;
    }

    private static boolean isSuspended(AnActionEvent e) {
        EventData data = AnnotateDiffViewerAction.collectEventData(e);
        return data != null && data.annotator.getBackgroundableLock().isLocked();
    }

    private static boolean isAnnotated(AnActionEvent e) {
        EventData data = AnnotateDiffViewerAction.collectEventData(e);
        assert (data != null);
        return data.annotator.isAnnotationShown();
    }

    private static void perform(AnActionEvent e, boolean selected) {
        EventData data = AnnotateDiffViewerAction.collectEventData(e);
        assert (data != null);
        boolean annotationShown = data.annotator.isAnnotationShown();
        if (annotationShown) {
            data.annotator.hideAnnotation();
        } else {
            AnnotateDiffViewerAction.doAnnotate(data.annotator);
        }
    }

    private static void doAnnotate(@NotNull ViewerAnnotator annotator) {
        if (annotator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotator", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "doAnnotate"));
        }
        DiffViewerBase viewer = annotator.getViewer();
        Project project2 = viewer.getProject();
        if (project2 == null) {
            return;
        }
        FileAnnotationLoader loader = annotator.createAnnotationsLoader();
        if (loader == null) {
            return;
        }
        DiffContextEx diffContext = (DiffContextEx)((Object)ObjectUtils.tryCast((Object)viewer.getContext(), DiffContextEx.class));
        annotator.getBackgroundableLock().lock();
        if (diffContext != null) {
            diffContext.showProgressBar(true);
        }
        BackgroundTaskUtil.executeOnPooledThread((Consumer<ProgressIndicator>)((Consumer)indicator -> {
            if (annotator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotator", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "lambda$doAnnotate$1"));
            }
            try {
                loader.run();
            }
            finally {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (annotator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotator", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "lambda$null$0"));
                    }
                    if (diffContext != null) {
                        diffContext.showProgressBar(false);
                    }
                    annotator.getBackgroundableLock().unlock();
                    VcsException exception = loader.getException();
                    if (exception != null) {
                        Notification notification = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification("Can't Load Annotations", exception.getMessage(), NotificationType.ERROR, null);
                        AnnotateDiffViewerAction.showNotification(viewer, notification);
                        LOG.warn((Throwable)exception);
                        return;
                    }
                    if (loader.getResult() == null) {
                        return;
                    }
                    if (viewer.isDisposed()) {
                        return;
                    }
                    annotator.showAnnotation(loader.getResult());
                }, indicator.getModalityState());
            }
        }), (Disposable)viewer);
    }

    @Nullable
    private static FileAnnotationLoader createThreesideAnnotationsLoader(@NotNull Project project2, @NotNull DiffRequest request, @NotNull ThreeSide side) {
        DiffContent content;
        FileAnnotationLoader loader;
        ContentDiffRequest requestEx;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "createThreesideAnnotationsLoader"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "createThreesideAnnotationsLoader"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "createThreesideAnnotationsLoader"));
        }
        if (request instanceof ContentDiffRequest && (requestEx = (ContentDiffRequest)request).getContents().size() == 3 && (loader = AnnotateDiffViewerAction.createAnnotationsLoader(project2, content = (DiffContent)side.select(requestEx.getContents()))) != null) {
            return loader;
        }
        return null;
    }

    @Nullable
    private static FileAnnotationLoader createTwosideAnnotationsLoader(@NotNull Project project2, @NotNull DiffRequest request, @NotNull Side side) {
        ContentDiffRequest requestEx;
        ContentRevision revision;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "createTwosideAnnotationsLoader"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "createTwosideAnnotationsLoader"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "createTwosideAnnotationsLoader"));
        }
        Change change = (Change)request.getUserData(ChangeDiffRequestProducer.CHANGE_KEY);
        if (change != null && (revision = (ContentRevision)side.select((Object)change.getBeforeRevision(), (Object)change.getAfterRevision())) != null) {
            AbstractVcs vcs = ChangesUtil.getVcsForChange((Change)change, (Project)project2);
            if (revision instanceof CurrentContentRevision) {
                VirtualFile file2 = ((CurrentContentRevision)revision).getVirtualFile();
                FileAnnotationLoader loader = AnnotateDiffViewerAction.doCreateAnnotationsLoader(project2, vcs, file2);
                if (loader != null) {
                    return loader;
                }
            } else {
                FileAnnotationLoader loader = AnnotateDiffViewerAction.doCreateAnnotationsLoader(vcs, revision.getFile(), revision.getRevisionNumber());
                if (loader != null) {
                    return loader;
                }
            }
        }
        if (request instanceof ContentDiffRequest && (requestEx = (ContentDiffRequest)request).getContents().size() == 2) {
            DiffContent content = (DiffContent)side.select(requestEx.getContents());
            return AnnotateDiffViewerAction.createAnnotationsLoader(project2, content);
        }
        return null;
    }

    @Nullable
    private static FileAnnotationLoader createAnnotationsLoader(@NotNull Project project2, @NotNull DiffContent content) {
        FilePath filePath;
        AbstractVcs vcs;
        FileAnnotationLoader loader;
        VirtualFile file2;
        AbstractVcs vcs2;
        FileAnnotationLoader loader2;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "createAnnotationsLoader"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "createAnnotationsLoader"));
        }
        if (content instanceof FileContent && (loader2 = AnnotateDiffViewerAction.doCreateAnnotationsLoader(project2, vcs2 = VcsUtil.getVcsFor((Project)project2, (VirtualFile)(file2 = ((FileContent)content).getFile())), file2)) != null) {
            return loader2;
        }
        Pair info = (Pair)content.getUserData(DiffUserDataKeysEx.REVISION_INFO);
        if (info != null && (loader = AnnotateDiffViewerAction.doCreateAnnotationsLoader(vcs = VcsUtil.getVcsFor((Project)project2, (FilePath)(filePath = (FilePath)info.first)), filePath, (VcsRevisionNumber)info.second)) != null) {
            return loader;
        }
        return null;
    }

    @Nullable
    private static FileAnnotationLoader doCreateAnnotationsLoader(@NotNull Project project2, @Nullable AbstractVcs vcs, final @Nullable VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "doCreateAnnotationsLoader"));
        }
        if (vcs == null || file2 == null) {
            return null;
        }
        final AnnotationProvider annotationProvider = vcs.getAnnotationProvider();
        if (annotationProvider == null) {
            return null;
        }
        FileStatus fileStatus = FileStatusManager.getInstance((Project)project2).getStatus(file2);
        if (fileStatus == FileStatus.UNKNOWN || fileStatus == FileStatus.ADDED || fileStatus == FileStatus.IGNORED) {
            return null;
        }
        return new FileAnnotationLoader(vcs){

            @Override
            public FileAnnotation compute() throws VcsException {
                return annotationProvider.annotate(file2);
            }
        };
    }

    @Nullable
    private static FileAnnotationLoader doCreateAnnotationsLoader(@Nullable AbstractVcs vcs, final @Nullable FilePath path, final @Nullable VcsRevisionNumber revisionNumber) {
        if (vcs == null || path == null || revisionNumber == null) {
            return null;
        }
        if (revisionNumber instanceof TextRevisionNumber) {
            return null;
        }
        final AnnotationProvider annotationProvider = vcs.getAnnotationProvider();
        if (!(annotationProvider instanceof AnnotationProviderEx)) {
            return null;
        }
        return new FileAnnotationLoader(vcs){

            @Override
            public FileAnnotation compute() throws VcsException {
                return ((AnnotationProviderEx)annotationProvider).annotate(path, revisionNumber);
            }
        };
    }

    private static void showNotification(@NotNull DiffViewerBase viewer, @NotNull Notification notification) {
        if (viewer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "showNotification"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction", "showNotification"));
        }
        JComponent component = viewer.getComponent();
        Window window = UIUtil.getWindow((Component)component);
        if (window instanceof IdeFrame && NotificationsManagerImpl.findWindowForBalloon(viewer.getProject()) == window) {
            notification.notify(viewer.getProject());
            return;
        }
        Balloon balloon = NotificationsManagerImpl.createBalloon(component, notification, false, true, BalloonLayoutData.fullContent(), (Disposable)viewer);
        Dimension componentSize = component.getSize();
        Dimension balloonSize = balloon.getPreferredSize();
        int width = Math.min(balloonSize.width, componentSize.width);
        int height = Math.min(balloonSize.height, componentSize.height);
        RelativePoint point = new RelativePoint((Component)component, new Point(componentSize.width - 20 - width / 2, 20 + height / 2));
        balloon.show(point, Balloon.Position.above);
    }

    public static class Provider
    implements AnnotateToggleAction.Provider {
        @Override
        public boolean isEnabled(AnActionEvent e) {
            return AnnotateDiffViewerAction.isEnabled(e);
        }

        @Override
        public boolean isSuspended(AnActionEvent e) {
            return AnnotateDiffViewerAction.isSuspended(e);
        }

        @Override
        public boolean isAnnotated(AnActionEvent e) {
            return AnnotateDiffViewerAction.isAnnotated(e);
        }

        @Override
        public void perform(AnActionEvent e, boolean selected) {
            AnnotateDiffViewerAction.perform(e, selected);
        }
    }

    private static class EventData {
        @NotNull
        public final DiffViewerBase viewer;
        @NotNull
        public final ViewerAnnotator annotator;

        public EventData(@NotNull DiffViewerBase viewer, @NotNull ViewerAnnotator annotator) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$EventData", "<init>"));
            }
            if (annotator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotator", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$EventData", "<init>"));
            }
            this.viewer = viewer;
            this.annotator = annotator;
        }
    }

    private static class AnnotationData {
        @NotNull
        public final AbstractVcs vcs;
        @NotNull
        public final FileAnnotation annotation;

        public AnnotationData(@NotNull AbstractVcs vcs, @NotNull FileAnnotation annotation) {
            if (vcs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$AnnotationData", "<init>"));
            }
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$AnnotationData", "<init>"));
            }
            this.vcs = vcs;
            this.annotation = annotation;
        }
    }

    private static abstract class FileAnnotationLoader {
        @NotNull
        private final AbstractVcs myVcs;
        @Nullable
        private VcsException myException;
        @Nullable
        private FileAnnotation myResult;

        public FileAnnotationLoader(@NotNull AbstractVcs vcs) {
            if (vcs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$FileAnnotationLoader", "<init>"));
            }
            this.myVcs = vcs;
        }

        @Nullable
        public VcsException getException() {
            return this.myException;
        }

        @Nullable
        public AnnotationData getResult() {
            return this.myResult != null ? new AnnotationData(this.myVcs, this.myResult) : null;
        }

        public void run() {
            try {
                this.myResult = this.compute();
            }
            catch (VcsException e) {
                this.myException = e;
            }
        }

        protected abstract FileAnnotation compute() throws VcsException;
    }

    private static abstract class ViewerAnnotator {
        private ViewerAnnotator() {
        }

        @NotNull
        public abstract DiffViewerBase getViewer();

        public abstract boolean isAnnotationShown();

        public abstract void showAnnotation(@NotNull AnnotationData var1);

        public abstract void hideAnnotation();

        @Nullable
        public abstract FileAnnotationLoader createAnnotationsLoader();

        @NotNull
        public abstract BackgroundableActionLock getBackgroundableLock();
    }

    private static abstract class ViewerAnnotatorFactory<T extends DiffViewerBase> {
        private ViewerAnnotatorFactory() {
        }

        @NotNull
        public abstract Class<? extends T> getViewerClass();

        @Nullable
        public abstract ViewerAnnotator createAnnotator(@NotNull T var1, @NotNull Editor var2);

        public abstract void showRememberedAnnotations(@NotNull T var1);

        public abstract void rememberShownAnnotations(@NotNull T var1);
    }

    private static abstract class ThreesideViewerAnnotatorFactory<T extends DiffViewerBase>
    extends ViewerAnnotatorFactory<T> {
        private ThreesideViewerAnnotatorFactory() {
        }

        @Nullable
        public abstract ThreeSide getCurrentSide(@NotNull T var1, @NotNull Editor var2);

        public abstract boolean isAnnotationShown(@NotNull T var1, @NotNull ThreeSide var2);

        public abstract void showAnnotation(@NotNull T var1, @NotNull ThreeSide var2, @NotNull AnnotationData var3);

        public abstract void hideAnnotation(@NotNull T var1, @NotNull ThreeSide var2);

        @Override
        @Nullable
        public ViewerAnnotator createAnnotator(@NotNull T viewer, @NotNull Editor editor) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$ThreesideViewerAnnotatorFactory", "createAnnotator"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$ThreesideViewerAnnotatorFactory", "createAnnotator"));
            }
            ThreeSide side = this.getCurrentSide(viewer, editor);
            if (side == null) {
                return null;
            }
            return this.createAnnotator(viewer, side);
        }

        @Override
        public void showRememberedAnnotations(@NotNull T viewer) {
            ViewerAnnotator annotator;
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$ThreesideViewerAnnotatorFactory", "showRememberedAnnotations"));
            }
            boolean[] annotationsShown = (boolean[])((DiffViewerBase)viewer).getRequest().getUserData(ANNOTATIONS_SHOWN_KEY);
            if (annotationsShown == null || annotationsShown.length != 3) {
                return;
            }
            if (annotationsShown[0] && (annotator = this.createAnnotator(viewer, ThreeSide.LEFT)) != null) {
                AnnotateDiffViewerAction.doAnnotate(annotator);
            }
            if (annotationsShown[1] && (annotator = this.createAnnotator(viewer, ThreeSide.BASE)) != null) {
                AnnotateDiffViewerAction.doAnnotate(annotator);
            }
            if (annotationsShown[2] && (annotator = this.createAnnotator(viewer, ThreeSide.RIGHT)) != null) {
                AnnotateDiffViewerAction.doAnnotate(annotator);
            }
        }

        @Override
        public void rememberShownAnnotations(@NotNull T viewer) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$ThreesideViewerAnnotatorFactory", "rememberShownAnnotations"));
            }
            boolean[] annotationsShown = new boolean[]{this.isAnnotationShown(viewer, ThreeSide.LEFT), this.isAnnotationShown(viewer, ThreeSide.BASE), this.isAnnotationShown(viewer, ThreeSide.RIGHT)};
            ((DiffViewerBase)viewer).getRequest().putUserData(ANNOTATIONS_SHOWN_KEY, (Object)annotationsShown);
        }

        @Nullable
        public ViewerAnnotator createAnnotator(@NotNull T viewer, @NotNull ThreeSide side) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$ThreesideViewerAnnotatorFactory", "createAnnotator"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$ThreesideViewerAnnotatorFactory", "createAnnotator"));
            }
            ThreesideViewerAnnotatorFactory factory = this;
            Project project2 = ((DiffViewerBase)viewer).getProject();
            assert (project2 != null);
            return new ViewerAnnotator((DiffViewerBase)viewer, factory, side, project2){
                final /* synthetic */ DiffViewerBase val$viewer;
                final /* synthetic */ ThreesideViewerAnnotatorFactory val$factory;
                final /* synthetic */ ThreeSide val$side;
                final /* synthetic */ Project val$project;
                {
                    this.val$viewer = diffViewerBase;
                    this.val$factory = threesideViewerAnnotatorFactory;
                    this.val$side = threeSide;
                    this.val$project = project2;
                }

                @NotNull
                public T getViewer() {
                    DiffViewerBase diffViewerBase = this.val$viewer;
                    if (diffViewerBase == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$ThreesideViewerAnnotatorFactory$1", "getViewer"));
                    }
                    return diffViewerBase;
                }

                @Override
                public boolean isAnnotationShown() {
                    return this.val$factory.isAnnotationShown(this.val$viewer, this.val$side);
                }

                @Override
                public void showAnnotation(@NotNull AnnotationData data) {
                    if (data == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$ThreesideViewerAnnotatorFactory$1", "showAnnotation"));
                    }
                    this.val$factory.showAnnotation(this.val$viewer, this.val$side, data);
                }

                @Override
                public void hideAnnotation() {
                    this.val$factory.hideAnnotation(this.val$viewer, this.val$side);
                }

                @Override
                @Nullable
                public FileAnnotationLoader createAnnotationsLoader() {
                    return AnnotateDiffViewerAction.createThreesideAnnotationsLoader(this.val$project, (DiffRequest)this.val$viewer.getRequest(), this.val$side);
                }

                @Override
                @NotNull
                public BackgroundableActionLock getBackgroundableLock() {
                    BackgroundableActionLock backgroundableActionLock = BackgroundableActionLock.getLock(this.val$viewer.getProject(), new Object[]{VcsBackgroundableActions.ANNOTATE, this.val$viewer, this.val$side});
                    if (backgroundableActionLock == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$ThreesideViewerAnnotatorFactory$1", "getBackgroundableLock"));
                    }
                    return backgroundableActionLock;
                }
            };
        }
    }

    private static abstract class TwosideViewerAnnotatorFactory<T extends DiffViewerBase>
    extends ViewerAnnotatorFactory<T> {
        private TwosideViewerAnnotatorFactory() {
        }

        @Nullable
        public abstract Side getCurrentSide(@NotNull T var1, @NotNull Editor var2);

        public abstract boolean isAnnotationShown(@NotNull T var1, @NotNull Side var2);

        public abstract void showAnnotation(@NotNull T var1, @NotNull Side var2, @NotNull AnnotationData var3);

        public abstract void hideAnnotation(@NotNull T var1, @NotNull Side var2);

        @Override
        @Nullable
        public ViewerAnnotator createAnnotator(@NotNull T viewer, @NotNull Editor editor) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideViewerAnnotatorFactory", "createAnnotator"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideViewerAnnotatorFactory", "createAnnotator"));
            }
            Side side = this.getCurrentSide(viewer, editor);
            if (side == null) {
                return null;
            }
            return this.createAnnotator(viewer, side);
        }

        @Override
        public void showRememberedAnnotations(@NotNull T viewer) {
            ViewerAnnotator annotator;
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideViewerAnnotatorFactory", "showRememberedAnnotations"));
            }
            boolean[] annotationsShown = (boolean[])((DiffViewerBase)viewer).getRequest().getUserData(ANNOTATIONS_SHOWN_KEY);
            if (annotationsShown == null || annotationsShown.length != 2) {
                return;
            }
            if (annotationsShown[0] && (annotator = this.createAnnotator(viewer, Side.LEFT)) != null) {
                AnnotateDiffViewerAction.doAnnotate(annotator);
            }
            if (annotationsShown[1] && (annotator = this.createAnnotator(viewer, Side.RIGHT)) != null) {
                AnnotateDiffViewerAction.doAnnotate(annotator);
            }
        }

        @Override
        public void rememberShownAnnotations(@NotNull T viewer) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideViewerAnnotatorFactory", "rememberShownAnnotations"));
            }
            boolean[] annotationsShown = new boolean[]{this.isAnnotationShown(viewer, Side.LEFT), this.isAnnotationShown(viewer, Side.RIGHT)};
            ((DiffViewerBase)viewer).getRequest().putUserData(ANNOTATIONS_SHOWN_KEY, (Object)annotationsShown);
        }

        @Nullable
        public ViewerAnnotator createAnnotator(@NotNull T viewer, @NotNull Side side) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideViewerAnnotatorFactory", "createAnnotator"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideViewerAnnotatorFactory", "createAnnotator"));
            }
            TwosideViewerAnnotatorFactory factory = this;
            Project project2 = ((DiffViewerBase)viewer).getProject();
            assert (project2 != null);
            return new ViewerAnnotator((DiffViewerBase)viewer, factory, side, project2){
                final /* synthetic */ DiffViewerBase val$viewer;
                final /* synthetic */ TwosideViewerAnnotatorFactory val$factory;
                final /* synthetic */ Side val$side;
                final /* synthetic */ Project val$project;
                {
                    this.val$viewer = diffViewerBase;
                    this.val$factory = twosideViewerAnnotatorFactory;
                    this.val$side = side;
                    this.val$project = project2;
                }

                @NotNull
                public T getViewer() {
                    DiffViewerBase diffViewerBase = this.val$viewer;
                    if (diffViewerBase == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideViewerAnnotatorFactory$1", "getViewer"));
                    }
                    return diffViewerBase;
                }

                @Override
                public boolean isAnnotationShown() {
                    return this.val$factory.isAnnotationShown(this.val$viewer, this.val$side);
                }

                @Override
                public void showAnnotation(@NotNull AnnotationData data) {
                    if (data == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideViewerAnnotatorFactory$1", "showAnnotation"));
                    }
                    this.val$factory.showAnnotation(this.val$viewer, this.val$side, data);
                }

                @Override
                public void hideAnnotation() {
                    this.val$factory.hideAnnotation(this.val$viewer, this.val$side);
                }

                @Override
                @Nullable
                public FileAnnotationLoader createAnnotationsLoader() {
                    return AnnotateDiffViewerAction.createTwosideAnnotationsLoader(this.val$project, (DiffRequest)this.val$viewer.getRequest(), this.val$side);
                }

                @Override
                @NotNull
                public BackgroundableActionLock getBackgroundableLock() {
                    BackgroundableActionLock backgroundableActionLock = BackgroundableActionLock.getLock(this.val$viewer.getProject(), new Object[]{VcsBackgroundableActions.ANNOTATE, this.val$viewer, this.val$side});
                    if (backgroundableActionLock == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideViewerAnnotatorFactory$1", "getBackgroundableLock"));
                    }
                    return backgroundableActionLock;
                }
            };
        }
    }

    private static class TextMergeAnnotatorFactory
    extends ThreesideAnnotatorFactory {
        private TextMergeAnnotatorFactory() {
        }

        @Override
        @NotNull
        public Class<? extends ThreesideTextDiffViewerEx> getViewerClass() {
            if (TextMergeViewer.MyThreesideViewer.class == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TextMergeAnnotatorFactory", "getViewerClass"));
            }
            return TextMergeViewer.MyThreesideViewer.class;
        }

        @Override
        @Nullable
        public ViewerAnnotator createAnnotator(@NotNull ThreesideTextDiffViewerEx viewer, @NotNull ThreeSide side) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TextMergeAnnotatorFactory", "createAnnotator"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TextMergeAnnotatorFactory", "createAnnotator"));
            }
            if (side == ThreeSide.BASE) {
                return null;
            }
            return super.createAnnotator(viewer, side);
        }
    }

    private static class ThreesideAnnotatorFactory
    extends ThreesideViewerAnnotatorFactory<ThreesideTextDiffViewerEx> {
        private ThreesideAnnotatorFactory() {
        }

        @Override
        @NotNull
        public Class<? extends ThreesideTextDiffViewerEx> getViewerClass() {
            if (SimpleThreesideDiffViewer.class == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$ThreesideAnnotatorFactory", "getViewerClass"));
            }
            return SimpleThreesideDiffViewer.class;
        }

        @Override
        @Nullable
        public ThreeSide getCurrentSide(@NotNull ThreesideTextDiffViewerEx viewer, @NotNull Editor editor) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$ThreesideAnnotatorFactory", "getCurrentSide"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$ThreesideAnnotatorFactory", "getCurrentSide"));
            }
            ThreeSide side = null;
            if (viewer.getEditor(ThreeSide.LEFT) == editor) {
                side = ThreeSide.LEFT;
            }
            if (viewer.getEditor(ThreeSide.BASE) == editor) {
                side = ThreeSide.BASE;
            }
            if (viewer.getEditor(ThreeSide.RIGHT) == editor) {
                side = ThreeSide.RIGHT;
            }
            return side;
        }

        @Override
        public boolean isAnnotationShown(@NotNull ThreesideTextDiffViewerEx viewer, @NotNull ThreeSide side) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$ThreesideAnnotatorFactory", "isAnnotationShown"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$ThreesideAnnotatorFactory", "isAnnotationShown"));
            }
            return viewer.getEditor(side).getGutter().isAnnotationsShown();
        }

        @Override
        public void showAnnotation(@NotNull ThreesideTextDiffViewerEx viewer, @NotNull ThreeSide side, @NotNull AnnotationData data) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$ThreesideAnnotatorFactory", "showAnnotation"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$ThreesideAnnotatorFactory", "showAnnotation"));
            }
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$ThreesideAnnotatorFactory", "showAnnotation"));
            }
            Project project2 = (Project)ObjectUtils.assertNotNull((Object)viewer.getProject());
            AnnotateToggleAction.doAnnotate(viewer.getEditor(side), project2, null, data.annotation, data.vcs);
        }

        @Override
        public void hideAnnotation(@NotNull ThreesideTextDiffViewerEx viewer, @NotNull ThreeSide side) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$ThreesideAnnotatorFactory", "hideAnnotation"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$ThreesideAnnotatorFactory", "hideAnnotation"));
            }
            viewer.getEditor(side).getGutter().closeAllAnnotations();
        }
    }

    private static class UnifiedUpToDateLineNumberProvider
    implements UpToDateLineNumberProvider {
        @NotNull
        private final UnifiedDiffViewer myViewer;
        @NotNull
        private final Side mySide;
        @NotNull
        private final UpToDateLineNumberProvider myLocalChangesProvider;

        public UnifiedUpToDateLineNumberProvider(@NotNull UnifiedDiffViewer viewer, @NotNull Side side) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$UnifiedUpToDateLineNumberProvider", "<init>"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$UnifiedUpToDateLineNumberProvider", "<init>"));
            }
            this.myViewer = viewer;
            this.mySide = side;
            this.myLocalChangesProvider = new UpToDateLineNumberProviderImpl(this.myViewer.getDocument(this.mySide), viewer.getProject());
        }

        public int getLineNumber(int currentNumber) {
            int number = this.myViewer.transferLineFromOnesideStrict(this.mySide, currentNumber);
            return number != -1 ? this.myLocalChangesProvider.getLineNumber(number) : -2;
        }

        public boolean isLineChanged(int currentNumber) {
            return this.getLineNumber(currentNumber) == -1;
        }

        public boolean isRangeChanged(int start, int end) {
            int line1 = this.myViewer.transferLineFromOnesideStrict(this.mySide, start);
            int line2 = this.myViewer.transferLineFromOnesideStrict(this.mySide, end);
            if (line2 - line1 != end - start) {
                return true;
            }
            for (int i2 = start; i2 <= end; ++i2) {
                if (!this.isLineChanged(i2)) continue;
                return true;
            }
            return this.myLocalChangesProvider.isRangeChanged(line1, line2);
        }

        public int getLineCount() {
            return this.myLocalChangesProvider.getLineCount();
        }
    }

    private static class UnifiedAnnotatorFactory
    extends TwosideViewerAnnotatorFactory<UnifiedDiffViewer> {
        private UnifiedAnnotatorFactory() {
        }

        @Override
        @NotNull
        public Class<UnifiedDiffViewer> getViewerClass() {
            if (UnifiedDiffViewer.class == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$UnifiedAnnotatorFactory", "getViewerClass"));
            }
            return UnifiedDiffViewer.class;
        }

        @Override
        @Nullable
        public Side getCurrentSide(@NotNull UnifiedDiffViewer viewer, @NotNull Editor editor) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$UnifiedAnnotatorFactory", "getCurrentSide"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$UnifiedAnnotatorFactory", "getCurrentSide"));
            }
            if (viewer.getEditor() != editor) {
                return null;
            }
            return viewer.getMasterSide();
        }

        @Override
        public boolean isAnnotationShown(@NotNull UnifiedDiffViewer viewer, @NotNull Side side) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$UnifiedAnnotatorFactory", "isAnnotationShown"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$UnifiedAnnotatorFactory", "isAnnotationShown"));
            }
            if (side != viewer.getMasterSide()) {
                return false;
            }
            return viewer.getEditor().getGutter().isAnnotationsShown();
        }

        @Override
        public void showAnnotation(@NotNull UnifiedDiffViewer viewer, @NotNull Side side, @NotNull AnnotationData data) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$UnifiedAnnotatorFactory", "showAnnotation"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$UnifiedAnnotatorFactory", "showAnnotation"));
            }
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$UnifiedAnnotatorFactory", "showAnnotation"));
            }
            if (side != viewer.getMasterSide()) {
                return;
            }
            Project project2 = (Project)ObjectUtils.assertNotNull((Object)viewer.getProject());
            UnifiedUpToDateLineNumberProvider lineNumberProvider = new UnifiedUpToDateLineNumberProvider(viewer, side);
            AnnotateToggleAction.doAnnotate(viewer.getEditor(), project2, null, data.annotation, data.vcs, lineNumberProvider);
        }

        @Override
        public void hideAnnotation(@NotNull UnifiedDiffViewer viewer, @NotNull Side side) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$UnifiedAnnotatorFactory", "hideAnnotation"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$UnifiedAnnotatorFactory", "hideAnnotation"));
            }
            viewer.getEditor().getGutter().closeAllAnnotations();
        }
    }

    private static class OnesideAnnotatorFactory
    extends TwosideViewerAnnotatorFactory<OnesideTextDiffViewer> {
        private OnesideAnnotatorFactory() {
        }

        @Override
        @NotNull
        public Class<OnesideTextDiffViewer> getViewerClass() {
            if (OnesideTextDiffViewer.class == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$OnesideAnnotatorFactory", "getViewerClass"));
            }
            return OnesideTextDiffViewer.class;
        }

        @Override
        @Nullable
        public Side getCurrentSide(@NotNull OnesideTextDiffViewer viewer, @NotNull Editor editor) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$OnesideAnnotatorFactory", "getCurrentSide"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$OnesideAnnotatorFactory", "getCurrentSide"));
            }
            if (viewer.getEditor() != editor) {
                return null;
            }
            return viewer.getSide();
        }

        @Override
        public boolean isAnnotationShown(@NotNull OnesideTextDiffViewer viewer, @NotNull Side side) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$OnesideAnnotatorFactory", "isAnnotationShown"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$OnesideAnnotatorFactory", "isAnnotationShown"));
            }
            if (side != viewer.getSide()) {
                return false;
            }
            return viewer.getEditor().getGutter().isAnnotationsShown();
        }

        @Override
        public void showAnnotation(@NotNull OnesideTextDiffViewer viewer, @NotNull Side side, @NotNull AnnotationData data) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$OnesideAnnotatorFactory", "showAnnotation"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$OnesideAnnotatorFactory", "showAnnotation"));
            }
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$OnesideAnnotatorFactory", "showAnnotation"));
            }
            if (side != viewer.getSide()) {
                return;
            }
            Project project2 = (Project)ObjectUtils.assertNotNull((Object)viewer.getProject());
            AnnotateToggleAction.doAnnotate(viewer.getEditor(), project2, null, data.annotation, data.vcs);
        }

        @Override
        public void hideAnnotation(@NotNull OnesideTextDiffViewer viewer, @NotNull Side side) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$OnesideAnnotatorFactory", "hideAnnotation"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$OnesideAnnotatorFactory", "hideAnnotation"));
            }
            viewer.getEditor().getGutter().closeAllAnnotations();
        }
    }

    private static class TwosideAnnotatorFactory
    extends TwosideViewerAnnotatorFactory<TwosideTextDiffViewer> {
        private TwosideAnnotatorFactory() {
        }

        @Override
        @NotNull
        public Class<TwosideTextDiffViewer> getViewerClass() {
            if (TwosideTextDiffViewer.class == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideAnnotatorFactory", "getViewerClass"));
            }
            return TwosideTextDiffViewer.class;
        }

        @Override
        @Nullable
        public Side getCurrentSide(@NotNull TwosideTextDiffViewer viewer, @NotNull Editor editor) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideAnnotatorFactory", "getCurrentSide"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideAnnotatorFactory", "getCurrentSide"));
            }
            Side side = null;
            if (viewer.getEditor(Side.LEFT) == editor) {
                side = Side.LEFT;
            }
            if (viewer.getEditor(Side.RIGHT) == editor) {
                side = Side.RIGHT;
            }
            return side;
        }

        @Override
        public boolean isAnnotationShown(@NotNull TwosideTextDiffViewer viewer, @NotNull Side side) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideAnnotatorFactory", "isAnnotationShown"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideAnnotatorFactory", "isAnnotationShown"));
            }
            return viewer.getEditor(side).getGutter().isAnnotationsShown();
        }

        @Override
        public void showAnnotation(@NotNull TwosideTextDiffViewer viewer, @NotNull Side side, @NotNull AnnotationData data) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideAnnotatorFactory", "showAnnotation"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideAnnotatorFactory", "showAnnotation"));
            }
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideAnnotatorFactory", "showAnnotation"));
            }
            Project project2 = (Project)ObjectUtils.assertNotNull((Object)viewer.getProject());
            AnnotateToggleAction.doAnnotate(viewer.getEditor(side), project2, null, data.annotation, data.vcs);
        }

        @Override
        public void hideAnnotation(@NotNull TwosideTextDiffViewer viewer, @NotNull Side side) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideAnnotatorFactory", "hideAnnotation"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideAnnotatorFactory", "hideAnnotation"));
            }
            viewer.getEditor(side).getGutter().closeAllAnnotations();
        }
    }

    private static class MyDiffViewerListener
    extends DiffViewerListener {
        @NotNull
        private final DiffViewerBase myViewer;

        public MyDiffViewerListener(@NotNull DiffViewerBase viewer) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$MyDiffViewerListener", "<init>"));
            }
            this.myViewer = viewer;
        }

        @Override
        public void onInit() {
            if (this.myViewer.getProject() == null) {
                return;
            }
            for (ViewerAnnotatorFactory annotator : ANNOTATORS) {
                if (!annotator.getViewerClass().isInstance(this.myViewer)) continue;
                annotator.showRememberedAnnotations(this.myViewer);
            }
        }

        @Override
        public void onDispose() {
            if (this.myViewer.getProject() == null) {
                return;
            }
            for (ViewerAnnotatorFactory annotator : ANNOTATORS) {
                if (!annotator.getViewerClass().isInstance(this.myViewer)) continue;
                annotator.rememberShownAnnotations(this.myViewer);
            }
        }
    }

    public static class MyDiffExtension
    extends DiffExtension {
        public void onViewerCreated(@NotNull FrameDiffTool.DiffViewer diffViewer, @NotNull DiffContext context, @NotNull DiffRequest request) {
            if (diffViewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffViewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$MyDiffExtension", "onViewerCreated"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$MyDiffExtension", "onViewerCreated"));
            }
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$MyDiffExtension", "onViewerCreated"));
            }
            if (diffViewer instanceof DiffViewerBase) {
                DiffViewerBase viewer = (DiffViewerBase)diffViewer;
                viewer.addListener(new MyDiffViewerListener(viewer));
            }
        }
    }
}

