/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.actions.AnnotateRevisionActionBase;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.UpToDateLineNumberListener;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.vcsUtil.VcsUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AnnotateRevisionAction
extends AnnotateRevisionActionBase
implements DumbAware,
UpToDateLineNumberListener {
    @NotNull
    protected final FileAnnotation myAnnotation;
    @NotNull
    private final AbstractVcs myVcs;
    private int currentLine;

    public AnnotateRevisionAction(@Nullable String text2, @Nullable String description, @Nullable Icon icon, @NotNull FileAnnotation annotation, @NotNull AbstractVcs vcs) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/openapi/vcs/actions/AnnotateRevisionAction", "<init>"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/actions/AnnotateRevisionAction", "<init>"));
        }
        super(text2, description, icon);
        this.myAnnotation = annotation;
        this.myVcs = vcs;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/AnnotateRevisionAction", "update"));
        }
        if (Boolean.TRUE.equals(e.getData(PlatformDataKeys.IS_MODAL_CONTEXT))) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (this.myAnnotation.getFile() == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        super.update(e);
    }

    @Nullable
    protected abstract VcsFileRevision getRevision(int var1);

    @Override
    @Nullable
    protected AbstractVcs getVcs(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/AnnotateRevisionAction", "getVcs"));
        }
        return this.myVcs;
    }

    @Override
    @Nullable
    protected VirtualFile getFile(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/AnnotateRevisionAction", "getFile"));
        }
        VcsFileRevision revision = this.getFileRevision(e);
        if (revision == null) {
            return null;
        }
        final FileType currentFileType = this.myAnnotation.getFile().getFileType();
        FilePath filePath = revision instanceof VcsFileRevisionEx ? ((VcsFileRevisionEx)revision).getPath() : VcsUtil.getFilePath((VirtualFile)this.myAnnotation.getFile());
        return new VcsVirtualFile(filePath.getPath(), revision, (VirtualFileSystem)VcsFileSystem.getInstance()){

            @NotNull
            public FileType getFileType() {
                FileType type2 = super.getFileType();
                if (!type2.isBinary()) {
                    FileType fileType = type2;
                    if (fileType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/AnnotateRevisionAction$1", "getFileType"));
                    }
                    return fileType;
                }
                if (!currentFileType.isBinary()) {
                    FileType fileType = currentFileType;
                    if (fileType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/AnnotateRevisionAction$1", "getFileType"));
                    }
                    return fileType;
                }
                PlainTextFileType plainTextFileType = PlainTextFileType.INSTANCE;
                if (plainTextFileType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/AnnotateRevisionAction$1", "getFileType"));
                }
                return plainTextFileType;
            }
        };
    }

    @Override
    @Nullable
    protected VcsFileRevision getFileRevision(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/AnnotateRevisionAction", "getFileRevision"));
        }
        return this.getRevision(this.currentLine);
    }

    @Override
    protected int getAnnotatedLine(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/AnnotateRevisionAction", "getAnnotatedLine"));
        }
        if (this.currentLine < 0) {
            return super.getAnnotatedLine(e);
        }
        return this.currentLine;
    }

    @Override
    @Nullable
    protected Editor getEditor(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/AnnotateRevisionAction", "getEditor"));
        }
        return (Editor)e.getData(CommonDataKeys.EDITOR);
    }

    public void consume(Integer integer) {
        this.currentLine = integer;
    }
}

