/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsAnnotateUtil;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AnnotateRevisionActionBase
extends AnAction {
    public AnnotateRevisionActionBase(@Nullable String text2, @Nullable String description, @Nullable Icon icon) {
        super(text2, description, icon);
    }

    @Nullable
    protected abstract AbstractVcs getVcs(@NotNull AnActionEvent var1);

    @Nullable
    protected abstract VirtualFile getFile(@NotNull AnActionEvent var1);

    @Nullable
    protected abstract VcsFileRevision getFileRevision(@NotNull AnActionEvent var1);

    @Nullable
    protected Editor getEditor(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/AnnotateRevisionActionBase", "getEditor"));
        }
        return null;
    }

    protected int getAnnotatedLine(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/AnnotateRevisionActionBase", "getAnnotatedLine"));
        }
        Editor editor = this.getEditor(e);
        return editor == null ? 0 : editor.getCaretModel().getLogicalPosition().line;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/AnnotateRevisionActionBase", "update"));
        }
        e.getPresentation().setEnabled(this.isEnabled(e));
    }

    public boolean isEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/AnnotateRevisionActionBase", "isEnabled"));
        }
        if (e.getProject() == null) {
            return false;
        }
        return AnnotateRevisionActionBase.isEnabled(this.getVcs(e), this.getFile(e), this.getFileRevision(e));
    }

    public static boolean isEnabled(@Nullable AbstractVcs vcs, @Nullable VirtualFile file2, @Nullable VcsFileRevision fileRevision) {
        if (VcsHistoryUtil.isEmpty(fileRevision) || file2 == null || vcs == null) {
            return false;
        }
        AnnotationProvider provider = vcs.getAnnotationProvider();
        if (provider == null || !provider.isAnnotationValid(fileRevision)) {
            return false;
        }
        return !VcsAnnotateUtil.getBackgroundableLock(vcs.getProject(), file2).isLocked();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/AnnotateRevisionActionBase", "actionPerformed"));
        }
        VcsFileRevision fileRevision = this.getFileRevision(e);
        VirtualFile file2 = this.getFile(e);
        AbstractVcs vcs = this.getVcs(e);
        AnnotateRevisionActionBase.annotate((VirtualFile)ObjectUtils.notNull((Object)file2), (VcsFileRevision)ObjectUtils.notNull((Object)fileRevision), (AbstractVcs)ObjectUtils.notNull((Object)vcs), this.getEditor(e), this.getAnnotatedLine(e));
    }

    public static void annotate(final @NotNull VirtualFile file2, final @NotNull VcsFileRevision fileRevision, final @NotNull AbstractVcs vcs, @Nullable Editor editor, final int annotatedLine) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/actions/AnnotateRevisionActionBase", "annotate"));
        }
        if (fileRevision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileRevision", "com/intellij/openapi/vcs/actions/AnnotateRevisionActionBase", "annotate"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/actions/AnnotateRevisionActionBase", "annotate"));
        }
        final CharSequence oldContent = editor == null ? null : editor.getDocument().getImmutableCharSequence();
        final AnnotationProvider annotationProvider = vcs.getAnnotationProvider();
        assert (annotationProvider != null);
        final Ref fileAnnotationRef = new Ref();
        final Ref newLineRef = new Ref();
        final Ref exceptionRef = new Ref();
        VcsAnnotateUtil.getBackgroundableLock(vcs.getProject(), file2).lock();
        final Semaphore semaphore = new Semaphore(0);
        final AtomicBoolean shouldOpenEditorInSync = new AtomicBoolean(true);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(vcs.getProject(), VcsBundle.message((String)"retrieving.annotations", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/actions/AnnotateRevisionActionBase$1", "run"));
                }
                try {
                    FileAnnotation fileAnnotation = annotationProvider.annotate(file2, fileRevision);
                    int newLine = AnnotateRevisionActionBase.translateLine(oldContent, fileAnnotation.getAnnotatedContent(), annotatedLine);
                    fileAnnotationRef.set((Object)fileAnnotation);
                    newLineRef.set((Object)newLine);
                    shouldOpenEditorInSync.set(false);
                    semaphore.release();
                }
                catch (VcsException e) {
                    exceptionRef.set((Object)e);
                }
            }

            public void onFinished() {
                VcsAnnotateUtil.getBackgroundableLock(vcs.getProject(), file2).unlock();
            }

            public void onSuccess() {
                if (!exceptionRef.isNull()) {
                    AbstractVcsHelper.getInstance((Project)this.myProject).showError((VcsException)((Object)exceptionRef.get()), VcsBundle.message((String)"operation.name.annotate", (Object[])new Object[0]));
                }
                if (fileAnnotationRef.isNull()) {
                    return;
                }
                AbstractVcsHelper.getInstance((Project)this.myProject).showAnnotation((FileAnnotation)fileAnnotationRef.get(), file2, vcs, ((Integer)newLineRef.get()).intValue());
            }
        });
        try {
            semaphore.tryAcquire(300L, TimeUnit.MILLISECONDS);
            if (shouldOpenEditorInSync.get()) {
                CharSequence content = LoadTextUtil.loadText(file2);
                int newLine = AnnotateRevisionActionBase.translateLine(oldContent, content, annotatedLine);
                OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(vcs.getProject(), file2, newLine, 0);
                FileEditorManager.getInstance((Project)vcs.getProject()).openTextEditor(openFileDescriptor, true);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static int translateLine(@Nullable CharSequence oldContent, @Nullable CharSequence newContent, int line) {
        if (oldContent == null || newContent == null) {
            return line;
        }
        try {
            return Diff.translateLine((CharSequence)oldContent, (CharSequence)newContent, (int)line, (boolean)true);
        }
        catch (FilesTooBigForDiffException ignore) {
            return line;
        }
    }
}

