/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AbstractCommonCheckinAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.UtilKt;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonCheckinFilesAction
extends AbstractCommonCheckinAction {
    @Override
    protected String getActionName(@NotNull VcsContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/vcs/actions/CommonCheckinFilesAction", "getActionName"));
        }
        String actionName = Optional.ofNullable(dataContext.getProject()).map(project2 -> {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/vcs/actions/CommonCheckinFilesAction", "lambda$getActionName$0"));
            }
            return CommonCheckinFilesAction.getCommonVcs(this.getRootsStream(dataContext), project2);
        }).map(AbstractVcs::getCheckinEnvironment).map(CheckinEnvironment::getCheckinOperationName).orElse(VcsBundle.message((String)"vcs.command.name.checkin", (Object[])new Object[0]));
        return this.modifyCheckinActionName(dataContext, actionName);
    }

    private String modifyCheckinActionName(@NotNull VcsContext dataContext, String checkinActionName) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/vcs/actions/CommonCheckinFilesAction", "modifyCheckinActionName"));
        }
        String result2 = checkinActionName;
        List roots = this.getRootsStream(dataContext).limit(2L).collect(Collectors.toList());
        if (!roots.isEmpty()) {
            String messageKey = ((FilePath)roots.get(0)).isDirectory() ? "action.name.checkin.directory" : "action.name.checkin.file";
            result2 = VcsBundle.message((String)StringUtil.pluralize((String)messageKey, (int)roots.size()), (Object[])new Object[]{checkinActionName});
        }
        return result2;
    }

    @Override
    protected String getMnemonicsFreeActionName(@NotNull VcsContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/CommonCheckinFilesAction", "getMnemonicsFreeActionName"));
        }
        return this.modifyCheckinActionName(context, VcsBundle.message((String)"vcs.command.name.checkin.no.mnemonics", (Object[])new Object[0]));
    }

    @Override
    @Nullable
    protected LocalChangeList getInitiallySelectedChangeList(@NotNull VcsContext context, @NotNull Project project2) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/CommonCheckinFilesAction", "getInitiallySelectedChangeList"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/CommonCheckinFilesAction", "getInitiallySelectedChangeList"));
        }
        ChangeListManager manager = ChangeListManager.getInstance((Project)project2);
        LocalChangeList defaultChangeList = manager.getDefaultChangeList();
        LocalChangeList result2 = null;
        for (FilePath root : this.getRoots(context)) {
            if (root.getVirtualFile() == null) continue;
            Collection changes = manager.getChangesIn(root);
            if (defaultChangeList != null && CommonCheckinFilesAction.containsAnyChange(defaultChangeList, changes)) {
                return defaultChangeList;
            }
            result2 = changes.stream().findFirst().map(arg_0 -> ((ChangeListManager)manager).getChangeList(arg_0)).orElse(null);
        }
        return (LocalChangeList)ObjectUtils.chooseNotNull(result2, (Object)defaultChangeList);
    }

    @Override
    protected boolean approximatelyHasRoots(@NotNull VcsContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/vcs/actions/CommonCheckinFilesAction", "approximatelyHasRoots"));
        }
        FileStatusManager manager = FileStatusManager.getInstance((Project)dataContext.getProject());
        return this.getRootsStream(dataContext).map(FilePath::getVirtualFile).filter(Objects::nonNull).anyMatch(file2 -> {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/vcs/actions/CommonCheckinFilesAction", "lambda$approximatelyHasRoots$1"));
            }
            return this.isApplicableRoot((VirtualFile)file2, manager.getStatus(file2), dataContext);
        });
    }

    protected boolean isApplicableRoot(@NotNull VirtualFile file2, @NotNull FileStatus status, @NotNull VcsContext dataContext) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/actions/CommonCheckinFilesAction", "isApplicableRoot"));
        }
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/openapi/vcs/actions/CommonCheckinFilesAction", "isApplicableRoot"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/vcs/actions/CommonCheckinFilesAction", "isApplicableRoot"));
        }
        return status != FileStatus.UNKNOWN && status != FileStatus.IGNORED;
    }

    @Override
    @NotNull
    protected FilePath[] getRoots(@NotNull VcsContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/CommonCheckinFilesAction", "getRoots"));
        }
        FilePath[] filePathArray = context.getSelectedFilePaths();
        if (filePathArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/CommonCheckinFilesAction", "getRoots"));
        }
        return filePathArray;
    }

    @NotNull
    protected Stream<FilePath> getRootsStream(@NotNull VcsContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/CommonCheckinFilesAction", "getRootsStream"));
        }
        Stream stream = context.getSelectedFilePathsStream();
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/CommonCheckinFilesAction", "getRootsStream"));
        }
        return stream;
    }

    private static boolean containsAnyChange(@NotNull LocalChangeList changeList, @NotNull Collection<Change> changes) {
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "com/intellij/openapi/vcs/actions/CommonCheckinFilesAction", "containsAnyChange"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/actions/CommonCheckinFilesAction", "containsAnyChange"));
        }
        return changes.stream().anyMatch(changeList.getChanges()::contains);
    }

    @Nullable
    private static AbstractVcs getCommonVcs(@NotNull Stream<FilePath> roots, @NotNull Project project2) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/openapi/vcs/actions/CommonCheckinFilesAction", "getCommonVcs"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/CommonCheckinFilesAction", "getCommonVcs"));
        }
        return UtilKt.getIfSingle(roots.map(root -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/CommonCheckinFilesAction", "lambda$getCommonVcs$2"));
            }
            return VcsUtil.getVcsFor((Project)project2, (FilePath)root);
        }).filter(Objects::nonNull).distinct().limit(Math.min(2, ProjectLevelVcsManager.getInstance((Project)project2).getAllActiveVcss().length)));
    }
}

