/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AbstractCommonCheckinAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.vcsUtil.VcsUtil;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class CommonCheckinProjectAction
extends AbstractCommonCheckinAction {
    @Override
    @NotNull
    protected FilePath[] getRoots(@NotNull VcsContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/CommonCheckinProjectAction", "getRoots"));
        }
        ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance((Project)context.getProject());
        FilePath[] filePathArray = (FilePath[])Stream.of(manager.getAllActiveVcss()).filter(vcs -> vcs.getCheckinEnvironment() != null).flatMap(vcs -> Stream.of(manager.getRootsUnderVcs(vcs))).map(VcsUtil::getFilePath).toArray(FilePath[]::new);
        if (filePathArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/CommonCheckinProjectAction", "getRoots"));
        }
        return filePathArray;
    }

    @Override
    protected boolean approximatelyHasRoots(@NotNull VcsContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/vcs/actions/CommonCheckinProjectAction", "approximatelyHasRoots"));
        }
        return true;
    }

    @Override
    protected String getActionName(@NotNull VcsContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/vcs/actions/CommonCheckinProjectAction", "getActionName"));
        }
        return ActionsBundle.message((String)"action.CheckinProject.text", (Object[])new Object[0]);
    }

    @Override
    protected String getMnemonicsFreeActionName(@NotNull VcsContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/CommonCheckinProjectAction", "getMnemonicsFreeActionName"));
        }
        return VcsBundle.message((String)"vcs.command.name.checkin.no.mnemonics", (Object[])new Object[0]);
    }
}

