/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.AbstractShowDiffAction;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.DiffActionExecutor;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.RevisionSelector;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class SelectAndCompareWithSelectedRevisionAction
extends AbstractVcsAction {
    @Override
    protected void actionPerformed(@NotNull VcsContext vcsContext) {
        VcsRevisionNumber vcsRevisionNumber;
        if (vcsContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsContext", "com/intellij/openapi/vcs/actions/SelectAndCompareWithSelectedRevisionAction", "actionPerformed"));
        }
        VirtualFile file2 = vcsContext.getSelectedFiles()[0];
        Project project2 = vcsContext.getProject();
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project2).getVcsFor(file2);
        if (vcs == null) {
            return;
        }
        RevisionSelector selector2 = vcs.getRevisionSelector();
        DiffProvider diffProvider = vcs.getDiffProvider();
        if (selector2 != null && (vcsRevisionNumber = selector2.selectNumber(file2)) != null) {
            DiffActionExecutor.showDiff(diffProvider, vcsRevisionNumber, file2, project2, VcsBackgroundableActions.COMPARE_WITH);
        }
    }

    @Override
    protected void update(@NotNull VcsContext vcsContext, @NotNull Presentation presentation) {
        if (vcsContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsContext", "com/intellij/openapi/vcs/actions/SelectAndCompareWithSelectedRevisionAction", "update"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/vcs/actions/SelectAndCompareWithSelectedRevisionAction", "update"));
        }
        AbstractShowDiffAction.updateDiffAction(presentation, vcsContext, VcsBackgroundableActions.COMPARE_WITH);
    }
}

