/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.google.common.primitives.Ints;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListUtil {
    @Nullable
    public static LocalChangeList getPredefinedChangeList(@NotNull String defaultName, @NotNull ChangeListManager changeListManager) {
        if (defaultName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultName", "com/intellij/openapi/vcs/changes/ChangeListUtil", "getPredefinedChangeList"));
        }
        if (changeListManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeListManager", "com/intellij/openapi/vcs/changes/ChangeListUtil", "getPredefinedChangeList"));
        }
        LocalChangeList sameNamedList = changeListManager.findChangeList(defaultName);
        if (sameNamedList != null) {
            return sameNamedList;
        }
        return ChangeListUtil.tryToMatchWithExistingChangelist(changeListManager, defaultName);
    }

    @Nullable
    private static LocalChangeList tryToMatchWithExistingChangelist(@NotNull ChangeListManager changeListManager, @NotNull String defaultName) {
        if (changeListManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeListManager", "com/intellij/openapi/vcs/changes/ChangeListUtil", "tryToMatchWithExistingChangelist"));
        }
        if (defaultName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultName", "com/intellij/openapi/vcs/changes/ChangeListUtil", "tryToMatchWithExistingChangelist"));
        }
        List matched = ContainerUtil.findAll((Collection)changeListManager.getChangeListsCopy(), list2 -> {
            if (defaultName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultName", "com/intellij/openapi/vcs/changes/ChangeListUtil", "lambda$tryToMatchWithExistingChangelist$0"));
            }
            return defaultName.contains(list2.getName().trim());
        });
        return matched.isEmpty() ? null : (LocalChangeList)Collections.max(matched, (o1, o2) -> Ints.compare((int)o1.getName().trim().length(), (int)o2.getName().trim().length()));
    }
}

