/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.BaseRevision;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeListsIndexes;
import com.intellij.openapi.vcs.changes.ChangesDelta;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListImpl;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vcs.changes.ui.PlusMinusModify;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListWorker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ChangeListWorker");
    private final Project myProject;
    private final Map<String, LocalChangeListImpl> myMap;
    private LocalChangeListImpl myDefault;
    private final ChangeListsIndexes myIdx;
    private final ChangesDelta myDelta;
    private final Set<String> myListsToDisappear;
    private final Map<String, OpenTHashSet<Change>> myChangesBeforeUpdateMap;
    private final Comparator<Pair<Change, String>> CHANGES_AFTER_REVISION_COMPARATOR;

    public ChangeListWorker(@NotNull Project project2, @NotNull PlusMinusModify<BaseRevision> deltaListener) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangeListWorker", "<init>"));
        }
        if (deltaListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deltaListener", "com/intellij/openapi/vcs/changes/ChangeListWorker", "<init>"));
        }
        this.myChangesBeforeUpdateMap = new HashMap<String, OpenTHashSet<Change>>();
        this.CHANGES_AFTER_REVISION_COMPARATOR = (o1, o2) -> {
            String s1 = ((Change)o1.getFirst()).getAfterRevision().getFile().getPresentableUrl();
            String s2 = ((Change)o2.getFirst()).getAfterRevision().getFile().getPresentableUrl();
            return SystemInfo.isFileSystemCaseSensitive ? s1.compareTo(s2) : s1.compareToIgnoreCase(s2);
        };
        this.myProject = project2;
        this.myMap = new LinkedHashMap<String, LocalChangeListImpl>();
        this.myIdx = new ChangeListsIndexes();
        this.myDelta = new ChangesDelta(deltaListener);
        this.myListsToDisappear = ContainerUtil.newLinkedHashSet();
        this.ensureDefaultListExists();
    }

    private ChangeListWorker(ChangeListWorker worker) {
        this.myChangesBeforeUpdateMap = new HashMap<String, OpenTHashSet<Change>>();
        this.CHANGES_AFTER_REVISION_COMPARATOR = (o1, o2) -> {
            String s1 = ((Change)o1.getFirst()).getAfterRevision().getFile().getPresentableUrl();
            String s2 = ((Change)o2.getFirst()).getAfterRevision().getFile().getPresentableUrl();
            return SystemInfo.isFileSystemCaseSensitive ? s1.compareTo(s2) : s1.compareToIgnoreCase(s2);
        };
        this.myProject = worker.myProject;
        this.myMap = new LinkedHashMap<String, LocalChangeListImpl>();
        this.myIdx = new ChangeListsIndexes(worker.myIdx);
        this.myDelta = worker.myDelta;
        this.myListsToDisappear = ContainerUtil.newLinkedHashSet(worker.myListsToDisappear);
        for (LocalChangeListImpl list2 : worker.myMap.values()) {
            LocalChangeListImpl copy = list2.copy();
            this.myMap.put(copy.getName(), copy);
            if (!copy.isDefault()) continue;
            if (this.myDefault != null) {
                LOG.error("multiple default lists found when copy");
            }
            this.myDefault = copy;
        }
        this.ensureDefaultListExists();
    }

    private void ensureDefaultListExists() {
        if (this.myDefault != null) {
            return;
        }
        if (!this.myMap.isEmpty()) {
            this.myDefault = this.myMap.values().iterator().next();
            this.myDefault.setDefault(true);
        } else {
            this.myDefault = LocalChangeListImpl.createEmptyChangeListImpl(this.myProject, LocalChangeList.DEFAULT_NAME, null);
            this.myDefault.setDefault(true);
            this.myMap.put(this.myDefault.getName(), this.myDefault);
        }
    }

    public void onAfterWorkerSwitch(@NotNull ChangeListWorker previous) {
        if (previous == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previous", "com/intellij/openapi/vcs/changes/ChangeListWorker", "onAfterWorkerSwitch"));
        }
        boolean somethingChanged = this.myDelta.notifyPathsChanged(previous.myIdx, this.myIdx);
        if (somethingChanged |= this.checkForMultipleCopiesNotMove()) {
            FileStatusManager.getInstance((Project)this.myProject).fileStatusesChanged();
        }
    }

    private boolean checkForMultipleCopiesNotMove() {
        boolean somethingChanged = false;
        MultiMap moves = new MultiMap();
        for (LocalChangeList localChangeList : this.myMap.values()) {
            Collection changes = localChangeList.getChanges();
            for (Change change : changes) {
                if (!change.isMoved() && !change.isRenamed()) continue;
                moves.putValue((Object)change.getBeforeRevision().getFile(), (Object)Pair.create((Object)change, (Object)localChangeList.getName()));
            }
        }
        for (FilePath filePath : moves.keySet()) {
            List copies = (List)moves.get((Object)filePath);
            if (copies.size() == 1) continue;
            copies.sort(this.CHANGES_AFTER_REVISION_COMPARATOR);
            for (int i = 0; i < copies.size() - 1; ++i) {
                somethingChanged = true;
                Pair item = (Pair)copies.get(i);
                Change oldChange = (Change)item.getFirst();
                Change newChange = new Change(null, oldChange.getAfterRevision());
                LocalChangeListImpl list2 = this.myMap.get(item.getSecond());
                list2.removeChange(oldChange);
                list2.addChange(newChange);
                VcsKey key2 = this.myIdx.getVcsFor(oldChange);
                this.myIdx.changeRemoved(oldChange);
                this.myIdx.changeAdded(newChange, key2);
            }
        }
        return somethingChanged;
    }

    public ChangeListWorker copy() {
        return new ChangeListWorker(this);
    }

    @Nullable
    public LocalChangeList getChangeListByName(@Nullable String name2) {
        return this.myMap.get(name2);
    }

    @Nullable
    public LocalChangeList getChangeListCopyByName(@Nullable String name2) {
        LocalChangeList list2 = this.getChangeListByName(name2);
        return list2 != null ? list2.copy() : null;
    }

    @Nullable
    public LocalChangeList getChangeListById(@Nullable String id) {
        for (LocalChangeList localChangeList : this.myMap.values()) {
            if (!localChangeList.getId().equals(id)) continue;
            return localChangeList;
        }
        return null;
    }

    @Nullable
    public String setDefault(String name2) {
        LocalChangeListImpl newDefault = this.myMap.get(name2);
        if (newDefault == null) {
            return null;
        }
        String previousName = this.myDefault.getName();
        this.myDefault.setDefault(false);
        newDefault.setDefault(true);
        this.myDefault = newDefault;
        return previousName;
    }

    public boolean setReadOnly(String name2, boolean value2) {
        LocalChangeListImpl list2 = this.myMap.get(name2);
        if (list2 != null) {
            list2.setReadOnlyImpl(value2);
        }
        return list2 != null;
    }

    @NotNull
    public LocalChangeList addChangeList(@NotNull String name2, @Nullable String comment, @Nullable Object data) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/ChangeListWorker", "addChangeList"));
        }
        LocalChangeList localChangeList = this.addChangeList(name2, comment, false, data);
        if (localChangeList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListWorker", "addChangeList"));
        }
        return localChangeList;
    }

    @NotNull
    private LocalChangeList addChangeList(@NotNull String name2, @Nullable String description, boolean inUpdate, @Nullable Object data) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/ChangeListWorker", "addChangeList"));
        }
        if (this.myMap.containsKey(name2)) {
            LOG.error("Attempt to create duplicate changelist " + name2);
            LocalChangeList localChangeList = this.myMap.get(name2);
            if (localChangeList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListWorker", "addChangeList"));
            }
            return localChangeList;
        }
        LocalChangeListImpl newList = LocalChangeListImpl.createEmptyChangeListImpl(this.myProject, name2, null);
        newList.setCommentImpl(description);
        newList.setData(data);
        this.myMap.put(name2, newList);
        if (inUpdate) {
            this.startProcessingChanges(newList);
        }
        LocalChangeListImpl localChangeListImpl = newList;
        if (localChangeListImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListWorker", "addChangeList"));
        }
        return localChangeListImpl;
    }

    void setChangeLists(@NotNull Collection<LocalChangeListImpl> lists) {
        if (lists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists", "com/intellij/openapi/vcs/changes/ChangeListWorker", "setChangeLists"));
        }
        this.myDefault = null;
        this.myMap.clear();
        this.myIdx.clear();
        for (LocalChangeListImpl list2 : lists) {
            this.myMap.put(list2.getName(), list2);
            if (list2.isDefault()) {
                if (this.myDefault != null) {
                    LOG.error("multiple default lists found when copy");
                }
                this.myDefault = list2;
            }
            for (Change change : list2.getChanges()) {
                this.myIdx.changeAdded(change, null);
            }
        }
        this.ensureDefaultListExists();
    }

    private void addChangeToList(@NotNull LocalChangeListImpl list2, @NotNull Change change, VcsKey vcsKey) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/ChangeListWorker", "addChangeToList"));
        }
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ChangeListWorker", "addChangeToList"));
        }
        list2.addChange(change);
        this.myIdx.changeAdded(change, vcsKey);
    }

    public void addChangeToList(@NotNull String name2, @NotNull Change change, VcsKey vcsKey) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/ChangeListWorker", "addChangeToList"));
        }
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ChangeListWorker", "addChangeToList"));
        }
        LOG.debug("[addChangeToList] name: " + name2 + " change: " + ChangesUtil.getFilePath((Change)change).getPath() + " vcs: " + (vcsKey == null ? null : vcsKey.getName()));
        LocalChangeListImpl changeList = this.myMap.get(name2);
        if (changeList == null) {
            return;
        }
        this.addChangeToList(changeList, change, vcsKey);
    }

    public void addChangeToCorrespondingList(@NotNull Change change, VcsKey vcsKey) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ChangeListWorker", "addChangeToCorrespondingList"));
        }
        String path = ChangesUtil.getFilePath((Change)change).getPath();
        LOG.debug("[addChangeToCorrespondingList] for change " + path + " type: " + change.getType() + " have before revision: " + (change.getBeforeRevision() != null));
        for (LocalChangeListImpl list2 : this.myMap.values()) {
            OpenTHashSet<Change> changesBeforeUpdate = this.myChangesBeforeUpdateMap.get(list2.getName());
            if (!changesBeforeUpdate.contains((Object)change)) continue;
            LOG.debug("[addChangeToCorrespondingList] matched: " + list2.getName());
            this.addChangeToList(list2, change, vcsKey);
            return;
        }
        LOG.debug("[addChangeToCorrespondingList] added to default list");
        this.addChangeToList(this.myDefault, change, vcsKey);
    }

    public boolean removeChangeList(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/ChangeListWorker", "removeChangeList"));
        }
        LocalChangeList list2 = this.myMap.get(name2);
        if (list2 == null) {
            return false;
        }
        if (list2.isDefault()) {
            LOG.error("Cannot remove default changelist");
            return false;
        }
        for (Change change : list2.getChanges()) {
            this.myDefault.addChange(change);
        }
        this.myMap.remove(name2);
        return true;
    }

    @Nullable
    public MultiMap<LocalChangeList, Change> moveChangesTo(String name2, @NotNull Change[] changes) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ChangeListWorker", "moveChangesTo"));
        }
        LocalChangeListImpl changeList = this.myMap.get(name2);
        if (changeList != null) {
            MultiMap result2 = new MultiMap();
            for (LocalChangeListImpl list2 : this.myMap.values()) {
                if (list2.equals((Object)changeList)) continue;
                for (Change change : changes) {
                    Change removedChange = list2.removeChange(change);
                    if (removedChange == null) continue;
                    changeList.addChange(removedChange);
                    result2.putValue((Object)list2, (Object)removedChange);
                }
            }
            return result2;
        }
        return null;
    }

    public boolean editName(@NotNull String fromName, @NotNull String toName) {
        if (fromName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromName", "com/intellij/openapi/vcs/changes/ChangeListWorker", "editName"));
        }
        if (toName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toName", "com/intellij/openapi/vcs/changes/ChangeListWorker", "editName"));
        }
        if (fromName.equals(toName)) {
            return false;
        }
        if (this.myMap.containsKey(toName)) {
            return false;
        }
        LocalChangeListImpl list2 = this.myMap.get(fromName);
        if (list2 == null || list2.isReadOnly()) {
            return false;
        }
        LocalChangeListImpl newList = list2.copy(toName);
        this.myMap.remove(fromName);
        this.myMap.put(toName, newList);
        OpenTHashSet<Change> changesBeforeUpdateFrom = this.myChangesBeforeUpdateMap.remove(fromName);
        OpenTHashSet<Change> changesBeforeUpdateTo = this.myChangesBeforeUpdateMap.put(toName, changesBeforeUpdateFrom);
        LOG.assertTrue(changesBeforeUpdateTo == null, (Object)"old changes for new changelist name found during rename");
        return true;
    }

    @Nullable
    public String editComment(@NotNull String name2, @Nullable String newComment) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/ChangeListWorker", "editComment"));
        }
        LocalChangeListImpl list2 = this.myMap.get(name2);
        if (list2 == null) {
            return null;
        }
        String oldComment = list2.getComment();
        if (!Comparing.equal((String)oldComment, (String)newComment)) {
            list2.setCommentImpl(newComment);
        }
        return oldComment;
    }

    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @NotNull
    public LocalChangeList getDefaultList() {
        LocalChangeListImpl localChangeListImpl = this.myDefault;
        if (localChangeListImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListWorker", "getDefaultList"));
        }
        return localChangeListImpl;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListWorker", "getProject"));
        }
        return project2;
    }

    public void notifyStartProcessingChanges(@Nullable VcsModifiableDirtyScope scope) {
        ArrayList<Change> removedChanges = new ArrayList<Change>();
        for (LocalChangeListImpl list2 : this.myMap.values()) {
            this.startProcessingChanges(list2);
            removedChanges.addAll(this.removeChangesUnderScope(list2, scope));
        }
        if (scope != null) {
            for (Change change : removedChanges) {
                if (!change.isMoved() && !change.isRenamed()) continue;
                scope.addDirtyFile(change.getBeforeRevision().getFile());
                scope.addDirtyFile(change.getAfterRevision().getFile());
            }
        }
    }

    public void notifyDoneProcessingChanges(ChangeListListener dispatcher) {
        ArrayList<LocalChangeListImpl> changedLists = new ArrayList<LocalChangeListImpl>();
        HashMap<LocalChangeListImpl, ArrayList<Change>> removedChanges = new HashMap<LocalChangeListImpl, ArrayList<Change>>();
        HashMap<LocalChangeListImpl, ArrayList<Change>> addedChanges = new HashMap<LocalChangeListImpl, ArrayList<Change>>();
        for (LocalChangeListImpl localChangeListImpl : this.myMap.values()) {
            ArrayList<Change> added;
            ArrayList<Change> removed;
            if (this.doneProcessingChanges(localChangeListImpl, removed = new ArrayList<Change>(), added = new ArrayList<Change>())) {
                changedLists.add(localChangeListImpl);
            }
            if (!removed.isEmpty()) {
                removedChanges.put(localChangeListImpl, removed);
            }
            if (added.isEmpty()) continue;
            addedChanges.put(localChangeListImpl, added);
        }
        for (Map.Entry entry : removedChanges.entrySet()) {
            dispatcher.changesRemoved((Collection)entry.getValue(), (ChangeList)entry.getKey());
        }
        for (Map.Entry entry : addedChanges.entrySet()) {
            dispatcher.changesAdded((Collection)entry.getValue(), (ChangeList)entry.getKey());
        }
        for (ChangeList changeList : changedLists) {
            dispatcher.changeListChanged(changeList);
        }
        for (String string : this.myListsToDisappear) {
            LocalChangeList changeList = this.myMap.get(string);
            if (changeList == null || !changeList.getChanges().isEmpty() || changeList.isReadOnly() || changeList.isDefault()) continue;
            this.removeChangeList(string);
        }
        this.myListsToDisappear.clear();
        this.myChangesBeforeUpdateMap.clear();
    }

    private void startProcessingChanges(@NotNull LocalChangeListImpl list2) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/ChangeListWorker", "startProcessingChanges"));
        }
        OpenTHashSet changesBeforeUpdate = new OpenTHashSet(list2.getChanges());
        this.myChangesBeforeUpdateMap.put(list2.getName(), (OpenTHashSet<Change>)changesBeforeUpdate);
    }

    @NotNull
    private List<Change> removeChangesUnderScope(@NotNull LocalChangeListImpl list2, @Nullable VcsModifiableDirtyScope scope) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/ChangeListWorker", "removeChangesUnderScope"));
        }
        ArrayList<Change> removed = new ArrayList<Change>();
        for (Change change : list2.getChanges()) {
            ContentRevision before = change.getBeforeRevision();
            ContentRevision after2 = change.getAfterRevision();
            boolean isUnderScope = scope == null || before != null && scope.belongsTo(before.getFile()) || after2 != null && scope.belongsTo(after2.getFile()) || ChangeListWorker.isIgnoredChange(before, after2, this.myProject);
            if (!isUnderScope) continue;
            list2.removeChange(change);
            this.myIdx.changeRemoved(change);
            removed.add(change);
        }
        ArrayList<Change> arrayList = removed;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListWorker", "removeChangesUnderScope"));
        }
        return arrayList;
    }

    private static boolean isIgnoredChange(@Nullable ContentRevision before, @Nullable ContentRevision after2, @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangeListWorker", "isIgnoredChange"));
        }
        return ChangeListWorker.isIgnoredRevision(before, project2) && ChangeListWorker.isIgnoredRevision(after2, project2);
    }

    private static boolean isIgnoredRevision(@Nullable ContentRevision revision, @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangeListWorker", "isIgnoredRevision"));
        }
        if (revision == null) {
            return true;
        }
        return (Boolean)ReadAction.compute(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangeListWorker", "lambda$isIgnoredRevision$0"));
            }
            if (project2.isDisposed()) {
                return false;
            }
            VirtualFile vFile = revision.getFile().getVirtualFile();
            return vFile != null && ProjectLevelVcsManager.getInstance((Project)project2).isIgnored(vFile);
        });
    }

    private boolean doneProcessingChanges(@NotNull LocalChangeListImpl list2, @NotNull List<Change> removedChanges, @NotNull List<Change> addedChanges) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/ChangeListWorker", "doneProcessingChanges"));
        }
        if (removedChanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "removedChanges", "com/intellij/openapi/vcs/changes/ChangeListWorker", "doneProcessingChanges"));
        }
        if (addedChanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "addedChanges", "com/intellij/openapi/vcs/changes/ChangeListWorker", "doneProcessingChanges"));
        }
        OpenTHashSet<Change> changesBeforeUpdate = this.myChangesBeforeUpdateMap.get(list2.getName());
        Collection changes = list2.getChanges();
        for (Change newChange : changes) {
            Change oldChange = ChangeListWorker.findOldChange(changesBeforeUpdate, newChange);
            if (oldChange != null) continue;
            addedChanges.add(newChange);
        }
        removedChanges.addAll((Collection<Change>)changesBeforeUpdate);
        removedChanges.removeAll(changes);
        return changes.size() != changesBeforeUpdate.size() || !addedChanges.isEmpty() || !removedChanges.isEmpty();
    }

    @Nullable
    private static Change findOldChange(@NotNull OpenTHashSet<Change> changesBeforeUpdate, @NotNull Change newChange) {
        if (changesBeforeUpdate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changesBeforeUpdate", "com/intellij/openapi/vcs/changes/ChangeListWorker", "findOldChange"));
        }
        if (newChange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newChange", "com/intellij/openapi/vcs/changes/ChangeListWorker", "findOldChange"));
        }
        Change oldChange = (Change)changesBeforeUpdate.get((Object)newChange);
        if (oldChange != null && ChangeListWorker.sameBeforeRevision(oldChange, newChange) && newChange.getFileStatus().equals(oldChange.getFileStatus())) {
            return oldChange;
        }
        return null;
    }

    private static boolean sameBeforeRevision(@NotNull Change change1, @NotNull Change change2) {
        if (change1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change1", "com/intellij/openapi/vcs/changes/ChangeListWorker", "sameBeforeRevision"));
        }
        if (change2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change2", "com/intellij/openapi/vcs/changes/ChangeListWorker", "sameBeforeRevision"));
        }
        ContentRevision b1 = change1.getBeforeRevision();
        ContentRevision b2 = change2.getBeforeRevision();
        if (b1 != null && b2 != null) {
            VcsRevisionNumber rn1 = b1.getRevisionNumber();
            VcsRevisionNumber rn2 = b2.getRevisionNumber();
            boolean isBinary1 = b1 instanceof BinaryContentRevision;
            boolean isBinary2 = b2 instanceof BinaryContentRevision;
            return rn1 != VcsRevisionNumber.NULL && rn2 != VcsRevisionNumber.NULL && rn1.compareTo((Object)rn2) == 0 && isBinary1 == isBinary2;
        }
        return b1 == null && b2 == null;
    }

    @NotNull
    public List<LocalChangeList> getChangeLists() {
        ArrayList<LocalChangeList> arrayList = new ArrayList<LocalChangeList>(this.myMap.values());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListWorker", "getChangeLists"));
        }
        return arrayList;
    }

    @NotNull
    public List<File> getAffectedPaths() {
        NavigableSet<FilePath> set2 = this.myIdx.getAffectedPaths();
        ArrayList<File> result2 = new ArrayList<File>(set2.size());
        for (FilePath path : set2) {
            result2.add(path.getIOFile());
        }
        ArrayList<File> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListWorker", "getAffectedPaths"));
        }
        return arrayList;
    }

    @NotNull
    public List<VirtualFile> getAffectedFiles() {
        LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
        for (LocalChangeList localChangeList : this.myMap.values()) {
            for (Change change : localChangeList.getChanges()) {
                VirtualFile file2;
                VirtualFile file22;
                ContentRevision before = change.getBeforeRevision();
                ContentRevision after2 = change.getAfterRevision();
                if (before != null && (file22 = before.getFile().getVirtualFile()) != null) {
                    result2.add(file22);
                }
                if (after2 == null || (file2 = after2.getFile().getVirtualFile()) == null) continue;
                result2.add(file2);
            }
        }
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>(result2);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListWorker", "getAffectedFiles"));
        }
        return arrayList;
    }

    @Nullable
    public LocalChangeList getChangeListFor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ChangeListWorker", "getChangeListFor"));
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file2);
        Pair<LocalChangeListImpl, Change> pair2 = this.getChangeAndListByPath(filePath);
        if (pair2 == null) {
            return null;
        }
        return (LocalChangeList)pair2.first;
    }

    public void removeRegisteredChangeFor(@Nullable FilePath filePath) {
        this.myIdx.remove(filePath);
        Pair<LocalChangeListImpl, Change> pair2 = this.getChangeAndListByPath(filePath);
        if (pair2 == null) {
            return;
        }
        LocalChangeListImpl list2 = (LocalChangeListImpl)((Object)pair2.first);
        Change change = (Change)pair2.second;
        list2.removeChange(change);
    }

    @Nullable
    public Change getChangeForPath(@Nullable FilePath filePath) {
        Pair<LocalChangeListImpl, Change> pair2 = this.getChangeAndListByPath(filePath);
        if (pair2 == null) {
            return null;
        }
        return (Change)pair2.second;
    }

    @Nullable
    private Pair<LocalChangeListImpl, Change> getChangeAndListByPath(@Nullable FilePath filePath) {
        if (filePath == null) {
            return null;
        }
        for (LocalChangeListImpl list2 : this.myMap.values()) {
            for (Change change : list2.getChanges()) {
                ContentRevision before = change.getBeforeRevision();
                ContentRevision after2 = change.getAfterRevision();
                if ((before == null || !before.getFile().equals(filePath)) && (after2 == null || !after2.getFile().equals(filePath))) continue;
                return Pair.create((Object)((Object)list2), (Object)change);
            }
        }
        return null;
    }

    @Nullable
    public FileStatus getStatus(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ChangeListWorker", "getStatus"));
        }
        return this.myIdx.getStatus(file2);
    }

    @Nullable
    public FileStatus getStatus(@NotNull FilePath file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ChangeListWorker", "getStatus"));
        }
        return this.myIdx.getStatus(file2);
    }

    @NotNull
    public Collection<Change> getAllChanges() {
        HashSet<Change> changes = new HashSet<Change>();
        for (LocalChangeList localChangeList : this.myMap.values()) {
            changes.addAll(localChangeList.getChanges());
        }
        HashSet<Change> hashSet = changes;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListWorker", "getAllChanges"));
        }
        return hashSet;
    }

    public int getChangeListsNumber() {
        return this.myMap.size();
    }

    @NotNull
    public Collection<LocalChangeList> getInvolvedListsFilterChanges(@NotNull Collection<Change> changes, @NotNull List<Change> validChanges) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ChangeListWorker", "getInvolvedListsFilterChanges"));
        }
        if (validChanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "validChanges", "com/intellij/openapi/vcs/changes/ChangeListWorker", "getInvolvedListsFilterChanges"));
        }
        HashSet<LocalChangeList> includedListsCopies = new HashSet<LocalChangeList>();
        HashMap<Change, LocalChangeList> internalMap = new HashMap<Change, LocalChangeList>();
        for (LocalChangeList localChangeList : this.myMap.values()) {
            for (Change change : localChangeList.getChanges()) {
                internalMap.put(change, localChangeList);
            }
        }
        for (Change change : changes) {
            LocalChangeList list3 = (LocalChangeList)internalMap.get(change);
            if (list3 == null) continue;
            includedListsCopies.add(list3);
            validChanges.add(change);
        }
        HashSet<LocalChangeList> hashSet = includedListsCopies;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListWorker", "getInvolvedListsFilterChanges"));
        }
        return hashSet;
    }

    @Nullable
    public LocalChangeList getChangeListForChange(Change change) {
        for (LocalChangeList localChangeList : this.myMap.values()) {
            if (!localChangeList.getChanges().contains(change)) continue;
            return localChangeList;
        }
        return null;
    }

    @Nullable
    public LocalChangeList getChangeListIfOnlyOne(@Nullable Change[] changes) {
        if (changes == null || changes.length == 0) {
            return null;
        }
        Change first = changes[0];
        for (LocalChangeList localChangeList : this.myMap.values()) {
            Collection listChanges = localChangeList.getChanges();
            if (!listChanges.contains(first)) continue;
            for (int i = 1; i < changes.length; ++i) {
                Change change = changes[i];
                if (listChanges.contains(change)) continue;
                return null;
            }
            return localChangeList;
        }
        return null;
    }

    public ThreeState haveChangesUnder(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vcs/changes/ChangeListWorker", "haveChangesUnder"));
        }
        FilePath dir = VcsUtil.getFilePath((VirtualFile)virtualFile);
        FilePath changeCandidate = this.myIdx.getAffectedPaths().ceiling(dir);
        if (changeCandidate == null) {
            return ThreeState.NO;
        }
        return FileUtil.isAncestorThreeState((String)dir.getPath(), (String)changeCandidate.getPath(), (boolean)false);
    }

    @NotNull
    public List<Change> getChangesIn(@NotNull FilePath dirPath) {
        if (dirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirPath", "com/intellij/openapi/vcs/changes/ChangeListWorker", "getChangesIn"));
        }
        ArrayList<Change> changes = new ArrayList<Change>();
        for (ChangeList changeList : this.myMap.values()) {
            for (Change change : changeList.getChanges()) {
                ContentRevision after2 = change.getAfterRevision();
                ContentRevision before = change.getBeforeRevision();
                if ((after2 == null || !after2.getFile().isUnder(dirPath, false)) && (before == null || !before.getFile().isUnder(dirPath, false))) continue;
                changes.add(change);
            }
        }
        ArrayList<Change> arrayList = changes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListWorker", "getChangesIn"));
        }
        return arrayList;
    }

    @Nullable
    public VcsKey getVcsFor(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ChangeListWorker", "getVcsFor"));
        }
        return this.myIdx.getVcsFor(change);
    }

    public void setListsToDisappear(@NotNull Collection<String> names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/openapi/vcs/changes/ChangeListWorker", "setListsToDisappear"));
        }
        this.myListsToDisappear.addAll(names);
    }

    @NotNull
    public ChangeListManagerGate createGate() {
        MyGate myGate = new MyGate(this);
        if (myGate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListWorker", "createGate"));
        }
        return myGate;
    }

    public String toString() {
        return String.format("ChangeListWorker{myMap=%s}", StringUtil.join(this.myMap.values(), list2 -> String.format("list: %s changes: %s", list2.getName(), StringUtil.join((Iterable)list2.getChanges(), (String)", ")), (String)"\n"));
    }

    private static class MyGate
    implements ChangeListManagerGate {
        private final ChangeListWorker myWorker;

        private MyGate(ChangeListWorker worker) {
            this.myWorker = worker;
        }

        @NotNull
        public List<LocalChangeList> getListsCopy() {
            List list2 = ContainerUtil.map(this.myWorker.getChangeLists(), LocalChangeList::copy);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListWorker$MyGate", "getListsCopy"));
            }
            return list2;
        }

        @Nullable
        public LocalChangeList findChangeList(String name2) {
            return this.myWorker.getChangeListCopyByName(name2);
        }

        @NotNull
        public LocalChangeList addChangeList(@NotNull String name2, @Nullable String comment) {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/ChangeListWorker$MyGate", "addChangeList"));
            }
            LocalChangeList localChangeList = this.myWorker.addChangeList(name2, comment, true, null).copy();
            if (localChangeList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListWorker$MyGate", "addChangeList"));
            }
            return localChangeList;
        }

        @NotNull
        public LocalChangeList findOrCreateList(@NotNull String name2, String comment) {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/ChangeListWorker$MyGate", "findOrCreateList"));
            }
            LocalChangeList list2 = this.myWorker.getChangeListByName(name2);
            if (list2 == null) {
                list2 = this.addChangeList(name2, comment);
            }
            LocalChangeList localChangeList = list2.copy();
            if (localChangeList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListWorker$MyGate", "findOrCreateList"));
            }
            return localChangeList;
        }

        public void editComment(@NotNull String name2, String comment) {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/ChangeListWorker$MyGate", "editComment"));
            }
            this.myWorker.editComment(name2, comment);
        }

        public void editName(@NotNull String oldName, @NotNull String newName) {
            if (oldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldName", "com/intellij/openapi/vcs/changes/ChangeListWorker$MyGate", "editName"));
            }
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/vcs/changes/ChangeListWorker$MyGate", "editName"));
            }
            this.myWorker.editName(oldName, newName);
        }

        public void setListsToDisappear(@NotNull Collection<String> names) {
            if (names == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/openapi/vcs/changes/ChangeListWorker$MyGate", "setListsToDisappear"));
            }
            this.myWorker.setListsToDisappear(names);
        }

        public FileStatus getStatus(@NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ChangeListWorker$MyGate", "getStatus"));
            }
            return this.myWorker.getStatus(file2);
        }

        @Deprecated
        public FileStatus getStatus(@NotNull File file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ChangeListWorker$MyGate", "getStatus"));
            }
            return this.myWorker.getStatus(VcsUtil.getFilePath((File)file2));
        }

        public FileStatus getStatus(@NotNull FilePath filePath) {
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/changes/ChangeListWorker$MyGate", "getStatus"));
            }
            return this.myWorker.getStatus(filePath);
        }

        public void setDefaultChangeList(@NotNull String list2) {
            if (list2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/ChangeListWorker$MyGate", "setDefaultChangeList"));
            }
            this.myWorker.setDefault(list2);
        }
    }
}

