/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.BaseRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.HierarchicalFilePathComparator;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BeforeAfter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListsIndexes {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ChangeListsIndexes");
    private final TreeMap<FilePath, Data> myMap;

    public ChangeListsIndexes() {
        this.myMap = new TreeMap(HierarchicalFilePathComparator.SYSTEM_CASE_SENSITIVE);
    }

    public ChangeListsIndexes(@NotNull ChangeListsIndexes idx) {
        if (idx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idx", "com/intellij/openapi/vcs/changes/ChangeListsIndexes", "<init>"));
        }
        this.myMap = new TreeMap<FilePath, Data>((SortedMap<FilePath, Data>)idx.myMap);
    }

    private void add(@NotNull FilePath file2, @NotNull FileStatus status, @Nullable VcsKey key2, @NotNull VcsRevisionNumber number) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ChangeListsIndexes", "add"));
        }
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/openapi/vcs/changes/ChangeListsIndexes", "add"));
        }
        if (number == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "number", "com/intellij/openapi/vcs/changes/ChangeListsIndexes", "add"));
        }
        this.myMap.put(file2, new Data(status, key2, number));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set status " + status + " for " + file2);
        }
    }

    public void remove(FilePath file2) {
        this.myMap.remove(file2);
    }

    @Nullable
    public FileStatus getStatus(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ChangeListsIndexes", "getStatus"));
        }
        return this.getStatus(VcsUtil.getFilePath((VirtualFile)file2));
    }

    @Nullable
    public FileStatus getStatus(@NotNull FilePath file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ChangeListsIndexes", "getStatus"));
        }
        Data data = this.myMap.get(file2);
        return data != null ? data.status : null;
    }

    public void changeAdded(@NotNull Change change, VcsKey key2) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ChangeListsIndexes", "changeAdded"));
        }
        ContentRevision afterRevision = change.getAfterRevision();
        ContentRevision beforeRevision = change.getBeforeRevision();
        if (beforeRevision != null && afterRevision != null) {
            this.add(afterRevision.getFile(), change.getFileStatus(), key2, beforeRevision.getRevisionNumber());
            if (!Comparing.equal((Object)beforeRevision.getFile(), (Object)afterRevision.getFile())) {
                this.add(beforeRevision.getFile(), FileStatus.DELETED, key2, beforeRevision.getRevisionNumber());
            }
        } else if (afterRevision != null) {
            this.add(afterRevision.getFile(), change.getFileStatus(), key2, VcsRevisionNumber.NULL);
        } else if (beforeRevision != null) {
            this.add(beforeRevision.getFile(), change.getFileStatus(), key2, beforeRevision.getRevisionNumber());
        }
    }

    public void changeRemoved(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ChangeListsIndexes", "changeRemoved"));
        }
        ContentRevision afterRevision = change.getAfterRevision();
        ContentRevision beforeRevision = change.getBeforeRevision();
        if (afterRevision != null) {
            this.remove(afterRevision.getFile());
        }
        if (beforeRevision != null) {
            this.remove(beforeRevision.getFile());
        }
    }

    @Nullable
    public VcsKey getVcsFor(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ChangeListsIndexes", "getVcsFor"));
        }
        VcsKey key2 = this.getVcsForRevision(change.getAfterRevision());
        if (key2 != null) {
            return key2;
        }
        return this.getVcsForRevision(change.getBeforeRevision());
    }

    @Nullable
    private VcsKey getVcsForRevision(@Nullable ContentRevision revision) {
        if (revision != null) {
            Data data = this.myMap.get(revision.getFile());
            return data != null ? data.vcsKey : null;
        }
        return null;
    }

    public void getDelta(ChangeListsIndexes newIndexes, Set<BaseRevision> toRemove2, Set<BaseRevision> toAdd, Set<BeforeAfter<BaseRevision>> toModify) {
        Data data;
        TreeMap<FilePath, Data> oldMap = this.myMap;
        TreeMap<FilePath, Data> newMap = newIndexes.myMap;
        Set<FilePath> oldFiles = oldMap.keySet();
        Set<FilePath> newFiles = newMap.keySet();
        HashSet toRemoveSet = ContainerUtil.newHashSet(oldFiles);
        toRemoveSet.removeAll(newFiles);
        HashSet toAddSet = ContainerUtil.newHashSet(newFiles);
        toAddSet.removeAll(oldFiles);
        HashSet toModifySet = ContainerUtil.newHashSet(oldFiles);
        toModifySet.removeAll(toRemoveSet);
        for (FilePath s : toRemoveSet) {
            data = oldMap.get(s);
            toRemove2.add(ChangeListsIndexes.createBaseRevision(s, data));
        }
        for (FilePath s : toAddSet) {
            data = newMap.get(s);
            toAdd.add(ChangeListsIndexes.createBaseRevision(s, data));
        }
        for (FilePath s : toModifySet) {
            Data oldData = oldMap.get(s);
            Data newData = newMap.get(s);
            assert (oldData != null && newData != null);
            if (oldData.sameRevisions(newData)) continue;
            toModify.add((BeforeAfter<BaseRevision>)new BeforeAfter((Object)ChangeListsIndexes.createBaseRevision(s, oldData), (Object)ChangeListsIndexes.createBaseRevision(s, newData)));
        }
    }

    private static BaseRevision createBaseRevision(@NotNull FilePath path, @NotNull Data data) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/changes/ChangeListsIndexes", "createBaseRevision"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/vcs/changes/ChangeListsIndexes", "createBaseRevision"));
        }
        return new BaseRevision(data.vcsKey, data.revision, path);
    }

    @NotNull
    public List<BaseRevision> getAffectedFilesUnderVcs() {
        ArrayList<BaseRevision> result2 = new ArrayList<BaseRevision>();
        for (Map.Entry<FilePath, Data> entry : this.myMap.entrySet()) {
            Data value2 = entry.getValue();
            result2.add(ChangeListsIndexes.createBaseRevision(entry.getKey(), value2));
        }
        ArrayList<BaseRevision> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListsIndexes", "getAffectedFilesUnderVcs"));
        }
        return arrayList;
    }

    public void clear() {
        this.myMap.clear();
    }

    @NotNull
    public NavigableSet<FilePath> getAffectedPaths() {
        NavigableSet navigableSet = Sets.unmodifiableNavigableSet(this.myMap.navigableKeySet());
        if (navigableSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListsIndexes", "getAffectedPaths"));
        }
        return navigableSet;
    }

    private static class Data {
        @NotNull
        public final FileStatus status;
        public final VcsKey vcsKey;
        @NotNull
        public final VcsRevisionNumber revision;

        public Data(@NotNull FileStatus status, VcsKey vcsKey, @NotNull VcsRevisionNumber revision) {
            if (status == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/openapi/vcs/changes/ChangeListsIndexes$Data", "<init>"));
            }
            if (revision == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/intellij/openapi/vcs/changes/ChangeListsIndexes$Data", "<init>"));
            }
            this.status = status;
            this.vcsKey = vcsKey;
            this.revision = revision;
        }

        public boolean sameRevisions(@NotNull Data data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/vcs/changes/ChangeListsIndexes$Data", "sameRevisions"));
            }
            return Comparing.equal((Object)this.vcsKey, (Object)data.vcsKey) && Comparing.equal((Object)this.revision, (Object)data.revision);
        }
    }
}

