/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.util.Alarm;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class ControlledCycle {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ControlledCycle");
    private final Alarm mySimpleAlarm;
    private final int myRefreshInterval;
    private final Runnable myRunnable;
    private final AtomicBoolean myActive;

    public ControlledCycle(final @NotNull Project project2, final Getter<Boolean> callback, @NotNull String name2, int refreshInterval) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ControlledCycle", "<init>"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/ControlledCycle", "<init>"));
        }
        this.myRefreshInterval = refreshInterval;
        this.myActive = new AtomicBoolean(false);
        this.myRunnable = new Runnable(){
            boolean shouldBeContinued = true;

            @Override
            public void run() {
                if (!ControlledCycle.this.myActive.get() || project2.isDisposed()) {
                    return;
                }
                try {
                    this.shouldBeContinued = (Boolean)callback.get();
                }
                catch (ProcessCanceledException e) {
                    return;
                }
                catch (RuntimeException e) {
                    LOG.info((Throwable)e);
                }
                if (!this.shouldBeContinued) {
                    ControlledCycle.this.myActive.set(false);
                } else {
                    ControlledCycle.this.mySimpleAlarm.addRequest(ControlledCycle.this.myRunnable, ControlledCycle.this.myRefreshInterval);
                }
            }
        };
        this.mySimpleAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project2);
    }

    public void startIfNotStarted() {
        if (this.myActive.compareAndSet(false, true)) {
            this.mySimpleAlarm.addRequest(this.myRunnable, this.myRefreshInterval);
        }
    }

    public void stop() {
        this.myActive.set(false);
    }
}

