/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalChangeListImpl
extends LocalChangeList {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ChangeList");
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<Change> myChanges;
    private Set<Change> myReadChangesCache;
    @NotNull
    private final String myId;
    @NotNull
    private final String myName;
    @NotNull
    private String myComment;
    @Nullable
    private Object myData;
    private boolean myIsDefault;
    private boolean myIsReadOnly;

    @NotNull
    public static LocalChangeListImpl createEmptyChangeListImpl(@NotNull Project project2, @NotNull String name2, @Nullable String id) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "createEmptyChangeListImpl"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "createEmptyChangeListImpl"));
        }
        LocalChangeListImpl localChangeListImpl = new LocalChangeListImpl(project2, name2, id);
        if (localChangeListImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "createEmptyChangeListImpl"));
        }
        return localChangeListImpl;
    }

    private LocalChangeListImpl(@NotNull Project project2, @NotNull String name2, @Nullable String id) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "<init>"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "<init>"));
        }
        this.myReadChangesCache = null;
        this.myComment = "";
        this.myIsDefault = false;
        this.myIsReadOnly = false;
        this.myProject = project2;
        this.myId = id != null ? id : UUID.randomUUID().toString();
        this.myName = LocalChangeListImpl.validateName(name2);
        this.myChanges = ContainerUtil.newHashSet();
    }

    private LocalChangeListImpl(@NotNull LocalChangeListImpl origin, @NotNull String name2) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "<init>"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "<init>"));
        }
        this.myReadChangesCache = null;
        this.myComment = "";
        this.myIsDefault = false;
        this.myIsReadOnly = false;
        this.myId = origin.getId();
        this.myProject = origin.myProject;
        this.myName = LocalChangeListImpl.validateName(name2);
        this.myComment = origin.myComment;
        this.myIsDefault = origin.myIsDefault;
        this.myIsReadOnly = origin.myIsReadOnly;
        this.myData = origin.myData;
        this.myChanges = ContainerUtil.newHashSet(origin.myChanges);
        this.myReadChangesCache = origin.myReadChangesCache;
    }

    @NotNull
    public Set<Change> getChanges() {
        if (this.myReadChangesCache == null) {
            this.myReadChangesCache = Collections.unmodifiableSet(ContainerUtil.newHashSet(this.myChanges));
        }
        Set<Change> set2 = this.myReadChangesCache;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "getChanges"));
        }
        return set2;
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "getId"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "getName"));
        }
        return string;
    }

    @NotNull
    private static String validateName(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "validateName"));
        }
        if (StringUtil.isEmptyOrSpaces((String)name2) && Registry.is((String)"vcs.log.empty.change.list.creation")) {
            LOG.info("Creating a changelist with empty name");
        }
        String string = name2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "validateName"));
        }
        return string;
    }

    @NotNull
    public String getComment() {
        String string = this.myComment;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "getComment"));
        }
        return string;
    }

    public void setCommentImpl(@Nullable String comment) {
        this.myComment = comment != null ? comment : "";
    }

    public boolean isDefault() {
        return this.myIsDefault;
    }

    void setDefault(boolean isDefault) {
        this.myIsDefault = isDefault;
    }

    public boolean isReadOnly() {
        return this.myIsReadOnly;
    }

    public void setReadOnlyImpl(boolean isReadOnly) {
        this.myIsReadOnly = isReadOnly;
    }

    void setData(@Nullable Object data) {
        this.myData = data;
    }

    @Nullable
    public Object getData() {
        return this.myData;
    }

    void addChange(Change change) {
        this.myReadChangesCache = null;
        this.myChanges.add(change);
        LOG.debug("List: " + this.myName + ". addChange: " + change);
    }

    @Nullable
    Change removeChange(@Nullable Change change) {
        if (this.myChanges.remove(change)) {
            LOG.debug("List: " + this.myName + ". removeChange: " + change);
            this.myReadChangesCache = null;
            return change;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LocalChangeListImpl list2 = (LocalChangeListImpl)((Object)o);
        return this.myName.equals(list2.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public String toString() {
        return this.myName.trim();
    }

    public LocalChangeListImpl copy() {
        return new LocalChangeListImpl(this, this.myName);
    }

    public LocalChangeListImpl copy(@NotNull String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "copy"));
        }
        return new LocalChangeListImpl(this, newName);
    }

    public void setName(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/LocalChangeListImpl", "setName"));
        }
        ChangeListManager.getInstance((Project)this.myProject).editName(this.myName, name2);
    }

    public void setComment(@Nullable String comment) {
        ChangeListManager.getInstance((Project)this.myProject).editComment(this.myName, comment);
    }

    public void setReadOnly(boolean isReadOnly) {
        ChangeListManager.getInstance((Project)this.myProject).setReadOnly(this.myName, isReadOnly);
    }
}

