/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.TodoForBaseRevision;
import com.intellij.openapi.vcs.changes.TodoForRanges;
import com.intellij.openapi.vcs.changes.TodoItemData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiTodoSearchHelper;
import java.util.List;

public class TodoForExistingFile
extends TodoForRanges {
    private final VirtualFile myFile;

    public TodoForExistingFile(Project project2, List<TextRange> ranges, int additionalOffset, String name2, String text2, boolean revision, FileType type2, VirtualFile file2) {
        super(project2, ranges, additionalOffset, name2, text2, revision, type2);
        this.myFile = file2;
    }

    @Override
    protected TodoItemData[] getTodoItems() {
        return (TodoItemData[])ReadAction.compute(() -> {
            PsiFile psiFile;
            PsiTodoSearchHelper helper = PsiTodoSearchHelper.SERVICE.getInstance((Project)this.myProject);
            PsiFile psiFile2 = psiFile = this.myFile == null ? null : PsiManager.getInstance((Project)this.myProject).findFile(this.myFile);
            if (psiFile != null) {
                return TodoForBaseRevision.convertTodo(helper.findTodoItems(psiFile));
            }
            return TodoForBaseRevision.convertTodo(this.getTodoForText(helper));
        });
    }
}

