/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.TodoItemData;
import com.intellij.openapi.vcs.checkin.StepIntersection;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.util.containers.Convertor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class TodoForRanges {
    protected final Project myProject;
    private final List<TextRange> myRanges;
    private final int myAdditionalOffset;
    protected final String myFileName;
    protected final String myText;
    protected final boolean myOldRevision;
    protected final FileType myFileType;

    protected TodoForRanges(Project project2, List<TextRange> ranges, int additionalOffset, String name2, String text2, boolean revision, FileType type2) {
        this.myProject = project2;
        this.myRanges = ranges;
        this.myAdditionalOffset = additionalOffset;
        this.myFileName = name2;
        this.myText = text2;
        this.myOldRevision = revision;
        this.myFileType = type2;
    }

    public List<Pair<TextRange, TextAttributes>> execute() {
        TodoItemData[] todoItems = this.getTodoItems();
        StepIntersection stepIntersection = new StepIntersection((Convertor)new Convertor<TodoItemData, TextRange>(){

            public TextRange convert(TodoItemData o) {
                return o.getTextRange();
            }
        }, (Convertor)Convertor.SELF, this.myRanges);
        List filtered = stepIntersection.process(Arrays.asList(todoItems));
        ArrayList<Pair<TextRange, TextAttributes>> result2 = new ArrayList<Pair<TextRange, TextAttributes>>(filtered.size());
        int offset = 0;
        for (TextRange range : this.myRanges) {
            TodoItemData item;
            Iterator iterator = filtered.iterator();
            while (iterator.hasNext() && range.contains((item = (TodoItemData)iterator.next()).getTextRange())) {
                TextRange todoRange = new TextRange(offset - range.getStartOffset() + item.getTextRange().getStartOffset(), offset - range.getStartOffset() + item.getTextRange().getEndOffset());
                result2.add((Pair<TextRange, TextAttributes>)Pair.create((Object)todoRange, (Object)item.getPattern().getAttributes().getTextAttributes()));
                iterator.remove();
            }
            offset += range.getLength() + 1 + this.myAdditionalOffset;
        }
        return result2;
    }

    protected abstract TodoItemData[] getTodoItems();

    protected TodoItem[] getTodoForText(PsiTodoSearchHelper helper) {
        PsiFile psiFile = (PsiFile)ReadAction.compute(() -> PsiFileFactory.getInstance((Project)this.myProject).createFileFromText((this.myOldRevision ? "old" : "") + this.myFileName, this.myFileType, (CharSequence)this.myText));
        return helper.findTodoItemsLight(psiFile);
    }
}

