/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeModifier;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsDirtyScopeImpl
extends VcsModifiableDirtyScope {
    private static final TObjectHashingStrategy<FilePath> CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY = new TObjectHashingStrategy<FilePath>(){

        public int computeHashCode(@NotNull FilePath path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/changes/VcsDirtyScopeImpl$1", "computeHashCode"));
            }
            return Objects.hash(path.getPath(), path.isDirectory(), path.isNonLocal());
        }

        public boolean equals(@NotNull FilePath path1, @NotNull FilePath path2) {
            if (path1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path1", "com/intellij/openapi/vcs/changes/VcsDirtyScopeImpl$1", "equals"));
            }
            if (path2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path2", "com/intellij/openapi/vcs/changes/VcsDirtyScopeImpl$1", "equals"));
            }
            return path1.isDirectory() == path2.isDirectory() && path1.isNonLocal() == path2.isNonLocal() && path1.getPath().equals(path2.getPath());
        }
    };
    private final Map<VirtualFile, THashSet<FilePath>> myDirtyFiles = new HashMap<VirtualFile, THashSet<FilePath>>();
    private final Map<VirtualFile, THashSet<FilePath>> myDirtyDirectoriesRecursively = new HashMap<VirtualFile, THashSet<FilePath>>();
    private final Set<VirtualFile> myAffectedContentRoots = new THashSet();
    private final Project myProject;
    private final ProjectLevelVcsManager myVcsManager;
    private final AbstractVcs myVcs;
    private VcsDirtyScopeModifier myVcsDirtyScopeModifier;
    private boolean myWasEverythingDirty;

    public VcsDirtyScopeImpl(AbstractVcs vcs, Project project2) {
        this.myProject = project2;
        this.myVcs = vcs;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        this.myWasEverythingDirty = false;
        this.myVcsDirtyScopeModifier = new VcsDirtyScopeModifier(){

            public Collection<VirtualFile> getAffectedVcsRoots() {
                return Collections.unmodifiableCollection(VcsDirtyScopeImpl.this.myDirtyDirectoriesRecursively.keySet());
            }

            public Iterator<FilePath> getDirtyFilesIterator() {
                if (VcsDirtyScopeImpl.this.myDirtyFiles.isEmpty()) {
                    return Collections.emptyList().iterator();
                }
                ArrayList<Iterator> iteratorList = new ArrayList<Iterator>(VcsDirtyScopeImpl.this.myDirtyFiles.size());
                for (THashSet paths : VcsDirtyScopeImpl.this.myDirtyFiles.values()) {
                    iteratorList.add(paths.iterator());
                }
                return ContainerUtil.concatIterators(iteratorList);
            }

            @NotNull
            public Iterator<FilePath> getDirtyDirectoriesIterator(VirtualFile root) {
                THashSet filePaths = (THashSet)VcsDirtyScopeImpl.this.myDirtyDirectoriesRecursively.get(root);
                if (filePaths != null) {
                    Iterator iterator = filePaths.iterator();
                    if (iterator == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsDirtyScopeImpl$2", "getDirtyDirectoriesIterator"));
                    }
                    return iterator;
                }
                Iterator iterator = ContainerUtil.emptyIterator();
                if (iterator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsDirtyScopeImpl$2", "getDirtyDirectoriesIterator"));
                }
                return iterator;
            }

            public void recheckDirtyKeys() {
                this.recheckMap(VcsDirtyScopeImpl.this.myDirtyDirectoriesRecursively);
                this.recheckMap(VcsDirtyScopeImpl.this.myDirtyFiles);
            }

            private void recheckMap(Map<VirtualFile, THashSet<FilePath>> map2) {
                Iterator<THashSet<FilePath>> iterator = map2.values().iterator();
                while (iterator.hasNext()) {
                    THashSet<FilePath> next = iterator.next();
                    if (!next.isEmpty()) continue;
                    iterator.remove();
                }
            }
        };
    }

    public Collection<VirtualFile> getAffectedContentRoots() {
        return this.myAffectedContentRoots;
    }

    public Collection<VirtualFile> getAffectedContentRootsWithCheck() {
        if (this.myVcs.allowsNestedRoots()) {
            ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myVcs.getProject());
            VirtualFile[] roots = vcsManager.getRootsUnderVcs(this.myVcs);
            HashSet<VirtualFile> result2 = new HashSet<VirtualFile>(this.myAffectedContentRoots);
            for (VirtualFile root : roots) {
                for (VirtualFile dir : this.myDirtyDirectoriesRecursively.keySet()) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)dir, (VirtualFile)root, (boolean)true)) continue;
                    result2.add(root);
                }
            }
            return new SmartList(result2);
        }
        return this.myAffectedContentRoots;
    }

    public Project getProject() {
        return this.myProject;
    }

    public AbstractVcs getVcs() {
        return this.myVcs;
    }

    public Set<FilePath> getDirtyFiles() {
        THashSet<FilePath> result2 = VcsDirtyScopeImpl.newFilePathsSet();
        for (THashSet<FilePath> paths : this.myDirtyFiles.values()) {
            result2.addAll(paths);
        }
        for (THashSet<FilePath> paths : this.myDirtyFiles.values()) {
            for (FilePath filePath : paths) {
                VirtualFile vFile = filePath.getVirtualFile();
                if (vFile == null || !vFile.isValid() || !vFile.isDirectory()) continue;
                for (VirtualFile child : vFile.getChildren()) {
                    result2.add((Object)VcsUtil.getFilePath((VirtualFile)child));
                }
            }
        }
        return result2;
    }

    public Set<FilePath> getDirtyFilesNoExpand() {
        THashSet<FilePath> paths = VcsDirtyScopeImpl.newFilePathsSet();
        for (THashSet<FilePath> filePaths : this.myDirtyFiles.values()) {
            paths.addAll(filePaths);
        }
        return paths;
    }

    public Set<FilePath> getRecursivelyDirtyDirectories() {
        THashSet<FilePath> result2 = VcsDirtyScopeImpl.newFilePathsSet();
        for (THashSet<FilePath> dirsByRoot : this.myDirtyDirectoriesRecursively.values()) {
            result2.addAll(dirsByRoot);
        }
        return result2;
    }

    public boolean isRecursivelyDirty(VirtualFile vf) {
        for (THashSet<FilePath> dirsByRoot : this.myDirtyDirectoriesRecursively.values()) {
            for (FilePath dir : dirsByRoot) {
                VirtualFile dirVf = dir.getVirtualFile();
                if (dirVf == null || !VfsUtilCore.isAncestor((VirtualFile)dirVf, (VirtualFile)vf, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    public void addDirtyData(@NotNull Collection<FilePath> dirs, @NotNull Collection<FilePath> files) {
        if (dirs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirs", "com/intellij/openapi/vcs/changes/VcsDirtyScopeImpl", "addDirtyData"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/VcsDirtyScopeImpl", "addDirtyData"));
        }
        HashMap<VirtualFile, THashSet<FilePath>> perRootDirs = new HashMap<VirtualFile, THashSet<FilePath>>();
        HashMap<VirtualFile, THashSet<FilePath>> perRootFiles = new HashMap<VirtualFile, THashSet<FilePath>>();
        for (Map.Entry<VirtualFile, THashSet<FilePath>> entry : this.myDirtyDirectoriesRecursively.entrySet()) {
            perRootDirs.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<VirtualFile, THashSet<FilePath>> entry : this.myDirtyFiles.entrySet()) {
            perRootFiles.put(entry.getKey(), entry.getValue());
        }
        this.addFilePathsToMap(dirs, perRootDirs);
        this.addFilePathsToMap(files, perRootFiles);
        this.myAffectedContentRoots.addAll(perRootDirs.keySet());
        this.myAffectedContentRoots.addAll(perRootFiles.keySet());
        for (VirtualFile root : this.myAffectedContentRoots) {
            Set rootDirs = ContainerUtil.notNullize((Set)((Set)perRootDirs.get(root)));
            Set rootFiles = ContainerUtil.notNullize((Set)((Set)perRootFiles.get(root)));
            THashSet<FilePath> filteredDirs = VcsDirtyScopeImpl.removeAncestorsRecursive(rootDirs);
            THashSet<FilePath> filteredFiles = VcsDirtyScopeImpl.removeAncestorsNonRecursive(filteredDirs, rootFiles);
            this.myDirtyDirectoriesRecursively.put(root, filteredDirs);
            this.myDirtyFiles.put(root, filteredFiles);
        }
    }

    private void addFilePathsToMap(@NotNull Collection<FilePath> paths, @NotNull Map<VirtualFile, THashSet<FilePath>> pathsMap) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/intellij/openapi/vcs/changes/VcsDirtyScopeImpl", "addFilePathsToMap"));
        }
        if (pathsMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathsMap", "com/intellij/openapi/vcs/changes/VcsDirtyScopeImpl", "addFilePathsToMap"));
        }
        for (FilePath dir : paths) {
            VirtualFile vcsRoot = this.myVcsManager.getVcsRootFor(dir);
            if (vcsRoot == null) continue;
            THashSet<FilePath> set2 = pathsMap.get(vcsRoot);
            if (set2 == null) {
                set2 = VcsDirtyScopeImpl.newFilePathsSet();
                pathsMap.put(vcsRoot, set2);
            }
            set2.add((Object)dir);
        }
    }

    @NotNull
    private static THashSet<FilePath> removeAncestorsRecursive(@NotNull Collection<FilePath> dirs) {
        if (dirs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirs", "com/intellij/openapi/vcs/changes/VcsDirtyScopeImpl", "removeAncestorsRecursive"));
        }
        List paths = ContainerUtil.sorted(dirs, Comparator.comparing(it -> it.getPath().length()));
        THashSet<FilePath> result2 = VcsDirtyScopeImpl.newFilePathsSet();
        for (FilePath path : paths) {
            if (VcsDirtyScopeImpl.hasAncestor(result2, path)) continue;
            result2.add((Object)path);
        }
        THashSet<FilePath> tHashSet = result2;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsDirtyScopeImpl", "removeAncestorsRecursive"));
        }
        return tHashSet;
    }

    @NotNull
    private static THashSet<FilePath> removeAncestorsNonRecursive(@NotNull Set<FilePath> dirs, @NotNull Set<FilePath> files) {
        if (dirs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirs", "com/intellij/openapi/vcs/changes/VcsDirtyScopeImpl", "removeAncestorsNonRecursive"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/VcsDirtyScopeImpl", "removeAncestorsNonRecursive"));
        }
        THashSet<FilePath> result2 = VcsDirtyScopeImpl.newFilePathsSet();
        for (FilePath file2 : files) {
            if (VcsDirtyScopeImpl.hasAncestor(dirs, file2) || !file2.isDirectory() && files.contains(file2.getParentPath())) continue;
            result2.add((Object)file2);
        }
        THashSet<FilePath> tHashSet = result2;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsDirtyScopeImpl", "removeAncestorsNonRecursive"));
        }
        return tHashSet;
    }

    private static boolean hasAncestor(@NotNull Set<FilePath> dirs, @NotNull FilePath filePath) {
        if (dirs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirs", "com/intellij/openapi/vcs/changes/VcsDirtyScopeImpl", "hasAncestor"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/changes/VcsDirtyScopeImpl", "hasAncestor"));
        }
        String path = filePath.getPath();
        for (FilePath parent : dirs) {
            if (!FileUtil.startsWith((String)path, (String)parent.getPath())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static THashSet<FilePath> newFilePathsSet() {
        THashSet tHashSet = new THashSet(CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY);
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsDirtyScopeImpl", "newFilePathsSet"));
        }
        return tHashSet;
    }

    public void addDirtyDirRecursively(FilePath newcomer) {
        VirtualFile vcsRoot = this.myVcsManager.getVcsRootFor(newcomer);
        if (vcsRoot == null) {
            return;
        }
        this.myAffectedContentRoots.add(vcsRoot);
        for (Map.Entry<VirtualFile, THashSet<FilePath>> entry : this.myDirtyFiles.entrySet()) {
            THashSet<FilePath> files;
            VirtualFile groupRoot = entry.getKey();
            if (groupRoot == null || !VfsUtilCore.isAncestor((VirtualFile)vcsRoot, (VirtualFile)groupRoot, (boolean)false) || (files = entry.getValue()) == null) continue;
            Iterator it = files.iterator();
            while (it.hasNext()) {
                FilePath oldBoy = (FilePath)it.next();
                if (!oldBoy.isUnder(newcomer, false)) continue;
                it.remove();
            }
        }
        THashSet<FilePath> dirsByRoot = this.myDirtyDirectoriesRecursively.get(vcsRoot);
        if (dirsByRoot == null) {
            dirsByRoot = VcsDirtyScopeImpl.newFilePathsSet();
            this.myDirtyDirectoriesRecursively.put(vcsRoot, dirsByRoot);
        } else {
            Iterator it = dirsByRoot.iterator();
            while (it.hasNext()) {
                FilePath oldBoy = (FilePath)it.next();
                if (newcomer.isUnder(oldBoy, false)) {
                    return;
                }
                if (!oldBoy.isUnder(newcomer, false)) continue;
                it.remove();
            }
        }
        dirsByRoot.add((Object)newcomer);
    }

    public void addDirtyFile(FilePath newcomer) {
        THashSet<FilePath> dirtyFiles;
        VirtualFile vcsRoot = this.myVcsManager.getVcsRootFor(newcomer);
        this.myAffectedContentRoots.add(vcsRoot);
        THashSet<FilePath> dirsByRoot = this.myDirtyDirectoriesRecursively.get(vcsRoot);
        if (dirsByRoot != null) {
            for (FilePath oldBoy : dirsByRoot) {
                if (!newcomer.isUnder(oldBoy, false)) continue;
                return;
            }
        }
        if ((dirtyFiles = this.myDirtyFiles.get(vcsRoot)) == null) {
            THashSet<FilePath> set2 = VcsDirtyScopeImpl.newFilePathsSet();
            set2.add((Object)newcomer);
            this.myDirtyFiles.put(vcsRoot, set2);
        } else if (newcomer.isDirectory()) {
            Iterator iterator = dirtyFiles.iterator();
            while (iterator.hasNext()) {
                FilePath oldBoy = (FilePath)iterator.next();
                if (oldBoy.isDirectory() || !Comparing.equal((Object)oldBoy.getVirtualFileParent(), (Object)newcomer.getVirtualFile())) continue;
                iterator.remove();
            }
        } else if (!dirtyFiles.isEmpty()) {
            VirtualFile parent = newcomer.getVirtualFileParent();
            if (parent != null && dirtyFiles.contains((Object)VcsUtil.getFilePath((VirtualFile)parent))) {
                return;
            }
            dirtyFiles.add((Object)newcomer);
        }
    }

    public void iterate(Processor<FilePath> iterator) {
        VirtualFile vFile;
        if (this.myProject.isDisposed()) {
            return;
        }
        for (VirtualFile root : this.myAffectedContentRoots) {
            THashSet<FilePath> dirsByRoot = this.myDirtyDirectoriesRecursively.get(root);
            if (dirsByRoot == null) continue;
            for (FilePath dir : dirsByRoot) {
                vFile = dir.getVirtualFile();
                if (vFile == null || !vFile.isValid()) continue;
                this.myVcsManager.iterateVcsRoot(vFile, iterator);
            }
        }
        for (VirtualFile root : this.myAffectedContentRoots) {
            THashSet<FilePath> files = this.myDirtyFiles.get(root);
            if (files == null) continue;
            for (FilePath file2 : files) {
                iterator.process((Object)file2);
                vFile = file2.getVirtualFile();
                if (vFile == null || !vFile.isValid() || !vFile.isDirectory()) continue;
                for (VirtualFile child : vFile.getChildren()) {
                    iterator.process((Object)VcsUtil.getFilePath((VirtualFile)child));
                }
            }
        }
    }

    public void iterateExistingInsideScope(Processor<VirtualFile> processor2) {
        VirtualFile vFile;
        if (this.myProject.isDisposed()) {
            return;
        }
        for (VirtualFile root : this.myAffectedContentRoots) {
            THashSet<FilePath> dirsByRoot = this.myDirtyDirectoriesRecursively.get(root);
            if (dirsByRoot == null) continue;
            for (FilePath dir : dirsByRoot) {
                vFile = VcsDirtyScopeImpl.obtainVirtualFile(dir);
                if (vFile == null || !vFile.isValid()) continue;
                this.myVcsManager.iterateVfUnderVcsRoot(vFile, processor2);
            }
        }
        for (VirtualFile root : this.myAffectedContentRoots) {
            THashSet<FilePath> files = this.myDirtyFiles.get(root);
            if (files == null) continue;
            for (FilePath file2 : files) {
                vFile = VcsDirtyScopeImpl.obtainVirtualFile(file2);
                if (vFile == null || !vFile.isValid()) continue;
                processor2.process((Object)vFile);
                if (!vFile.isDirectory()) continue;
                for (VirtualFile child : vFile.getChildren()) {
                    processor2.process((Object)child);
                }
            }
        }
    }

    @Nullable
    private static VirtualFile obtainVirtualFile(FilePath file2) {
        VirtualFile vFile = file2.getVirtualFile();
        return vFile == null ? VfsUtil.findFileByIoFile((File)file2.getIOFile(), (boolean)false) : vFile;
    }

    public boolean isEmpty() {
        return this.myDirtyDirectoriesRecursively.isEmpty() && this.myDirtyFiles.isEmpty();
    }

    public boolean belongsTo(FilePath path, Consumer<AbstractVcs> vcsConsumer) {
        if (this.myProject.isDisposed()) {
            return false;
        }
        VcsRoot rootObject = this.myVcsManager.getVcsRootObjectFor(path);
        if (vcsConsumer != null && rootObject != null) {
            vcsConsumer.consume((Object)rootObject.getVcs());
        }
        if (rootObject == null || rootObject.getVcs() != this.myVcs) {
            return false;
        }
        VirtualFile vcsRoot = rootObject.getPath();
        if (vcsRoot != null) {
            for (VirtualFile contentRoot : this.myAffectedContentRoots) {
                THashSet<FilePath> dirsByRoot;
                if (!VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)vcsRoot, (boolean)false) || (dirsByRoot = this.myDirtyDirectoriesRecursively.get(contentRoot)) == null) continue;
                for (FilePath filePath : dirsByRoot) {
                    if (!path.isUnder(filePath, false)) continue;
                    return true;
                }
            }
        }
        if (!this.myDirtyFiles.isEmpty()) {
            FilePath parent = path.getParentPath();
            return this.isInDirtyFiles(path) || this.isInDirtyFiles(parent);
        }
        return false;
    }

    private boolean isInDirtyFiles(FilePath path) {
        THashSet<FilePath> files;
        VcsRoot rootObject = this.myVcsManager.getVcsRootObjectFor(path);
        return rootObject != null && this.myVcs.equals((Object)rootObject.getVcs()) && (files = this.myDirtyFiles.get(rootObject.getPath())) != null && files.contains((Object)path);
    }

    public boolean belongsTo(FilePath path) {
        return this.belongsTo(path, null);
    }

    @NonNls
    public String toString() {
        StringBuilder result2 = new StringBuilder("VcsDirtyScope[");
        if (!this.myDirtyFiles.isEmpty()) {
            result2.append(" files: ");
            for (THashSet<FilePath> paths : this.myDirtyFiles.values()) {
                for (FilePath file2 : paths) {
                    result2.append(file2).append(" ");
                }
            }
        }
        if (!this.myDirtyDirectoriesRecursively.isEmpty()) {
            result2.append("\ndirs: ");
            for (THashSet<FilePath> dirsByRoot : this.myDirtyDirectoriesRecursively.values()) {
                for (FilePath file2 : dirsByRoot) {
                    result2.append(file2).append(" ");
                }
            }
        }
        result2.append("\naffected roots: ");
        for (VirtualFile contentRoot : this.myAffectedContentRoots) {
            result2.append(contentRoot.getPath()).append(" ");
        }
        result2.append("\naffected roots with check: ");
        for (VirtualFile contentRoot : this.getAffectedContentRootsWithCheck()) {
            result2.append(contentRoot.getPath()).append(" ");
        }
        result2.append("]");
        return result2.toString();
    }

    public VcsDirtyScopeModifier getModifier() {
        return this.myVcsDirtyScopeModifier;
    }

    public boolean wasEveryThingDirty() {
        return this.myWasEverythingDirty;
    }

    public void setWasEverythingDirty(boolean wasEverythingDirty) {
        this.myWasEverythingDirty = wasEverythingDirty;
    }
}

