/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ExtendableAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.openapi.vcs.changes.CommitSessionContextAware;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.patch.CreatePatchCommitExecutor;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.ui.SessionDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreatePatchFromChangesAction
extends ExtendableAction
implements DumbAware {
    private static final ExtensionPointName<AnActionExtensionProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.openapi.vcs.changes.actions.CreatePatchFromChangesAction.ExtensionProvider");

    public CreatePatchFromChangesAction() {
        super(EP_NAME);
    }

    @Override
    public void defaultActionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/CreatePatchFromChangesAction", "defaultActionPerformed"));
        }
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        if (changes == null || changes.length == 0) {
            return;
        }
        String commitMessage = null;
        List<ShelvedChangeList> shelvedChangeLists = ShelvedChangesViewManager.getShelvedLists(e.getDataContext());
        if (!shelvedChangeLists.isEmpty()) {
            commitMessage = shelvedChangeLists.get((int)0).DESCRIPTION;
        } else {
            ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
            if (changeLists != null && changeLists.length > 0) {
                commitMessage = changeLists[0].getComment();
            }
        }
        if (commitMessage == null) {
            commitMessage = (String)e.getData(VcsDataKeys.PRESET_COMMIT_MESSAGE);
        }
        if (commitMessage == null) {
            commitMessage = "";
        }
        ArrayList<Change> changeCollection = new ArrayList<Change>();
        Collections.addAll(changeCollection, changes);
        CreatePatchFromChangesAction.createPatch(project2, commitMessage, changeCollection);
    }

    public static void createPatch(Project project2, String commitMessage, @NotNull List<Change> changeCollection) {
        SessionDialog sessionDialog;
        if (changeCollection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeCollection", "com/intellij/openapi/vcs/changes/actions/CreatePatchFromChangesAction", "createPatch"));
        }
        CreatePatchCommitExecutor executor = CreatePatchCommitExecutor.getInstance(project2 = project2 == null ? ProjectManager.getInstance().getDefaultProject() : project2);
        CommitSession commitSession = executor.createCommitSession();
        if (commitSession instanceof CommitSessionContextAware) {
            ((CommitSessionContextAware)commitSession).setContext(new CommitContext());
        }
        if (!(sessionDialog = new SessionDialog(executor.getActionText(), project2, commitSession, changeCollection, commitMessage)).showAndGet()) {
            return;
        }
        CreatePatchFromChangesAction.preloadContent(project2, changeCollection);
        commitSession.execute(changeCollection, commitMessage);
    }

    private static void preloadContent(Project project2, final List<Change> changes) {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                for (Change change : changes) {
                    this.checkLoadContent(change.getBeforeRevision());
                    this.checkLoadContent(change.getAfterRevision());
                }
            }

            private void checkLoadContent(ContentRevision revision) {
                ProgressManager.checkCanceled();
                if (revision != null && !(revision instanceof BinaryContentRevision)) {
                    try {
                        revision.getContent();
                    }
                    catch (VcsException vcsException) {
                        // empty catch block
                    }
                }
            }
        }, VcsBundle.message((String)"create.patch.loading.content.progress", (Object[])new Object[0]), true, project2);
    }

    @Override
    public void defaultUpdate(@NotNull AnActionEvent e) {
        Change[] changes;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/CreatePatchFromChangesAction", "defaultUpdate"));
        }
        Boolean haveSelectedChanges = (Boolean)e.getData(VcsDataKeys.HAVE_SELECTED_CHANGES);
        ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        List<ShelvedChangeList> shelveChangelists = ShelvedChangesViewManager.getShelvedLists(e.getDataContext());
        int changelistNum = changeLists == null ? 0 : changeLists.length;
        e.getPresentation().setEnabled(Boolean.TRUE.equals(haveSelectedChanges) && (changelistNum += shelveChangelists.size()) == 1 && (changes = (Change[])e.getData(VcsDataKeys.CHANGES)) != null && changes.length > 0);
    }
}

