/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.changes.committed.ChangesCacheFile;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationCache;
import com.intellij.openapi.vcs.changes.committed.RootsCalculator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachesHolder {
    @NonNls
    private static final String VCS_CACHE_PATH = "vcsCache";
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<String, ChangesCacheFile> myCacheFiles;
    @NotNull
    private final RepositoryLocationCache myLocationCache;
    @NotNull
    private final ProjectLevelVcsManager myPlManager;

    public CachesHolder(@NotNull Project project2, @NotNull RepositoryLocationCache locationCache) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/committed/CachesHolder", "<init>"));
        }
        if (locationCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locationCache", "com/intellij/openapi/vcs/changes/committed/CachesHolder", "<init>"));
        }
        this.myCacheFiles = ContainerUtil.newConcurrentMap();
        this.myProject = project2;
        this.myLocationCache = locationCache;
        this.myPlManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
    }

    @NotNull
    public Map<VirtualFile, RepositoryLocation> getAllRootsUnderVcs(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/changes/committed/CachesHolder", "getAllRootsUnderVcs"));
        }
        Map<VirtualFile, RepositoryLocation> map2 = new RootsCalculator(this.myProject, vcs, this.myLocationCache).getRoots();
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/committed/CachesHolder", "getAllRootsUnderVcs"));
        }
        return map2;
    }

    public void iterateAllCaches(@NotNull Processor<ChangesCacheFile> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/vcs/changes/committed/CachesHolder", "iterateAllCaches"));
        }
        for (AbstractVcs vcs : this.myPlManager.getAllActiveVcss()) {
            if (!(vcs.getCommittedChangesProvider() instanceof CachingCommittedChangesProvider)) continue;
            for (Map.Entry<VirtualFile, RepositoryLocation> entry : this.getAllRootsUnderVcs(vcs).entrySet()) {
                ChangesCacheFile cacheFile = this.getCacheFile(vcs, entry.getKey(), entry.getValue());
                if (processor2.process((Object)cacheFile)) continue;
                return;
            }
        }
    }

    public void clearAllCaches() {
        this.myCacheFiles.values().forEach(ChangesCacheFile::delete);
        this.myCacheFiles.clear();
    }

    @NotNull
    public Collection<ChangesCacheFile> getAllCaches() {
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor();
        this.iterateAllCaches((Processor<ChangesCacheFile>)processor2);
        Collection collection = processor2.getResults();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/committed/CachesHolder", "getAllCaches"));
        }
        return collection;
    }

    @NotNull
    public ChangesCacheFile getCacheFile(@NotNull AbstractVcs vcs, @NotNull VirtualFile root, @NotNull RepositoryLocation location) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/changes/committed/CachesHolder", "getCacheFile"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/vcs/changes/committed/CachesHolder", "getCacheFile"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/openapi/vcs/changes/committed/CachesHolder", "getCacheFile"));
        }
        ChangesCacheFile changesCacheFile = this.myCacheFiles.computeIfAbsent(location.getKey(), key2 -> {
            if (location == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/openapi/vcs/changes/committed/CachesHolder", "lambda$getCacheFile$0"));
            }
            if (vcs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/changes/committed/CachesHolder", "lambda$getCacheFile$0"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/vcs/changes/committed/CachesHolder", "lambda$getCacheFile$0"));
            }
            return new ChangesCacheFile(this.myProject, this.getCachePath(location), vcs, root, location);
        });
        if (changesCacheFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/committed/CachesHolder", "getCacheFile"));
        }
        return changesCacheFile;
    }

    @NotNull
    public File getCacheBasePath() {
        File file2 = new File(PathManager.getSystemPath(), VCS_CACHE_PATH);
        File file3 = file2 = new File(file2, this.myProject.getLocationHash());
        if (file3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/committed/CachesHolder", "getCacheBasePath"));
        }
        return file3;
    }

    @NotNull
    private File getCachePath(@NotNull RepositoryLocation location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/openapi/vcs/changes/committed/CachesHolder", "getCachePath"));
        }
        File file2 = this.getCacheBasePath();
        file2.mkdirs();
        File file3 = new File(file2, DigestUtils.md5Hex((String)location.getKey()));
        if (file3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/committed/CachesHolder", "getCachePath"));
        }
        return file3;
    }

    @Nullable
    public ChangesCacheFile haveCache(@NotNull RepositoryLocation location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/openapi/vcs/changes/committed/CachesHolder", "haveCache"));
        }
        String key2 = location.getKey();
        ChangesCacheFile result2 = this.myCacheFiles.get(key2);
        if (result2 == null) {
            String keyWithSlash = key2.endsWith("/") ? key2 : key2 + "/";
            String cachedSimilarKey = (String)ContainerUtil.find(this.myCacheFiles.keySet(), s -> keyWithSlash.startsWith((String)s) || s.startsWith(keyWithSlash));
            result2 = cachedSimilarKey != null ? this.myCacheFiles.get(cachedSimilarKey) : null;
        }
        return result2;
    }
}

