/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.diff.DiffManager;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDifferentiatedDialog;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchMode;
import com.intellij.openapi.vcs.changes.patch.ImportToShelfExecutor;
import com.intellij.openapi.vcs.changes.patch.PatchDiffRequestFactory;
import com.intellij.openapi.vcs.changes.patch.PatchFileType;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.patch.ApplyPatchAction");

    public void update(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            VirtualFile vFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            e.getPresentation().setEnabledAndVisible(project2 != null && PatchFileType.isPatchFile(vFile));
        } else {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(project2 != null);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        if (ChangeListManager.getInstance((Project)project2).isFreezedWithNotification("Can not apply patch now")) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        VirtualFile vFile = null;
        String place = e.getPlace();
        if (ActionPlaces.isPopupPlace((String)e.getPlace()) || "MainMenu".equals(place)) {
            vFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        }
        if (PatchFileType.isPatchFile(vFile)) {
            ApplyPatchAction.showApplyPatch(project2, vFile);
        } else {
            FileChooserDescriptor descriptor = ApplyPatchDifferentiatedDialog.createSelectPatchDescriptor();
            VcsApplicationSettings settings = VcsApplicationSettings.getInstance();
            VirtualFile toSelect2 = settings.PATCH_STORAGE_LOCATION == null ? null : LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(settings.PATCH_STORAGE_LOCATION));
            FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project2, (VirtualFile)toSelect2, file2 -> {
                VirtualFile parent = file2.getParent();
                if (parent != null) {
                    settings.PATCH_STORAGE_LOCATION = parent.getPath();
                }
                ApplyPatchAction.showApplyPatch(project2, file2);
            });
        }
    }

    public static void showApplyPatch(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "showApplyPatch"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "showApplyPatch"));
        }
        ApplyPatchDifferentiatedDialog dialog2 = new ApplyPatchDifferentiatedDialog(project2, new ApplyPatchDefaultExecutor(project2), Collections.singletonList(new ImportToShelfExecutor(project2)), ApplyPatchMode.APPLY, file2);
        dialog2.show();
    }

    public static Boolean showAndGetApplyPatch(@NotNull Project project2, @NotNull File file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "showAndGetApplyPatch"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "showAndGetApplyPatch"));
        }
        VirtualFile vFile = VfsUtil.findFileByIoFile((File)file2, (boolean)true);
        String patchPath = file2.getPath();
        if (vFile == null) {
            VcsNotifier.getInstance(project2).notifyWeakError("Can't find patch file " + patchPath);
            return false;
        }
        if (!PatchFileType.isPatchFile(file2)) {
            VcsNotifier.getInstance(project2).notifyWeakError("Selected file " + patchPath + " is not patch type file ");
            return false;
        }
        ApplyPatchDifferentiatedDialog dialog2 = new ApplyPatchDifferentiatedDialog(project2, new ApplyPatchDefaultExecutor(project2), Collections.emptyList(), ApplyPatchMode.APPLY_PATCH_IN_MEMORY, vFile);
        dialog2.setModal(true);
        return dialog2.showAndGet();
    }

    public static void applySkipDirs(List<FilePatch> patches, int skipDirs) {
        if (skipDirs < 1) {
            return;
        }
        for (FilePatch patch : patches) {
            patch.setBeforeName(ApplyPatchAction.skipN(patch.getBeforeName(), skipDirs));
            patch.setAfterName(ApplyPatchAction.skipN(patch.getAfterName(), skipDirs));
        }
    }

    private static String skipN(String path, int num) {
        String[] pieces = path.split("/");
        StringBuilder sb = new StringBuilder();
        for (int i = num; i < pieces.length; ++i) {
            String piece = pieces[i];
            sb.append('/').append(piece);
        }
        return sb.toString();
    }

    @NotNull
    public static ApplyPatchStatus applyOnly(@Nullable Project project2, @NotNull ApplyFilePatchBase patch, @Nullable ApplyPatchContext context, @NotNull VirtualFile file2, @Nullable CommitContext commitContext, boolean reverse, @Nullable String leftPanelTitle, @Nullable String rightPanelTitle) {
        ApplyPatchStatus applyPatchStatus;
        if (patch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patch", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "applyOnly"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "applyOnly"));
        }
        ApplyFilePatch.Result result2 = ApplyPatchAction.tryApplyPatch(project2, patch, context, file2, commitContext);
        ApplyPatchStatus status = result2.getStatus();
        if (ApplyPatchStatus.ALREADY_APPLIED.equals((Object)status) || ApplyPatchStatus.SUCCESS.equals((Object)status)) {
            ApplyPatchStatus applyPatchStatus2 = status;
            if (applyPatchStatus2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "applyOnly"));
            }
            return applyPatchStatus2;
        }
        ApplyPatchForBaseRevisionTexts mergeData = result2.getMergeData();
        if (mergeData == null) {
            ApplyPatchStatus applyPatchStatus3 = status;
            if (applyPatchStatus3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "applyOnly"));
            }
            return applyPatchStatus3;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        if (document == null) {
            ApplyPatchStatus applyPatchStatus4 = ApplyPatchStatus.FAILURE;
            if (applyPatchStatus4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "applyOnly"));
            }
            return applyPatchStatus4;
        }
        String baseContent = ApplyPatchAction.convertLineSeparators(mergeData.getBase());
        String localContent = ApplyPatchAction.convertLineSeparators(mergeData.getLocal());
        String patchedContent = mergeData.getPatched();
        Ref applyPatchStatusReference = new Ref();
        Consumer callback = result13 -> {
            FileDocumentManager.getInstance().saveDocument(document);
            applyPatchStatusReference.setIfNull((Object)(result13 != MergeResult.CANCEL ? ApplyPatchStatus.SUCCESS : ApplyPatchStatus.FAILURE));
        };
        try {
            MergeRequest request;
            if (baseContent != null) {
                if (reverse) {
                    if (leftPanelTitle == null) {
                        leftPanelTitle = VcsBundle.message((String)"patch.apply.conflict.patched.version", (Object[])new Object[0]);
                    }
                    if (rightPanelTitle == null) {
                        rightPanelTitle = VcsBundle.message((String)"patch.apply.conflict.local.version", (Object[])new Object[0]);
                    }
                    List contents = ContainerUtil.list((Object[])new String[]{patchedContent, baseContent, localContent});
                    List titles = ContainerUtil.list((Object[])new String[]{leftPanelTitle, null, rightPanelTitle});
                    request = PatchDiffRequestFactory.createMergeRequest(project2, document, file2, contents, null, titles, (Consumer<MergeResult>)callback);
                } else {
                    request = PatchDiffRequestFactory.createMergeRequest(project2, document, file2, baseContent, localContent, patchedContent, (Consumer<MergeResult>)callback);
                }
            } else {
                TextFilePatch textPatch = (TextFilePatch)patch.getPatch();
                GenericPatchApplier applier = new GenericPatchApplier(localContent, textPatch.getHunks());
                applier.execute();
                AppliedTextPatch appliedTextPatch = AppliedTextPatch.create(applier.getAppliedInfo());
                request = PatchDiffRequestFactory.createBadMergeRequest(project2, document, file2, localContent, appliedTextPatch, (Consumer<MergeResult>)callback);
            }
            request.putUserData(DiffUserDataKeysEx.MERGE_ACTION_CAPTIONS, result12 -> result12.equals((Object)MergeResult.CANCEL) ? "Abort..." : null);
            request.putUserData(DiffUserDataKeysEx.MERGE_CANCEL_HANDLER, viewer -> {
                int result1 = Messages.showYesNoCancelDialog((Component)viewer.getComponent().getRootPane(), (String)XmlStringUtil.wrapInHtml((CharSequence)"Would you like to <u>A</u>bort&Rollback applying patch action or <u>S</u>kip this file?"), (String)"Close Merge", (String)"_Abort", (String)"_Skip", (String)"Cancel", (Icon)Messages.getQuestionIcon());
                if (result1 == 0) {
                    applyPatchStatusReference.set((Object)ApplyPatchStatus.ABORT);
                } else if (result1 == 1) {
                    applyPatchStatusReference.set((Object)ApplyPatchStatus.SKIP);
                }
                return result1 != 2;
            });
            DiffManager.getInstance().showMerge(project2, request);
            applyPatchStatus = (ApplyPatchStatus)((Object)applyPatchStatusReference.get());
        }
        catch (InvalidDiffRequestException e) {
            LOG.warn((Throwable)e);
            ApplyPatchStatus applyPatchStatus5 = ApplyPatchStatus.FAILURE;
            if (applyPatchStatus5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "applyOnly"));
            }
            return applyPatchStatus5;
        }
        if (applyPatchStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "applyOnly"));
        }
        return applyPatchStatus;
    }

    @NotNull
    private static ApplyFilePatch.Result tryApplyPatch(@Nullable Project project2, @NotNull ApplyFilePatchBase patch, @Nullable ApplyPatchContext context, @NotNull VirtualFile file2, @Nullable CommitContext commitContext) {
        if (patch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patch", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "tryApplyPatch"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "tryApplyPatch"));
        }
        Object patchBase = patch.getPatch();
        ApplyFilePatch.Result result2 = (ApplyFilePatch.Result)WriteAction.compute(() -> {
            if (patch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patch", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "lambda$tryApplyPatch$5"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "lambda$tryApplyPatch$5"));
            }
            try {
                return patch.apply(file2, context, project2, VcsUtil.getFilePath((VirtualFile)file2), (Getter<CharSequence>)((Getter)() -> {
                    BaseRevisionTextPatchEP baseRevisionTextPatchEP = (BaseRevisionTextPatchEP)Extensions.findExtension((ExtensionPointName)PatchEP.EP_NAME, (AreaInstance)project2, BaseRevisionTextPatchEP.class);
                    String path = (String)ObjectUtils.chooseNotNull((Object)patchBase.getBeforeName(), (Object)patchBase.getAfterName());
                    return baseRevisionTextPatchEP.provideContent(path, commitContext);
                }), commitContext);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return ApplyFilePatch.Result.createThrow(e);
            }
        });
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction", "tryApplyPatch"));
        }
        return result2;
    }

    @Nullable
    private static String convertLineSeparators(@Nullable String charSequence) {
        return charSequence != null ? StringUtil.convertLineSeparators((String)charSequence) : null;
    }
}

