/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.patch.DefaultPatchBaseVersionProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchForBaseRevisionTexts {
    private static final Logger LOG = Logger.getInstance(ApplyPatchForBaseRevisionTexts.class);
    @NotNull
    private final String myLocal;
    @Nullable
    private final String myBase;
    @NotNull
    private final String myPatched;
    private final boolean myIsAppliedSomehow;

    public ApplyPatchForBaseRevisionTexts(@NotNull String patched, @NotNull String local, @Nullable String base, boolean isAppliedSomehow) {
        if (patched == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patched", "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts", "<init>"));
        }
        if (local == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "local", "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts", "<init>"));
        }
        this.myLocal = local;
        this.myBase = base;
        this.myPatched = patched;
        this.myIsAppliedSomehow = isAppliedSomehow;
    }

    @NotNull
    public String getLocal() {
        String string = this.myLocal;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts", "getLocal"));
        }
        return string;
    }

    @Nullable
    public String getBase() {
        return this.myBase;
    }

    @NotNull
    public String getPatched() {
        String string = this.myPatched;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts", "getPatched"));
        }
        return string;
    }

    public boolean isAppliedSomehow() {
        return this.myIsAppliedSomehow;
    }

    public boolean isBaseRevisionLoaded() {
        return this.myBase != null;
    }

    @NotNull
    public static ApplyPatchForBaseRevisionTexts create(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull FilePath pathBeforeRename, @NotNull TextFilePatch patch, @Nullable CharSequence baseContents) {
        ApplyPatchForBaseRevisionTexts result2;
        ApplyPatchForBaseRevisionTexts result3;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts", "create"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts", "create"));
        }
        if (pathBeforeRename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathBeforeRename", "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts", "create"));
        }
        if (patch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patch", "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts", "create"));
        }
        assert (!patch.isNewFile());
        String localContent = ApplyPatchForBaseRevisionTexts.getLocalFileContent(file2);
        if (baseContents != null && (result3 = ApplyPatchForBaseRevisionTexts.createFromStoredBase(localContent, patch, baseContents)) != null) {
            ApplyPatchForBaseRevisionTexts applyPatchForBaseRevisionTexts = result3;
            if (applyPatchForBaseRevisionTexts == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts", "create"));
            }
            return applyPatchForBaseRevisionTexts;
        }
        String beforeVersionId = patch.getBeforeVersionId();
        if (beforeVersionId != null && (result2 = ApplyPatchForBaseRevisionTexts.createFromBaseVersionProvider(project2, localContent, patch, beforeVersionId, file2, pathBeforeRename)) != null) {
            ApplyPatchForBaseRevisionTexts applyPatchForBaseRevisionTexts = result2;
            if (applyPatchForBaseRevisionTexts == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts", "create"));
            }
            return applyPatchForBaseRevisionTexts;
        }
        ApplyPatchForBaseRevisionTexts applyPatchForBaseRevisionTexts = ApplyPatchForBaseRevisionTexts.createFromLocal(localContent, patch);
        if (applyPatchForBaseRevisionTexts == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts", "create"));
        }
        return applyPatchForBaseRevisionTexts;
    }

    @NotNull
    private static ApplyPatchForBaseRevisionTexts createFromLocal(@NotNull String localContent, @NotNull TextFilePatch patch) {
        if (localContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localContent", "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts", "createFromLocal"));
        }
        if (patch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patch", "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts", "createFromLocal"));
        }
        GenericPatchApplier applier = new GenericPatchApplier(localContent, patch.getHunks());
        boolean exactlyApplied = applier.execute();
        if (!exactlyApplied) {
            applier.trySolveSomehow();
        }
        String patched = StringUtil.convertLineSeparators((String)applier.getAfter());
        ApplyPatchForBaseRevisionTexts applyPatchForBaseRevisionTexts = new ApplyPatchForBaseRevisionTexts(patched, localContent, null, !exactlyApplied);
        if (applyPatchForBaseRevisionTexts == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts", "createFromLocal"));
        }
        return applyPatchForBaseRevisionTexts;
    }

    @Nullable
    private static ApplyPatchForBaseRevisionTexts createFromBaseVersionProvider(@NotNull Project project2, @NotNull String localContent, @NotNull TextFilePatch patch, @NotNull String beforeVersionId, @NotNull VirtualFile file2, @NotNull FilePath pathBeforeRename) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts", "createFromBaseVersionProvider"));
        }
        if (localContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localContent", "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts", "createFromBaseVersionProvider"));
        }
        if (patch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patch", "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts", "createFromBaseVersionProvider"));
        }
        if (beforeVersionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeVersionId", "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts", "createFromBaseVersionProvider"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts", "createFromBaseVersionProvider"));
        }
        if (pathBeforeRename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathBeforeRename", "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts", "createFromBaseVersionProvider"));
        }
        DefaultPatchBaseVersionProvider baseVersionProvider = new DefaultPatchBaseVersionProvider(project2, file2, beforeVersionId);
        if (!baseVersionProvider.canProvideContent()) {
            return null;
        }
        try {
            List hunks = patch.getHunks();
            Ref baseRef = new Ref();
            Ref patchedRef = new Ref();
            baseVersionProvider.getBaseVersionContent(pathBeforeRename, (Processor<String>)((Processor)base -> {
                GenericPatchApplier applier = new GenericPatchApplier((CharSequence)base, hunks);
                if (!applier.execute()) {
                    return true;
                }
                baseRef.set(base);
                patchedRef.set((Object)StringUtil.convertLineSeparators((String)applier.getAfter()));
                return false;
            }));
            String base2 = (String)baseRef.get();
            String patched = (String)patchedRef.get();
            if (base2 == null || patched == null) {
                return null;
            }
            return new ApplyPatchForBaseRevisionTexts(patched, localContent, base2, false);
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Nullable
    private static ApplyPatchForBaseRevisionTexts createFromStoredBase(@NotNull String localContent, @NotNull TextFilePatch patch, @NotNull CharSequence baseContents) {
        if (localContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localContent", "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts", "createFromStoredBase"));
        }
        if (patch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patch", "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts", "createFromStoredBase"));
        }
        if (baseContents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseContents", "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts", "createFromStoredBase"));
        }
        List hunks = patch.getHunks();
        String base = baseContents.toString();
        GenericPatchApplier applier = new GenericPatchApplier(base, hunks);
        boolean exactlyApplied = applier.execute();
        if (!exactlyApplied) {
            LOG.warn(String.format("Patch for %s has wrong base and can't be applied properly", ObjectUtils.chooseNotNull((Object)patch.getBeforeName(), (Object)patch.getAfterName())));
            return null;
        }
        String patched = StringUtil.convertLineSeparators((String)applier.getAfter());
        return new ApplyPatchForBaseRevisionTexts(patched, localContent, base, false);
    }

    @NotNull
    private static String getLocalFileContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts", "getLocalFileContent"));
        }
        String string = (String)ReadAction.compute(() -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts", "lambda$getLocalFileContent$1"));
            }
            Document document = FileDocumentManager.getInstance().getDocument(file2);
            if (document != null) {
                return document.getText();
            }
            return LoadTextUtil.loadText(file2).toString();
        });
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts", "getLocalFileContent"));
        }
        return string;
    }
}

