/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vcs.changes.patch.tool.ApplyPatchDiffRequest;
import com.intellij.openapi.vcs.changes.patch.tool.ApplyPatchMergeRequest;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchDiffRequestFactory {
    @NotNull
    public static DiffRequest createDiffRequest(@Nullable Project project2, @NotNull Change change, @NotNull String name2, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createDiffRequest"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createDiffRequest"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createDiffRequest"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createDiffRequest"));
        }
        ChangeDiffRequestProducer proxyProducer = ChangeDiffRequestProducer.create(project2, change);
        if (proxyProducer == null) {
            throw new DiffRequestProducerException("Can't show diff for '" + name2 + "'");
        }
        DiffRequest diffRequest = proxyProducer.process(context, indicator);
        if (diffRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createDiffRequest"));
        }
        return diffRequest;
    }

    @NotNull
    public static DiffRequest createConflictDiffRequest(@Nullable Project project2, @Nullable VirtualFile file2, @NotNull TextFilePatch patch, @NotNull String afterTitle, @NotNull ApplyPatchForBaseRevisionTexts texts, @NotNull String name2) throws DiffRequestProducerException {
        if (patch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patch", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createConflictDiffRequest"));
        }
        if (afterTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterTitle", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createConflictDiffRequest"));
        }
        if (texts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "texts", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createConflictDiffRequest"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createConflictDiffRequest"));
        }
        if (file2 == null) {
            throw new DiffRequestProducerException("Can't show diff for '" + name2 + "'");
        }
        if (file2.getFileType().isBinary()) {
            throw new DiffRequestProducerException("Can't show diff for binary file '" + name2 + "'");
        }
        if (texts.getBase() == null) {
            String localContent = texts.getLocal();
            GenericPatchApplier applier = new GenericPatchApplier(localContent, patch.getHunks());
            applier.execute();
            AppliedTextPatch appliedTextPatch = AppliedTextPatch.create(applier.getAppliedInfo());
            DiffRequest diffRequest = PatchDiffRequestFactory.createBadDiffRequest(project2, file2, localContent, appliedTextPatch, null, null, "Current Version", null);
            if (diffRequest == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createConflictDiffRequest"));
            }
            return diffRequest;
        }
        String localContent = texts.getLocal();
        String baseContent = texts.getBase();
        String patchedContent = texts.getPatched();
        DiffRequest diffRequest = PatchDiffRequestFactory.createDiffRequest(project2, file2, ContainerUtil.list((Object[])new String[]{localContent, baseContent, patchedContent}), null, ContainerUtil.list((Object[])new String[]{"Current Version", "Base Version", afterTitle}));
        if (diffRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createConflictDiffRequest"));
        }
        return diffRequest;
    }

    @NotNull
    public static DiffRequest createDiffRequest(@Nullable Project project2, @Nullable VirtualFile file2, @NotNull List<String> contents, @Nullable String windowTitle, @NotNull List<String> titles) {
        DocumentContent localContent;
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createDiffRequest"));
        }
        if (titles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titles", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createDiffRequest"));
        }
        assert (contents.size() == 3);
        assert (titles.size() == 3);
        if (windowTitle == null) {
            windowTitle = PatchDiffRequestFactory.getPatchTitle(file2);
        }
        String localTitle = StringUtil.notNullize((String)titles.get(0), (String)VcsBundle.message((String)"patch.apply.conflict.local.version", (Object[])new Object[0]));
        String baseTitle = StringUtil.notNullize((String)titles.get(1), (String)"Base Version");
        String patchedTitle = StringUtil.notNullize((String)titles.get(2), (String)VcsBundle.message((String)"patch.apply.conflict.patched.version", (Object[])new Object[0]));
        FileType fileType = file2 != null ? file2.getFileType() : null;
        DiffContentFactory contentFactory = DiffContentFactory.getInstance();
        DocumentContent documentContent = localContent = file2 != null ? contentFactory.createDocument(project2, file2) : null;
        if (localContent == null) {
            localContent = contentFactory.create(project2, contents.get(0), fileType);
        }
        DocumentContent baseContent = contentFactory.create(project2, contents.get(1), fileType);
        DocumentContent patchedContent = contentFactory.create(project2, contents.get(2), fileType);
        SimpleDiffRequest simpleDiffRequest = new SimpleDiffRequest(windowTitle, (DiffContent)localContent, (DiffContent)baseContent, (DiffContent)patchedContent, localTitle, baseTitle, patchedTitle);
        if (simpleDiffRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createDiffRequest"));
        }
        return simpleDiffRequest;
    }

    @NotNull
    public static DiffRequest createBadDiffRequest(@Nullable Project project2, @NotNull VirtualFile file2, @NotNull String localContent, @NotNull AppliedTextPatch textPatch, @Nullable String windowTitle, @Nullable String localTitle, @Nullable String resultTitle, @Nullable String patchTitle) {
        DocumentContent resultContent;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createBadDiffRequest"));
        }
        if (localContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localContent", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createBadDiffRequest"));
        }
        if (textPatch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textPatch", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createBadDiffRequest"));
        }
        if (windowTitle == null) {
            windowTitle = PatchDiffRequestFactory.getBadPatchTitle(file2);
        }
        if (localTitle == null) {
            localTitle = VcsBundle.message((String)"patch.apply.conflict.local.version", (Object[])new Object[0]);
        }
        if (resultTitle == null) {
            resultTitle = VcsBundle.message((String)"patch.apply.conflict.patched.somehow.version", (Object[])new Object[0]);
        }
        if (patchTitle == null) {
            patchTitle = VcsBundle.message((String)"patch.apply.conflict.patch", (Object[])new Object[0]);
        }
        if ((resultContent = DiffContentFactory.getInstance().createDocument(project2, file2)) == null) {
            resultContent = DiffContentFactory.getInstance().create(project2, localContent, file2);
        }
        ApplyPatchDiffRequest applyPatchDiffRequest = new ApplyPatchDiffRequest(resultContent, textPatch, localContent, windowTitle, localTitle, resultTitle, patchTitle);
        if (applyPatchDiffRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createBadDiffRequest"));
        }
        return applyPatchDiffRequest;
    }

    @NotNull
    public static MergeRequest createMergeRequest(@Nullable Project project2, @NotNull Document document, @NotNull VirtualFile file2, @NotNull String baseContent, @NotNull String localContent, @NotNull String patchedContent, @Nullable Consumer<MergeResult> callback) throws InvalidDiffRequestException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createMergeRequest"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createMergeRequest"));
        }
        if (baseContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseContent", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createMergeRequest"));
        }
        if (localContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localContent", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createMergeRequest"));
        }
        if (patchedContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchedContent", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createMergeRequest"));
        }
        List titles = ContainerUtil.list((Object[])new String[]{null, null, null});
        List contents = ContainerUtil.list((Object[])new String[]{localContent, baseContent, patchedContent});
        MergeRequest mergeRequest = PatchDiffRequestFactory.createMergeRequest(project2, document, file2, contents, null, titles, callback);
        if (mergeRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createMergeRequest"));
        }
        return mergeRequest;
    }

    @NotNull
    public static MergeRequest createBadMergeRequest(@Nullable Project project2, @NotNull Document document, @NotNull VirtualFile file2, @NotNull String localContent, @NotNull AppliedTextPatch textPatch, @Nullable Consumer<MergeResult> callback) throws InvalidDiffRequestException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createBadMergeRequest"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createBadMergeRequest"));
        }
        if (localContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localContent", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createBadMergeRequest"));
        }
        if (textPatch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textPatch", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createBadMergeRequest"));
        }
        MergeRequest mergeRequest = PatchDiffRequestFactory.createBadMergeRequest(project2, document, file2, localContent, textPatch, null, null, null, null, callback);
        if (mergeRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createBadMergeRequest"));
        }
        return mergeRequest;
    }

    @NotNull
    public static MergeRequest createMergeRequest(@Nullable Project project2, @NotNull Document document, @Nullable VirtualFile file2, @NotNull List<String> contents, @Nullable String windowTitle, @NotNull List<String> titles, @Nullable Consumer<MergeResult> callback) throws InvalidDiffRequestException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createMergeRequest"));
        }
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createMergeRequest"));
        }
        if (titles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titles", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createMergeRequest"));
        }
        assert (contents.size() == 3);
        assert (titles.size() == 3);
        if (windowTitle == null) {
            windowTitle = PatchDiffRequestFactory.getPatchTitle(file2);
        }
        String localTitle = StringUtil.notNullize((String)titles.get(0), (String)VcsBundle.message((String)"patch.apply.conflict.local.version", (Object[])new Object[0]));
        String baseTitle = StringUtil.notNullize((String)titles.get(1), (String)VcsBundle.message((String)"patch.apply.conflict.merged.version", (Object[])new Object[0]));
        String patchedTitle = StringUtil.notNullize((String)titles.get(2), (String)VcsBundle.message((String)"patch.apply.conflict.patched.version", (Object[])new Object[0]));
        List actualTitles = ContainerUtil.list((Object[])new String[]{localTitle, baseTitle, patchedTitle});
        FileType fileType = file2 != null ? file2.getFileType() : null;
        MergeRequest mergeRequest = DiffRequestFactory.getInstance().createMergeRequest(project2, fileType, document, contents, windowTitle, actualTitles, callback);
        if (mergeRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createMergeRequest"));
        }
        return mergeRequest;
    }

    @NotNull
    public static MergeRequest createBadMergeRequest(@Nullable Project project2, @NotNull Document document, @Nullable VirtualFile file2, @NotNull String localContent, @NotNull AppliedTextPatch textPatch, @Nullable String windowTitle, @Nullable String localTitle, @Nullable String resultTitle, @Nullable String patchTitle, @Nullable Consumer<MergeResult> callback) throws InvalidDiffRequestException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createBadMergeRequest"));
        }
        if (localContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localContent", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createBadMergeRequest"));
        }
        if (textPatch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textPatch", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createBadMergeRequest"));
        }
        if (!DiffUtil.canMakeWritable(document)) {
            throw new InvalidDiffRequestException("Output is read only" + (file2 != null ? " : '" + file2.getPresentableUrl() + "'" : ""));
        }
        if (windowTitle == null) {
            windowTitle = PatchDiffRequestFactory.getBadPatchTitle(file2);
        }
        if (localTitle == null) {
            localTitle = VcsBundle.message((String)"patch.apply.conflict.local.version", (Object[])new Object[0]);
        }
        if (resultTitle == null) {
            resultTitle = VcsBundle.message((String)"patch.apply.conflict.patched.somehow.version", (Object[])new Object[0]);
        }
        if (patchTitle == null) {
            patchTitle = VcsBundle.message((String)"patch.apply.conflict.patch", (Object[])new Object[0]);
        }
        DocumentContent resultContent = DiffContentFactory.getInstance().create(project2, document, file2);
        ApplyPatchMergeRequest applyPatchMergeRequest = new ApplyPatchMergeRequest(project2, resultContent, textPatch, localContent, windowTitle, localTitle, resultTitle, patchTitle, callback);
        if (applyPatchMergeRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "createBadMergeRequest"));
        }
        return applyPatchMergeRequest;
    }

    @NotNull
    private static String getPatchTitle(@Nullable VirtualFile file2) {
        if (file2 != null) {
            String string = VcsBundle.message((String)"patch.apply.conflict.title", (Object[])new Object[]{PatchDiffRequestFactory.getPresentablePath(file2)});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "getPatchTitle"));
            }
            return string;
        }
        if ("Patch Conflict" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "getPatchTitle"));
        }
        return "Patch Conflict";
    }

    @NotNull
    private static String getBadPatchTitle(@Nullable VirtualFile file2) {
        if (file2 != null) {
            String string = "Result of Patch Apply to " + PatchDiffRequestFactory.getPresentablePath(file2);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "getBadPatchTitle"));
            }
            return string;
        }
        if ("Result of Patch Apply" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "getBadPatchTitle"));
        }
        return "Result of Patch Apply";
    }

    @NotNull
    private static String getPresentablePath(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "getPresentablePath"));
        }
        String fullPath = file2.getParent() == null ? file2.getPath() : file2.getParent().getPath();
        String string = file2.getName() + " (" + fullPath + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/PatchDiffRequestFactory", "getPresentablePath"));
        }
        return string;
    }
}

