/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.editor.CustomFileDropHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchAction;
import com.intellij.openapi.vcs.changes.patch.PatchFileType;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchFileDropHandler
extends CustomFileDropHandler {
    @Override
    public boolean canHandle(@NotNull Transferable t, @Nullable Editor editor) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/openapi/vcs/changes/patch/PatchFileDropHandler", "canHandle"));
        }
        List<File> list2 = FileCopyPasteUtil.getFileList(t);
        if (list2 == null || list2.size() != 1) {
            return false;
        }
        return PatchFileType.isPatchFile(list2.get(0));
    }

    @Override
    public boolean handleDrop(@NotNull Transferable t, @Nullable Editor editor, @NotNull Project project2) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/openapi/vcs/changes/patch/PatchFileDropHandler", "handleDrop"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/patch/PatchFileDropHandler", "handleDrop"));
        }
        List<File> list2 = FileCopyPasteUtil.getFileList(t);
        if (list2 == null || list2.size() != 1) {
            return false;
        }
        return ApplyPatchAction.showAndGetApplyPatch(project2, list2.get(0));
    }
}

