/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.requests.UnknownFileTypeDiffRequest;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.SoftHardCacheMap;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeGoToChangePopupAction;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vcs.changes.patch.PatchDiffRequestFactory;
import com.intellij.openapi.vcs.changes.patch.tool.PatchDiffRequest;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffShelvedChangesActionProvider
implements AnActionExtensionProvider {
    private static final String DIFF_WITH_BASE_ERROR = "Base content not found or not applicable.";
    public static final String SHELVED_VERSION = "Shelved Version";
    public static final String BASE_VERSION = "Base Version";
    public static final String CURRENT_VERSION = "Current Version";

    @Override
    public boolean isActive(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider", "isActive"));
        }
        return e.getData(ShelvedChangesViewManager.SHELVED_CHANGELIST_KEY) != null || e.getData(ShelvedChangesViewManager.SHELVED_RECYCLED_CHANGELIST_KEY) != null;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider", "update"));
        }
        e.getPresentation().setEnabled(DiffShelvedChangesActionProvider.isEnabled(e.getDataContext()));
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider", "actionPerformed"));
        }
        DiffShelvedChangesActionProvider.showShelvedChangesDiff(e.getDataContext());
    }

    public static boolean isEnabled(DataContext dc) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dc);
        if (project2 == null) {
            return false;
        }
        List<ShelvedChangeList> changeLists = ShelvedChangesViewManager.getShelvedLists(dc);
        return changeLists.size() == 1;
    }

    public static void showShelvedChangesDiff(DataContext dc) {
        DiffShelvedChangesActionProvider.showShelvedChangesDiff(dc, false);
    }

    public static void showShelvedChangesDiff(DataContext dc, boolean withLocal) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dc);
        if (project2 == null) {
            return;
        }
        if (ChangeListManager.getInstance((Project)project2).isFreezedWithNotification(null)) {
            return;
        }
        List<ShelvedChangeList> changeLists = ShelvedChangesViewManager.getShelvedLists(dc);
        ShelvedChangeList changeList = (ShelvedChangeList)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(changeLists));
        List<ShelvedChange> textChanges = changeList.getChanges(project2);
        List<ShelvedBinaryFile> binaryChanges = changeList.getBinaryFiles();
        ArrayList<MyDiffRequestProducer> diffRequestProducers = new ArrayList<MyDiffRequestProducer>();
        DiffShelvedChangesActionProvider.processTextChanges(project2, textChanges, diffRequestProducers, withLocal);
        DiffShelvedChangesActionProvider.processBinaryFiles(project2, binaryChanges, diffRequestProducers);
        Collections.sort(diffRequestProducers, ChangeDiffRequestComparator.getInstance());
        HashSet<Object> selectedChanges = new HashSet<Object>();
        selectedChanges.addAll(ShelvedChangesViewManager.getShelveChanges(dc));
        selectedChanges.addAll(ShelvedChangesViewManager.getBinaryShelveChanges(dc));
        int index = 0;
        for (int i2 = 0; i2 < diffRequestProducers.size(); ++i2) {
            MyDiffRequestProducer producer = (MyDiffRequestProducer)diffRequestProducers.get(i2);
            if (!selectedChanges.contains(producer.getBinaryChange()) && !selectedChanges.contains(producer.getTextChange())) continue;
            index = i2;
            break;
        }
        MyDiffRequestChain chain = new MyDiffRequestChain(diffRequestProducers, index);
        DiffManager.getInstance().showDiff(project2, (DiffRequestChain)chain, DiffDialogHints.FRAME);
    }

    private static void processBinaryFiles(final @NotNull Project project2, @NotNull List<ShelvedBinaryFile> files, @NotNull List<MyDiffRequestProducer> diffRequestProducers) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider", "processBinaryFiles"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider", "processBinaryFiles"));
        }
        if (diffRequestProducers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffRequestProducers", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider", "processBinaryFiles"));
        }
        String base = project2.getBaseDir().getPath();
        for (final ShelvedBinaryFile shelvedChange : files) {
            File file2 = new File(base, shelvedChange.AFTER_PATH == null ? shelvedChange.BEFORE_PATH : shelvedChange.AFTER_PATH);
            FilePath filePath = VcsUtil.getFilePath((File)file2);
            diffRequestProducers.add(new MyDiffRequestProducer(shelvedChange, filePath){

                @NotNull
                public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
                    if (context == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$1", "process"));
                    }
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$1", "process"));
                    }
                    Change change = shelvedChange.createChange(project2);
                    DiffRequest diffRequest = PatchDiffRequestFactory.createDiffRequest(project2, change, this.getName(), context, indicator);
                    if (diffRequest == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$1", "process"));
                    }
                    return diffRequest;
                }
            });
        }
    }

    private static void processTextChanges(final @NotNull Project project2, @NotNull List<ShelvedChange> changesFromFirstList, @NotNull List<MyDiffRequestProducer> diffRequestProducers, final boolean withLocal) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider", "processTextChanges"));
        }
        if (changesFromFirstList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changesFromFirstList", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider", "processTextChanges"));
        }
        if (diffRequestProducers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffRequestProducers", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider", "processTextChanges"));
        }
        String base = project2.getBasePath();
        final ApplyPatchContext patchContext = new ApplyPatchContext(project2.getBaseDir(), 0, false, false);
        final PatchesPreloader preloader = new PatchesPreloader(project2);
        final CommitContext commitContext = new CommitContext();
        for (final ShelvedChange shelvedChange : changesFromFirstList) {
            VirtualFile file2;
            final String beforePath = shelvedChange.getBeforePath();
            final String afterPath = shelvedChange.getAfterPath();
            FilePath filePath = VcsUtil.getFilePath((File)new File(base, afterPath == null ? beforePath : afterPath));
            final boolean isNewFile = FileStatus.ADDED.equals(shelvedChange.getFileStatus());
            try {
                file2 = ApplyFilePatchBase.findPatchTarget(patchContext, beforePath, afterPath, isNewFile);
                if (!(isNewFile || file2 != null && file2.exists())) {
                    throw new FileNotFoundException(beforePath);
                }
            }
            catch (IOException e) {
                diffRequestProducers.add(new MyDiffRequestProducer(shelvedChange, filePath){

                    @NotNull
                    public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
                        PatchDiffRequest patchDiffRequest;
                        if (context == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$2", "process"));
                        }
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$2", "process"));
                        }
                        try {
                            TextFilePatch patch = preloader.getPatch(shelvedChange, commitContext);
                            PatchDiffRequest patchDiffRequest2 = new PatchDiffRequest(DiffShelvedChangesActionProvider.createAppliedTextPatch(patch), this.getName(), VcsBundle.message((String)"patch.apply.conflict.patch", (Object[])new Object[0]));
                            DiffUtil.addNotification(DiffNotifications.createNotification("Cannot find local file for '" + (String)ObjectUtils.chooseNotNull((Object)beforePath, (Object)afterPath) + "'"), (UserDataHolder)patchDiffRequest2);
                            patchDiffRequest = patchDiffRequest2;
                        }
                        catch (VcsException e) {
                            throw new DiffRequestProducerException("Can't show diff for '" + this.getName() + "'", (Throwable)e);
                        }
                        if (patchDiffRequest == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$2", "process"));
                        }
                        return patchDiffRequest;
                    }
                });
                continue;
            }
            diffRequestProducers.add(new MyDiffRequestProducer(shelvedChange, filePath){

                @NotNull
                public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
                    TextFilePatch patch;
                    if (context == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$3", "process"));
                    }
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$3", "process"));
                    }
                    if (!isNewFile && file2.getFileType() == UnknownFileType.INSTANCE) {
                        UnknownFileTypeDiffRequest unknownFileTypeDiffRequest = new UnknownFileTypeDiffRequest(file2, this.getName());
                        if (unknownFileTypeDiffRequest == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$3", "process"));
                        }
                        return unknownFileTypeDiffRequest;
                    }
                    if (isNewFile) {
                        DiffRequest diffRequest = PatchDiffRequestFactory.createDiffRequest(project2, shelvedChange.getChange(project2), this.getName(), context, indicator);
                        if (diffRequest == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$3", "process"));
                        }
                        return diffRequest;
                    }
                    try {
                        patch = preloader.getPatch(shelvedChange, commitContext);
                    }
                    catch (VcsException e) {
                        throw new DiffRequestProducerException("Can't show diff for '" + this.getName() + "'", (Throwable)e);
                    }
                    if (patch.isDeletedFile()) {
                        DiffRequest diffRequest = this.createDiffRequestForDeleted(patch);
                        if (diffRequest == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$3", "process"));
                        }
                        return diffRequest;
                    }
                    DiffRequest diffRequest = this.createDiffRequestForModified(patch, commitContext, context, indicator);
                    if (diffRequest == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$3", "process"));
                    }
                    return diffRequest;
                }

                @NotNull
                private DiffRequest createDiffRequestForDeleted(@NotNull TextFilePatch patch) {
                    if (patch == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patch", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$3", "createDiffRequestForDeleted"));
                    }
                    assert (file2 != null);
                    DiffContentFactory contentFactory = DiffContentFactory.getInstance();
                    DiffContent leftContent = withLocal ? contentFactory.create(project2, file2) : contentFactory.create(project2, patch.getSingleHunkPatchText(), file2);
                    SimpleDiffRequest simpleDiffRequest = new SimpleDiffRequest(this.getName(), leftContent, (DiffContent)contentFactory.createEmpty(), withLocal ? DiffShelvedChangesActionProvider.CURRENT_VERSION : DiffShelvedChangesActionProvider.SHELVED_VERSION, null);
                    if (simpleDiffRequest == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$3", "createDiffRequestForDeleted"));
                    }
                    return simpleDiffRequest;
                }

                @NotNull
                private DiffRequest createDiffRequestForModified(@NotNull TextFilePatch patch, @NotNull CommitContext commitContext2, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException {
                    DiffRequest diffRequest;
                    if (patch == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patch", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$3", "createDiffRequestForModified"));
                    }
                    if (commitContext2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitContext", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$3", "createDiffRequestForModified"));
                    }
                    if (context == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$3", "createDiffRequestForModified"));
                    }
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$3", "createDiffRequestForModified"));
                    }
                    assert (file2 != null);
                    CharSequence baseContents = ((BaseRevisionTextPatchEP)Extensions.findExtension((ExtensionPointName)PatchEP.EP_NAME, (AreaInstance)project2, BaseRevisionTextPatchEP.class)).provideContent((String)ObjectUtils.chooseNotNull((Object)patch.getAfterName(), (Object)patch.getBeforeName()), commitContext2);
                    ApplyPatchForBaseRevisionTexts texts = ApplyPatchForBaseRevisionTexts.create(project2, file2, patchContext.getPathBeforeRename(file2), patch, baseContents);
                    if (texts.isBaseRevisionLoaded()) {
                        assert (!texts.isAppliedSomehow());
                        DiffContentFactory contentFactory = DiffContentFactory.getInstance();
                        DiffContent leftContent = withLocal ? contentFactory.create(project2, file2) : contentFactory.create(project2, (String)ObjectUtils.assertNotNull((Object)texts.getBase()), file2);
                        SimpleDiffRequest simpleDiffRequest = new SimpleDiffRequest(this.getName(), leftContent, (DiffContent)contentFactory.create(project2, texts.getPatched(), file2), withLocal ? DiffShelvedChangesActionProvider.CURRENT_VERSION : DiffShelvedChangesActionProvider.BASE_VERSION, DiffShelvedChangesActionProvider.SHELVED_VERSION);
                        if (simpleDiffRequest == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$3", "createDiffRequestForModified"));
                        }
                        return simpleDiffRequest;
                    }
                    DiffRequest diffRequest2 = diffRequest = shelvedChange.isConflictingChange(project2) ? PatchDiffRequestFactory.createConflictDiffRequest(project2, file2, patch, DiffShelvedChangesActionProvider.SHELVED_VERSION, texts, this.getName()) : PatchDiffRequestFactory.createDiffRequest(project2, shelvedChange.getChange(project2), this.getName(), context, indicator);
                    if (!withLocal) {
                        DiffUtil.addNotification(DiffNotifications.createNotification("Base content not found or not applicable. Showing difference with local version"), (UserDataHolder)diffRequest);
                    }
                    DiffRequest diffRequest3 = diffRequest;
                    if (diffRequest3 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$3", "createDiffRequestForModified"));
                    }
                    return diffRequest3;
                }
            });
        }
    }

    @NotNull
    static AppliedTextPatch createAppliedTextPatch(@NotNull TextFilePatch patch) {
        if (patch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patch", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider", "createAppliedTextPatch"));
        }
        GenericPatchApplier applier = new GenericPatchApplier("", patch.getHunks());
        applier.execute();
        AppliedTextPatch appliedTextPatch = AppliedTextPatch.create(applier.getAppliedInfo());
        if (appliedTextPatch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider", "createAppliedTextPatch"));
        }
        return appliedTextPatch;
    }

    private static abstract class MyDiffRequestProducer
    implements DiffRequestProducer {
        @Nullable
        private final ShelvedChange myTextChange;
        @Nullable
        private final ShelvedBinaryFile myBinaryChange;
        @NotNull
        private final FilePath myFilePath;

        public MyDiffRequestProducer(@NotNull ShelvedChange textChange, @NotNull FilePath filePath) {
            if (textChange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textChange", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$MyDiffRequestProducer", "<init>"));
            }
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$MyDiffRequestProducer", "<init>"));
            }
            this.myBinaryChange = null;
            this.myTextChange = textChange;
            this.myFilePath = filePath;
        }

        public MyDiffRequestProducer(@NotNull ShelvedBinaryFile binaryChange, @NotNull FilePath filePath) {
            if (binaryChange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryChange", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$MyDiffRequestProducer", "<init>"));
            }
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$MyDiffRequestProducer", "<init>"));
            }
            this.myBinaryChange = binaryChange;
            this.myTextChange = null;
            this.myFilePath = filePath;
        }

        @Nullable
        public ShelvedChange getTextChange() {
            return this.myTextChange;
        }

        @Nullable
        public ShelvedBinaryFile getBinaryChange() {
            return this.myBinaryChange;
        }

        @NotNull
        public String getName() {
            String string = FileUtil.toSystemDependentName((String)this.getFilePath().getPath());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$MyDiffRequestProducer", "getName"));
            }
            return string;
        }

        @NotNull
        protected FileStatus getFileStatus() {
            if (this.myTextChange != null) {
                FileStatus fileStatus = this.myTextChange.getFileStatus();
                if (fileStatus == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$MyDiffRequestProducer", "getFileStatus"));
                }
                return fileStatus;
            }
            assert (this.myBinaryChange != null);
            FileStatus fileStatus = this.myBinaryChange.getFileStatus();
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$MyDiffRequestProducer", "getFileStatus"));
            }
            return fileStatus;
        }

        @NotNull
        public FilePath getFilePath() {
            FilePath filePath = this.myFilePath;
            if (filePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$MyDiffRequestProducer", "getFilePath"));
            }
            return filePath;
        }
    }

    private static class MyDiffRequestChain
    extends UserDataHolderBase
    implements DiffRequestChain,
    GoToChangePopupBuilder.Chain {
        @NotNull
        private final List<MyDiffRequestProducer> myProducers;
        private int myIndex;

        public MyDiffRequestChain(@NotNull List<MyDiffRequestProducer> producers, int index) {
            if (producers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producers", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$MyDiffRequestChain", "<init>"));
            }
            this.myIndex = 0;
            this.myProducers = producers;
            this.myIndex = index;
        }

        @NotNull
        public List<? extends DiffRequestProducer> getRequests() {
            List<MyDiffRequestProducer> list2 = this.myProducers;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$MyDiffRequestChain", "getRequests"));
            }
            return list2;
        }

        public int getIndex() {
            return this.myIndex;
        }

        public void setIndex(int index) {
            assert (index >= 0 && index < this.myProducers.size());
            this.myIndex = index;
        }

        @Override
        @NotNull
        public AnAction createGoToChangeAction(@NotNull Consumer<Integer> onSelected) {
            if (onSelected == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onSelected", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$MyDiffRequestChain", "createGoToChangeAction"));
            }
            ChangeGoToChangePopupAction.Fake<MyDiffRequestChain> fake = new ChangeGoToChangePopupAction.Fake<MyDiffRequestChain>(this, this.myIndex, onSelected){

                @Override
                @NotNull
                protected FilePath getFilePath(int index) {
                    FilePath filePath = ((MyDiffRequestProducer)myProducers.get(index)).getFilePath();
                    if (filePath == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$MyDiffRequestChain$1", "getFilePath"));
                    }
                    return filePath;
                }

                @Override
                @NotNull
                protected FileStatus getFileStatus(int index) {
                    FileStatus fileStatus = ((MyDiffRequestProducer)myProducers.get(index)).getFileStatus();
                    if (fileStatus == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$MyDiffRequestChain$1", "getFileStatus"));
                    }
                    return fileStatus;
                }
            };
            if (fake == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$MyDiffRequestChain", "createGoToChangeAction"));
            }
            return fake;
        }
    }

    static class PatchesPreloader {
        private final Project myProject;
        private final SoftHardCacheMap<String, PatchInfo> myFilePatchesMap = new SoftHardCacheMap(5, 5);
        private final ReadWriteLock myLock = new ReentrantReadWriteLock(true);

        PatchesPreloader(Project project2) {
            this.myProject = project2;
        }

        @NotNull
        public TextFilePatch getPatch(ShelvedChange shelvedChange, @Nullable CommitContext commitContext) throws VcsException {
            PatchInfo patchInfo;
            String patchPath = shelvedChange.getPatchPath();
            if (this.getInfoFromCache(patchPath) == null || this.isPatchFileChanged(patchPath)) {
                this.readFilePatchAndUpdateCaches(patchPath, commitContext);
            }
            if ((patchInfo = this.getInfoFromCache(patchPath)) != null) {
                for (TextFilePatch textFilePatch : patchInfo.myTextFilePatches) {
                    if (!shelvedChange.getBeforePath().equals(textFilePatch.getBeforeName())) continue;
                    TextFilePatch textFilePatch2 = textFilePatch;
                    if (textFilePatch2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$PatchesPreloader", "getPatch"));
                    }
                    return textFilePatch2;
                }
            }
            throw new VcsException("Can not find patch for " + shelvedChange.getBeforePath() + " in patch file.");
        }

        private PatchInfo getInfoFromCache(@NotNull String patchPath) {
            if (patchPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchPath", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$PatchesPreloader", "getInfoFromCache"));
            }
            try {
                this.myLock.readLock().lock();
                PatchInfo patchInfo = this.myFilePatchesMap.get(patchPath);
                return patchInfo;
            }
            finally {
                this.myLock.readLock().unlock();
            }
        }

        private void readFilePatchAndUpdateCaches(@NotNull String patchPath, @Nullable CommitContext commitContext) throws VcsException {
            if (patchPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchPath", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$PatchesPreloader", "readFilePatchAndUpdateCaches"));
            }
            try {
                this.myLock.writeLock().lock();
                this.myFilePatchesMap.put(patchPath, new PatchInfo(ShelveChangesManager.loadPatches(this.myProject, patchPath, commitContext), new File(patchPath).lastModified()));
            }
            catch (PatchSyntaxException | IOException e) {
                throw new VcsException(e);
            }
            finally {
                this.myLock.writeLock().unlock();
            }
        }

        public boolean isPatchFileChanged(@NotNull String patchPath) {
            if (patchPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchPath", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$PatchesPreloader", "isPatchFileChanged"));
            }
            PatchInfo patchInfo = this.getInfoFromCache(patchPath);
            long lastModified = new File(patchPath).lastModified();
            return patchInfo != null && lastModified != patchInfo.myLoadedTimeStamp;
        }

        private static class PatchInfo {
            private final long myLoadedTimeStamp;
            @NotNull
            private final List<TextFilePatch> myTextFilePatches;

            public PatchInfo(@NotNull List<TextFilePatch> patches, long loadedTimeStamp) {
                if (patches == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patches", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$PatchesPreloader$PatchInfo", "<init>"));
                }
                this.myTextFilePatches = patches;
                this.myLoadedTimeStamp = loadedTimeStamp;
            }
        }
    }

    private static class ChangeDiffRequestComparator
    implements Comparator<DiffRequestProducer> {
        private static final ChangeDiffRequestComparator ourInstance = new ChangeDiffRequestComparator();

        private ChangeDiffRequestComparator() {
        }

        public static ChangeDiffRequestComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(DiffRequestProducer o1, DiffRequestProducer o2) {
            return FilePathsHelper.convertPath((String)o1.getName()).compareTo(FilePathsHelper.convertPath((String)o2.getName()));
        }
    }
}

