/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShelvedWrapper {
    @Nullable
    private final ShelvedChange myShelvedChange;
    @Nullable
    private final ShelvedBinaryFile myBinaryFile;

    public ShelvedWrapper(@NotNull ShelvedChange shelvedChange) {
        if (shelvedChange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shelvedChange", "com/intellij/openapi/vcs/changes/shelf/ShelvedWrapper", "<init>"));
        }
        this.myShelvedChange = shelvedChange;
        this.myBinaryFile = null;
    }

    public ShelvedWrapper(@NotNull ShelvedBinaryFile binaryFile) {
        if (binaryFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryFile", "com/intellij/openapi/vcs/changes/shelf/ShelvedWrapper", "<init>"));
        }
        this.myShelvedChange = null;
        this.myBinaryFile = binaryFile;
    }

    @Nullable
    public ShelvedChange getShelvedChange() {
        return this.myShelvedChange;
    }

    @Nullable
    public ShelvedBinaryFile getBinaryFile() {
        return this.myBinaryFile;
    }

    public String getRequestName() {
        return FileUtil.toSystemDependentName((String)((String)ObjectUtils.chooseNotNull((Object)this.getAfterPath(), (Object)this.getBeforePath())));
    }

    private String getBeforePath() {
        return this.myShelvedChange != null ? this.myShelvedChange.getBeforePath() : ((ShelvedBinaryFile)ObjectUtils.assertNotNull((Object)this.myBinaryFile)).BEFORE_PATH;
    }

    private String getAfterPath() {
        return this.myShelvedChange != null ? this.myShelvedChange.getAfterPath() : ((ShelvedBinaryFile)ObjectUtils.assertNotNull((Object)this.myBinaryFile)).AFTER_PATH;
    }
}

