/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.ide.DeleteProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesSelection;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffAction;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffContext;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeList;
import com.intellij.openapi.vcs.changes.ui.RemoteStatusChangeNodeDecorator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangesBrowserBase<T>
extends JPanel
implements TypeSafeDataProvider,
Disposable {
    private static final Logger LOG = Logger.getInstance(ChangesBrowserBase.class);
    private boolean myDataIsDirty;
    protected final Class<T> myClass;
    protected final ChangesTreeList<T> myViewer;
    protected final JScrollPane myViewerScrollPane;
    protected ChangeList mySelectedChangeList;
    protected List<T> myChangesToDisplay;
    protected final Project myProject;
    private final boolean myCapableOfExcludingChanges;
    protected final JPanel myHeaderPanel;
    private JComponent myBottomPanel;
    private DefaultActionGroup myToolBarGroup;
    private String myToggleActionTitle;
    private JComponent myDiffBottomComponent;
    public static DataKey<ChangesBrowserBase> DATA_KEY = DataKey.create((String)"com.intellij.openapi.vcs.changes.ui.ChangesBrowser");
    private AnAction myDiffAction;
    private final VirtualFile myToSelect;
    @NotNull
    private final DeleteProvider myDeleteProvider;

    public void setChangesToDisplay(List<T> changes) {
        this.myChangesToDisplay = changes;
        this.myViewer.setChangesToDisplay(changes);
    }

    public void setDecorator(ChangeNodeDecorator decorator) {
        this.myViewer.setChangeDecorator(decorator);
    }

    protected ChangesBrowserBase(@NotNull Project project2, @NotNull List<T> changes, boolean capableOfExcludingChanges, boolean highlightProblems, @Nullable Runnable inclusionListener, @NotNull ChangesBrowser.MyUseCase useCase, @Nullable VirtualFile toSelect2, @NotNull Class<T> clazz) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserBase", "<init>"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserBase", "<init>"));
        }
        if (useCase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useCase", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserBase", "<init>"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserBase", "<init>"));
        }
        super(new BorderLayout());
        this.myToggleActionTitle = VcsBundle.message((String)"commit.dialog.include.action.name", (Object[])new Object[0]);
        this.myDeleteProvider = new VirtualFileDeleteProvider();
        this.setFocusable(false);
        this.myClass = clazz;
        this.myDataIsDirty = false;
        this.myProject = project2;
        this.myCapableOfExcludingChanges = capableOfExcludingChanges;
        this.myToSelect = toSelect2;
        RemoteStatusChangeNodeDecorator decorator = ChangesBrowser.MyUseCase.LOCAL_CHANGES.equals((Object)useCase) ? RemoteRevisionsCache.getInstance(this.myProject).getChangesNodeDecorator() : null;
        this.myViewer = new ChangesTreeList<T>(this.myProject, changes, capableOfExcludingChanges, highlightProblems, inclusionListener, decorator){

            @Override
            protected DefaultTreeModel buildTreeModel(List<T> changes, ChangeNodeDecorator changeNodeDecorator) {
                return ChangesBrowserBase.this.buildTreeModel(changes, changeNodeDecorator, this.isShowFlatten());
            }

            @Override
            protected List<T> getSelectedObjects(ChangesBrowserNode<T> node) {
                return ChangesBrowserBase.this.getSelectedObjects(node);
            }

            @Override
            @Nullable
            protected T getLeadSelectedObject(ChangesBrowserNode node) {
                return ChangesBrowserBase.this.getLeadSelectedObject(node);
            }

            @Override
            public void setScrollPaneBorder(Border border) {
                ChangesBrowserBase.this.myViewerScrollPane.setBorder(border);
            }
        };
        this.myViewerScrollPane = ScrollPaneFactory.createScrollPane(this.myViewer);
        this.myHeaderPanel = new JPanel(new BorderLayout());
    }

    protected void init() {
        this.add((Component)this.myViewerScrollPane, "Center");
        this.myHeaderPanel.add((Component)this.createToolbar(), "Center");
        this.add((Component)this.myHeaderPanel, "North");
        this.myBottomPanel = new JPanel(new BorderLayout());
        this.add((Component)this.myBottomPanel, "South");
        this.myViewer.installPopupHandler((ActionGroup)this.myToolBarGroup);
        this.myViewer.setDoubleClickHandler(this.getDoubleClickHandler());
    }

    @NotNull
    protected abstract DefaultTreeModel buildTreeModel(List<T> var1, ChangeNodeDecorator var2, boolean var3);

    @NotNull
    protected abstract List<T> getSelectedObjects(@NotNull ChangesBrowserNode<T> var1);

    @Nullable
    protected abstract T getLeadSelectedObject(@NotNull ChangesBrowserNode var1);

    @NotNull
    protected Runnable getDoubleClickHandler() {
        Runnable runnable2 = () -> this.showDiff();
        if (runnable2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserBase", "getDoubleClickHandler"));
        }
        return runnable2;
    }

    protected void setInitialSelection(List<? extends ChangeList> changeLists, @NotNull List<T> changes, ChangeList initialListSelection) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserBase", "setInitialSelection"));
        }
        this.mySelectedChangeList = initialListSelection;
    }

    public void dispose() {
    }

    public void addToolbarAction(AnAction action) {
        this.myToolBarGroup.add(action);
    }

    public void setDiffBottomComponent(JComponent diffBottomComponent) {
        this.myDiffBottomComponent = diffBottomComponent;
    }

    public void setToggleActionTitle(String toggleActionTitle) {
        this.myToggleActionTitle = toggleActionTitle;
    }

    public JPanel getHeaderPanel() {
        return this.myHeaderPanel;
    }

    public ChangesTreeList<T> getViewer() {
        return this.myViewer;
    }

    @NotNull
    public JScrollPane getViewerScrollPane() {
        JScrollPane jScrollPane = this.myViewerScrollPane;
        if (jScrollPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserBase", "getViewerScrollPane"));
        }
        return jScrollPane;
    }

    public void calcData(DataKey key2, DataSink sink) {
        if (key2 == VcsDataKeys.CHANGES) {
            List<Change> list2 = this.getSelectedChanges();
            if (list2.isEmpty()) {
                list2 = this.getAllChanges();
            }
            sink.put(VcsDataKeys.CHANGES, (Object)list2.toArray(new Change[list2.size()]));
        } else if (key2 == VcsDataKeys.CHANGES_SELECTION) {
            sink.put(VcsDataKeys.CHANGES_SELECTION, (Object)this.getChangesSelection());
        } else if (key2 == VcsDataKeys.CHANGE_LISTS) {
            sink.put(VcsDataKeys.CHANGE_LISTS, (Object)this.getSelectedChangeLists());
        } else if (key2 == VcsDataKeys.CHANGE_LEAD_SELECTION) {
            Change[] changeArray;
            Change highestSelection = (Change)ObjectUtils.tryCast(this.myViewer.getHighestLeadSelection(), Change.class);
            if (highestSelection == null) {
                changeArray = new Change[]{};
            } else {
                Change[] changeArray2 = new Change[1];
                changeArray = changeArray2;
                changeArray2[0] = highestSelection;
            }
            sink.put(VcsDataKeys.CHANGE_LEAD_SELECTION, (Object)changeArray);
        } else if (key2 == CommonDataKeys.VIRTUAL_FILE_ARRAY) {
            sink.put(CommonDataKeys.VIRTUAL_FILE_ARRAY, this.getSelectedFiles().toArray(VirtualFile[]::new));
        } else if (key2 == CommonDataKeys.NAVIGATABLE_ARRAY) {
            sink.put(CommonDataKeys.NAVIGATABLE_ARRAY, (Object)ChangesUtil.getNavigatableArray((Project)this.myProject, this.getSelectedFiles()));
        } else if (VcsDataKeys.IO_FILE_ARRAY.equals(key2)) {
            sink.put(VcsDataKeys.IO_FILE_ARRAY, (Object)this.getSelectedIoFiles());
        } else if (key2 == DATA_KEY) {
            sink.put(DATA_KEY, (Object)this);
        } else if (VcsDataKeys.SELECTED_CHANGES_IN_DETAILS.equals(key2)) {
            List<Change> selectedChanges = this.getSelectedChanges();
            sink.put(VcsDataKeys.SELECTED_CHANGES_IN_DETAILS, (Object)selectedChanges.toArray(new Change[selectedChanges.size()]));
        } else if (ChangesListView.UNVERSIONED_FILES_DATA_KEY.equals((Object)key2)) {
            sink.put(ChangesListView.UNVERSIONED_FILES_DATA_KEY, ChangesListView.getVirtualFiles(this.myViewer.getSelectionPaths(), ChangesBrowserNode.UNVERSIONED_FILES_TAG));
        } else if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.equals(key2)) {
            sink.put(PlatformDataKeys.DELETE_ELEMENT_PROVIDER, (Object)this.myDeleteProvider);
        }
    }

    public void select(List<T> changes) {
        this.myViewer.select(changes);
    }

    public JComponent getBottomPanel() {
        return this.myBottomPanel;
    }

    protected void showDiffForChanges(Change[] changesArray, int indexInSelection) {
        ShowDiffContext context = new ShowDiffContext(ChangesBrowserBase.isInFrame() ? DiffDialogHints.FRAME : DiffDialogHints.MODAL);
        context.addActions(this.createDiffActions());
        if (this.myDiffBottomComponent != null) {
            context.putChainContext(DiffUserDataKeysEx.BOTTOM_PANEL, this.myDiffBottomComponent);
        }
        this.updateDiffContext(context);
        ShowDiffAction.showDiffForChange(this.myProject, Arrays.asList(changesArray), indexInSelection, context);
    }

    protected void updateDiffContext(@NotNull ShowDiffContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserBase", "updateDiffContext"));
        }
    }

    private boolean canShowDiff() {
        return ShowDiffAction.canShowDiff(this.myProject, this.getChangesSelection().getChanges());
    }

    private void showDiff() {
        ChangesSelection selection = this.getChangesSelection();
        List changes = selection.getChanges();
        Change[] changesArray = changes.toArray(new Change[changes.size()]);
        this.showDiffForChanges(changesArray, selection.getIndex());
        this.afterDiffRefresh();
    }

    @NotNull
    protected ChangesSelection getChangesSelection() {
        List<Change> allChanges;
        Change leadSelection = (Change)ObjectUtils.tryCast(this.myViewer.getLeadSelection(), Change.class);
        List<Change> changes = this.getSelectedChanges();
        if (changes.size() < 2 && ((allChanges = this.getAllChanges()).size() > 1 || changes.isEmpty())) {
            changes = allChanges;
        }
        if (leadSelection != null) {
            int indexInSelection = changes.indexOf(leadSelection);
            if (indexInSelection == -1) {
                ChangesSelection changesSelection = new ChangesSelection(Collections.singletonList(leadSelection), 0);
                if (changesSelection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserBase", "getChangesSelection"));
                }
                return changesSelection;
            }
            ChangesSelection changesSelection = new ChangesSelection(changes, indexInSelection);
            if (changesSelection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserBase", "getChangesSelection"));
            }
            return changesSelection;
        }
        ChangesSelection changesSelection = new ChangesSelection(changes, 0);
        if (changesSelection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserBase", "getChangesSelection"));
        }
        return changesSelection;
    }

    protected void afterDiffRefresh() {
    }

    private static boolean isInFrame() {
        return ModalityState.current().equals(ModalityState.NON_MODAL);
    }

    protected List<AnAction> createDiffActions() {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        if (this.myCapableOfExcludingChanges) {
            actions.add((AnAction)new ToggleChangeAction());
        }
        return actions;
    }

    public void rebuildList() {
        this.myViewer.setChangesToDisplay(this.getCurrentDisplayedObjects(), this.myToSelect);
    }

    public void setAlwayExpandList(boolean value2) {
        this.myViewer.setAlwaysExpandList(value2);
    }

    @NotNull
    protected JComponent createToolbar() {
        DefaultActionGroup toolbarGroups = new DefaultActionGroup();
        this.myToolBarGroup = new DefaultActionGroup();
        toolbarGroups.add((AnAction)this.myToolBarGroup);
        this.buildToolBar(this.myToolBarGroup);
        toolbarGroups.addSeparator();
        DefaultActionGroup treeActionsGroup = new DefaultActionGroup();
        toolbarGroups.add((AnAction)treeActionsGroup);
        for (AnAction action : this.myViewer.getTreeActions()) {
            treeActionsGroup.add(action);
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ChangesBrowser", (ActionGroup)toolbarGroups, true);
        toolbar.setTargetComponent((JComponent)this);
        JComponent jComponent = toolbar.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserBase", "createToolbar"));
        }
        return jComponent;
    }

    protected void buildToolBar(DefaultActionGroup toolBarGroup) {
        this.myDiffAction = new DumbAwareAction(){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(ChangesBrowserBase.this.canShowDiff() || e.getInputEvent() instanceof KeyEvent);
            }

            public void actionPerformed(AnActionEvent e) {
                ChangesBrowserBase.this.showDiff();
            }
        };
        ActionUtil.copyFrom((AnAction)this.myDiffAction, (String)"Diff.ShowDiff");
        this.myDiffAction.registerCustomShortcutSet(this.myViewer, null);
        toolBarGroup.add(this.myDiffAction);
    }

    @NotNull
    public Set<AbstractVcs> getAffectedVcses() {
        Set set2 = ChangesUtil.getAffectedVcses(this.getCurrentDisplayedChanges(), (Project)this.myProject);
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserBase", "getAffectedVcses"));
        }
        return set2;
    }

    @NotNull
    public abstract List<Change> getCurrentIncludedChanges();

    @NotNull
    public List<Change> getCurrentDisplayedChanges() {
        ArrayList arrayList = this.mySelectedChangeList != null ? ContainerUtil.newArrayList((Iterable)this.mySelectedChangeList.getChanges()) : Collections.emptyList();
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserBase", "getCurrentDisplayedChanges"));
        }
        return arrayList;
    }

    @NotNull
    public abstract List<T> getCurrentDisplayedObjects();

    @NotNull
    public List<VirtualFile> getIncludedUnversionedFiles() {
        List<VirtualFile> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserBase", "getIncludedUnversionedFiles"));
        }
        return list2;
    }

    public int getUnversionedFilesCount() {
        return 0;
    }

    public ChangeList getSelectedChangeList() {
        return this.mySelectedChangeList;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myViewer.getPreferredFocusedComponent();
    }

    private ChangeList[] getSelectedChangeLists() {
        if (this.mySelectedChangeList != null) {
            return new ChangeList[]{this.mySelectedChangeList};
        }
        return null;
    }

    private File[] getSelectedIoFiles() {
        List<Change> changes = this.getSelectedChanges();
        ArrayList<File> files = new ArrayList<File>();
        for (Change change : changes) {
            ContentRevision afterRevision = change.getAfterRevision();
            if (afterRevision == null) continue;
            FilePath file2 = afterRevision.getFile();
            File ioFile = file2.getIOFile();
            files.add(ioFile);
        }
        return files.toArray(new File[files.size()]);
    }

    @NotNull
    public abstract List<Change> getSelectedChanges();

    @NotNull
    public abstract List<Change> getAllChanges();

    @NotNull
    protected Stream<VirtualFile> getSelectedFiles() {
        Stream<VirtualFile> stream = Stream.concat(ChangesUtil.getFiles(this.getSelectedChanges().stream()), ChangesListView.getVirtualFiles(this.myViewer.getSelectionPaths(), null)).distinct();
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserBase", "getSelectedFiles"));
        }
        return stream;
    }

    public AnAction getDiffAction() {
        return this.myDiffAction;
    }

    public boolean isDataIsDirty() {
        return this.myDataIsDirty;
    }

    public void setDataIsDirty(boolean dataIsDirty) {
        this.myDataIsDirty = dataIsDirty;
    }

    public void setSelectionMode(@JdkConstants.TreeSelectionMode int mode) {
        this.myViewer.setSelectionMode(mode);
    }

    @Contract(pure=true)
    @NotNull
    protected static <T> List<Change> findChanges(@NotNull Collection<T> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserBase", "findChanges"));
        }
        List list2 = ContainerUtil.findAll(items, Change.class);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserBase", "findChanges"));
        }
        return list2;
    }

    static boolean isUnderUnversioned(@NotNull ChangesBrowserNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserBase", "isUnderUnversioned"));
        }
        return ChangesListView.isUnderTag(new TreePath(node.getPath()), ChangesBrowserNode.UNVERSIONED_FILES_TAG);
    }

    private class ToggleChangeAction
    extends CheckboxAction {
        public ToggleChangeAction() {
            super(ChangesBrowserBase.this.myToggleActionTitle);
        }

        public boolean isSelected(AnActionEvent e) {
            Object change = ObjectUtils.tryCast((Object)e.getData(VcsDataKeys.CURRENT_CHANGE), ChangesBrowserBase.this.myClass);
            if (change == null) {
                return false;
            }
            return ChangesBrowserBase.this.myViewer.isIncluded(change);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            Object change = ObjectUtils.tryCast((Object)e.getData(VcsDataKeys.CURRENT_CHANGE), ChangesBrowserBase.this.myClass);
            if (change == null) {
                return;
            }
            if (state) {
                ChangesBrowserBase.this.myViewer.includeChange(change);
            } else {
                ChangesBrowserBase.this.myViewer.excludeChange(change);
            }
        }
    }
}

