/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeCopyProvider;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.actions.CollapseAllAction;
import com.intellij.ui.treeStructure.actions.ExpandAllAction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangesTreeList<T>
extends Tree
implements TypeSafeDataProvider {
    @NotNull
    protected final Project myProject;
    private final boolean myShowCheckboxes;
    private final int myCheckboxWidth;
    private final boolean myHighlightProblems;
    private boolean myShowFlatten;
    private boolean myIsModelFlat;
    @NotNull
    private final Set<T> myIncludedChanges;
    @NotNull
    private Runnable myDoubleClickHandler;
    private boolean myAlwaysExpandList;
    @NotNull
    private final MyTreeCellRenderer myNodeRenderer;
    @NonNls
    private static final String ROOT = "root";
    @NonNls
    private static final String FLATTEN_OPTION_KEY = "ChangesBrowser.SHOW_FLATTEN";
    @Nullable
    private final Runnable myInclusionListener;
    @Nullable
    private ChangeNodeDecorator myChangeDecorator;
    private Runnable myGenericSelectionListener;
    @NotNull
    private final CopyProvider myTreeCopyProvider;
    private TreeState myNonFlatTreeState;

    public ChangesTreeList(@NotNull Project project2, @NotNull Collection<T> initiallyIncluded, boolean showCheckboxes, boolean highlightProblems, @Nullable Runnable inclusionListener, @Nullable ChangeNodeDecorator decorator) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/ChangesTreeList", "<init>"));
        }
        if (initiallyIncluded == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initiallyIncluded", "com/intellij/openapi/vcs/changes/ui/ChangesTreeList", "<init>"));
        }
        super((TreeNode)ChangesBrowserNode.create(project2, ROOT));
        this.myDoubleClickHandler = EmptyRunnable.getInstance();
        this.myProject = project2;
        this.myShowCheckboxes = showCheckboxes;
        this.myHighlightProblems = highlightProblems;
        this.myInclusionListener = inclusionListener;
        this.myChangeDecorator = decorator;
        this.myIncludedChanges = new HashSet<T>(initiallyIncluded);
        this.myAlwaysExpandList = true;
        ChangesBrowserNodeRenderer nodeRenderer = new ChangesBrowserNodeRenderer(this.myProject, () -> this.myShowFlatten, this.myHighlightProblems);
        this.myNodeRenderer = new MyTreeCellRenderer(nodeRenderer);
        this.myCheckboxWidth = new JCheckBox().getPreferredSize().width;
        this.setHorizontalAutoScrollingEnabled(false);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setOpaque(false);
        new TreeSpeedSearch(this, ChangesBrowserNode.TO_TEXT_CONVERTER);
        this.setCellRenderer(this.myNodeRenderer);
        new MyToggleSelectionAction().registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(32, 0)), (JComponent)((Object)this));
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangesTreeList.this.myDoubleClickHandler.run();
            }
        }, KeyStroke.getKeyStroke(10, 0), 1);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode() && e.getModifiers() == 0) {
                    if (ChangesTreeList.this.getSelectionCount() <= 1) {
                        Object lastPathComponent = ChangesTreeList.this.getLastSelectedPathComponent();
                        if (!(lastPathComponent instanceof DefaultMutableTreeNode)) {
                            return;
                        }
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)lastPathComponent;
                        if (!node.isLeaf()) {
                            return;
                        }
                    }
                    ChangesTreeList.this.myDoubleClickHandler.run();
                    e.consume();
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                TreePath clickPath;
                TreePath treePath = clickPath = ChangesTreeList.this.getUI() instanceof WideSelectionTreeUI ? ChangesTreeList.this.getClosestPathForLocation(e.getX(), e.getY()) : ChangesTreeList.this.getPathForLocation(e.getX(), e.getY());
                if (clickPath == null) {
                    return false;
                }
                int row = ChangesTreeList.this.getRowForLocation(e.getPoint().x, e.getPoint().y);
                if (row >= 0 && ChangesTreeList.this.myShowCheckboxes) {
                    Rectangle baseRect = ChangesTreeList.this.getRowBounds(row);
                    baseRect.setSize(ChangesTreeList.this.myCheckboxWidth, baseRect.height);
                    if (baseRect.contains(e.getPoint())) {
                        return false;
                    }
                }
                ChangesTreeList.this.myDoubleClickHandler.run();
                return true;
            }
        }.installOn((Component)((Object)this));
        new TreeLinkMouseListener(this.myNodeRenderer.myTextRenderer){

            @Override
            protected int getRendererRelativeX(@NotNull MouseEvent e, @NotNull JTree tree, @NotNull TreePath path) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/ui/ChangesTreeList$4", "getRendererRelativeX"));
                }
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/openapi/vcs/changes/ui/ChangesTreeList$4", "getRendererRelativeX"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/changes/ui/ChangesTreeList$4", "getRendererRelativeX"));
                }
                int x = super.getRendererRelativeX(e, tree, path);
                return !ChangesTreeList.this.myShowCheckboxes ? x : x - ChangesTreeList.this.myCheckboxWidth;
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (!ChangesTreeList.this.isEmpty()) {
                    super.mouseMoved(e);
                }
            }
        }.installOn((Component)((Object)this));
        SmartExpander.installOn((JTree)((Object)this));
        this.setShowFlatten(PropertiesComponent.getInstance((Project)this.myProject).isTrueValue(FLATTEN_OPTION_KEY));
        String emptyText = StringUtil.capitalize((String)DiffBundle.message((String)"diff.count.differences.status.text", (Object[])new Object[]{0}));
        this.setEmptyText(emptyText);
        this.myTreeCopyProvider = new ChangesBrowserNodeCopyProvider((JTree)((Object)this));
    }

    public void setEmptyText(@NotNull String emptyText) {
        if (emptyText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptyText", "com/intellij/openapi/vcs/changes/ui/ChangesTreeList", "setEmptyText"));
        }
        this.getEmptyText().setText(emptyText);
    }

    public void addSelectionListener(Runnable runnable2) {
        this.myGenericSelectionListener = runnable2;
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ChangesTreeList.this.myGenericSelectionListener.run();
            }
        });
    }

    public void setChangeDecorator(@Nullable ChangeNodeDecorator changeDecorator) {
        this.myChangeDecorator = changeDecorator;
    }

    public void setDoubleClickHandler(@NotNull Runnable doubleClickHandler) {
        if (doubleClickHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doubleClickHandler", "com/intellij/openapi/vcs/changes/ui/ChangesTreeList", "setDoubleClickHandler"));
        }
        this.myDoubleClickHandler = doubleClickHandler;
    }

    public void installPopupHandler(ActionGroup group) {
        PopupHandler.installUnknownPopupHandler((JComponent)((Object)this), (ActionGroup)group, (ActionManager)ActionManager.getInstance());
    }

    public JComponent getPreferredFocusedComponent() {
        return this;
    }

    public boolean isShowFlatten() {
        return this.myShowFlatten;
    }

    @Deprecated
    public void setScrollPaneBorder(Border border) {
    }

    public void setShowFlatten(boolean showFlatten) {
        List<T> wasSelected = this.getSelectedChanges();
        if (!this.myAlwaysExpandList && !this.myShowFlatten) {
            this.myNonFlatTreeState = TreeState.createOn((JTree)((Object)this), this.getRoot());
        }
        this.myShowFlatten = showFlatten;
        this.setChangesToDisplay(this.getChanges());
        if (!this.myAlwaysExpandList && !this.myShowFlatten && this.myNonFlatTreeState != null) {
            this.myNonFlatTreeState.applyTo((JTree)((Object)this), this.getRoot());
        }
        this.select(wasSelected);
    }

    private void setChildIndent(boolean isFlat) {
        BasicTreeUI treeUI = (BasicTreeUI)this.getUI();
        treeUI.setLeftChildIndent(!isFlat ? UIUtil.getTreeLeftChildIndent() : 0);
        treeUI.setRightChildIndent(!isFlat ? UIUtil.getTreeRightChildIndent() : 0);
    }

    protected boolean isCurrentModelFlat() {
        boolean isFlat = true;
        Enumeration<TreeNode> enumeration = this.getRoot().depthFirstEnumeration();
        while (isFlat && enumeration.hasMoreElements()) {
            isFlat = ((ChangesBrowserNode)enumeration.nextElement()).getLevel() <= 1;
        }
        return isFlat;
    }

    public void setChangesToDisplay(List<T> changes) {
        this.setChangesToDisplay(changes, null);
    }

    public void setChangesToDisplay(List<T> changes, @Nullable VirtualFile toSelect2) {
        DefaultTreeModel model = this.buildTreeModel(changes, this.myChangeDecorator);
        TreeState state = null;
        if (!this.myAlwaysExpandList) {
            state = TreeState.createOn((JTree)((Object)this), this.getRoot());
        }
        this.setModel(model);
        this.myIsModelFlat = this.isCurrentModelFlat();
        this.setChildIndent(this.myShowFlatten && this.myIsModelFlat);
        if (!this.myAlwaysExpandList) {
            state.applyTo((JTree)((Object)this), this.getRoot());
            return;
        }
        Runnable runnable2 = () -> {
            int rowInTree;
            if (this.myProject.isDisposed()) {
                return;
            }
            TreeUtil.expandAll((JTree)((Object)this));
            int selectedTreeRow = -1;
            if (this.myShowCheckboxes && this.myIncludedChanges.size() > 0) {
                CheckboxTreeBase.NodeState state1;
                ChangesBrowserNode node;
                ChangesBrowserNode root = (ChangesBrowserNode)model.getRoot();
                Enumeration<TreeNode> enumeration = root.depthFirstEnumeration();
                while (enumeration.hasMoreElements()) {
                    node = (ChangesBrowserNode)enumeration.nextElement();
                    state1 = this.getNodeStatus(node);
                    if (node == root || state1 != CheckboxTreeBase.NodeState.CLEAR) continue;
                    this.collapsePath(new TreePath(node.getPath()));
                }
                enumeration = root.depthFirstEnumeration();
                while (enumeration.hasMoreElements()) {
                    node = (ChangesBrowserNode)enumeration.nextElement();
                    state1 = this.getNodeStatus(node);
                    if (state1 != CheckboxTreeBase.NodeState.FULL || !node.isLeaf()) continue;
                    selectedTreeRow = this.getRowForPath(new TreePath(node.getPath()));
                    break;
                }
            }
            if (toSelect2 != null && (rowInTree = this.findRowContainingFile((TreeNode)model.getRoot(), toSelect2)) > -1) {
                selectedTreeRow = rowInTree;
            }
            if (selectedTreeRow >= 0) {
                this.setSelectionRow(selectedTreeRow);
            }
            TreeUtil.showRowCentered((JTree)((Object)this), (int)selectedTreeRow, (boolean)false);
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable2.run();
        } else {
            SwingUtilities.invokeLater(runnable2);
        }
    }

    private int findRowContainingFile(@NotNull TreeNode root, @NotNull VirtualFile toSelect2) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ROOT, "com/intellij/openapi/vcs/changes/ui/ChangesTreeList", "findRowContainingFile"));
        }
        if (toSelect2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toSelect", "com/intellij/openapi/vcs/changes/ui/ChangesTreeList", "findRowContainingFile"));
        }
        Ref row = Ref.create((Object)-1);
        TreeUtil.traverse((TreeNode)root, node -> {
            Object userObject;
            if (toSelect2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toSelect", "com/intellij/openapi/vcs/changes/ui/ChangesTreeList", "lambda$findRowContainingFile$2"));
            }
            if (node instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)node).getUserObject()) instanceof Change && ChangesTreeList.matches((Change)userObject, toSelect2)) {
                Object[] path = ((DefaultMutableTreeNode)node).getPath();
                row.set((Object)this.getRowForPath(new TreePath(path)));
            }
            return (Integer)row.get() == -1;
        });
        return (Integer)row.get();
    }

    private static boolean matches(@NotNull Change change, @NotNull VirtualFile file2) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ui/ChangesTreeList", "matches"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ui/ChangesTreeList", "matches"));
        }
        VirtualFile virtualFile = change.getVirtualFile();
        return virtualFile != null && virtualFile.equals(file2) || ChangesTreeList.seemsToBeMoved(change, file2);
    }

    private static boolean seemsToBeMoved(Change change, VirtualFile toSelect2) {
        ContentRevision afterRevision = change.getAfterRevision();
        if (afterRevision == null) {
            return false;
        }
        FilePath file2 = afterRevision.getFile();
        return FileUtil.pathsEqual((String)file2.getPath(), (String)toSelect2.getPath());
    }

    protected abstract DefaultTreeModel buildTreeModel(List<T> var1, ChangeNodeDecorator var2);

    private void toggleSelection() {
        this.toggleChanges(this.getSelectedChanges());
    }

    @NotNull
    public List<T> getChanges() {
        List<Change> list2 = this.getRoot().getAllChangesUnder();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesTreeList", "getChanges"));
        }
        return list2;
    }

    @NotNull
    public List<T> getSelectedChanges() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesTreeList", "getSelectedChanges"));
            }
            return list2;
        }
        LinkedHashSet changes = ContainerUtil.newLinkedHashSet();
        for (TreePath path : paths) {
            changes.addAll(this.getSelectedObjects((ChangesBrowserNode)path.getLastPathComponent()));
        }
        ArrayList arrayList = ContainerUtil.newArrayList((Iterable)changes);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesTreeList", "getSelectedChanges"));
        }
        return arrayList;
    }

    @NotNull
    private List<T> getSelectedChangesOrAllIfNone() {
        List<T> changes = this.getSelectedChanges();
        if (!changes.isEmpty()) {
            List<T> list2 = changes;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesTreeList", "getSelectedChangesOrAllIfNone"));
            }
            return list2;
        }
        List<T> list3 = this.getChanges();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesTreeList", "getSelectedChangesOrAllIfNone"));
        }
        return list3;
    }

    protected abstract List<T> getSelectedObjects(ChangesBrowserNode<T> var1);

    @Nullable
    protected abstract T getLeadSelectedObject(ChangesBrowserNode var1);

    @Nullable
    public T getHighestLeadSelection() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        return this.getLeadSelectedObject((ChangesBrowserNode)path.getLastPathComponent());
    }

    @Nullable
    public T getLeadSelection() {
        TreePath path = this.getSelectionPath();
        return (T)(path == null ? null : ContainerUtil.getFirstItem(this.getSelectedObjects((ChangesBrowserNode)path.getLastPathComponent())));
    }

    @NotNull
    ChangesBrowserNode<?> getRoot() {
        ChangesBrowserNode changesBrowserNode = (ChangesBrowserNode)this.getModel().getRoot();
        if (changesBrowserNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesTreeList", "getRoot"));
        }
        return changesBrowserNode;
    }

    private void notifyInclusionListener() {
        if (this.myInclusionListener != null) {
            this.myInclusionListener.run();
        }
    }

    public void setIncludedChanges(Collection<T> changes) {
        this.myIncludedChanges.clear();
        this.myIncludedChanges.addAll(changes);
        this.repaint();
    }

    public void includeChange(T change) {
        this.includeChanges(Collections.singleton(change));
    }

    public void includeChanges(Collection<T> changes) {
        this.myIncludedChanges.addAll(changes);
        this.notifyInclusionListener();
        this.repaint();
    }

    public void excludeChange(T change) {
        this.excludeChanges(Collections.singleton(change));
    }

    public void excludeChanges(Collection<T> changes) {
        this.myIncludedChanges.removeAll(changes);
        this.notifyInclusionListener();
        this.repaint();
    }

    protected void toggleChanges(Collection<T> changes) {
        boolean hasExcluded = false;
        for (T value2 : changes) {
            if (this.myIncludedChanges.contains(value2)) continue;
            hasExcluded = true;
            break;
        }
        if (hasExcluded) {
            this.includeChanges(changes);
        } else {
            this.excludeChanges(changes);
        }
    }

    public boolean isIncluded(T change) {
        return this.myIncludedChanges.contains(change);
    }

    @NotNull
    public Collection<T> getIncludedChanges() {
        Set<T> set2 = this.myIncludedChanges;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesTreeList", "getIncludedChanges"));
        }
        return set2;
    }

    public void expandAll() {
        TreeUtil.expandAll((JTree)((Object)this));
    }

    public AnAction[] getTreeActions() {
        ToggleShowDirectoriesAction directoriesAction = new ToggleShowDirectoriesAction();
        ExpandAllAction expandAllAction = new ExpandAllAction((JTree)((Object)this)){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabledAndVisible(!ChangesTreeList.this.myShowFlatten || !ChangesTreeList.this.myIsModelFlat);
            }
        };
        CollapseAllAction collapseAllAction = new CollapseAllAction((JTree)((Object)this)){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabledAndVisible(!ChangesTreeList.this.myShowFlatten || !ChangesTreeList.this.myIsModelFlat);
            }
        };
        AnAction[] actions = new AnAction[]{directoriesAction, expandAllAction, collapseAllAction};
        directoriesAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(80, SystemInfo.isMac ? 256 : 128)), (JComponent)((Object)this));
        expandAllAction.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"ExpandAll"), (JComponent)((Object)this));
        collapseAllAction.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"CollapseAll"), (JComponent)((Object)this));
        return actions;
    }

    public void setSelectionMode(@JdkConstants.TreeSelectionMode int mode) {
        this.getSelectionModel().setSelectionMode(mode);
    }

    private CheckboxTreeBase.NodeState getNodeStatus(ChangesBrowserNode<T> node) {
        boolean hasIncluded = false;
        boolean hasExcluded = false;
        for (T change : this.getSelectedObjects(node)) {
            if (this.myIncludedChanges.contains(change)) {
                hasIncluded = true;
                continue;
            }
            hasExcluded = true;
        }
        if (hasIncluded && hasExcluded) {
            return CheckboxTreeBase.NodeState.PARTIAL;
        }
        if (hasIncluded) {
            return CheckboxTreeBase.NodeState.FULL;
        }
        return CheckboxTreeBase.NodeState.CLEAR;
    }

    protected boolean isNodeEnabled(ChangesBrowserNode<T> node) {
        return this.getNodeStatus(node) != CheckboxTreeBase.NodeState.PARTIAL;
    }

    public void select(@NotNull Collection<T> changes) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ui/ChangesTreeList", "select"));
        }
        HashSet changesSet = new HashSet(changes);
        ArrayList treeSelection = new ArrayList(changes.size());
        TreeUtil.traverse(this.getRoot(), node -> {
            Object change = ((DefaultMutableTreeNode)node).getUserObject();
            if (changesSet.contains(change)) {
                treeSelection.add(new TreePath(((DefaultMutableTreeNode)node).getPath()));
            }
            return true;
        });
        this.setSelectionPaths(treeSelection.toArray(new TreePath[treeSelection.size()]));
        if (treeSelection.size() == 1) {
            this.scrollPathToVisible((TreePath)treeSelection.get(0));
        }
    }

    public void setAlwaysExpandList(boolean alwaysExpandList) {
        this.myAlwaysExpandList = alwaysExpandList;
    }

    public void calcData(DataKey key2, DataSink sink) {
        if (PlatformDataKeys.COPY_PROVIDER == key2) {
            sink.put(PlatformDataKeys.COPY_PROVIDER, (Object)this.myTreeCopyProvider);
        }
    }

    public boolean isFileColorsEnabled() {
        return ProjectViewTree.isFileColorsEnabledFor((JTree)((Object)this));
    }

    public Color getFileColorFor(Object object) {
        VirtualFile file2 = object instanceof FilePath ? ((FilePath)object).getVirtualFile() : (object instanceof Change ? ((Change)object).getVirtualFile() : (VirtualFile)ObjectUtils.tryCast((Object)object, VirtualFile.class));
        if (file2 != null) {
            return FileColorManager.getInstance((Project)this.myProject).getFileColor(file2);
        }
        return super.getFileColorFor(object);
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension size = super.getPreferredScrollableViewportSize();
        size = new Dimension(size.width + 10, size.height);
        return size;
    }

    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501) {
            if (!this.isEnabled()) {
                return;
            }
            int row = this.getRowForLocation(e.getX(), e.getY());
            if (row >= 0) {
                Rectangle baseRect = this.getRowBounds(row);
                baseRect.setSize(this.myCheckboxWidth, baseRect.height);
                if (baseRect.contains(e.getPoint())) {
                    this.setSelectionRow(row);
                    this.toggleSelection();
                }
            }
        }
        super.processMouseEvent(e);
    }

    public int getToggleClickCount() {
        return -1;
    }

    public class ToggleShowDirectoriesAction
    extends ToggleAction
    implements DumbAware {
        public ToggleShowDirectoriesAction() {
            super(VcsBundle.message((String)"changes.action.show.directories.text", (Object[])new Object[0]), VcsBundle.message((String)"changes.action.show.directories.description", (Object[])new Object[0]), AllIcons.Actions.GroupByPackage);
        }

        public boolean isSelected(AnActionEvent e) {
            return !ChangesTreeList.this.myProject.isDisposed() && !PropertiesComponent.getInstance((Project)ChangesTreeList.this.myProject).isTrueValue(ChangesTreeList.FLATTEN_OPTION_KEY);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            PropertiesComponent.getInstance((Project)ChangesTreeList.this.myProject).setValue(ChangesTreeList.FLATTEN_OPTION_KEY, String.valueOf(!state));
            ChangesTreeList.this.setShowFlatten(!state);
        }
    }

    private class MyToggleSelectionAction
    extends AnAction
    implements DumbAware {
        private MyToggleSelectionAction() {
        }

        public void actionPerformed(AnActionEvent e) {
            ChangesTreeList.this.toggleChanges(ChangesTreeList.this.getSelectedChangesOrAllIfNone());
        }
    }

    private class MyTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        private final ChangesBrowserNodeRenderer myTextRenderer;
        private final JCheckBox myCheckBox;

        public MyTreeCellRenderer(ChangesBrowserNodeRenderer textRenderer) {
            if (textRenderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRenderer", "com/intellij/openapi/vcs/changes/ui/ChangesTreeList$MyTreeCellRenderer", "<init>"));
            }
            super(new BorderLayout());
            this.myCheckBox = new JCheckBox();
            this.myTextRenderer = textRenderer;
            if (ChangesTreeList.this.myShowCheckboxes) {
                this.add((Component)this.myCheckBox, "West");
            }
            this.add((Component)((Object)this.myTextRenderer), "Center");
            this.setOpaque(false);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (UIUtil.isUnderGTKLookAndFeel() || UIUtil.isUnderNimbusLookAndFeel()) {
                NonOpaquePanel.setTransparent((JComponent)this);
                NonOpaquePanel.setTransparent((JComponent)this.myCheckBox);
            } else {
                this.setBackground(null);
                this.myCheckBox.setBackground(null);
                this.myCheckBox.setOpaque(false);
            }
            this.myTextRenderer.setOpaque(false);
            this.myTextRenderer.setTransparentIconBackground(true);
            this.myTextRenderer.setToolTipText(null);
            this.myTextRenderer.getTreeCellRendererComponent(tree, value2, selected, expanded, leaf, row, hasFocus);
            if (ChangesTreeList.this.myShowCheckboxes) {
                CheckboxTreeBase.NodeState state = ChangesTreeList.this.getNodeStatus((ChangesBrowserNode)value2);
                this.myCheckBox.setSelected(state != CheckboxTreeBase.NodeState.CLEAR);
                this.myCheckBox.setEnabled(tree.isEnabled() && ChangesTreeList.this.isNodeEnabled((ChangesBrowserNode)value2));
                this.revalidate();
                return this;
            }
            return this.myTextRenderer;
        }

        @Override
        public String getToolTipText() {
            return this.myTextRenderer.getToolTipText();
        }
    }
}

