/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.actions.MoveChangesToAnotherListAction;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.ui.ChangelistMoveOfferDialog;
import com.intellij.openapi.vcs.changes.ui.DefaultCommitResultHandler;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ConfirmationDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitHelper {
    public static final Key<Object> DOCUMENT_BEING_COMMITTED_KEY = new Key("DOCUMENT_BEING_COMMITTED");
    private static final Logger LOG = Logger.getInstance(CommitHelper.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ChangeList myChangeList;
    @NotNull
    private final List<Change> myIncludedChanges;
    @NotNull
    private final String myActionName;
    @NotNull
    private final String myCommitMessage;
    @NotNull
    private final List<CheckinHandler> myHandlers;
    private final boolean myAllOfDefaultChangeListChangesIncluded;
    private final boolean myForceSyncCommit;
    @NotNull
    private final NullableFunction<Object, Object> myAdditionalData;
    @NotNull
    private final CommitResultHandler myResultHandler;
    @NotNull
    private final List<Document> myCommittingDocuments;
    @NotNull
    private final VcsConfiguration myConfiguration;
    @NotNull
    private final HashSet<String> myFeedback;
    @NotNull
    private final GeneralCommitProcessor myCommitProcessor;

    public CommitHelper(@NotNull Project project2, @NotNull ChangeList changeList, @NotNull List<Change> includedChanges, @NotNull String actionName, @NotNull String commitMessage, @NotNull List<CheckinHandler> handlers, boolean allOfDefaultChangeListChangesIncluded, boolean synchronously, @NotNull NullableFunction<Object, Object> additionalDataHolder, @Nullable CommitResultHandler customResultHandler) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "<init>"));
        }
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "<init>"));
        }
        if (includedChanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "includedChanges", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "<init>"));
        }
        if (actionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionName", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "<init>"));
        }
        if (commitMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitMessage", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "<init>"));
        }
        if (handlers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handlers", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "<init>"));
        }
        if (additionalDataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalDataHolder", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "<init>"));
        }
        this(project2, changeList, includedChanges, actionName, commitMessage, handlers, allOfDefaultChangeListChangesIncluded, synchronously, additionalDataHolder, customResultHandler, false, null);
    }

    public CommitHelper(@NotNull Project project2, @NotNull ChangeList changeList, @NotNull List<Change> includedChanges, @NotNull String actionName, @NotNull String commitMessage, @NotNull List<CheckinHandler> handlers, boolean allOfDefaultChangeListChangesIncluded, boolean synchronously, @NotNull NullableFunction<Object, Object> additionalDataHolder, @Nullable CommitResultHandler resultHandler, boolean isAlien, @Nullable AbstractVcs vcs) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "<init>"));
        }
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "<init>"));
        }
        if (includedChanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "includedChanges", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "<init>"));
        }
        if (actionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionName", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "<init>"));
        }
        if (commitMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitMessage", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "<init>"));
        }
        if (handlers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handlers", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "<init>"));
        }
        if (additionalDataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalDataHolder", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "<init>"));
        }
        this.myCommittingDocuments = ContainerUtil.newArrayList();
        this.myFeedback = ContainerUtil.newHashSet();
        this.myProject = project2;
        this.myChangeList = changeList;
        this.myIncludedChanges = includedChanges;
        this.myActionName = actionName;
        this.myCommitMessage = commitMessage;
        this.myHandlers = handlers;
        this.myAllOfDefaultChangeListChangesIncluded = allOfDefaultChangeListChangesIncluded;
        this.myForceSyncCommit = synchronously;
        this.myAdditionalData = additionalDataHolder;
        this.myConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        this.myCommitProcessor = isAlien ? new AlienCommitProcessor((AbstractVcs)ObjectUtils.notNull((Object)vcs)) : new CommitProcessor(vcs);
        this.myResultHandler = (CommitResultHandler)ObjectUtils.notNull((Object)resultHandler, (Object)new DefaultCommitResultHandler(this.myProject, this.myIncludedChanges, this.myCommitMessage, this.myCommitProcessor, this.myFeedback));
    }

    public boolean doCommit() {
        Task.Backgroundable task = new Task.Backgroundable(this.myProject, this.myActionName, true, this.myConfiguration.getCommitOption()){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/ui/CommitHelper$1", "run"));
                }
                ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
                vcsManager.startBackgroundVcsOperation();
                try {
                    CommitHelper.this.delegateCommitToVcsThread();
                }
                finally {
                    vcsManager.stopBackgroundVcsOperation();
                }
            }

            public boolean shouldStartInBackground() {
                return !CommitHelper.this.myForceSyncCommit && super.shouldStartInBackground();
            }

            public boolean isConditionalModal() {
                return CommitHelper.this.myForceSyncCommit;
            }
        };
        ProgressManager.getInstance().run((Task)task);
        return CommitHelper.hasOnlyWarnings(this.myCommitProcessor.getVcsExceptions());
    }

    private void delegateCommitToVcsThread() {
        DelegatingProgressIndicator indicator = new DelegatingProgressIndicator();
        Semaphore endSemaphore = new Semaphore();
        endSemaphore.down();
        ChangeListManagerImpl.getInstanceImpl(this.myProject).executeOnUpdaterThread(() -> this.lambda$delegateCommitToVcsThread$1((ProgressIndicator)indicator, endSemaphore));
        indicator.setText("Waiting for VCS background tasks to finish...");
        while (!endSemaphore.waitFor(20L)) {
            indicator.checkCanceled();
        }
    }

    static boolean hasOnlyWarnings(@NotNull List<VcsException> exceptions) {
        if (exceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptions", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "hasOnlyWarnings"));
        }
        return exceptions.stream().allMatch(VcsException::isWarning);
    }

    private void generalCommit() throws RuntimeException {
        try {
            ReadAction.run(() -> this.markCommittingDocuments());
            try {
                this.myCommitProcessor.callSelf();
            }
            finally {
                ReadAction.run(() -> this.unmarkCommittingDocuments());
            }
            this.myCommitProcessor.doBeforeRefresh();
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable e) {
            LOG.error(e);
            this.myCommitProcessor.myVcsExceptions.add(new VcsException(e));
            ExceptionUtil.rethrow((Throwable)e);
        }
        finally {
            this.commitCompleted(this.myCommitProcessor.getVcsExceptions());
            this.myCommitProcessor.customRefresh();
            WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> this.myCommitProcessor.doPostRefresh(), null, (Project)this.myProject);
        }
    }

    public static ChangeListsModificationAfterCommit getRemoveStrategy(VcsShowConfirmationOption.Value removeEmptyInactive) {
        if (removeEmptyInactive == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
            return ChangeListsModificationAfterCommit.DELETE_LIST;
        }
        if (removeEmptyInactive == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION) {
            return ChangeListsModificationAfterCommit.ASK_BEFORE_DELETE;
        }
        return ChangeListsModificationAfterCommit.NOTHING;
    }

    private void markCommittingDocuments() {
        this.myCommittingDocuments.addAll(CommitHelper.markCommittingDocuments(this.myProject, this.myIncludedChanges));
    }

    private void unmarkCommittingDocuments() {
        CommitHelper.unmarkCommittingDocuments(this.myCommittingDocuments);
        this.myCommittingDocuments.clear();
    }

    @NotNull
    private static Collection<Document> markCommittingDocuments(@NotNull Project project2, @NotNull List<Change> changes) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "markCommittingDocuments"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "markCommittingDocuments"));
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (Change change : changes) {
            Document doc;
            VirtualFile virtualFile = ChangesUtil.getFilePath((Change)change).getVirtualFile();
            if (virtualFile == null || virtualFile.getFileType().isBinary() || (doc = FileDocumentManager.getInstance().getDocument(virtualFile)) == null) continue;
            doc.putUserData(DOCUMENT_BEING_COMMITTED_KEY, (Object)project2);
            result2.add(doc);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "markCommittingDocuments"));
        }
        return arrayList;
    }

    private static void unmarkCommittingDocuments(@NotNull Collection<Document> committingDocs) {
        if (committingDocs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "committingDocs", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "unmarkCommittingDocuments"));
        }
        committingDocs.forEach(document -> document.putUserData(DOCUMENT_BEING_COMMITTED_KEY, null));
    }

    private void commitCompleted(@NotNull List<VcsException> allExceptions) {
        if (allExceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allExceptions", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "commitCompleted"));
        }
        List<VcsException> errors = CommitHelper.collectErrors(allExceptions);
        boolean noErrors = errors.isEmpty();
        boolean noWarnings = allExceptions.isEmpty();
        if (noErrors) {
            this.myHandlers.forEach(CheckinHandler::checkinSuccessful);
            this.myCommitProcessor.afterSuccessfulCheckIn();
            this.myResultHandler.onSuccess(this.myCommitMessage);
            if (noWarnings) {
                ProgressManager.progress((String)VcsBundle.message((String)"commit.dialog.completed.successfully", (Object[])new Object[0]));
            }
        } else {
            this.myHandlers.forEach(handler2 -> handler2.checkinFailed(errors));
            this.myCommitProcessor.afterFailedCheckIn();
            this.myResultHandler.onFailure();
        }
    }

    public static void moveToFailedList(@NotNull ChangeList changeList, @NotNull String commitMessage, @NotNull List<Change> failedChanges, @NotNull String newChangelistName, @NotNull Project project2) {
        VcsShowConfirmationOption option;
        boolean result2;
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "moveToFailedList"));
        }
        if (commitMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitMessage", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "moveToFailedList"));
        }
        if (failedChanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "failedChanges", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "moveToFailedList"));
        }
        if (newChangelistName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newChangelistName", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "moveToFailedList"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "moveToFailedList"));
        }
        if (failedChanges.containsAll(changeList.getChanges())) {
            return;
        }
        final VcsConfiguration configuration = VcsConfiguration.getInstance((Project)project2);
        if (configuration.MOVE_TO_FAILED_COMMIT_CHANGELIST != VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY && !(result2 = ConfirmationDialog.requestForConfirmation((VcsShowConfirmationOption)(option = new VcsShowConfirmationOption(){

            public VcsShowConfirmationOption.Value getValue() {
                return configuration.MOVE_TO_FAILED_COMMIT_CHANGELIST;
            }

            public void setValue(VcsShowConfirmationOption.Value value2) {
                configuration.MOVE_TO_FAILED_COMMIT_CHANGELIST = value2;
            }

            public boolean isPersistent() {
                return true;
            }
        }), (Project)project2, (String)VcsBundle.message((String)"commit.failed.confirm.prompt", (Object[])new Object[0]), (String)VcsBundle.message((String)"commit.failed.confirm.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()))) {
            return;
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project2);
        int index = 1;
        String failedListName = newChangelistName;
        while (changeListManager.findChangeList(failedListName) != null) {
            failedListName = newChangelistName + " (" + ++index + ")";
        }
        LocalChangeList failedList = changeListManager.addChangeList(failedListName, commitMessage);
        changeListManager.moveChangesTo(failedList, (Change[])ArrayUtil.toObjectArray(failedChanges, Change.class));
    }

    @NotNull
    static List<VcsException> collectErrors(@NotNull List<VcsException> exceptions) {
        if (exceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptions", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "collectErrors"));
        }
        List<VcsException> list2 = exceptions.stream().filter(e -> !e.isWarning()).collect(Collectors.toList());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "collectErrors"));
        }
        return list2;
    }

    private /* synthetic */ void lambda$delegateCommitToVcsThread$1(ProgressIndicator indicator, Semaphore endSemaphore) {
        indicator.setText("Performing VCS commit...");
        try {
            ProgressManager.getInstance().runProcess(() -> {
                indicator.checkCanceled();
                this.generalCommit();
            }, indicator);
        }
        finally {
            endSemaphore.up();
        }
    }

    private class CommitProcessor
    extends GeneralCommitProcessor {
        @NotNull
        private LocalHistoryAction myAction;
        private ChangeListsModificationAfterCommit myPostRefreshModification;
        private boolean myCommitSuccess;
        @Nullable
        private final AbstractVcs myVcs;

        private CommitProcessor(AbstractVcs vcs) {
            this.myAction = LocalHistoryAction.NULL;
            this.myVcs = vcs;
            this.myPostRefreshModification = ChangeListsModificationAfterCommit.NOTHING;
            if (CommitHelper.this.myChangeList instanceof LocalChangeList) {
                LocalChangeList localList = (LocalChangeList)CommitHelper.this.myChangeList;
                boolean containsAll = ContainerUtil.newHashSet((Iterable)CommitHelper.this.myIncludedChanges).containsAll(CommitHelper.this.myChangeList.getChanges());
                if (containsAll && !localList.isDefault() && !localList.isReadOnly()) {
                    this.myPostRefreshModification = CommitHelper.getRemoveStrategy(((CommitHelper)CommitHelper.this).myConfiguration.REMOVE_EMPTY_INACTIVE_CHANGELISTS);
                } else if (((CommitHelper)CommitHelper.this).myConfiguration.OFFER_MOVE_TO_ANOTHER_CHANGELIST_ON_PARTIAL_COMMIT && !containsAll && localList.isDefault() && CommitHelper.this.myAllOfDefaultChangeListChangesIncluded) {
                    this.myPostRefreshModification = ChangeListsModificationAfterCommit.MOVE_OTHERS;
                }
            }
        }

        @Override
        public void callSelf() {
            if (this.myVcs != null && CommitHelper.this.myIncludedChanges.isEmpty()) {
                this.process(this.myVcs, CommitHelper.this.myIncludedChanges);
            }
            ChangesUtil.processChangesByVcs((Project)CommitHelper.this.myProject, (Collection)CommitHelper.this.myIncludedChanges, this::process);
        }

        @Override
        public void afterSuccessfulCheckIn() {
            this.myCommitSuccess = true;
        }

        @Override
        public void afterFailedCheckIn() {
            ApplicationManager.getApplication().invokeLater(() -> CommitHelper.moveToFailedList(CommitHelper.this.myChangeList, CommitHelper.this.myCommitMessage, this.getChangesFailedToCommit(), VcsBundle.message((String)"commit.dialog.failed.commit.template", (Object[])new Object[]{CommitHelper.this.myChangeList.getName()}), CommitHelper.this.myProject), ModalityState.defaultModalityState(), CommitHelper.this.myProject.getDisposed());
        }

        @Override
        public void doBeforeRefresh() {
            ChangeListManagerImpl.getInstanceImpl(CommitHelper.this.myProject).showLocalChangesInvalidated();
            this.myAction = (LocalHistoryAction)ReadAction.compute(() -> LocalHistory.getInstance().startAction(CommitHelper.this.myActionName));
        }

        @Override
        public void customRefresh() {
            ArrayList toRefresh = ContainerUtil.newArrayList();
            ChangesUtil.processChangesByVcs((Project)CommitHelper.this.myProject, (Collection)CommitHelper.this.myIncludedChanges, (vcs, changes) -> {
                CheckinEnvironment environment = vcs.getCheckinEnvironment();
                if (environment != null && environment.isRefreshAfterCommitNeeded()) {
                    toRefresh.addAll(changes);
                }
            });
            if (!toRefresh.isEmpty()) {
                ProgressManager.progress((String)VcsBundle.message((String)"commit.dialog.refresh.files", (Object[])new Object[0]));
                RefreshVFsSynchronously.updateChanges(toRefresh);
            }
        }

        @Override
        public void doPostRefresh() {
            this.myAction.finish();
            if (!CommitHelper.this.myProject.isDisposed()) {
                ChangeListManager clManager = ChangeListManager.getInstance((Project)CommitHelper.this.myProject);
                clManager.invokeAfterUpdate(() -> {
                    if (this.myCommitSuccess) {
                        ChangelistMoveOfferDialog dialog2;
                        if (this.myPostRefreshModification == ChangeListsModificationAfterCommit.DELETE_LIST || this.shouldDeleteWithConfirmation()) {
                            clManager.removeChangeList(CommitHelper.this.myChangeList.getName());
                        } else if (this.myPostRefreshModification == ChangeListsModificationAfterCommit.MOVE_OTHERS && (dialog2 = new ChangelistMoveOfferDialog(CommitHelper.this.myConfiguration)).showAndGet()) {
                            Collection changes = clManager.getDefaultChangeList().getChanges();
                            MoveChangesToAnotherListAction.askAndMove(CommitHelper.this.myProject, changes, Collections.emptyList());
                        }
                    }
                    CommittedChangesCache cache = CommittedChangesCache.getInstance(CommitHelper.this.myProject);
                    cache.refreshAllCachesAsync(false, true);
                    cache.refreshIncomingChangesAsync();
                }, InvokeAfterUpdateMode.SILENT, null, vcsDirtyScopeManager -> vcsDirtyScopeManager.filePathsDirty(this.getPathsToRefresh(), null), null);
                LocalHistory.getInstance().putSystemLabel(CommitHelper.this.myProject, CommitHelper.this.myActionName + ": " + CommitHelper.this.myCommitMessage);
            }
        }

        boolean shouldDeleteWithConfirmation() {
            return this.myPostRefreshModification == ChangeListsModificationAfterCommit.ASK_BEFORE_DELETE && ChangeListManager.getInstance((Project)CommitHelper.this.myProject).findChangeList(CommitHelper.this.myChangeList.getName()) != null && ChangeListManagerImpl.showRemoveEmptyChangeListsProposal(CommitHelper.this.myProject, CommitHelper.this.myConfiguration, Collections.singleton(CommitHelper.this.myChangeList));
        }
    }

    static enum ChangeListsModificationAfterCommit {
        DELETE_LIST,
        MOVE_OTHERS,
        NOTHING,
        ASK_BEFORE_DELETE;

    }

    abstract class GeneralCommitProcessor {
        @NotNull
        protected final List<FilePath> myPathsToRefresh = ContainerUtil.newArrayList();
        @NotNull
        protected final List<VcsException> myVcsExceptions = ContainerUtil.newArrayList();
        @NotNull
        protected final List<Change> myChangesFailedToCommit = ContainerUtil.newArrayList();

        GeneralCommitProcessor() {
        }

        public abstract void callSelf();

        public abstract void afterSuccessfulCheckIn();

        public abstract void afterFailedCheckIn();

        public abstract void doBeforeRefresh();

        public abstract void customRefresh();

        public abstract void doPostRefresh();

        protected void process(@NotNull AbstractVcs vcs, @NotNull List<Change> changes) {
            if (vcs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/changes/ui/CommitHelper$GeneralCommitProcessor", "process"));
            }
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ui/CommitHelper$GeneralCommitProcessor", "process"));
            }
            CheckinEnvironment environment = vcs.getCheckinEnvironment();
            if (environment != null) {
                this.myPathsToRefresh.addAll(ChangesUtil.getPaths(changes));
                List exceptions = environment.commit(changes, CommitHelper.this.myCommitMessage, CommitHelper.this.myAdditionalData, (Set)CommitHelper.this.myFeedback);
                if (!ContainerUtil.isEmpty((Collection)exceptions)) {
                    this.myVcsExceptions.addAll(exceptions);
                    this.myChangesFailedToCommit.addAll(changes);
                }
            }
        }

        @NotNull
        public List<FilePath> getPathsToRefresh() {
            List<FilePath> list2 = this.myPathsToRefresh;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitHelper$GeneralCommitProcessor", "getPathsToRefresh"));
            }
            return list2;
        }

        @NotNull
        public List<VcsException> getVcsExceptions() {
            List<VcsException> list2 = this.myVcsExceptions;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitHelper$GeneralCommitProcessor", "getVcsExceptions"));
            }
            return list2;
        }

        @NotNull
        public List<Change> getChangesFailedToCommit() {
            List<Change> list2 = this.myChangesFailedToCommit;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitHelper$GeneralCommitProcessor", "getChangesFailedToCommit"));
            }
            return list2;
        }
    }

    private class AlienCommitProcessor
    extends GeneralCommitProcessor {
        @NotNull
        private final AbstractVcs myVcs;

        private AlienCommitProcessor(AbstractVcs vcs) {
            if (vcs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/changes/ui/CommitHelper$AlienCommitProcessor", "<init>"));
            }
            this.myVcs = vcs;
        }

        @Override
        public void callSelf() {
            ChangesUtil.processItemsByVcs((Collection)CommitHelper.this.myIncludedChanges, change -> this.myVcs, this::process);
        }

        @Override
        protected void process(@NotNull AbstractVcs vcs, @NotNull List<Change> items) {
            if (vcs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/changes/ui/CommitHelper$AlienCommitProcessor", "process"));
            }
            if (items == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/openapi/vcs/changes/ui/CommitHelper$AlienCommitProcessor", "process"));
            }
            if (!this.myVcs.getName().equals(vcs.getName())) {
                return;
            }
            super.process(vcs, items);
        }

        @Override
        public void afterSuccessfulCheckIn() {
        }

        @Override
        public void afterFailedCheckIn() {
        }

        @Override
        public void doBeforeRefresh() {
        }

        @Override
        public void customRefresh() {
        }

        @Override
        public void doPostRefresh() {
        }
    }
}

