/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.PseudoMap;
import com.intellij.openapi.vcs.checkin.CheckinChangeListSpecificComponent;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.ui.Refreshable;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class CommitOptionsPanel
extends BorderLayoutPanel
implements Refreshable,
Disposable {
    private static final Comparator<AbstractVcs> VCS_COMPARATOR = Comparator.comparing(it -> it.getKeyInstanceMethod().getName(), String::compareToIgnoreCase);
    @NotNull
    private final CheckinProjectPanel myCommitPanel;
    @NotNull
    private final Collection<CheckinHandler> myHandlers;
    @NotNull
    private final Map<AbstractVcs, JPanel> myPerVcsOptionsPanels;
    @NotNull
    private final List<RefreshableOnComponent> myAdditionalComponents;
    @NotNull
    private final Set<CheckinChangeListSpecificComponent> myCheckinChangeListSpecificComponents;
    @NotNull
    private final PseudoMap<Object, Object> myAdditionalData;
    private final boolean myEmpty;

    public CommitOptionsPanel(@NotNull CheckinProjectPanel panel2, @NotNull Collection<CheckinHandler> handlers, @NotNull Collection<AbstractVcs> vcses) {
        if (panel2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/openapi/vcs/changes/ui/CommitOptionsPanel", "<init>"));
        }
        if (handlers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handlers", "com/intellij/openapi/vcs/changes/ui/CommitOptionsPanel", "<init>"));
        }
        if (vcses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcses", "com/intellij/openapi/vcs/changes/ui/CommitOptionsPanel", "<init>"));
        }
        this.myPerVcsOptionsPanels = ContainerUtil.newHashMap();
        this.myAdditionalComponents = ContainerUtil.newArrayList();
        this.myCheckinChangeListSpecificComponents = ContainerUtil.newHashSet();
        this.myAdditionalData = new PseudoMap();
        this.myCommitPanel = panel2;
        this.myHandlers = handlers;
        this.myEmpty = this.init(vcses);
    }

    public boolean isEmpty() {
        return this.myEmpty;
    }

    @NotNull
    public List<RefreshableOnComponent> getAdditionalComponents() {
        List<RefreshableOnComponent> list2 = Collections.unmodifiableList(this.myAdditionalComponents);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitOptionsPanel", "getAdditionalComponents"));
        }
        return list2;
    }

    @NotNull
    public PseudoMap<Object, Object> getAdditionalData() {
        PseudoMap<Object, Object> pseudoMap = this.myAdditionalData;
        if (pseudoMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitOptionsPanel", "getAdditionalData"));
        }
        return pseudoMap;
    }

    public void saveState() {
        this.myAdditionalComponents.forEach(Refreshable::saveState);
    }

    public void restoreState() {
        this.myAdditionalComponents.forEach(Refreshable::restoreState);
    }

    public void refresh() {
        this.myAdditionalComponents.forEach(Refreshable::refresh);
    }

    public void onChangeListSelected(@NotNull LocalChangeList changeList) {
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "com/intellij/openapi/vcs/changes/ui/CommitOptionsPanel", "onChangeListSelected"));
        }
        Set affectedVcses = ChangesUtil.getAffectedVcses((Collection)changeList.getChanges(), (Project)this.myCommitPanel.getProject());
        for (Map.Entry<AbstractVcs, JPanel> entry : this.myPerVcsOptionsPanels.entrySet()) {
            entry.getValue().setVisible(affectedVcses.contains(entry.getKey()));
        }
        this.myCheckinChangeListSpecificComponents.forEach(component -> {
            if (changeList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "com/intellij/openapi/vcs/changes/ui/CommitOptionsPanel", "lambda$onChangeListSelected$1"));
            }
            component.onChangeListSelected(changeList);
        });
    }

    public void saveChangeListComponentsState() {
        this.myCheckinChangeListSpecificComponents.forEach(Refreshable::saveState);
    }

    public void dispose() {
    }

    private boolean init(@NotNull Collection<AbstractVcs> vcses) {
        if (vcses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcses", "com/intellij/openapi/vcs/changes/ui/CommitOptionsPanel", "init"));
        }
        String borderTitleName = this.myCommitPanel.getCommitActionName().replace("_", "").replace("&", "");
        boolean hasVcsOptions = false;
        Box vcsCommitOptions = Box.createVerticalBox();
        for (AbstractVcs vcs : ContainerUtil.sorted(vcses, VCS_COMPARATOR)) {
            RefreshableOnComponent options;
            CheckinEnvironment checkinEnvironment = vcs.getCheckinEnvironment();
            if (checkinEnvironment == null || (options = checkinEnvironment.createAdditionalOptionsPanel(this.myCommitPanel, this.myAdditionalData)) == null) continue;
            JPanel vcsOptions = new JPanel(new BorderLayout());
            vcsOptions.add((Component)options.getComponent(), "Center");
            vcsOptions.setBorder((Border)IdeBorderFactory.createTitledBorder((String)vcs.getDisplayName(), (boolean)true));
            vcsCommitOptions.add(vcsOptions);
            this.myPerVcsOptionsPanels.put(vcs, vcsOptions);
            this.myAdditionalComponents.add(options);
            if (options instanceof CheckinChangeListSpecificComponent) {
                this.myCheckinChangeListSpecificComponents.add((CheckinChangeListSpecificComponent)options);
            }
            hasVcsOptions = true;
        }
        boolean beforeVisible = false;
        boolean afterVisible = false;
        Box beforeBox = Box.createVerticalBox();
        Box afterBox = Box.createVerticalBox();
        for (CheckinHandler handler2 : this.myHandlers) {
            RefreshableOnComponent afterPanel;
            RefreshableOnComponent beforePanel = handler2.getBeforeCheckinConfigurationPanel();
            if (beforePanel != null) {
                beforeVisible = true;
                this.addCheckinHandlerComponent(beforePanel, beforeBox);
            }
            if ((afterPanel = handler2.getAfterCheckinConfigurationPanel((Disposable)this)) == null) continue;
            afterVisible = true;
            this.addCheckinHandlerComponent(afterPanel, afterBox);
        }
        if (!(hasVcsOptions || beforeVisible || afterVisible)) {
            return true;
        }
        Box optionsBox = Box.createVerticalBox();
        if (hasVcsOptions) {
            vcsCommitOptions.add(Box.createVerticalGlue());
            optionsBox.add(vcsCommitOptions);
        }
        if (beforeVisible) {
            beforeBox.add(Box.createVerticalGlue());
            JPanel beforePanel = new JPanel(new BorderLayout());
            beforePanel.add(beforeBox);
            beforePanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)VcsBundle.message((String)"border.standard.checkin.options.group", (Object[])new Object[]{borderTitleName}), (boolean)true));
            optionsBox.add(beforePanel);
        }
        if (afterVisible) {
            afterBox.add(Box.createVerticalGlue());
            JPanel afterPanel = new JPanel(new BorderLayout());
            afterPanel.add(afterBox);
            afterPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)VcsBundle.message((String)"border.standard.after.checkin.options.group", (Object[])new Object[]{borderTitleName}), (boolean)true));
            optionsBox.add(afterPanel);
        }
        optionsBox.add(Box.createVerticalGlue());
        JPanel additionalOptionsPanel = new JPanel(new BorderLayout());
        additionalOptionsPanel.add((Component)optionsBox, "North");
        JScrollPane optionsPane = ScrollPaneFactory.createScrollPane((Component)additionalOptionsPanel, (boolean)true);
        this.addToCenter(optionsPane).withBorder((Border)JBUI.Borders.emptyLeft((int)10));
        return false;
    }

    private void addCheckinHandlerComponent(@NotNull RefreshableOnComponent component, @NotNull Box container) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/vcs/changes/ui/CommitOptionsPanel", "addCheckinHandlerComponent"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/openapi/vcs/changes/ui/CommitOptionsPanel", "addCheckinHandlerComponent"));
        }
        container.add(component.getComponent());
        this.myAdditionalComponents.add(component);
        if (component instanceof CheckinChangeListSpecificComponent) {
            this.myCheckinChangeListSpecificComponents.add((CheckinChangeListSpecificComponent)component);
        }
    }
}

