/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.ui.ChangeListRemoteState;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserIgnoredFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLogicallyLockedFile;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserSpecificFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserUnversionedFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.RemoteStatusChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.StaticFilePath;
import com.intellij.openapi.vcs.changes.ui.VirtualFileHierarchicalComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeModelBuilder {
    @NonNls
    private static final String ROOT_NODE_VALUE = "root";
    private static final int UNVERSIONED_MAX_SIZE = 50;
    @NotNull
    protected final Project myProject;
    protected final boolean myShowFlatten;
    @NotNull
    protected final DefaultTreeModel myModel;
    @NotNull
    protected final ChangesBrowserNode myRoot;
    @NotNull
    private final Map<ChangesBrowserNode, ChangesGroupingPolicy> myGroupingPoliciesCache;
    @NotNull
    private final Map<ChangesBrowserNode, Map<String, ChangesBrowserNode>> myFoldersCache;
    private static final Comparator<ChangesBrowserNode> BROWSER_NODE_COMPARATOR = (node1, node2) -> {
        int sortWeightDiff = Comparing.compare((int)node1.getSortWeight(), (int)node2.getSortWeight());
        if (sortWeightDiff != 0) {
            return sortWeightDiff;
        }
        if (node1 instanceof Comparable && node1.getClass().equals(node2.getClass())) {
            return ((Comparable)((Object)node1)).compareTo(node2);
        }
        return node1.compareUserObjects(node2.getUserObject());
    };
    protected static final Comparator<Change> PATH_LENGTH_COMPARATOR = (o1, o2) -> {
        FilePath fp1 = ChangesUtil.getFilePath((Change)o1);
        FilePath fp2 = ChangesUtil.getFilePath((Change)o2);
        return Comparing.compare((int)fp1.getPath().length(), (int)fp2.getPath().length());
    };

    public TreeModelBuilder(@NotNull Project project2, boolean showFlatten) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "<init>"));
        }
        this.myProject = project2;
        this.myShowFlatten = showFlatten;
        this.myRoot = ChangesBrowserNode.create(this.myProject, ROOT_NODE_VALUE);
        this.myModel = new DefaultTreeModel(this.myRoot);
        this.myGroupingPoliciesCache = new MyGroupingPolicyFactoryMap(this.myProject, this.myModel);
        this.myFoldersCache = new HashMap<ChangesBrowserNode, Map<String, ChangesBrowserNode>>();
    }

    @NotNull
    public static DefaultTreeModel buildEmpty(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildEmpty"));
        }
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(ChangesBrowserNode.create(project2, ROOT_NODE_VALUE));
        if (defaultTreeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildEmpty"));
        }
        return defaultTreeModel;
    }

    @NotNull
    public static DefaultTreeModel buildFromChanges(@NotNull Project project2, boolean showFlatten, @NotNull Collection<? extends Change> changes, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildFromChanges"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildFromChanges"));
        }
        DefaultTreeModel defaultTreeModel = new TreeModelBuilder(project2, showFlatten).setChanges(changes, changeNodeDecorator).build();
        if (defaultTreeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildFromChanges"));
        }
        return defaultTreeModel;
    }

    @NotNull
    public static DefaultTreeModel buildFromFilePaths(@NotNull Project project2, boolean showFlatten, @NotNull Collection<FilePath> filePaths) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildFromFilePaths"));
        }
        if (filePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildFromFilePaths"));
        }
        DefaultTreeModel defaultTreeModel = new TreeModelBuilder(project2, showFlatten).setFilePaths(filePaths).build();
        if (defaultTreeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildFromFilePaths"));
        }
        return defaultTreeModel;
    }

    @NotNull
    public static DefaultTreeModel buildFromChangeLists(@NotNull Project project2, boolean showFlatten, @NotNull Collection<? extends ChangeList> changeLists) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildFromChangeLists"));
        }
        if (changeLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeLists", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildFromChangeLists"));
        }
        DefaultTreeModel defaultTreeModel = new TreeModelBuilder(project2, showFlatten).setChangeLists(changeLists).build();
        if (defaultTreeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildFromChangeLists"));
        }
        return defaultTreeModel;
    }

    @NotNull
    public static DefaultTreeModel buildFromVirtualFiles(@NotNull Project project2, boolean showFlatten, @NotNull Collection<VirtualFile> virtualFiles) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildFromVirtualFiles"));
        }
        if (virtualFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFiles", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildFromVirtualFiles"));
        }
        DefaultTreeModel defaultTreeModel = new TreeModelBuilder(project2, showFlatten).setVirtualFiles(virtualFiles, null).build();
        if (defaultTreeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildFromVirtualFiles"));
        }
        return defaultTreeModel;
    }

    @NotNull
    public TreeModelBuilder setChanges(@NotNull Collection<? extends Change> changes, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setChanges"));
        }
        List sortedChanges = ContainerUtil.sorted(changes, PATH_LENGTH_COMPARATOR);
        for (Change change : sortedChanges) {
            this.insertChangeNode(change, this.myRoot, this.createChangeNode(change, changeNodeDecorator));
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setChanges"));
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setUnversioned(@Nullable List<VirtualFile> unversionedFiles) {
        if (ContainerUtil.isEmpty(unversionedFiles)) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setUnversioned"));
            }
            return treeModelBuilder;
        }
        int dirsCount = ContainerUtil.count(unversionedFiles, it -> it.isDirectory());
        int filesCount = unversionedFiles.size() - dirsCount;
        boolean manyFiles = unversionedFiles.size() > 50;
        ChangesBrowserUnversionedFilesNode node = new ChangesBrowserUnversionedFilesNode(this.myProject, filesCount, dirsCount, manyFiles);
        TreeModelBuilder treeModelBuilder = this.insertSpecificNodeToModel(unversionedFiles, node);
        if (treeModelBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setUnversioned"));
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setIgnored(@Nullable List<VirtualFile> ignoredFiles, boolean updatingMode) {
        if (ContainerUtil.isEmpty(ignoredFiles)) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setIgnored"));
            }
            return treeModelBuilder;
        }
        int dirsCount = ContainerUtil.count(ignoredFiles, it -> it.isDirectory());
        int filesCount = ignoredFiles.size() - dirsCount;
        boolean manyFiles = ignoredFiles.size() > 50;
        ChangesBrowserIgnoredFilesNode node = new ChangesBrowserIgnoredFilesNode(this.myProject, filesCount, dirsCount, manyFiles, updatingMode);
        TreeModelBuilder treeModelBuilder = this.insertSpecificNodeToModel(ignoredFiles, node);
        if (treeModelBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setIgnored"));
        }
        return treeModelBuilder;
    }

    @NotNull
    private TreeModelBuilder insertSpecificNodeToModel(@NotNull List<VirtualFile> specificFiles, @NotNull ChangesBrowserSpecificFilesNode node) {
        if (specificFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specificFiles", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "insertSpecificNodeToModel"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "insertSpecificNodeToModel"));
        }
        this.myModel.insertNodeInto(node, this.myRoot, this.myRoot.getChildCount());
        if (!node.isManyFiles()) {
            this.insertFilesIntoNode(specificFiles, node);
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "insertSpecificNodeToModel"));
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setChangeLists(@NotNull Collection<? extends ChangeList> changeLists) {
        if (changeLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeLists", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setChangeLists"));
        }
        RemoteRevisionsCache revisionsCache = RemoteRevisionsCache.getInstance(this.myProject);
        for (ChangeList changeList : changeLists) {
            List changes = ContainerUtil.sorted((Collection)changeList.getChanges(), PATH_LENGTH_COMPARATOR);
            ChangeListRemoteState listRemoteState = new ChangeListRemoteState(changes.size());
            ChangesBrowserChangeListNode listNode = new ChangesBrowserChangeListNode(this.myProject, changeList, listRemoteState);
            this.myModel.insertNodeInto(listNode, this.myRoot, 0);
            for (int i = 0; i < changes.size(); ++i) {
                Change change = (Change)changes.get(i);
                RemoteStatusChangeNodeDecorator decorator = new RemoteStatusChangeNodeDecorator(revisionsCache, listRemoteState, i);
                this.insertChangeNode(change, listNode, this.createChangeNode(change, decorator));
            }
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setChangeLists"));
        }
        return treeModelBuilder;
    }

    protected ChangesBrowserNode createChangeNode(Change change, ChangeNodeDecorator decorator) {
        return new ChangesBrowserChangeNode(this.myProject, change, decorator);
    }

    @NotNull
    public TreeModelBuilder setLockedFolders(@Nullable List<VirtualFile> lockedFolders) {
        TreeModelBuilder treeModelBuilder = this.setVirtualFiles(lockedFolders, ChangesBrowserNode.LOCKED_FOLDERS_TAG);
        if (treeModelBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setLockedFolders"));
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setModifiedWithoutEditing(@NotNull List<VirtualFile> modifiedWithoutEditing) {
        if (modifiedWithoutEditing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiedWithoutEditing", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setModifiedWithoutEditing"));
        }
        TreeModelBuilder treeModelBuilder = this.setVirtualFiles(modifiedWithoutEditing, ChangesBrowserNode.MODIFIED_WITHOUT_EDITING_TAG);
        if (treeModelBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setModifiedWithoutEditing"));
        }
        return treeModelBuilder;
    }

    @NotNull
    private TreeModelBuilder setVirtualFiles(@Nullable Collection<VirtualFile> files, @Nullable Object tag) {
        if (ContainerUtil.isEmpty(files)) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setVirtualFiles"));
            }
            return treeModelBuilder;
        }
        this.insertFilesIntoNode(files, this.createTagNode(tag));
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setVirtualFiles"));
        }
        return treeModelBuilder;
    }

    @NotNull
    private ChangesBrowserNode createTagNode(@Nullable Object tag) {
        if (tag == null) {
            ChangesBrowserNode changesBrowserNode = this.myRoot;
            if (changesBrowserNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "createTagNode"));
            }
            return changesBrowserNode;
        }
        ChangesBrowserNode subtreeRoot = ChangesBrowserNode.create(this.myProject, tag);
        this.myModel.insertNodeInto(subtreeRoot, this.myRoot, this.myRoot.getChildCount());
        ChangesBrowserNode changesBrowserNode = subtreeRoot;
        if (changesBrowserNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "createTagNode"));
        }
        return changesBrowserNode;
    }

    private void insertFilesIntoNode(@NotNull Collection<VirtualFile> files, @NotNull ChangesBrowserNode subtreeRoot) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "insertFilesIntoNode"));
        }
        if (subtreeRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subtreeRoot", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "insertFilesIntoNode"));
        }
        List sortedFiles = ContainerUtil.sorted(files, (Comparator)VirtualFileHierarchicalComparator.getInstance());
        for (VirtualFile file2 : sortedFiles) {
            this.insertChangeNode(file2, subtreeRoot, ChangesBrowserNode.create(this.myProject, file2));
        }
    }

    @NotNull
    public TreeModelBuilder setLocallyDeletedPaths(@Nullable Collection<LocallyDeletedChange> locallyDeletedChanges) {
        if (ContainerUtil.isEmpty(locallyDeletedChanges)) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setLocallyDeletedPaths"));
            }
            return treeModelBuilder;
        }
        ChangesBrowserNode subtreeRoot = this.createTagNode(ChangesBrowserNode.LOCALLY_DELETED_NODE_TAG);
        for (LocallyDeletedChange change : locallyDeletedChanges) {
            StaticFilePath key2 = new StaticFilePath(false, change.getPresentableUrl(), change.getPath().getVirtualFile());
            ChangesBrowserNode oldNode = this.getFolderCache(subtreeRoot).get(key2.getKey());
            if (oldNode != null) continue;
            ChangesBrowserNode node = ChangesBrowserNode.create(change);
            ChangesBrowserNode parent = this.getParentNodeFor(key2, subtreeRoot);
            this.myModel.insertNodeInto(node, parent, parent.getChildCount());
            this.getFolderCache(subtreeRoot).put(key2.getKey(), node);
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setLocallyDeletedPaths"));
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setFilePaths(@NotNull Collection<FilePath> filePaths) {
        if (filePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setFilePaths"));
        }
        TreeModelBuilder treeModelBuilder = this.setFilePaths(filePaths, this.myRoot);
        if (treeModelBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setFilePaths"));
        }
        return treeModelBuilder;
    }

    @NotNull
    private TreeModelBuilder setFilePaths(@NotNull Collection<FilePath> filePaths, @NotNull ChangesBrowserNode subtreeRoot) {
        if (filePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setFilePaths"));
        }
        if (subtreeRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subtreeRoot", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setFilePaths"));
        }
        for (FilePath file2 : filePaths) {
            StaticFilePath pathKey;
            assert (file2 != null);
            String path = file2.getPath();
            StaticFilePath staticFilePath = pathKey = !FileUtil.isAbsolute((String)path) || VcsUtil.isPathRemote((String)path) ? new StaticFilePath(false, path, null) : new StaticFilePath(false, new File(file2.getIOFile().getPath().replace('\\', '/')).getAbsolutePath(), file2.getVirtualFile());
            ChangesBrowserNode oldNode = this.getFolderCache(subtreeRoot).get(pathKey.getKey());
            if (oldNode != null) continue;
            ChangesBrowserNode node = ChangesBrowserNode.create(this.myProject, file2);
            ChangesBrowserNode parentNode = this.getParentNodeFor(pathKey, subtreeRoot);
            this.myModel.insertNodeInto(node, parentNode, 0);
            this.getFolderCache(subtreeRoot).put(pathKey.getKey(), node);
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setFilePaths"));
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setSwitchedRoots(@Nullable Map<VirtualFile, String> switchedRoots) {
        if (ContainerUtil.isEmpty(switchedRoots)) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setSwitchedRoots"));
            }
            return treeModelBuilder;
        }
        ChangesBrowserNode rootsHeadNode = this.createTagNode(ChangesBrowserNode.SWITCHED_ROOTS_TAG);
        rootsHeadNode.setAttributes(SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        List files = ContainerUtil.sorted(switchedRoots.keySet(), (Comparator)VirtualFileHierarchicalComparator.getInstance());
        for (VirtualFile vf : files) {
            CurrentContentRevision cr = new CurrentContentRevision(VcsUtil.getFilePath((VirtualFile)vf));
            Change change = new Change((ContentRevision)cr, (ContentRevision)cr, FileStatus.NOT_CHANGED);
            final String branchName = switchedRoots.get(vf);
            this.insertChangeNode(vf, rootsHeadNode, this.createChangeNode(change, new ChangeNodeDecorator(){

                @Override
                public void decorate(Change change1, SimpleColoredComponent component, boolean isShowFlatten) {
                }

                @Override
                public void preDecorate(Change change1, ChangesBrowserNodeRenderer renderer, boolean showFlatten) {
                    renderer.append("[" + branchName + "] ", SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
                }
            }));
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setSwitchedRoots"));
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setSwitchedFiles(@NotNull MultiMap<String, VirtualFile> switchedFiles) {
        if (switchedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "switchedFiles", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setSwitchedFiles"));
        }
        if (switchedFiles.isEmpty()) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setSwitchedFiles"));
            }
            return treeModelBuilder;
        }
        ChangesBrowserNode subtreeRoot = this.createTagNode(ChangesBrowserNode.SWITCHED_FILES_TAG);
        for (String branchName : switchedFiles.keySet()) {
            List switchedFileList = ContainerUtil.sorted((Collection)switchedFiles.get((Object)branchName), (Comparator)VirtualFileHierarchicalComparator.getInstance());
            if (switchedFileList.size() <= 0) continue;
            ChangesBrowserNode branchNode = ChangesBrowserNode.create(this.myProject, branchName);
            this.myModel.insertNodeInto(branchNode, subtreeRoot, subtreeRoot.getChildCount());
            for (VirtualFile file2 : switchedFileList) {
                this.insertChangeNode(file2, branchNode, ChangesBrowserNode.create(this.myProject, file2));
            }
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setSwitchedFiles"));
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setLogicallyLockedFiles(@Nullable Map<VirtualFile, LogicalLock> logicallyLockedFiles) {
        if (ContainerUtil.isEmpty(logicallyLockedFiles)) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setLogicallyLockedFiles"));
            }
            return treeModelBuilder;
        }
        ChangesBrowserNode subtreeRoot = this.createTagNode(ChangesBrowserNode.LOGICALLY_LOCKED_TAG);
        List keys = ContainerUtil.sorted(logicallyLockedFiles.keySet(), (Comparator)VirtualFileHierarchicalComparator.getInstance());
        for (VirtualFile file2 : keys) {
            LogicalLock lock = logicallyLockedFiles.get(file2);
            ChangesBrowserLogicallyLockedFile obj = new ChangesBrowserLogicallyLockedFile(this.myProject, file2, lock);
            this.insertChangeNode(obj, subtreeRoot, ChangesBrowserNode.create(this.myProject, obj));
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setLogicallyLockedFiles"));
        }
        return treeModelBuilder;
    }

    protected void insertChangeNode(@NotNull Object change, @NotNull ChangesBrowserNode subtreeRoot, @NotNull ChangesBrowserNode node) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "insertChangeNode"));
        }
        if (subtreeRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subtreeRoot", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "insertChangeNode"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "insertChangeNode"));
        }
        this.insertChangeNode(change, subtreeRoot, node, (Convertor<StaticFilePath, ChangesBrowserNode>)((Convertor)this::createPathNode));
    }

    protected void insertChangeNode(@NotNull Object change, @NotNull ChangesBrowserNode subtreeRoot, @NotNull ChangesBrowserNode node, @NotNull Convertor<StaticFilePath, ChangesBrowserNode> nodeBuilder) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "insertChangeNode"));
        }
        if (subtreeRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subtreeRoot", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "insertChangeNode"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "insertChangeNode"));
        }
        if (nodeBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeBuilder", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "insertChangeNode"));
        }
        StaticFilePath pathKey = TreeModelBuilder.getKey(change);
        ChangesBrowserNode parentNode = this.getParentNodeFor(pathKey, subtreeRoot, nodeBuilder);
        this.myModel.insertNodeInto(node, parentNode, this.myModel.getChildCount(parentNode));
        if (pathKey.isDirectory()) {
            this.getFolderCache(subtreeRoot).put(pathKey.getKey(), node);
        }
    }

    @NotNull
    public DefaultTreeModel build() {
        TreeModelBuilder.collapseDirectories(this.myModel, this.myRoot);
        this.sortNodes();
        DefaultTreeModel defaultTreeModel = this.myModel;
        if (defaultTreeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "build"));
        }
        return defaultTreeModel;
    }

    private void sortNodes() {
        TreeUtil.sort((DefaultTreeModel)this.myModel, BROWSER_NODE_COMPARATOR);
        this.myModel.nodeStructureChanged((TreeNode)this.myModel.getRoot());
    }

    private static void collapseDirectories(@NotNull DefaultTreeModel model, @NotNull ChangesBrowserNode node) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "collapseDirectories"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "collapseDirectories"));
        }
        if (node.getUserObject() instanceof FilePath && node.getChildCount() == 1) {
            ChangesBrowserNode child = (ChangesBrowserNode)node.getChildAt(0);
            if (child.getUserObject() instanceof FilePath && !child.isLeaf()) {
                ChangesBrowserNode parent = (ChangesBrowserNode)node.getParent();
                int idx = parent.getIndex(node);
                model.removeNodeFromParent(node);
                model.removeNodeFromParent(child);
                model.insertNodeInto(child, parent, idx);
                TreeModelBuilder.collapseDirectories(model, parent);
            }
        } else {
            Enumeration<TreeNode> children2 = node.children();
            while (children2.hasMoreElements()) {
                ChangesBrowserNode child = (ChangesBrowserNode)children2.nextElement();
                TreeModelBuilder.collapseDirectories(model, child);
            }
        }
    }

    @NotNull
    private static StaticFilePath getKey(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getKey"));
        }
        if (o instanceof Change) {
            StaticFilePath staticFilePath = TreeModelBuilder.staticFrom(ChangesUtil.getFilePath((Change)((Change)o)));
            if (staticFilePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getKey"));
            }
            return staticFilePath;
        }
        if (o instanceof VirtualFile) {
            StaticFilePath staticFilePath = TreeModelBuilder.staticFrom((VirtualFile)o);
            if (staticFilePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getKey"));
            }
            return staticFilePath;
        }
        if (o instanceof FilePath) {
            StaticFilePath staticFilePath = TreeModelBuilder.staticFrom((FilePath)o);
            if (staticFilePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getKey"));
            }
            return staticFilePath;
        }
        if (o instanceof ChangesBrowserLogicallyLockedFile) {
            StaticFilePath staticFilePath = TreeModelBuilder.staticFrom((VirtualFile)((ChangesBrowserLogicallyLockedFile)o).getUserObject());
            if (staticFilePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getKey"));
            }
            return staticFilePath;
        }
        if (o instanceof LocallyDeletedChange) {
            StaticFilePath staticFilePath = TreeModelBuilder.staticFrom(((LocallyDeletedChange)o).getPath());
            if (staticFilePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getKey"));
            }
            return staticFilePath;
        }
        throw new IllegalArgumentException("Unknown type - " + o.getClass());
    }

    @NotNull
    private static StaticFilePath staticFrom(@NotNull FilePath fp) {
        if (fp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fp", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "staticFrom"));
        }
        String path = fp.getPath();
        if (fp.isNonLocal() && (!FileUtil.isAbsolute((String)path) || VcsUtil.isPathRemote((String)path))) {
            StaticFilePath staticFilePath = new StaticFilePath(fp.isDirectory(), fp.getIOFile().getPath().replace('\\', '/'), fp.getVirtualFile());
            if (staticFilePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "staticFrom"));
            }
            return staticFilePath;
        }
        StaticFilePath staticFilePath = new StaticFilePath(fp.isDirectory(), new File(fp.getIOFile().getPath().replace('\\', '/')).getAbsolutePath(), fp.getVirtualFile());
        if (staticFilePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "staticFrom"));
        }
        return staticFilePath;
    }

    @NotNull
    private static StaticFilePath staticFrom(@NotNull VirtualFile vf) {
        if (vf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vf", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "staticFrom"));
        }
        StaticFilePath staticFilePath = new StaticFilePath(vf.isDirectory(), vf.getPath(), vf);
        if (staticFilePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "staticFrom"));
        }
        return staticFilePath;
    }

    @NotNull
    public static FilePath getPathForObject(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getPathForObject"));
        }
        if (o instanceof Change) {
            FilePath filePath = ChangesUtil.getFilePath((Change)((Change)o));
            if (filePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getPathForObject"));
            }
            return filePath;
        }
        if (o instanceof VirtualFile) {
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)((VirtualFile)o));
            if (filePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getPathForObject"));
            }
            return filePath;
        }
        if (o instanceof FilePath) {
            FilePath filePath = (FilePath)o;
            if (filePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getPathForObject"));
            }
            return filePath;
        }
        if (o instanceof ChangesBrowserLogicallyLockedFile) {
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)((VirtualFile)((ChangesBrowserLogicallyLockedFile)o).getUserObject()));
            if (filePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getPathForObject"));
            }
            return filePath;
        }
        if (o instanceof LocallyDeletedChange) {
            FilePath filePath = ((LocallyDeletedChange)o).getPath();
            if (filePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getPathForObject"));
            }
            return filePath;
        }
        throw new IllegalArgumentException("Unknown type - " + o.getClass());
    }

    @NotNull
    protected ChangesBrowserNode getParentNodeFor(@NotNull StaticFilePath nodePath, @NotNull ChangesBrowserNode subtreeRoot) {
        if (nodePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePath", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getParentNodeFor"));
        }
        if (subtreeRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subtreeRoot", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getParentNodeFor"));
        }
        ChangesBrowserNode changesBrowserNode = this.getParentNodeFor(nodePath, subtreeRoot, (Convertor<StaticFilePath, ChangesBrowserNode>)((Convertor)this::createPathNode));
        if (changesBrowserNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getParentNodeFor"));
        }
        return changesBrowserNode;
    }

    @NotNull
    protected ChangesBrowserNode getParentNodeFor(@NotNull StaticFilePath nodePath, @NotNull ChangesBrowserNode subtreeRoot, @NotNull Convertor<StaticFilePath, ChangesBrowserNode> nodeBuilder) {
        ChangesBrowserNode nodeFromPolicy;
        if (nodePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePath", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getParentNodeFor"));
        }
        if (subtreeRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subtreeRoot", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getParentNodeFor"));
        }
        if (nodeBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeBuilder", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getParentNodeFor"));
        }
        if (this.myShowFlatten) {
            ChangesBrowserNode changesBrowserNode = subtreeRoot;
            if (changesBrowserNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getParentNodeFor"));
            }
            return changesBrowserNode;
        }
        ChangesGroupingPolicy policy = this.myGroupingPoliciesCache.get(subtreeRoot);
        if (policy != null && (nodeFromPolicy = policy.getParentNodeFor(nodePath, subtreeRoot)) != null) {
            ChangesBrowserNode changesBrowserNode = nodeFromPolicy;
            if (changesBrowserNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getParentNodeFor"));
            }
            return changesBrowserNode;
        }
        for (StaticFilePath parentPath = nodePath.getParent(); parentPath != null; parentPath = parentPath.getParent()) {
            ChangesBrowserNode oldParentNode = this.getFolderCache(subtreeRoot).get(parentPath.getKey());
            if (oldParentNode != null) {
                ChangesBrowserNode changesBrowserNode = oldParentNode;
                if (changesBrowserNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getParentNodeFor"));
                }
                return changesBrowserNode;
            }
            ChangesBrowserNode parentNode = (ChangesBrowserNode)nodeBuilder.convert((Object)parentPath);
            if (parentNode == null) continue;
            ChangesBrowserNode grandPa = this.getParentNodeFor(parentPath, subtreeRoot, nodeBuilder);
            this.myModel.insertNodeInto(parentNode, grandPa, grandPa.getChildCount());
            this.getFolderCache(subtreeRoot).put(parentPath.getKey(), parentNode);
            ChangesBrowserNode changesBrowserNode = parentNode;
            if (changesBrowserNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getParentNodeFor"));
            }
            return changesBrowserNode;
        }
        ChangesBrowserNode changesBrowserNode = subtreeRoot;
        if (changesBrowserNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getParentNodeFor"));
        }
        return changesBrowserNode;
    }

    @Nullable
    private ChangesBrowserNode createPathNode(@NotNull StaticFilePath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "createPathNode"));
        }
        FilePath filePath = path.getVf() == null ? VcsUtil.getFilePath((String)path.getPath(), (boolean)true) : VcsUtil.getFilePath((VirtualFile)path.getVf());
        return ChangesBrowserNode.create(this.myProject, filePath);
    }

    @NotNull
    private Map<String, ChangesBrowserNode> getFolderCache(@NotNull ChangesBrowserNode subtreeRoot) {
        if (subtreeRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subtreeRoot", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getFolderCache"));
        }
        Map map2 = this.myFoldersCache.computeIfAbsent(subtreeRoot, key2 -> new HashMap());
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getFolderCache"));
        }
        return map2;
    }

    public boolean isEmpty() {
        return this.myModel.getChildCount(this.myRoot) == 0;
    }

    @Deprecated
    @NotNull
    public DefaultTreeModel buildModel(@NotNull List<Change> changes, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildModel"));
        }
        DefaultTreeModel defaultTreeModel = this.setChanges(changes, changeNodeDecorator).build();
        if (defaultTreeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildModel"));
        }
        return defaultTreeModel;
    }

    private static class MyGroupingPolicyFactoryMap
    extends FactoryMap<ChangesBrowserNode, ChangesGroupingPolicy> {
        @NotNull
        private final Project myProject;
        @NotNull
        private final DefaultTreeModel myModel;

        public MyGroupingPolicyFactoryMap(@NotNull Project project2, @NotNull DefaultTreeModel model) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder$MyGroupingPolicyFactoryMap", "<init>"));
            }
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder$MyGroupingPolicyFactoryMap", "<init>"));
            }
            this.myProject = project2;
            this.myModel = model;
        }

        @Nullable
        protected ChangesGroupingPolicy create(ChangesBrowserNode key2) {
            ChangesGroupingPolicyFactory factory = ChangesGroupingPolicyFactory.getInstance(this.myProject);
            return factory != null ? factory.createGroupingPolicy(this.myModel) : null;
        }
    }
}

