/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.configurable.ShelfProjectConfigurationPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelfStorageConfigurationDialog
extends DialogWrapper {
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsConfiguration myVcsConfiguration;
    @NotNull
    private final JBRadioButton myUseCustomShelfDirectory;
    @NotNull
    private final JBRadioButton myUseDefaultShelfDirectory;
    @NotNull
    private final TextFieldWithBrowseButton myShelfDirectoryPath;
    @NotNull
    private final JBCheckBox myMoveShelvesCheckBox;

    protected ShelfStorageConfigurationDialog(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/configurable/ShelfStorageConfigurationDialog", "<init>"));
        }
        super(project2);
        this.setTitle("Change Shelves Location");
        this.myProject = project2;
        this.myVcsConfiguration = VcsConfiguration.getInstance((Project)project2);
        this.myUseCustomShelfDirectory = new JBRadioButton("Custom directory:");
        if (UIUtil.isUnderWin10LookAndFeel()) {
            this.myUseCustomShelfDirectory.setBorder((Border)JBUI.Borders.emptyRight((int)10));
        }
        this.myUseDefaultShelfDirectory = new JBRadioButton("Default directory:", true);
        this.myShelfDirectoryPath = new TextFieldWithBrowseButton();
        this.myShelfDirectoryPath.addBrowseFolderListener("Shelf", "Select a directory to store shelves in", this.myProject, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myMoveShelvesCheckBox = new JBCheckBox(VcsBundle.message((String)"vcs.shelf.move.text", (Object[])new Object[0]));
        this.setOKButtonText("_Change Location");
        this.initComponents();
        this.updateOkAction();
        this.getOKAction().putValue("DefaultAction", null);
        this.getCancelAction().putValue("DefaultAction", Boolean.TRUE);
        this.init();
        this.initValidation();
    }

    protected boolean postponeValidation() {
        return false;
    }

    private void initComponents() {
        ButtonGroup bg = new ButtonGroup();
        bg.add((AbstractButton)this.myUseCustomShelfDirectory);
        bg.add((AbstractButton)this.myUseDefaultShelfDirectory);
        this.myUseCustomShelfDirectory.setMnemonic('U');
        this.myMoveShelvesCheckBox.setMnemonic('M');
        this.myUseCustomShelfDirectory.setSelected(this.myVcsConfiguration.USE_CUSTOM_SHELF_PATH);
        this.myMoveShelvesCheckBox.setSelected(this.myVcsConfiguration.MOVE_SHELVES);
        this.myShelfDirectoryPath.setText(FileUtil.toSystemDependentName((String)((String)ObjectUtils.chooseNotNull((Object)this.myVcsConfiguration.CUSTOM_SHELF_PATH, (Object)ShelfProjectConfigurationPanel.getDefaultShelfPresentationPath(this.myProject)))));
        this.setEnabledCustomShelfDirectoryComponents(this.myUseCustomShelfDirectory.isSelected());
        this.myUseCustomShelfDirectory.addChangeListener(e -> this.setEnabledCustomShelfDirectoryComponents(this.myUseCustomShelfDirectory.isSelected()));
    }

    private void setEnabledCustomShelfDirectoryComponents(boolean enabled) {
        this.myShelfDirectoryPath.setEnabled(enabled);
        this.myShelfDirectoryPath.setEditable(enabled);
    }

    @Nullable
    protected JComponent createNorthPanel() {
        JPanel contentPanel = new JPanel(new BorderLayout(10, 4));
        JBLabel label = new JBLabel("Store shelves in:");
        contentPanel.add((Component)label, "North");
        JPanel buttonPanel = new JPanel(new BorderLayout(10, 4));
        buttonPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)20));
        buttonPanel.add((Component)this.createCustomShelveLocationPanel(), "North");
        buttonPanel.add((Component)this.createDefaultLocationPanel(), "South");
        contentPanel.add((Component)buttonPanel, "Center");
        this.myMoveShelvesCheckBox.setAlignmentX(0.0f);
        this.myMoveShelvesCheckBox.setBorder(null);
        contentPanel.add((Component)this.myMoveShelvesCheckBox, "South");
        return contentPanel;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return null;
    }

    @NotNull
    private JPanel createCustomShelveLocationPanel() {
        JPanel customPanel = new JPanel(new BorderLayout());
        customPanel.add((Component)this.myUseCustomShelfDirectory, "West");
        customPanel.add((Component)this.myShelfDirectoryPath, "Center");
        JPanel jPanel = customPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/ShelfStorageConfigurationDialog", "createCustomShelveLocationPanel"));
        }
        return jPanel;
    }

    @NotNull
    private JPanel createDefaultLocationPanel() {
        JPanel defaultPanel = new JPanel(new BorderLayout());
        defaultPanel.add((Component)this.myUseDefaultShelfDirectory, "West");
        JLabel infoLabel = new JLabel(ShelfProjectConfigurationPanel.getDefaultShelfPresentationPath(this.myProject));
        infoLabel.setBorder(null);
        infoLabel.setForeground((Color)JBColor.GRAY);
        defaultPanel.add((Component)infoLabel, "Center");
        JPanel jPanel = defaultPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/ShelfStorageConfigurationDialog", "createDefaultLocationPanel"));
        }
        return jPanel;
    }

    @Nullable
    protected String getHelpId() {
        return "reference.dialogs.vcs.shelf.settings";
    }

    protected void doOKAction() {
        File toFile;
        boolean wasCustom = this.myVcsConfiguration.USE_CUSTOM_SHELF_PATH;
        String prevPath = this.myVcsConfiguration.CUSTOM_SHELF_PATH;
        String customPath = FileUtil.toSystemIndependentName((String)this.myShelfDirectoryPath.getText());
        boolean nowCustom = this.myUseCustomShelfDirectory.isSelected();
        if (nowCustom && !this.checkAndIgnoreIfCreated(customPath)) {
            PopupUtil.showBalloonForComponent((Component)this.myShelfDirectoryPath, (String)"Can't find or create new shelf directory", (MessageType)MessageType.WARNING, (boolean)false, (Disposable)this.myProject);
            return;
        }
        this.myVcsConfiguration.USE_CUSTOM_SHELF_PATH = nowCustom;
        this.myVcsConfiguration.CUSTOM_SHELF_PATH = customPath;
        this.myVcsConfiguration.MOVE_SHELVES = this.myMoveShelvesCheckBox.isSelected();
        File fromFile = new File(wasCustom ? prevPath : ShelveChangesManager.getDefaultShelfPath(this.myProject));
        if (!FileUtil.filesEqual((File)fromFile, (File)(toFile = new File(nowCustom ? customPath : ShelveChangesManager.getDefaultShelfPath(this.myProject))))) {
            this.myProject.save();
            if (wasCustom) {
                ApplicationManager.getApplication().saveSettings();
            }
            ShelveChangesManager.getInstance(this.myProject).checkAndMigrateUnderProgress(fromFile, toFile, wasCustom);
        }
        super.doOKAction();
    }

    private boolean checkAndIgnoreIfCreated(@NotNull String newPath) {
        if (newPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newPath", "com/intellij/openapi/vcs/configurable/ShelfStorageConfigurationDialog", "checkAndIgnoreIfCreated"));
        }
        File newDir = new File(newPath);
        if (newDir.exists()) {
            return true;
        }
        if (!newDir.mkdirs()) {
            return false;
        }
        String basePath = this.myProject.getBasePath();
        if (basePath != null && FileUtil.isAncestor((String)basePath, (String)newPath, (boolean)true)) {
            ChangeListManager.getInstance((Project)this.myProject).addDirectoryToIgnoreImplicitly(newDir.getAbsolutePath());
        }
        return true;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        this.updateOkAction();
        if (this.myUseCustomShelfDirectory.isSelected()) {
            File toFile = new File(this.myShelfDirectoryPath.getText());
            if (!toFile.exists()) {
                return null;
            }
            String validationError = null;
            if (!toFile.canRead()) {
                validationError = "Destination shelf directory should have read access";
            }
            if (!toFile.canWrite()) {
                validationError = "Destination shelf directory should have write access";
            }
            if (validationError != null) {
                return new ValidationInfo(validationError, (JComponent)this.myShelfDirectoryPath);
            }
        }
        return super.doValidate();
    }

    private void updateOkAction() {
        this.setOKActionEnabled(this.isModified());
    }

    private boolean isModified() {
        if (this.myVcsConfiguration.USE_CUSTOM_SHELF_PATH != this.myUseCustomShelfDirectory.isSelected()) {
            return true;
        }
        return this.myUseCustomShelfDirectory.isSelected() && !StringUtil.equals((CharSequence)this.myVcsConfiguration.CUSTOM_SHELF_PATH, (CharSequence)this.myShelfDirectoryPath.getText());
    }
}

