/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.PublicFieldBasedOptionDescription;
import com.intellij.ide.ui.PublicMethodBasedOptionDescription;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.contentAnnotation.VcsContentAnnotationSettings;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.vcs.commit.CommitMessageInspectionProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsOptionsTopHitProvider
extends OptionsTopHitProvider {
    @Override
    public String getId() {
        return "vcs";
    }

    @Override
    @NotNull
    public Collection<OptionDescription> getOptions(@Nullable Project project2) {
        if (project2 == null || ProjectLevelVcsManager.getInstance((Project)project2).getAllVcss().length == 0) {
            List<OptionDescription> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/VcsOptionsTopHitProvider", "getOptions"));
            }
            return list2;
        }
        VcsConfiguration vcs = VcsConfiguration.getInstance((Project)project2);
        if (vcs == null) {
            List<OptionDescription> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/VcsOptionsTopHitProvider", "getOptions"));
            }
            return list3;
        }
        ArrayList<BooleanOptionDescription> options = new ArrayList<BooleanOptionDescription>();
        String id = "project.propVCSSupport.Mappings";
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Limit history by " + vcs.MAXIMUM_HISTORY_ROWS + " rows", "LIMIT_HISTORY"));
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Show directories with changed descendants", "SHOW_DIRTY_RECURSIVELY"));
        VcsContentAnnotationSettings vcsCA = VcsContentAnnotationSettings.getInstance((Project)project2);
        if (vcsCA != null) {
            options.add(VcsOptionsTopHitProvider.option(vcsCA, id, "Show changed in last " + vcsCA.getLimitDays() + " days", "isShow", "setShow"));
        }
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Notify about VCS root errors", "SHOW_VCS_ERROR_NOTIFICATIONS"));
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Commit message right margin " + CommitMessageInspectionProfile.getBodyRightMargin(project2) + " columns", "USE_COMMIT_MESSAGE_MARGIN"));
        options.add(VcsOptionsTopHitProvider.option(vcs, id, ApplicationBundle.message((String)"checkbox.wrap.typing.on.right.margin", (Object[])new Object[0]), "WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN"));
        id = "project.propVCSSupport.Confirmation";
        ReadonlyStatusHandler vcsROSH = ReadonlyStatusHandler.getInstance((Project)project2);
        if (vcsROSH instanceof ReadonlyStatusHandlerImpl) {
            options.add(VcsOptionsTopHitProvider.option(((ReadonlyStatusHandlerImpl)vcsROSH).getState(), id, "Show \"Clear Read-only Status\" Dialog", "SHOW_DIALOG"));
        }
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Confirmation: Suggest to move uncommitted changes to another changelist", "OFFER_MOVE_TO_ANOTHER_CHANGELIST_ON_PARTIAL_COMMIT"));
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Confirmation: Force non-empty checkin comments", "FORCE_NON_EMPTY_COMMENT"));
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Confirmation: Clear initial commit message", "CLEAR_INITIAL_COMMIT_MESSAGE"));
        id = "project.propVCSSupport.Background";
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Perform in background: update from VCS", "PERFORM_UPDATE_IN_BACKGROUND"));
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Perform in background: commit to VCS", "PERFORM_COMMIT_IN_BACKGROUND"));
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Perform in background: checkout from VCS", "PERFORM_CHECKOUT_IN_BACKGROUND"));
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Perform in background: Edit/Checkout", "PERFORM_EDIT_IN_BACKGROUND"));
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Perform in background: Add/Remove", "PERFORM_ADD_REMOVE_IN_BACKGROUND"));
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Perform in background: revert", "PERFORM_ROLLBACK_IN_BACKGROUND"));
        id = "project.propVCSSupport.Shelf";
        options.add(VcsOptionsTopHitProvider.option(vcs, id, VcsBundle.message((String)"vcs.shelf.store.base.content", (Object[])new Object[0]), "INCLUDE_TEXT_INTO_SHELF"));
        if (!project2.isDefault()) {
            options.add(VcsOptionsTopHitProvider.tracker(project2, "Changelists: Enable changelist conflict tracking", "TRACKING_ENABLED"));
            options.add(VcsOptionsTopHitProvider.tracker(project2, "Changelists: Show conflict resolving dialog", "SHOW_DIALOG"));
            options.add(VcsOptionsTopHitProvider.tracker(project2, "Changelists: Highlight files with conflicts", "HIGHLIGHT_CONFLICTS"));
            options.add(VcsOptionsTopHitProvider.tracker(project2, "Changelists: Highlight files from non-active changelists", "HIGHLIGHT_NON_ACTIVE_CHANGELIST"));
        }
        Collection<OptionDescription> collection = Collections.unmodifiableCollection(options);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/VcsOptionsTopHitProvider", "getOptions"));
        }
        return collection;
    }

    private static BooleanOptionDescription option(final Object instance, String id, String option, String field) {
        return new PublicFieldBasedOptionDescription(option, id, field){

            public Object getInstance() {
                return instance;
            }
        };
    }

    private static BooleanOptionDescription option(final Object instance, String id, String option, String getter, String setter) {
        return new PublicMethodBasedOptionDescription(option, id, getter, setter){

            public Object getInstance() {
                return instance;
            }
        };
    }

    private static BooleanOptionDescription tracker(final Project project2, String option, String field) {
        return new PublicFieldBasedOptionDescription(option, "project.propVCSSupport.ChangelistConflict", field){

            public Object getInstance() {
                return ChangeListManagerImpl.getInstanceImpl(project2).getConflictTracker().getOptions();
            }

            protected void fireUpdated() {
                ChangeListManagerImpl.getInstanceImpl(project2).getConflictTracker().optionsChanged();
            }
        };
    }
}

