/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.util.PathUtilRt;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DefaultVcsRootPolicy {
    public static DefaultVcsRootPolicy getInstance(Project project2) {
        return (DefaultVcsRootPolicy)PeriodicalTasksCloser.getInstance().safeGetService(project2, DefaultVcsRootPolicy.class);
    }

    @NotNull
    public abstract Collection<VirtualFile> getDefaultVcsRoots(@NotNull NewMappings var1, @NotNull String var2);

    public abstract boolean matchesDefaultMapping(@NotNull VirtualFile var1, Object var2);

    @Nullable
    public abstract Object getMatchContext(VirtualFile var1);

    @Nullable
    public abstract VirtualFile getVcsRootFor(@NotNull VirtualFile var1);

    @NotNull
    public abstract Collection<VirtualFile> getDirtyRoots();

    public String getProjectConfigurationMessage(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/DefaultVcsRootPolicy", "getProjectConfigurationMessage"));
        }
        boolean isDirectoryBased = ProjectKt.isDirectoryBased(project2);
        StringBuilder sb = new StringBuilder("Content roots of all modules");
        if (isDirectoryBased) {
            sb.append(", ");
        } else {
            sb.append(", and ");
        }
        sb.append("all immediate descendants of project base directory");
        if (isDirectoryBased) {
            sb.append(", and ");
            sb.append(PathUtilRt.getFileName((String)ProjectKt.getStateStore(project2).getDirectoryStorePath()) + " directory contents");
        }
        return sb.toString();
    }
}

