/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactoryImpl;
import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.history.ByteContent;
import com.intellij.history.Label;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeGoToChangePopupAction;
import com.intellij.util.Consumer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowUpdatedDiffActionProvider
implements AnActionExtensionProvider {
    @Override
    public boolean isActive(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider", "isActive"));
        }
        return this.isVisible(e.getDataContext());
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider", "update"));
        }
        DataContext dc = e.getDataContext();
        Presentation presentation = e.getPresentation();
        presentation.setDescription("Show diff with version before update");
        presentation.setEnabled(this.isVisible(dc) && this.isEnabled(dc));
    }

    private boolean isVisible(DataContext dc) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dc);
        return project2 != null && VcsDataKeys.LABEL_BEFORE.getData(dc) != null && VcsDataKeys.LABEL_AFTER.getData(dc) != null;
    }

    private boolean isEnabled(DataContext dc) {
        Iterable iterable = (Iterable)VcsDataKeys.UPDATE_VIEW_FILES_ITERABLE.getData(dc);
        return iterable != null;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider", "actionPerformed"));
        }
        DataContext dc = e.getDataContext();
        if (!this.isVisible(dc) || !this.isEnabled(dc)) {
            return;
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dc);
        Iterable iterable = (Iterable)e.getRequiredData(VcsDataKeys.UPDATE_VIEW_FILES_ITERABLE);
        Label before = (Label)e.getRequiredData(VcsDataKeys.LABEL_BEFORE);
        Label after2 = (Label)e.getRequiredData(VcsDataKeys.LABEL_AFTER);
        FilePath selectedUrl = (FilePath)VcsDataKeys.UPDATE_VIEW_SELECTED_PATH.getData(dc);
        MyDiffRequestChain requestChain = new MyDiffRequestChain(project2, iterable, before, after2, selectedUrl);
        DiffManager.getInstance().showDiff(project2, (DiffRequestChain)requestChain, DiffDialogHints.FRAME);
    }

    private static class MyDiffRequestChain
    extends UserDataHolderBase
    implements DiffRequestChain,
    GoToChangePopupBuilder.Chain {
        @Nullable
        private final Project myProject;
        @NotNull
        private final Label myBefore;
        @NotNull
        private final Label myAfter;
        @NotNull
        private final List<MyDiffRequestProducer> myRequests;
        private int myIndex;

        public MyDiffRequestChain(@Nullable Project project2, @NotNull Iterable<Pair<FilePath, FileStatus>> iterable, @NotNull Label before, @NotNull Label after2, @Nullable FilePath selectedPath) {
            if (iterable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider$MyDiffRequestChain", "<init>"));
            }
            if (before == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "before", "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider$MyDiffRequestChain", "<init>"));
            }
            if (after2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "after", "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider$MyDiffRequestChain", "<init>"));
            }
            this.myRequests = new ArrayList<MyDiffRequestProducer>();
            this.myProject = project2;
            this.myBefore = before;
            this.myAfter = after2;
            int selected = -1;
            for (Pair<FilePath, FileStatus> pair2 : iterable) {
                if (selected == -1 && ((FilePath)pair2.first).equals(selectedPath)) {
                    selected = this.myRequests.size();
                }
                this.myRequests.add(new MyDiffRequestProducer((FilePath)pair2.first, (FileStatus)pair2.second));
            }
            if (selected != -1) {
                this.myIndex = selected;
            }
        }

        @NotNull
        public List<MyDiffRequestProducer> getRequests() {
            List<MyDiffRequestProducer> list2 = this.myRequests;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider$MyDiffRequestChain", "getRequests"));
            }
            return list2;
        }

        public int getIndex() {
            return this.myIndex;
        }

        public void setIndex(int index) {
            this.myIndex = index;
        }

        @Override
        @NotNull
        public AnAction createGoToChangeAction(@NotNull Consumer<Integer> onSelected) {
            if (onSelected == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onSelected", "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider$MyDiffRequestChain", "createGoToChangeAction"));
            }
            ChangeGoToChangePopupAction.Fake<MyDiffRequestChain> fake = new ChangeGoToChangePopupAction.Fake<MyDiffRequestChain>(this, this.myIndex, onSelected){

                @Override
                @NotNull
                protected FilePath getFilePath(int index) {
                    FilePath filePath = ((MyDiffRequestProducer)myRequests.get(index)).getFilePath();
                    if (filePath == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider$MyDiffRequestChain$1", "getFilePath"));
                    }
                    return filePath;
                }

                @Override
                @NotNull
                protected FileStatus getFileStatus(int index) {
                    FileStatus fileStatus = ((MyDiffRequestProducer)myRequests.get(index)).getFileStatus();
                    if (fileStatus == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider$MyDiffRequestChain$1", "getFileStatus"));
                    }
                    return fileStatus;
                }
            };
            if (fake == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider$MyDiffRequestChain", "createGoToChangeAction"));
            }
            return fake;
        }

        @NotNull
        private static byte[] loadContent(@NotNull FilePath path, @NotNull Label label) throws DiffRequestProducerException {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider$MyDiffRequestChain", "loadContent"));
            }
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider$MyDiffRequestChain", "loadContent"));
            }
            ByteContent byteContent = label.getByteContent(path.getPath());
            if (byteContent == null || byteContent.isDirectory() || byteContent.getBytes() == null) {
                throw new DiffRequestProducerException("Can't load content");
            }
            byte[] byArray = byteContent.getBytes();
            if (byArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider$MyDiffRequestChain", "loadContent"));
            }
            return byArray;
        }

        private class MyDiffRequestProducer
        implements DiffRequestProducer {
            @NotNull
            private final FileStatus myFileStatus;
            @NotNull
            private final FilePath myFilePath;

            public MyDiffRequestProducer(@NotNull FilePath filePath, FileStatus fileStatus) {
                if (filePath == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider$MyDiffRequestChain$MyDiffRequestProducer", "<init>"));
                }
                if (fileStatus == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileStatus", "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider$MyDiffRequestChain$MyDiffRequestProducer", "<init>"));
                }
                this.myFileStatus = fileStatus;
                this.myFilePath = filePath;
            }

            @NotNull
            public String getName() {
                String string = this.myFilePath.getPresentableUrl();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider$MyDiffRequestChain$MyDiffRequestProducer", "getName"));
                }
                return string;
            }

            @NotNull
            public FilePath getFilePath() {
                FilePath filePath = this.myFilePath;
                if (filePath == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider$MyDiffRequestChain$MyDiffRequestProducer", "getFilePath"));
                }
                return filePath;
            }

            @NotNull
            public FileStatus getFileStatus() {
                FileStatus fileStatus = this.myFileStatus;
                if (fileStatus == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider$MyDiffRequestChain$MyDiffRequestProducer", "getFileStatus"));
                }
                return fileStatus;
            }

            @NotNull
            public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
                SimpleDiffRequest simpleDiffRequest;
                block8: {
                    if (context == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider$MyDiffRequestChain$MyDiffRequestProducer", "process"));
                    }
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider$MyDiffRequestChain$MyDiffRequestProducer", "process"));
                    }
                    try {
                        EmptyContent content2;
                        EmptyContent content1;
                        DiffContentFactoryEx contentFactory = DiffContentFactoryEx.getInstanceEx();
                        if (FileStatus.ADDED.equals(this.myFileStatus)) {
                            content1 = contentFactory.createEmpty();
                        } else {
                            byte[] bytes1 = MyDiffRequestChain.loadContent(this.myFilePath, MyDiffRequestChain.this.myBefore);
                            content1 = contentFactory.createFromBytes(MyDiffRequestChain.this.myProject, bytes1, this.myFilePath);
                        }
                        if (FileStatus.DELETED.equals(this.myFileStatus)) {
                            content2 = contentFactory.createEmpty();
                        } else {
                            byte[] bytes2 = MyDiffRequestChain.loadContent(this.myFilePath, MyDiffRequestChain.this.myAfter);
                            content2 = contentFactory.createFromBytes(MyDiffRequestChain.this.myProject, bytes2, this.myFilePath);
                        }
                        String title = DiffRequestFactoryImpl.getContentTitle(this.myFilePath);
                        simpleDiffRequest = new SimpleDiffRequest(title, (DiffContent)content1, (DiffContent)content2, "Before update", "After update");
                        if (simpleDiffRequest != null) break block8;
                    }
                    catch (IOException e) {
                        throw new DiffRequestProducerException("Can't load content", (Throwable)e);
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider$MyDiffRequestChain$MyDiffRequestProducer", "process"));
                }
                return simpleDiffRequest;
            }
        }
    }
}

