/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileOperationsHandler;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.Processor;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.SafeFileOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalFileSystemBase
extends LocalFileSystem {
    protected static final Logger LOG = Logger.getInstance(LocalFileSystemBase.class);
    private static final FileAttributes FAKE_ROOT_ATTRIBUTES = new FileAttributes(true, false, false, false, 0L, 0L, false);
    private final List<LocalFileOperationsHandler> myHandlers = new ArrayList<LocalFileOperationsHandler>();
    private static final List<String> ourRootPaths = new ArrayList<String>();

    public LocalFileSystemBase() {
        List persistentFsRoots = StringUtil.split((String)System.getProperty("idea.persistentfs.roots", ""), (String)File.pathSeparator);
        LocalFileSystemBase.sortRootsLongestFirst(persistentFsRoots);
        for (String persistentFsRoot : persistentFsRoots) {
            ourRootPaths.add(persistentFsRoot);
        }
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "findFileByPath"));
        }
        return VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, path);
    }

    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "findFileByPathIfCached"));
        }
        return VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, path);
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "refreshAndFindFileByPath"));
        }
        return VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, path);
    }

    public VirtualFile findFileByIoFile(@NotNull File file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "findFileByIoFile"));
        }
        return this.findFileByPath(FileUtil.toSystemIndependentName((String)file2.getAbsolutePath()));
    }

    @NotNull
    protected static File convertToIOFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "convertToIOFile"));
        }
        String path = file2.getPath();
        if (StringUtil.endsWithChar((CharSequence)path, (char)':') && path.length() == 2 && SystemInfo.isWindows) {
            path = path + "/";
        }
        File file3 = new File(path);
        if (file3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "convertToIOFile"));
        }
        return file3;
    }

    @NotNull
    private static File convertToIOFileAndCheck(@NotNull VirtualFile file2) throws FileNotFoundException {
        FileAttributes attributes;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "convertToIOFileAndCheck"));
        }
        File ioFile = LocalFileSystemBase.convertToIOFile(file2);
        if (SystemInfo.isUnix && (attributes = FileSystemUtil.getAttributes((File)ioFile)) != null && !attributes.isFile()) {
            LOG.warn("not a file: " + ioFile + ", " + attributes);
            throw new FileNotFoundException("Not a file: " + ioFile);
        }
        File file3 = ioFile;
        if (file3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "convertToIOFileAndCheck"));
        }
        return file3;
    }

    public boolean exists(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "exists"));
        }
        return this.getAttributes(file2) != null;
    }

    public long getLength(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "getLength"));
        }
        FileAttributes attributes = this.getAttributes(file2);
        return attributes != null ? attributes.length : 0L;
    }

    public long getTimeStamp(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "getTimeStamp"));
        }
        FileAttributes attributes = this.getAttributes(file2);
        return attributes != null ? attributes.lastModified : 0L;
    }

    public boolean isDirectory(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "isDirectory"));
        }
        FileAttributes attributes = this.getAttributes(file2);
        return attributes != null && attributes.isDirectory();
    }

    public boolean isWritable(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "isWritable"));
        }
        FileAttributes attributes = this.getAttributes(file2);
        return attributes != null && attributes.isWritable();
    }

    public boolean isSymLink(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "isSymLink"));
        }
        FileAttributes attributes = this.getAttributes(file2);
        return attributes != null && attributes.isSymLink();
    }

    public String resolveSymLink(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "resolveSymLink"));
        }
        return FileSystemUtil.resolveSymLink((String)file2.getPath());
    }

    @NotNull
    public String[] list(@NotNull VirtualFile file2) {
        String[] names;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "list"));
        }
        if (file2.getParent() == null) {
            File[] roots = File.listRoots();
            if (roots.length == 1 && roots[0].getName().isEmpty()) {
                String[] list2 = roots[0].list();
                if (list2 != null) {
                    if (list2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "list"));
                    }
                    return list2;
                }
                LOG.warn("Root '" + roots[0] + "' has no children - is it readable?");
                if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "list"));
                }
                return ArrayUtil.EMPTY_STRING_ARRAY;
            }
            if (file2.getName().isEmpty()) {
                String[] names2 = new String[roots.length];
                for (int i2 = 0; i2 < names2.length; ++i2) {
                    String name2 = roots[i2].getPath();
                    names2[i2] = name2 = StringUtil.trimEnd((String)name2, (String)File.separator);
                }
                if (names2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "list"));
                }
                return names2;
            }
        }
        String[] stringArray = (names = LocalFileSystemBase.convertToIOFile(file2).list()) == null ? ArrayUtil.EMPTY_STRING_ARRAY : names;
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "list"));
        }
        return stringArray;
    }

    @NotNull
    public String getProtocol() {
        if ("file" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "getProtocol"));
        }
        return "file";
    }

    public boolean isReadOnly() {
        return false;
    }

    @Nullable
    protected String normalize(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "normalize"));
        }
        if (path.isEmpty()) {
            try {
                path = new File("").getCanonicalPath();
            }
            catch (IOException e) {
                return path;
            }
        }
        if (SystemInfo.isWindows) {
            if (path.charAt(0) == '/' && !path.startsWith("//")) {
                path = path.substring(1);
            }
            try {
                path = FileUtil.resolveShortWindowsName((String)path);
            }
            catch (IOException e) {
                return null;
            }
        }
        File file2 = new File(path);
        if (!LocalFileSystemBase.isAbsoluteFileOrDriveLetter(file2)) {
            path = file2.getAbsolutePath();
        }
        return FileUtil.normalize((String)path);
    }

    private static boolean isAbsoluteFileOrDriveLetter(@NotNull File file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "isAbsoluteFileOrDriveLetter"));
        }
        String path = file2.getPath();
        if (SystemInfo.isWindows && path.length() == 2 && path.charAt(1) == ':') {
            return true;
        }
        return file2.isAbsolute();
    }

    public VirtualFile refreshAndFindFileByIoFile(@NotNull File file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "refreshAndFindFileByIoFile"));
        }
        String path = FileUtil.toSystemIndependentName((String)file2.getAbsolutePath());
        return this.refreshAndFindFileByPath(path);
    }

    public void refreshIoFiles(@NotNull Iterable<File> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "refreshIoFiles"));
        }
        this.refreshIoFiles(files, false, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshIoFiles(@NotNull Iterable<File> files, boolean async, boolean recursive, @Nullable Runnable onFinish) {
        boolean fireCommonRefreshSession;
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "refreshIoFiles"));
        }
        VirtualFileManagerEx manager = (VirtualFileManagerEx)VirtualFileManager.getInstance();
        Application app = ApplicationManager.getApplication();
        boolean bl = fireCommonRefreshSession = app.isDispatchThread() || app.isWriteAccessAllowed();
        if (fireCommonRefreshSession) {
            manager.fireBeforeRefreshStart(false);
        }
        try {
            ArrayList<VirtualFile> filesToRefresh = new ArrayList<VirtualFile>();
            for (File file2 : files) {
                VirtualFile virtualFile = this.refreshAndFindFileByIoFile(file2);
                if (virtualFile == null) continue;
                filesToRefresh.add(virtualFile);
            }
            RefreshQueue.getInstance().refresh(async, recursive, onFinish, filesToRefresh);
        }
        finally {
            if (fireCommonRefreshSession) {
                manager.fireAfterRefreshFinish(false);
            }
        }
    }

    public void refreshFiles(@NotNull Iterable<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "refreshFiles"));
        }
        this.refreshFiles(files, false, false, null);
    }

    public void refreshFiles(@NotNull Iterable<VirtualFile> files, boolean async, boolean recursive, @Nullable Runnable onFinish) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "refreshFiles"));
        }
        RefreshQueue.getInstance().refresh(async, recursive, onFinish, ContainerUtil.toCollection(files));
    }

    public void registerAuxiliaryFileOperationsHandler(@NotNull LocalFileOperationsHandler handler2) {
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "registerAuxiliaryFileOperationsHandler"));
        }
        if (this.myHandlers.contains(handler2)) {
            LOG.error("Handler " + handler2 + " already registered.");
        }
        this.myHandlers.add(handler2);
    }

    public void unregisterAuxiliaryFileOperationsHandler(@NotNull LocalFileOperationsHandler handler2) {
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "unregisterAuxiliaryFileOperationsHandler"));
        }
        if (!this.myHandlers.remove(handler2)) {
            LOG.error("Handler" + handler2 + " haven't been registered or already unregistered.");
        }
    }

    public boolean processCachedFilesInSubtree(@NotNull VirtualFile file2, @NotNull Processor<VirtualFile> processor2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "processCachedFilesInSubtree"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "processCachedFilesInSubtree"));
        }
        return file2.getFileSystem() != this || LocalFileSystemBase.processFile((NewVirtualFile)file2, processor2);
    }

    private static boolean processFile(@NotNull NewVirtualFile file2, @NotNull Processor<VirtualFile> processor2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "processFile"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "processFile"));
        }
        if (!processor2.process((Object)file2)) {
            return false;
        }
        if (file2.isDirectory()) {
            for (VirtualFile child : file2.getCachedChildren()) {
                if (LocalFileSystemBase.processFile((NewVirtualFile)child, processor2)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean auxDelete(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "auxDelete"));
        }
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            if (!handler2.delete(file2)) continue;
            return true;
        }
        return false;
    }

    private boolean auxMove(@NotNull VirtualFile file2, @NotNull VirtualFile toDir) throws IOException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "auxMove"));
        }
        if (toDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toDir", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "auxMove"));
        }
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            if (!handler2.move(file2, toDir)) continue;
            return true;
        }
        return false;
    }

    private boolean auxCopy(@NotNull VirtualFile file2, @NotNull VirtualFile toDir, @NotNull String copyName) throws IOException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "auxCopy"));
        }
        if (toDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toDir", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "auxCopy"));
        }
        if (copyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyName", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "auxCopy"));
        }
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            File copy = handler2.copy(file2, toDir, copyName);
            if (copy == null) continue;
            return true;
        }
        return false;
    }

    private boolean auxRename(@NotNull VirtualFile file2, @NotNull String newName) throws IOException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "auxRename"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "auxRename"));
        }
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            if (!handler2.rename(file2, newName)) continue;
            return true;
        }
        return false;
    }

    private boolean auxCreateFile(@NotNull VirtualFile dir, @NotNull String name2) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "auxCreateFile"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "auxCreateFile"));
        }
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            if (!handler2.createFile(dir, name2)) continue;
            return true;
        }
        return false;
    }

    private boolean auxCreateDirectory(@NotNull VirtualFile dir, @NotNull String name2) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "auxCreateDirectory"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "auxCreateDirectory"));
        }
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            if (!handler2.createDirectory(dir, name2)) continue;
            return true;
        }
        return false;
    }

    private void auxNotifyCompleted(@NotNull ThrowableConsumer<LocalFileOperationsHandler, IOException> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "auxNotifyCompleted"));
        }
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            handler2.afterDone(consumer);
        }
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String dir) throws IOException {
        File ioDir;
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "createChildDirectory"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "createChildDirectory"));
        }
        if (!this.isValidName(dir)) {
            throw new IOException(VfsBundle.message((String)"directory.invalid.name.error", (Object[])new Object[]{dir}));
        }
        if (!parent.exists() || !parent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"vfs.target.not.directory.error", (Object[])new Object[]{parent.getPath()}));
        }
        if (parent.findChild(dir) != null) {
            throw new IOException(VfsBundle.message((String)"vfs.target.already.exists.error", (Object[])new Object[]{parent.getPath() + "/" + dir}));
        }
        File ioParent = LocalFileSystemBase.convertToIOFile(parent);
        if (!ioParent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"target.not.directory.error", (Object[])new Object[]{ioParent.getPath()}));
        }
        if (!(this.auxCreateDirectory(parent, dir) || (ioDir = new File(ioParent, dir)).mkdirs() || ioDir.isDirectory())) {
            throw new IOException(VfsBundle.message((String)"new.directory.failed.error", (Object[])new Object[]{ioDir.getPath()}));
        }
        this.auxNotifyCompleted((ThrowableConsumer<LocalFileOperationsHandler, IOException>)((ThrowableConsumer)handler2 -> {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "lambda$createChildDirectory$0"));
            }
            if (dir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "lambda$createChildDirectory$0"));
            }
            handler2.createDirectory(parent, dir);
        }));
        FakeVirtualFile fakeVirtualFile = new FakeVirtualFile(parent, dir);
        if (fakeVirtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "createChildDirectory"));
        }
        return fakeVirtualFile;
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String file2) throws IOException {
        File ioFile;
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "createChildFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "createChildFile"));
        }
        if (!this.isValidName(file2)) {
            throw new IOException(VfsBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{file2}));
        }
        if (!parent.exists() || !parent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"vfs.target.not.directory.error", (Object[])new Object[]{parent.getPath()}));
        }
        if (parent.findChild(file2) != null) {
            throw new IOException(VfsBundle.message((String)"vfs.target.already.exists.error", (Object[])new Object[]{parent.getPath() + "/" + file2}));
        }
        File ioParent = LocalFileSystemBase.convertToIOFile(parent);
        if (!ioParent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"target.not.directory.error", (Object[])new Object[]{ioParent.getPath()}));
        }
        if (!this.auxCreateFile(parent, file2) && !FileUtil.createIfDoesntExist((File)(ioFile = new File(ioParent, file2)))) {
            throw new IOException(VfsBundle.message((String)"new.file.failed.error", (Object[])new Object[]{ioFile.getPath()}));
        }
        this.auxNotifyCompleted((ThrowableConsumer<LocalFileOperationsHandler, IOException>)((ThrowableConsumer)handler2 -> {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "lambda$createChildFile$1"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "lambda$createChildFile$1"));
            }
            handler2.createFile(parent, file2);
        }));
        FakeVirtualFile fakeVirtualFile = new FakeVirtualFile(parent, file2);
        if (fakeVirtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "createChildFile"));
        }
        return fakeVirtualFile;
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile file2) throws IOException {
        File ioFile;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "deleteFile"));
        }
        if (file2.getParent() == null) {
            throw new IOException(VfsBundle.message((String)"cannot.delete.root.directory", (Object[])new Object[]{file2.getPath()}));
        }
        if (!this.auxDelete(file2) && !FileUtil.delete((File)(ioFile = LocalFileSystemBase.convertToIOFile(file2)))) {
            throw new IOException(VfsBundle.message((String)"delete.failed.error", (Object[])new Object[]{ioFile.getPath()}));
        }
        this.auxNotifyCompleted((ThrowableConsumer<LocalFileOperationsHandler, IOException>)((ThrowableConsumer)handler2 -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "lambda$deleteFile$2"));
            }
            handler2.delete(file2);
        }));
    }

    public boolean isCaseSensitive() {
        return SystemInfo.isFileSystemCaseSensitive;
    }

    public boolean isValidName(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "isValidName"));
        }
        return PathUtilRt.isValidFileName((String)name2, (boolean)false);
    }

    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "getInputStream"));
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(LocalFileSystemBase.convertToIOFileAndCheck(file2)));
        if (bufferedInputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "getInputStream"));
        }
        return bufferedInputStream;
    }

    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file2) throws IOException {
        byte[] byArray;
        block15: {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "contentsToByteArray"));
            }
            try (FileInputStream stream = new FileInputStream(LocalFileSystemBase.convertToIOFileAndCheck(file2));){
                long l = file2.getLength();
                if (l >= (long)FileUtilRt.LARGE_FOR_CONTENT_LOADING) {
                    throw new FileTooBigException(file2.getPath());
                }
                int length = (int)l;
                if (length < 0) {
                    throw new IOException("Invalid file length: " + length + ", " + file2);
                }
                byArray = LocalFileSystemBase.loadBytes(length <= 8192 ? stream : new BufferedInputStream(stream), length);
                if (byArray != null) break block15;
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "contentsToByteArray"));
        }
        return byArray;
    }

    @NotNull
    private static byte[] loadBytes(@NotNull InputStream stream, int length) throws IOException {
        int count;
        int n;
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "loadBytes"));
        }
        byte[] bytes = new byte[length];
        for (count = 0; count < length && (n = stream.read(bytes, count, length - count)) > 0; count += n) {
        }
        if (count < length) {
            byte[] byArray = Arrays.copyOf(bytes, count);
            if (byArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "loadBytes"));
            }
            return byArray;
        }
        if (bytes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "loadBytes"));
        }
        return bytes;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public OutputStream getOutputStream(@NotNull VirtualFile file2, Object requestor, long modStamp, long l) throws IOException {
        void timeStamp;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "getOutputStream"));
        }
        File ioFile = LocalFileSystemBase.convertToIOFileAndCheck(file2);
        Object stream = LocalFileSystemBase.shallUseSafeStream(requestor, file2) ? new SafeFileOutputStream(ioFile, SystemInfo.isUnix) : new FileOutputStream(ioFile);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)stream, (long)timeStamp, ioFile){
            final /* synthetic */ long val$timeStamp;
            final /* synthetic */ File val$ioFile;
            {
                this.val$timeStamp = l;
                this.val$ioFile = file2;
                super(x0);
            }

            @Override
            public void close() throws IOException {
                super.close();
                if (this.val$timeStamp > 0L && this.val$ioFile.exists() && !this.val$ioFile.setLastModified(this.val$timeStamp)) {
                    LOG.warn("Failed: " + this.val$ioFile.getPath() + ", new:" + this.val$timeStamp + ", old:" + this.val$ioFile.lastModified());
                }
            }
        };
        if (bufferedOutputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "getOutputStream"));
        }
        return bufferedOutputStream;
    }

    private static boolean shallUseSafeStream(Object requestor, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "shallUseSafeStream"));
        }
        return requestor instanceof SafeWriteRequestor && GeneralSettings.getInstance().isUseSafeWrite() && !file2.is(VFileProperty.SYMLINK);
    }

    public void moveFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent) throws IOException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "moveFile"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "moveFile"));
        }
        String name2 = file2.getName();
        if (!file2.exists()) {
            throw new IOException(VfsBundle.message((String)"vfs.file.not.exist.error", (Object[])new Object[]{file2.getPath()}));
        }
        if (file2.getParent() == null) {
            throw new IOException(VfsBundle.message((String)"cannot.rename.root.directory", (Object[])new Object[]{file2.getPath()}));
        }
        if (!newParent.exists() || !newParent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"vfs.target.not.directory.error", (Object[])new Object[]{newParent.getPath()}));
        }
        if (newParent.findChild(name2) != null) {
            throw new IOException(VfsBundle.message((String)"vfs.target.already.exists.error", (Object[])new Object[]{newParent.getPath() + "/" + name2}));
        }
        File ioFile = LocalFileSystemBase.convertToIOFile(file2);
        if (FileSystemUtil.getAttributes((File)ioFile) == null) {
            throw new FileNotFoundException(VfsBundle.message((String)"file.not.exist.error", (Object[])new Object[]{ioFile.getPath()}));
        }
        File ioParent = LocalFileSystemBase.convertToIOFile(newParent);
        if (!ioParent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"target.not.directory.error", (Object[])new Object[]{ioParent.getPath()}));
        }
        File ioTarget = new File(ioParent, name2);
        if (ioTarget.exists()) {
            throw new IOException(VfsBundle.message((String)"target.already.exists.error", (Object[])new Object[]{ioTarget.getPath()}));
        }
        if (!this.auxMove(file2, newParent) && !ioFile.renameTo(ioTarget)) {
            throw new IOException(VfsBundle.message((String)"move.failed.error", (Object[])new Object[]{ioFile.getPath(), ioParent.getPath()}));
        }
        this.auxNotifyCompleted((ThrowableConsumer<LocalFileOperationsHandler, IOException>)((ThrowableConsumer)handler2 -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "lambda$moveFile$3"));
            }
            if (newParent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "lambda$moveFile$3"));
            }
            handler2.move(file2, newParent);
        }));
    }

    public void renameFile(Object requestor, @NotNull VirtualFile file2, @NotNull String newName) throws IOException {
        boolean sameName;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "renameFile"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "renameFile"));
        }
        if (!this.isValidName(newName)) {
            throw new IOException(VfsBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{newName}));
        }
        boolean bl = sameName = !this.isCaseSensitive() && newName.equalsIgnoreCase(file2.getName());
        if (!file2.exists()) {
            throw new IOException(VfsBundle.message((String)"vfs.file.not.exist.error", (Object[])new Object[]{file2.getPath()}));
        }
        VirtualFile parent = file2.getParent();
        if (parent == null) {
            throw new IOException(VfsBundle.message((String)"cannot.rename.root.directory", (Object[])new Object[]{file2.getPath()}));
        }
        if (!sameName && parent.findChild(newName) != null) {
            throw new IOException(VfsBundle.message((String)"vfs.target.already.exists.error", (Object[])new Object[]{parent.getPath() + "/" + newName}));
        }
        File ioFile = LocalFileSystemBase.convertToIOFile(file2);
        if (!ioFile.exists()) {
            throw new FileNotFoundException(VfsBundle.message((String)"file.not.exist.error", (Object[])new Object[]{ioFile.getPath()}));
        }
        File ioTarget = new File(LocalFileSystemBase.convertToIOFile(parent), newName);
        if (!sameName && ioTarget.exists()) {
            throw new IOException(VfsBundle.message((String)"target.already.exists.error", (Object[])new Object[]{ioTarget.getPath()}));
        }
        if (!this.auxRename(file2, newName) && !FileUtil.rename((File)ioFile, (String)newName)) {
            throw new IOException(VfsBundle.message((String)"rename.failed.error", (Object[])new Object[]{ioFile.getPath(), newName}));
        }
        this.auxNotifyCompleted((ThrowableConsumer<LocalFileOperationsHandler, IOException>)((ThrowableConsumer)handler2 -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "lambda$renameFile$4"));
            }
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "lambda$renameFile$4"));
            }
            handler2.rename(file2, newName);
        }));
    }

    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "copyFile"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "copyFile"));
        }
        if (copyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyName", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "copyFile"));
        }
        if (!this.isValidName(copyName)) {
            throw new IOException(VfsBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{copyName}));
        }
        if (!file2.exists()) {
            throw new IOException(VfsBundle.message((String)"vfs.file.not.exist.error", (Object[])new Object[]{file2.getPath()}));
        }
        if (!newParent.exists() || !newParent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"vfs.target.not.directory.error", (Object[])new Object[]{newParent.getPath()}));
        }
        if (newParent.findChild(copyName) != null) {
            throw new IOException(VfsBundle.message((String)"vfs.target.already.exists.error", (Object[])new Object[]{newParent.getPath() + "/" + copyName}));
        }
        FileAttributes attributes = this.getAttributes(file2);
        if (attributes == null) {
            throw new FileNotFoundException(VfsBundle.message((String)"file.not.exist.error", (Object[])new Object[]{file2.getPath()}));
        }
        if (attributes.isSpecial()) {
            throw new FileNotFoundException("Not a file: " + file2);
        }
        File ioParent = LocalFileSystemBase.convertToIOFile(newParent);
        if (!ioParent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"target.not.directory.error", (Object[])new Object[]{ioParent.getPath()}));
        }
        File ioTarget = new File(ioParent, copyName);
        if (ioTarget.exists()) {
            throw new IOException(VfsBundle.message((String)"target.already.exists.error", (Object[])new Object[]{ioTarget.getPath()}));
        }
        if (!this.auxCopy(file2, newParent, copyName)) {
            try {
                File ioFile = LocalFileSystemBase.convertToIOFile(file2);
                FileUtil.copyFileOrDir((File)ioFile, (File)ioTarget, (boolean)attributes.isDirectory());
            }
            catch (IOException e) {
                FileUtil.delete((File)ioTarget);
                throw e;
            }
        }
        this.auxNotifyCompleted((ThrowableConsumer<LocalFileOperationsHandler, IOException>)((ThrowableConsumer)handler2 -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "lambda$copyFile$5"));
            }
            if (newParent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "lambda$copyFile$5"));
            }
            if (copyName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyName", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "lambda$copyFile$5"));
            }
            handler2.copy(file2, newParent, copyName);
        }));
        FakeVirtualFile fakeVirtualFile = new FakeVirtualFile(newParent, copyName);
        if (fakeVirtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "copyFile"));
        }
        return fakeVirtualFile;
    }

    public void setTimeStamp(@NotNull VirtualFile file2, long timeStamp) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "setTimeStamp"));
        }
        File ioFile = LocalFileSystemBase.convertToIOFile(file2);
        if (ioFile.exists() && !ioFile.setLastModified(timeStamp)) {
            LOG.warn("Failed: " + file2.getPath() + ", new:" + timeStamp + ", old:" + ioFile.lastModified());
        }
    }

    public void setWritable(@NotNull VirtualFile file2, boolean writableFlag) throws IOException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "setWritable"));
        }
        String path = FileUtil.toSystemDependentName((String)file2.getPath());
        FileUtil.setReadOnlyAttribute((String)path, (!writableFlag ? 1 : 0) != 0);
        if (FileUtil.canWrite((String)path) != writableFlag) {
            throw new IOException("Failed to change read-only flag for " + path);
        }
    }

    private static void sortRootsLongestFirst(List<String> persistentFsRoots) {
        Collections.sort(persistentFsRoots, (o1, o2) -> o2.length() - o1.length());
    }

    @VisibleForTesting
    public void registerCustomRootPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "registerCustomRootPath"));
        }
        ourRootPaths.add(path);
        LocalFileSystemBase.sortRootsLongestFirst(ourRootPaths);
    }

    @NotNull
    protected String extractRootPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "extractRootPath"));
        }
        if (path.isEmpty()) {
            String string;
            try {
                string = this.extractRootPath(new File("").getCanonicalPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "extractRootPath"));
            }
            return string;
        }
        for (String customRootPath : ourRootPaths) {
            if (!path.startsWith(customRootPath)) continue;
            String string = customRootPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "extractRootPath"));
            }
            return string;
        }
        if (SystemInfo.isWindows) {
            if (path.length() >= 2 && path.charAt(1) == ':') {
                String string = path.substring(0, 2).toUpperCase(Locale.US);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "extractRootPath"));
                }
                return string;
            }
            if (path.startsWith("//") || path.startsWith("\\\\")) {
                int idx;
                int slashCount = 0;
                for (idx = 2; idx < path.length() && slashCount < 2; ++idx) {
                    char c = path.charAt(idx);
                    if (c != '\\' && c != '/') continue;
                    ++slashCount;
                    --idx;
                }
                String string = path.substring(0, idx);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "extractRootPath"));
                }
                return string;
            }
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "extractRootPath"));
            }
            return "";
        }
        String string = StringUtil.startsWithChar((CharSequence)path, (char)'/') ? "/" : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "extractRootPath"));
        }
        return string;
    }

    public int getRank() {
        return 1;
    }

    public boolean markNewFilesAsDirty() {
        return true;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public String getCanonicallyCasedName(@NotNull VirtualFile file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[FORLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FileAttributes getAttributes(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase", "getAttributes"));
        }
        String path = this.normalize(file2.getPath());
        if (path == null) {
            return null;
        }
        if (file2.getParent() == null && path.startsWith("//")) {
            return FAKE_ROOT_ATTRIBUTES;
        }
        return FileSystemUtil.getAttributes((String)FileUtil.toSystemDependentName((String)path));
    }

    public void refresh(boolean asynchronous) {
        RefreshQueue.getInstance().refresh(asynchronous, true, null, ManagingFS.getInstance().getRoots((NewVirtualFileSystem)this));
    }
}

