/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.FrequentEventDetector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.newvfs.RefreshProgress;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.openapi.vfs.newvfs.RefreshSessionImpl;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.io.storage.HeavyProcessLatch;
import gnu.trove.TLongObjectHashMap;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class RefreshQueueImpl
extends RefreshQueue
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.newvfs.RefreshQueueImpl");
    private final ExecutorService myQueue = new BoundedTaskExecutor("RefreshQueue pool", (Executor)PooledThreadExecutor.INSTANCE, 1, (Disposable)this);
    private final ProgressIndicator myRefreshIndicator = RefreshProgress.create(VfsBundle.message((String)"file.synchronize.progress", (Object[])new Object[0]));
    private final TLongObjectHashMap<RefreshSession> mySessions = new TLongObjectHashMap();
    private final FrequentEventDetector myEventCounter = new FrequentEventDetector(100, 100, FrequentEventDetector.Level.WARN);

    public void execute(@NotNull RefreshSessionImpl session2) {
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/openapi/vfs/newvfs/RefreshQueueImpl", "execute"));
        }
        if (session2.isAsynchronous()) {
            this.queueSession(session2, session2.getTransaction());
        } else {
            Application app = ApplicationManager.getApplication();
            if (app.isDispatchThread()) {
                ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
                this.doScan(session2);
                session2.fireEvents();
            } else {
                if (((ApplicationEx)app).holdsReadLock()) {
                    LOG.error("Do not call synchronous refresh under read lock (except from EDT) - this will cause a deadlock if there are any events to fire.");
                    return;
                }
                this.queueSession(session2, TransactionGuard.getInstance().getContextTransaction());
                session2.waitFor();
            }
        }
    }

    private void queueSession(@NotNull RefreshSessionImpl session2, @Nullable TransactionId transaction) {
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/openapi/vfs/newvfs/RefreshQueueImpl", "queueSession"));
        }
        this.myQueue.submit(() -> {
            if (session2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/openapi/vfs/newvfs/RefreshQueueImpl", "lambda$queueSession$0"));
            }
            this.myRefreshIndicator.start();
            try (AccessToken ignored = HeavyProcessLatch.INSTANCE.processStarted("Doing file refresh. " + (Object)((Object)session2));){
                this.doScan(session2);
            }
            finally {
                this.myRefreshIndicator.stop();
                TransactionGuard.getInstance().submitTransaction((Disposable)ApplicationManager.getApplication(), transaction, session2::fireEvents);
            }
        });
        this.myEventCounter.eventHappened((Object)session2);
    }

    private void doScan(RefreshSessionImpl session2) {
        try {
            this.updateSessionMap(session2, true);
            session2.scan();
        }
        finally {
            this.updateSessionMap(session2, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSessionMap(RefreshSession session2, boolean add) {
        long id = session2.getId();
        if (id != 0L) {
            TLongObjectHashMap<RefreshSession> tLongObjectHashMap = this.mySessions;
            synchronized (tLongObjectHashMap) {
                if (add) {
                    this.mySessions.put(id, (Object)session2);
                } else {
                    this.mySessions.remove(id);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelSession(long id) {
        RefreshSession session2;
        TLongObjectHashMap<RefreshSession> tLongObjectHashMap = this.mySessions;
        synchronized (tLongObjectHashMap) {
            session2 = (RefreshSession)this.mySessions.get(id);
        }
        if (session2 instanceof RefreshSessionImpl) {
            ((RefreshSessionImpl)session2).cancel();
        }
    }

    @NotNull
    public RefreshSession createSession(boolean async, boolean recursively, @Nullable Runnable finishRunnable, @NotNull ModalityState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/vfs/newvfs/RefreshQueueImpl", "createSession"));
        }
        RefreshSessionImpl refreshSessionImpl = new RefreshSessionImpl(async, recursively, finishRunnable, ((TransactionGuardImpl)TransactionGuard.getInstance()).getModalityTransaction(state));
        if (refreshSessionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/RefreshQueueImpl", "createSession"));
        }
        return refreshSessionImpl;
    }

    public void processSingleEvent(@NotNull VFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/newvfs/RefreshQueueImpl", "processSingleEvent"));
        }
        new RefreshSessionImpl(Collections.singletonList(event)).launch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRefreshInProgress() {
        RefreshQueueImpl refreshQueue = (RefreshQueueImpl)RefreshQueue.getInstance();
        TLongObjectHashMap<RefreshSession> tLongObjectHashMap = refreshQueue.mySessions;
        synchronized (tLongObjectHashMap) {
            return !refreshQueue.mySessions.isEmpty();
        }
    }

    public void dispose() {
    }
}

