/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.persistent.LocalFileSystemRefreshWorker;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.util.containers.Queue;
import com.intellij.util.text.FilePathHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefreshWorker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.newvfs.persistent.RefreshWorker");
    private static final Logger LOG_ATTRIBUTES = Logger.getInstance((String)"#com.intellij.openapi.vfs.newvfs.persistent.RefreshWorker_Attributes");
    private final boolean myIsRecursive;
    private final Queue<Pair<NewVirtualFile, FileAttributes>> myRefreshQueue;
    private final List<VFileEvent> myEvents;
    private volatile boolean myCancelled;
    private final LocalFileSystemRefreshWorker myLocalFileSystemRefreshWorker;
    private static Function<VirtualFile, Boolean> ourCancellingCondition;

    public RefreshWorker(@NotNull NewVirtualFile refreshRoot, boolean isRecursive) {
        if (refreshRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refreshRoot", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "<init>"));
        }
        this.myRefreshQueue = new Queue(100);
        this.myEvents = new ArrayList<VFileEvent>();
        boolean canUseNioRefresher = refreshRoot.isInLocalFileSystem() && !(refreshRoot.getFileSystem() instanceof TempFileSystem);
        this.myLocalFileSystemRefreshWorker = canUseNioRefresher && Registry.is((String)"vfs.use.nio-based.local.refresh.worker") ? new LocalFileSystemRefreshWorker(refreshRoot, isRecursive) : null;
        this.myIsRecursive = isRecursive;
        this.myRefreshQueue.addLast((Object)Pair.pair((Object)refreshRoot, null));
    }

    @NotNull
    public List<VFileEvent> getEvents() {
        if (this.myLocalFileSystemRefreshWorker != null) {
            List<VFileEvent> list2 = this.myLocalFileSystemRefreshWorker.getEvents();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "getEvents"));
            }
            return list2;
        }
        List<VFileEvent> list3 = this.myEvents;
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "getEvents"));
        }
        return list3;
    }

    public void cancel() {
        if (this.myLocalFileSystemRefreshWorker != null) {
            this.myLocalFileSystemRefreshWorker.cancel();
        }
        this.myCancelled = true;
    }

    public void scan() {
        if (this.myLocalFileSystemRefreshWorker != null) {
            this.myLocalFileSystemRefreshWorker.scan();
            return;
        }
        NewVirtualFile root = (NewVirtualFile)((Pair)this.myRefreshQueue.peekFirst()).first;
        NewVirtualFileSystem fs = root.getFileSystem();
        if (root.isDirectory()) {
            fs = PersistentFS.replaceWithNativeFS(fs);
        }
        try {
            this.processQueue(fs, PersistentFS.getInstance());
        }
        catch (RefreshCancelledException e) {
            LOG.debug("refresh cancelled");
        }
    }

    private void processQueue(NewVirtualFileSystem fs, PersistentFS persistence) throws RefreshCancelledException {
        TObjectHashingStrategy strategy = FilePathHashingStrategy.create((boolean)fs.isCaseSensitive());
        while (!this.myRefreshQueue.isEmpty()) {
            boolean upToDateHidden;
            boolean currentHidden;
            FileAttributes attributes;
            Pair pair2 = (Pair)this.myRefreshQueue.pullFirst();
            NewVirtualFile file2 = (NewVirtualFile)pair2.first;
            boolean fileDirty = file2.isDirty();
            if (LOG.isTraceEnabled()) {
                LOG.trace("file=" + file2 + " dirty=" + fileDirty);
            }
            if (!fileDirty) continue;
            this.checkCancelled(file2);
            FileAttributes fileAttributes = attributes = pair2.second != null ? (FileAttributes)pair2.second : fs.getAttributes((VirtualFile)file2);
            if (attributes == null) {
                this.scheduleDeletion((VirtualFile)file2);
                file2.markClean();
                continue;
            }
            NewVirtualFile parent = file2.getParent();
            if (parent != null && this.checkAndScheduleFileTypeChange((VirtualFile)parent, (VirtualFile)file2, attributes)) {
                file2.markClean();
                continue;
            }
            if (file2.isDirectory()) {
                boolean fullSync = ((VirtualDirectoryImpl)file2).allChildrenLoaded();
                if (fullSync) {
                    this.fullDirRefresh(fs, persistence, (TObjectHashingStrategy<String>)strategy, (VirtualDirectoryImpl)file2);
                } else {
                    this.partialDirRefresh(fs, (TObjectHashingStrategy<String>)strategy, (VirtualDirectoryImpl)file2);
                }
            } else {
                long currentTimestamp = persistence.getTimeStamp((VirtualFile)file2);
                long upToDateTimestamp = attributes.lastModified;
                long currentLength = persistence.getLastRecordedLength((VirtualFile)file2);
                long upToDateLength = attributes.length;
                if (currentTimestamp != upToDateTimestamp || currentLength != upToDateLength) {
                    this.scheduleUpdateContent((VirtualFile)file2);
                }
            }
            boolean currentWritable = persistence.isWritable((VirtualFile)file2);
            boolean upToDateWritable = attributes.isWritable();
            if (LOG_ATTRIBUTES.isDebugEnabled()) {
                LOG_ATTRIBUTES.debug("file=" + file2 + " writable vfs=" + file2.isWritable() + " persistence=" + currentWritable + " real=" + upToDateWritable);
            }
            if (currentWritable != upToDateWritable) {
                this.scheduleAttributeChange((VirtualFile)file2, "writable", currentWritable, upToDateWritable);
            }
            if (SystemInfo.isWindows && (currentHidden = file2.is(VFileProperty.HIDDEN)) != (upToDateHidden = attributes.isHidden())) {
                this.scheduleAttributeChange((VirtualFile)file2, VirtualFile.PROP_HIDDEN, currentHidden, upToDateHidden);
            }
            if (attributes.isSymLink()) {
                String upToDateVfsTarget;
                String currentTarget = file2.getCanonicalPath();
                String upToDateTarget = fs.resolveSymLink((VirtualFile)file2);
                String string = upToDateVfsTarget = upToDateTarget != null ? FileUtil.toSystemIndependentName((String)upToDateTarget) : null;
                if (!Comparing.equal((String)currentTarget, (String)upToDateVfsTarget)) {
                    this.scheduleAttributeChange((VirtualFile)file2, "symlink", currentTarget, upToDateVfsTarget);
                }
            }
            if (!this.myIsRecursive && file2.isDirectory()) continue;
            file2.markClean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void fullDirRefresh(NewVirtualFileSystem fs, PersistentFS persistence, TObjectHashingStrategy<String> strategy, VirtualDirectoryImpl dir) {
        while (true) {
            void children2;
            Object[] currentNames;
            AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
            try {
                currentNames = persistence.list((VirtualFile)dir);
                VirtualFile[] children22 = dir.getChildren();
            }
            finally {
                token.finish();
            }
            Object[] upToDateNames = VfsUtil.filterNames((String[])fs.list((VirtualFile)dir));
            THashSet newNames = ContainerUtil.newTroveSet(strategy, (Object[])upToDateNames);
            ContainerUtil.removeAll((Collection)newNames, (Object[])currentNames);
            THashSet deletedNames = ContainerUtil.newTroveSet(strategy, (Object[])currentNames);
            ContainerUtil.removeAll((Collection)deletedNames, (Object[])upToDateNames);
            OpenTHashSet actualNames = null;
            if (!fs.isCaseSensitive()) {
                actualNames = new OpenTHashSet(strategy, upToDateNames);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("current=" + Arrays.toString(currentNames) + " +" + newNames + " -" + deletedNames);
            }
            ArrayList addedMap = ContainerUtil.newArrayListWithCapacity((int)newNames.size());
            for (String name2 : newNames) {
                this.checkCancelled(dir);
                addedMap.add(Pair.pair((Object)name2, (Object)fs.getAttributes((VirtualFile)new FakeVirtualFile((VirtualFile)dir, name2))));
            }
            ArrayList updatedMap = ContainerUtil.newArrayListWithCapacity((int)((void)children2).length);
            for (void var17_24 : children2) {
                if (deletedNames.contains(var17_24.getName())) continue;
                this.checkCancelled(dir);
                updatedMap.add(Pair.pair((Object)var17_24, (Object)fs.getAttributes((VirtualFile)var17_24)));
            }
            token = ApplicationManager.getApplication().acquireReadActionLock();
            try {
                if (!Arrays.equals(currentNames, persistence.list((VirtualFile)dir)) || !Arrays.equals((Object[])children2, dir.getChildren())) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("retry: " + (Object)((Object)dir));
                    continue;
                }
                for (String name3 : deletedNames) {
                    this.scheduleDeletion((VirtualFile)dir.findChild(name3));
                }
                for (Pair pair2 : addedMap) {
                    String name4 = (String)pair2.first;
                    FileAttributes fileAttributes = (FileAttributes)pair2.second;
                    if (fileAttributes != null) {
                        this.scheduleCreation((VirtualFile)dir, name4, fileAttributes.isDirectory(), false);
                        continue;
                    }
                    LOG.warn("[+] fs=" + fs + " dir=" + (Object)((Object)dir) + " name=" + name4);
                }
                for (Pair pair3 : updatedMap) {
                    VirtualFile child = (VirtualFile)pair3.first;
                    FileAttributes fileAttributes = (FileAttributes)pair3.second;
                    if (fileAttributes != null) {
                        this.checkAndScheduleChildRefresh((VirtualFile)dir, child, fileAttributes);
                        this.checkAndScheduleFileNameChange((OpenTHashSet<String>)actualNames, child);
                        continue;
                    }
                    LOG.warn("[x] fs=" + fs + " dir=" + (Object)((Object)dir) + " name=" + child.getName());
                    this.scheduleDeletion(child);
                }
            }
            finally {
                token.finish();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void partialDirRefresh(NewVirtualFileSystem fs, TObjectHashingStrategy<String> strategy, VirtualDirectoryImpl dir) {
        while (true) {
            List<String> wanted;
            Collection cached;
            AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
            try {
                cached = dir.getCachedChildren();
                wanted = dir.getSuspiciousNames();
            }
            finally {
                token.finish();
            }
            OpenTHashSet actualNames = null;
            if (!fs.isCaseSensitive()) {
                actualNames = new OpenTHashSet(strategy, (Object[])VfsUtil.filterNames((String[])fs.list((VirtualFile)dir)));
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("cached=" + cached + " actual=" + actualNames);
                LOG.trace("suspicious=" + wanted);
            }
            ArrayList existingMap = ContainerUtil.newArrayListWithCapacity((int)cached.size());
            for (VirtualFile child : cached) {
                this.checkCancelled(dir);
                existingMap.add(Pair.pair((Object)child, (Object)fs.getAttributes(child)));
            }
            ArrayList wantedMap = ContainerUtil.newArrayListWithCapacity((int)wanted.size());
            for (String name2 : wanted) {
                if (name2.isEmpty()) continue;
                this.checkCancelled(dir);
                wantedMap.add(Pair.pair((Object)name2, (Object)fs.getAttributes((VirtualFile)new FakeVirtualFile((VirtualFile)dir, name2))));
            }
            token = ApplicationManager.getApplication().acquireReadActionLock();
            try {
                FileAttributes childAttributes;
                if (!cached.equals(dir.getCachedChildren()) || !wanted.equals(dir.getSuspiciousNames())) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("retry: " + (Object)((Object)dir));
                    continue;
                }
                for (Pair pair2 : existingMap) {
                    VirtualFile child = (VirtualFile)pair2.first;
                    childAttributes = (FileAttributes)pair2.second;
                    if (childAttributes != null) {
                        this.checkAndScheduleChildRefresh((VirtualFile)dir, child, childAttributes);
                        this.checkAndScheduleFileNameChange((OpenTHashSet<String>)actualNames, child);
                        continue;
                    }
                    this.scheduleDeletion(child);
                }
                for (Pair pair2 : wantedMap) {
                    String name3 = (String)pair2.first;
                    childAttributes = (FileAttributes)pair2.second;
                    if (childAttributes == null) continue;
                    this.scheduleCreation((VirtualFile)dir, name3, childAttributes.isDirectory(), false);
                }
            }
            finally {
                token.finish();
                continue;
            }
            break;
        }
    }

    private void checkAndScheduleFileNameChange(@Nullable OpenTHashSet<String> actualNames, VirtualFile child) {
        String currentName;
        String actualName;
        if (actualNames != null && (actualName = (String)actualNames.get((Object)(currentName = child.getName()))) != null && !currentName.equals(actualName)) {
            this.scheduleAttributeChange(child, "name", currentName, actualName);
        }
    }

    private void checkCancelled(@NotNull NewVirtualFile stopAt) {
        if (stopAt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stopAt", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "checkCancelled"));
        }
        if (this.myCancelled || ourCancellingCondition != null && ((Boolean)ourCancellingCondition.fun((Object)stopAt)).booleanValue()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("cancelled at: " + stopAt);
            }
            RefreshWorker.forceMarkDirty(stopAt);
            while (!this.myRefreshQueue.isEmpty()) {
                NewVirtualFile next = (NewVirtualFile)((Pair)this.myRefreshQueue.pullFirst()).first;
                RefreshWorker.forceMarkDirty(next);
            }
            throw new RefreshCancelledException();
        }
    }

    private static void forceMarkDirty(NewVirtualFile file2) {
        file2.markClean();
        file2.markDirty();
    }

    private void checkAndScheduleChildRefresh(@NotNull VirtualFile parent, @NotNull VirtualFile child, @NotNull FileAttributes childAttributes) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "checkAndScheduleChildRefresh"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "checkAndScheduleChildRefresh"));
        }
        if (childAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childAttributes", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "checkAndScheduleChildRefresh"));
        }
        if (!this.checkAndScheduleFileTypeChange(parent, child, childAttributes)) {
            boolean upToDateIsDirectory = childAttributes.isDirectory();
            if (this.myIsRecursive || !upToDateIsDirectory) {
                this.myRefreshQueue.addLast((Object)Pair.pair((Object)((NewVirtualFile)child), (Object)childAttributes));
            }
        }
    }

    private boolean checkAndScheduleFileTypeChange(@NotNull VirtualFile parent, @NotNull VirtualFile child, @NotNull FileAttributes childAttributes) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "checkAndScheduleFileTypeChange"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "checkAndScheduleFileTypeChange"));
        }
        if (childAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childAttributes", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "checkAndScheduleFileTypeChange"));
        }
        boolean currentIsDirectory = child.isDirectory();
        boolean currentIsSymlink = child.is(VFileProperty.SYMLINK);
        boolean currentIsSpecial = child.is(VFileProperty.SPECIAL);
        boolean upToDateIsDirectory = childAttributes.isDirectory();
        boolean upToDateIsSymlink = childAttributes.isSymLink();
        boolean upToDateIsSpecial = childAttributes.isSpecial();
        if (currentIsDirectory != upToDateIsDirectory || currentIsSymlink != upToDateIsSymlink || currentIsSpecial != upToDateIsSpecial) {
            this.scheduleDeletion(child);
            this.scheduleCreation(parent, child.getName(), upToDateIsDirectory, true);
            return true;
        }
        return false;
    }

    private void scheduleAttributeChange(@NotNull VirtualFile file2, @NotNull String property, Object current, Object upToDate) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "scheduleAttributeChange"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "scheduleAttributeChange"));
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("update '" + property + "' file=" + file2);
        }
        this.myEvents.add((VFileEvent)new VFilePropertyChangeEvent(null, file2, property, current, upToDate, true));
    }

    private void scheduleUpdateContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "scheduleUpdateContent"));
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("update file=" + file2);
        }
        this.myEvents.add((VFileEvent)new VFileContentChangeEvent(null, file2, file2.getModificationStamp(), -1L, true));
    }

    private void scheduleCreation(@NotNull VirtualFile parent, @NotNull String childName, boolean isDirectory, boolean isReCreation) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "scheduleCreation"));
        }
        if (childName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childName", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "scheduleCreation"));
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("create parent=" + parent + " name=" + childName + " dir=" + isDirectory);
        }
        this.myEvents.add((VFileEvent)new VFileCreateEvent(null, parent, childName, isDirectory, true, isReCreation));
    }

    private void scheduleDeletion(@Nullable VirtualFile file2) {
        if (file2 != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("delete file=" + file2);
            }
            this.myEvents.add((VFileEvent)new VFileDeleteEvent(null, file2, true));
        }
    }

    public static void setCancellingCondition(@Nullable Function<VirtualFile, Boolean> condition2) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        LocalFileSystemRefreshWorker.setCancellingCondition(condition2);
        ourCancellingCondition = condition2;
    }

    private static class RefreshCancelledException
    extends RuntimeException {
        private RefreshCancelledException() {
        }
    }
}

