/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.CloseAction;
import com.intellij.ide.actions.ShowContentAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ComboContentLayout;
import com.intellij.openapi.wm.impl.content.ContentLayout;
import com.intellij.openapi.wm.impl.content.TabContentLayout;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.TabbedContent;
import com.intellij.ui.content.tabs.PinToolwindowTabAction;
import com.intellij.ui.content.tabs.TabbedContentAction;
import com.intellij.util.Alarm;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolWindowContentUi
extends JPanel
implements ContentUI,
PropertyChangeListener,
DataProvider {
    public static final String POPUP_PLACE = "ToolwindowPopup";
    public static final String HIDE_ID_LABEL = "HideIdLabel";
    ContentManager myManager;
    final JPanel myContent = new JPanel(new BorderLayout());
    ToolWindowImpl myWindow;
    TabbedContentAction.CloseAllAction myCloseAllAction;
    TabbedContentAction.MyNextTabAction myNextTabAction;
    TabbedContentAction.MyPreviousTabAction myPreviousTabAction;
    ShowContentAction myShowContent;
    ContentLayout myTabsLayout = new TabContentLayout(this);
    ContentLayout myComboLayout = new ComboContentLayout(this);
    private ToolWindowContentUiType myType = ToolWindowContentUiType.TABBED;
    private boolean myShouldNotShowPopup;

    public ToolWindowContentUi(ToolWindowImpl window) {
        this.myWindow = window;
        this.myContent.setOpaque(false);
        this.myContent.setFocusable(false);
        this.setOpaque(false);
        this.myShowContent = new ShowContentAction(this.myWindow, this.myContent);
        this.setBorder(new EmptyBorder(0, 0, 0, 2));
        UIUtil.putClientProperty((JComponent)this, (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, (Object)new Iterable<JComponent>(){

            @Override
            public Iterator<JComponent> iterator() {
                if (ToolWindowContentUi.this.myManager == null || ToolWindowContentUi.this.myManager.getContentCount() == 0) {
                    return EmptyIterator.getInstance();
                }
                return JBIterable.of((Object[])ToolWindowContentUi.this.myManager.getContents()).map(content -> {
                    JComponent last = null;
                    for (Component c : UIUtil.uiParents((Component)content.getComponent(), (boolean)false)) {
                        if (c == ToolWindowContentUi.this.myManager.getComponent() || !(c instanceof JComponent)) {
                            return null;
                        }
                        last = (JComponent)c;
                    }
                    return last;
                }).filter(Conditions.notNull()).iterator();
            }
        });
    }

    public void setType(@NotNull ToolWindowContentUiType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/content/ToolWindowContentUi", "setType"));
        }
        if (this.myType != type2) {
            if (this.myType != null) {
                this.getCurrentLayout().reset();
            }
            this.myType = type2;
            this.getCurrentLayout().init();
            this.rebuild();
        }
    }

    private ContentLayout getCurrentLayout() {
        assert (this.myManager != null);
        return this.myType == ToolWindowContentUiType.TABBED ? this.myTabsLayout : this.myComboLayout;
    }

    public JComponent getComponent() {
        return this.myContent;
    }

    public JComponent getTabComponent() {
        return this;
    }

    public void setManager(@NotNull ContentManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/openapi/wm/impl/content/ToolWindowContentUi", "setManager"));
        }
        if (this.myManager != null) {
            this.getCurrentLayout().reset();
        }
        this.myManager = manager;
        this.getCurrentLayout().init();
        this.myManager.addContentManagerListener(new ContentManagerListener(){

            public void contentAdded(ContentManagerEvent event) {
                ToolWindowContentUi.this.getCurrentLayout().contentAdded(event);
                event.getContent().addPropertyChangeListener((PropertyChangeListener)ToolWindowContentUi.this);
                ToolWindowContentUi.this.rebuild();
            }

            public void contentRemoved(ContentManagerEvent event) {
                event.getContent().removePropertyChangeListener((PropertyChangeListener)ToolWindowContentUi.this);
                ToolWindowContentUi.this.getCurrentLayout().contentRemoved(event);
                ToolWindowContentUi.this.ensureSelectedContentVisible();
                ToolWindowContentUi.this.rebuild();
            }

            public void contentRemoveQuery(ContentManagerEvent event) {
            }

            public void selectionChanged(ContentManagerEvent event) {
                ToolWindowContentUi.this.ensureSelectedContentVisible();
                ToolWindowContentUi.this.update();
                ToolWindowContentUi.this.myContent.revalidate();
                ToolWindowContentUi.this.myContent.repaint();
            }
        });
        ToolWindowContentUi.initMouseListeners(this, this);
        this.rebuild();
        this.myCloseAllAction = new TabbedContentAction.CloseAllAction(this.myManager);
        this.myNextTabAction = new TabbedContentAction.MyNextTabAction(this.myManager);
        this.myPreviousTabAction = new TabbedContentAction.MyPreviousTabAction(this.myManager);
    }

    private void ensureSelectedContentVisible() {
        Component visible;
        Content selected = this.myManager.getSelectedContent();
        if (selected == null) {
            this.myContent.removeAll();
            return;
        }
        if (this.myContent.getComponentCount() == 1 && (visible = this.myContent.getComponent(0)) == selected.getComponent()) {
            return;
        }
        this.myContent.removeAll();
        this.myContent.add((Component)selected.getComponent(), "Center");
        this.myContent.revalidate();
        this.myContent.repaint();
    }

    private void rebuild() {
        this.getCurrentLayout().rebuild();
        this.getCurrentLayout().update();
        this.revalidate();
        this.repaint();
        if (this.myManager.getContentCount() == 0 && this.myWindow.isToHideOnEmptyContent()) {
            this.myWindow.hide(null);
        }
    }

    @Override
    public void doLayout() {
        this.getCurrentLayout().layout();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.getCurrentLayout().paintComponent(g);
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        this.getCurrentLayout().paintChildren(g);
    }

    @Override
    public Dimension getMinimumSize() {
        Insets insets = this.getInsets();
        return new Dimension(insets.left + insets.right + this.getCurrentLayout().getMinimumWidth(), super.getMinimumSize().height);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.height = 0;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component each = this.getComponent(i);
            size.height = Math.max(each.getPreferredSize().height, size.height);
        }
        return size;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.update();
    }

    private void update() {
        this.getCurrentLayout().update();
        this.revalidate();
        this.repaint();
    }

    public boolean isSingleSelection() {
        return true;
    }

    public boolean isToSelectAddedContent() {
        return false;
    }

    public boolean canBeEmptySelection() {
        return false;
    }

    public void beforeDispose() {
    }

    public boolean canChangeSelectionTo(@NotNull Content content, boolean implicit) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/wm/impl/content/ToolWindowContentUi", "canChangeSelectionTo"));
        }
        return true;
    }

    @NotNull
    public String getCloseActionName() {
        String string = this.getCurrentLayout().getCloseActionName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/content/ToolWindowContentUi", "getCloseActionName"));
        }
        return string;
    }

    @NotNull
    public String getCloseAllButThisActionName() {
        String string = this.getCurrentLayout().getCloseAllButThisActionName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/content/ToolWindowContentUi", "getCloseAllButThisActionName"));
        }
        return string;
    }

    @NotNull
    public String getPreviousContentActionName() {
        String string = this.getCurrentLayout().getPreviousContentActionName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/content/ToolWindowContentUi", "getPreviousContentActionName"));
        }
        return string;
    }

    @NotNull
    public String getNextContentActionName() {
        String string = this.getCurrentLayout().getNextContentActionName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/content/ToolWindowContentUi", "getNextContentActionName"));
        }
        return string;
    }

    public static void initMouseListeners(final JComponent c, final ToolWindowContentUi ui) {
        if (c.getClientProperty(ui) != null) {
            return;
        }
        final Point[] myLastPoint = new Point[1];
        c.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (myLastPoint[0] == null) {
                    return;
                }
                Window window = SwingUtilities.windowForComponent(c);
                if (window instanceof IdeFrame) {
                    return;
                }
                Point windowLocation = window.getLocationOnScreen();
                PointerInfo info = MouseInfo.getPointerInfo();
                if (info == null) {
                    return;
                }
                Point newPoint = info.getLocation();
                Point p = myLastPoint[0];
                windowLocation.translate(newPoint.x - p.x, newPoint.y - p.y);
                window.setLocation(windowLocation);
                myLastPoint[0] = newPoint;
            }
        });
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PointerInfo info = MouseInfo.getPointerInfo();
                Point point = myLastPoint[0] = info != null ? info.getLocation() : e.getLocationOnScreen();
                if (!e.isPopupTrigger() && !UIUtil.isCloseClick((MouseEvent)e)) {
                    ui.myWindow.fireActivated();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!e.isPopupTrigger() && UIUtil.isCloseClick((MouseEvent)e, (int)502)) {
                    ui.processHide(e);
                }
            }
        });
        c.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                Content content = c instanceof BaseLabel ? ((BaseLabel)c).getContent() : null;
                ui.showContextMenu(comp, x, y, ui.myWindow.getPopupGroup(), content);
            }
        });
        c.putClientProperty(ui, Boolean.TRUE);
    }

    private void initActionGroup(DefaultActionGroup group, Content content) {
        String groupName;
        if (content == null) {
            return;
        }
        group.addSeparator();
        group.add((AnAction)new TabbedContentAction.CloseAction(content));
        group.add((AnAction)this.myCloseAllAction);
        group.add((AnAction)new TabbedContentAction.CloseAllButThisAction(content));
        group.addSeparator();
        if (content.isPinnable()) {
            group.add(PinToolwindowTabAction.getPinAction());
            group.addSeparator();
        }
        group.add((AnAction)this.myNextTabAction);
        group.add((AnAction)this.myPreviousTabAction);
        group.add((AnAction)this.myShowContent);
        if (content instanceof TabbedContent && ((TabbedContent)content).getTabs().size() > 1) {
            group.addAction(ToolWindowContentUi.createSplitTabsAction((TabbedContent)content));
        }
        if (Boolean.TRUE == content.getUserData(Content.TABBED_CONTENT_KEY) && (groupName = (String)content.getUserData(Content.TAB_GROUP_NAME_KEY)) != null) {
            group.addAction(ToolWindowContentUi.createMergeTabsAction(this.myManager, groupName));
        }
        group.addSeparator();
    }

    public void showContextMenu(Component comp, int x, int y, ActionGroup toolWindowGroup, @Nullable Content selectedContent) {
        if (selectedContent == null && toolWindowGroup == null) {
            return;
        }
        DefaultActionGroup group = new DefaultActionGroup();
        if (selectedContent != null) {
            this.initActionGroup(group, selectedContent);
        }
        if (toolWindowGroup != null) {
            group.addAll(toolWindowGroup);
        }
        ActionPopupMenu popupMenu = ((ActionManagerImpl)ActionManager.getInstance()).createActionPopupMenu(POPUP_PLACE, (ActionGroup)group, new MenuItemPresentationFactory(true));
        popupMenu.getComponent().show(comp, x, y);
    }

    private static AnAction createSplitTabsAction(final TabbedContent content) {
        return new DumbAwareAction("Split '" + content.getTitlePrefix() + "' group"){

            public void actionPerformed(AnActionEvent e) {
                content.split();
            }
        };
    }

    private static AnAction createMergeTabsAction(final ContentManager manager, final String tabPrefix) {
        return new DumbAwareAction("Merge tabs to '" + tabPrefix + "' group"){

            public void actionPerformed(AnActionEvent e) {
                Content selectedContent = manager.getSelectedContent();
                ArrayList<Pair> tabs = new ArrayList<Pair>();
                int selectedTab = -1;
                ArrayList mergedContent = ContainerUtil.newArrayList();
                for (Content content : manager.getContents()) {
                    if (!tabPrefix.equals(content.getUserData(Content.TAB_GROUP_NAME_KEY))) continue;
                    String label = content.getTabName().substring(tabPrefix.length() + 2);
                    JComponent component = content.getComponent();
                    if (content == selectedContent) {
                        selectedTab = tabs.size();
                    }
                    tabs.add(Pair.create((Object)label, (Object)component));
                    manager.removeContent(content, false);
                    content.setComponent(null);
                    content.setShouldDisposeContent(false);
                    mergedContent.add(content);
                }
                PropertiesComponent.getInstance().unsetValue("tabbed.toolwindow.expanded." + tabPrefix);
                for (int i = 0; i < tabs.size(); ++i) {
                    Pair tab = (Pair)tabs.get(i);
                    ContentUtilEx.addTabbedContent(manager, (JComponent)tab.second, tabPrefix, (String)tab.first, i == selectedTab);
                }
                mergedContent.forEach(Disposer::dispose);
            }
        };
    }

    private void processHide(MouseEvent e) {
        IdeEventQueue.getInstance().blockNextEvents(e);
        Component c = e.getComponent();
        if (c instanceof BaseLabel) {
            BaseLabel tab = (BaseLabel)c;
            if (tab.getContent() != null) {
                if (this.myManager.canCloseContents() && tab.getContent().isCloseable()) {
                    this.myManager.removeContent(tab.getContent(), true, true, true);
                } else if (this.myManager.getContentCount() == 1) {
                    this.hideWindow(e);
                }
            } else {
                this.hideWindow(e);
            }
        } else {
            this.hideWindow(e);
        }
    }

    private void hideWindow(MouseEvent e) {
        if (e.isControlDown()) {
            this.myWindow.fireHiddenSide();
        } else {
            this.myWindow.fireHidden();
        }
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.TOOL_WINDOW.is(dataId)) {
            return this.myWindow;
        }
        if (CloseAction.CloseTarget.KEY.is(dataId)) {
            return this.computeCloseTarget();
        }
        return null;
    }

    private CloseAction.CloseTarget computeCloseTarget() {
        Content selected;
        if (this.myManager.canCloseContents() && (selected = this.myManager.getSelectedContent()) != null && selected.isCloseable()) {
            return new CloseContentTarget(selected);
        }
        return new HideToolwindowTarget();
    }

    public void dispose() {
        this.myContent.removeAll();
    }

    boolean isCurrent(ContentLayout layout) {
        return this.getCurrentLayout() == layout;
    }

    public void toggleContentPopup() {
        if (this.myShouldNotShowPopup) {
            this.myShouldNotShowPopup = false;
            return;
        }
        Ref selected = Ref.create();
        Ref selectedTab = Ref.create();
        Content[] contents = this.myManager.getContents();
        Content selectedContent = this.myManager.getSelectedContent();
        AnAction[] actions = new AnAction[contents.length];
        for (int i = 0; i < actions.length; ++i) {
            final Content content = contents[i];
            if (content instanceof TabbedContent) {
                final TabbedContent tabbedContent = (TabbedContent)content;
                List tabs = ((TabbedContent)content).getTabs();
                AnAction[] tabActions = new AnAction[tabs.size()];
                for (int j = 0; j < tabActions.length; ++j) {
                    final int index = j;
                    tabActions[j] = new DumbAwareAction((String)((Pair)tabs.get((int)index)).first){

                        public void actionPerformed(@NotNull AnActionEvent e) {
                            if (e == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/content/ToolWindowContentUi$8", "actionPerformed"));
                            }
                            ToolWindowContentUi.this.myManager.setSelectedContent((Content)tabbedContent);
                            tabbedContent.selectContent(index);
                        }
                    };
                }
                DefaultActionGroup group = new DefaultActionGroup(tabActions);
                group.getTemplatePresentation().setText(((TabbedContent)content).getTitlePrefix());
                group.setPopup(true);
                actions[i] = group;
                if (content != selectedContent) continue;
                selected.set((Object)group);
                int selectedIndex = ContentUtilEx.getSelectedTab(tabbedContent);
                if (selectedIndex == -1) continue;
                selectedTab.set((Object)tabActions[selectedIndex]);
                continue;
            }
            actions[i] = new DumbAwareAction(){
                {
                    this.getTemplatePresentation().setText(content.getTabName(), false);
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/content/ToolWindowContentUi$9", "actionPerformed"));
                    }
                    ToolWindowContentUi.this.myManager.setSelectedContent(content, true, true);
                }
            };
            if (content != selectedContent) continue;
            selected.set((Object)actions[i]);
        }
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)new DefaultActionGroup(actions), DataManager.getInstance().getDataContext((Component)this.myManager.getComponent()), false, true, true, null, -1, action -> action == selected.get() || action == selectedTab.get());
        this.getCurrentLayout().showContentPopup(popup);
        if (selectedContent instanceof TabbedContent) {
            new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)popup).addRequest(() -> popup.handleSelect(true), 30);
        }
    }

    private class CloseContentTarget
    implements CloseAction.CloseTarget {
        private Content myContent;

        private CloseContentTarget(Content content) {
            this.myContent = content;
        }

        @Override
        public void close() {
            ToolWindowContentUi.this.myManager.removeContent(this.myContent, true, true, true);
        }
    }

    private class HideToolwindowTarget
    implements CloseAction.CloseTarget {
        private HideToolwindowTarget() {
        }

        @Override
        public void close() {
            ToolWindowContentUi.this.myWindow.fireHidden();
        }
    }
}

