/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.Generator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleOutputPackagingElementBase
extends PackagingElement<ModuleOutputPackagingElementState>
implements ModuleOutputPackagingElement {
    @NonNls
    public static final String MODULE_NAME_ATTRIBUTE = "name";
    protected ModulePointer myModulePointer;
    protected final Project myProject;

    public ModuleOutputPackagingElementBase(PackagingElementType type2, Project project2, ModulePointer modulePointer) {
        super(type2);
        this.myProject = project2;
        this.myModulePointer = modulePointer;
    }

    public ModuleOutputPackagingElementBase(PackagingElementType type2, Project project2) {
        super(type2);
        this.myProject = project2;
    }

    public List<? extends Generator> computeAntInstructions(@NotNull PackagingElementResolvingContext resolvingContext, @NotNull AntCopyInstructionCreator creator, @NotNull ArtifactAntGenerationContext generationContext, @NotNull ArtifactType artifactType) {
        if (resolvingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvingContext", "com/intellij/packaging/impl/elements/ModuleOutputPackagingElementBase", "computeAntInstructions"));
        }
        if (creator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "creator", "com/intellij/packaging/impl/elements/ModuleOutputPackagingElementBase", "computeAntInstructions"));
        }
        if (generationContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generationContext", "com/intellij/packaging/impl/elements/ModuleOutputPackagingElementBase", "computeAntInstructions"));
        }
        if (artifactType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactType", "com/intellij/packaging/impl/elements/ModuleOutputPackagingElementBase", "computeAntInstructions"));
        }
        if (this.myModulePointer != null) {
            String moduleOutput = BuildProperties.propertyRef((String)this.getModuleOutputAntProperty(generationContext));
            return Collections.singletonList(creator.createDirectoryContentCopyInstruction(moduleOutput));
        }
        return Collections.emptyList();
    }

    protected abstract String getModuleOutputAntProperty(ArtifactAntGenerationContext var1);

    @Nullable
    protected abstract VirtualFile getModuleOutputPath(CompilerModuleExtension var1);

    @NotNull
    public PackagingElementOutputKind getFilesKind(PackagingElementResolvingContext context) {
        PackagingElementOutputKind packagingElementOutputKind = PackagingElementOutputKind.DIRECTORIES_WITH_CLASSES;
        if (packagingElementOutputKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/ModuleOutputPackagingElementBase", "getFilesKind"));
        }
        return packagingElementOutputKind;
    }

    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/packaging/impl/elements/ModuleOutputPackagingElementBase", "isEqualTo"));
        }
        return element.getClass() == this.getClass() && this.myModulePointer != null && this.myModulePointer.equals(((ModuleOutputPackagingElementBase)element).myModulePointer);
    }

    public ModuleOutputPackagingElementState getState() {
        ModuleOutputPackagingElementState state = new ModuleOutputPackagingElementState();
        if (this.myModulePointer != null) {
            state.setModuleName(this.myModulePointer.getModuleName());
        }
        return state;
    }

    public void loadState(ModuleOutputPackagingElementState state) {
        String moduleName = state.getModuleName();
        this.myModulePointer = moduleName != null ? ModulePointerManager.getInstance((Project)this.myProject).create(moduleName) : null;
    }

    @Override
    @Nullable
    public String getModuleName() {
        return this.myModulePointer != null ? this.myModulePointer.getModuleName() : null;
    }

    @Override
    @Nullable
    public Module findModule(PackagingElementResolvingContext context) {
        if (this.myModulePointer != null) {
            Module module2 = this.myModulePointer.getModule();
            ModulesProvider modulesProvider = context.getModulesProvider();
            if (module2 != null && (modulesProvider instanceof DefaultModulesProvider || ArrayUtil.contains((Object)module2, (Object[])modulesProvider.getModules()))) {
                return module2;
            }
            return modulesProvider.getModule(this.myModulePointer.getModuleName());
        }
        return null;
    }

    public static class ModuleOutputPackagingElementState {
        private String myModuleName;

        @Attribute(value="name")
        public String getModuleName() {
            return this.myModuleName;
        }

        public void setModuleName(String moduleName) {
            this.myModuleName = moduleName;
        }
    }
}

