/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElementBase;
import com.intellij.packaging.impl.elements.TestModuleOutputElementType;
import com.intellij.packaging.impl.ui.DelegatedPackagingElementPresentation;
import com.intellij.packaging.impl.ui.ModuleElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class TestModuleOutputPackagingElement
extends ModuleOutputPackagingElementBase {
    public TestModuleOutputPackagingElement(Project project2) {
        super(TestModuleOutputElementType.ELEMENT_TYPE, project2);
    }

    public TestModuleOutputPackagingElement(Project project2, ModulePointer modulePointer) {
        super(TestModuleOutputElementType.ELEMENT_TYPE, project2, modulePointer);
    }

    public String toString() {
        return "module-tests:" + this.getModuleName();
    }

    @Override
    protected String getModuleOutputAntProperty(ArtifactAntGenerationContext generationContext) {
        return generationContext.getModuleTestOutputPath(this.myModulePointer.getModuleName());
    }

    @Override
    protected VirtualFile getModuleOutputPath(CompilerModuleExtension extension) {
        return extension.getCompilerOutputPathForTests();
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getSourceRoots(PackagingElementResolvingContext context) {
        Module module2 = this.findModule(context);
        if (module2 == null) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/TestModuleOutputPackagingElement", "getSourceRoots"));
            }
            return list2;
        }
        List list3 = context.getModulesProvider().getRootModel(module2).getSourceRoots(JavaModuleSourceRootTypes.TESTS);
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/TestModuleOutputPackagingElement", "getSourceRoots"));
        }
        return list3;
    }

    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/elements/TestModuleOutputPackagingElement", "createPresentation"));
        }
        return new DelegatedPackagingElementPresentation(new ModuleElementPresentation(this.myModulePointer, context, true));
    }
}

