/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.AppInspectionProfilesVisibleTreeState;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ProjectInspectionProfilesVisibleTreeState;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.VisibleTreeState;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.profile.codeInspection.ui.InspectionsAggregationUtil;
import com.intellij.profile.codeInspection.ui.LevelChooserAction;
import com.intellij.profile.codeInspection.ui.ScopesChooser;
import com.intellij.profile.codeInspection.ui.ToolDescriptors;
import com.intellij.profile.codeInspection.ui.filter.InspectionFilterAction;
import com.intellij.profile.codeInspection.ui.filter.InspectionsFilter;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionConfigTreeNode;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeComparator;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeRenderer;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeTable;
import com.intellij.profile.codeInspection.ui.table.ScopesAndSeveritiesTable;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.HintHint;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.Queue;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleInspectionProfilePanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.InspectionToolsPanel");
    @NonNls
    private static final String INSPECTION_FILTER_HISTORY = "INSPECTION_FILTER_HISTORY";
    private static final String UNDER_CONSTRUCTION = InspectionsBundle.message((String)"inspection.tool.description.under.construction.text", (Object[])new Object[0]);
    @NonNls
    private static final String EMPTY_HTML = "<html><body></body></html>";
    private static final float DIVIDER_PROPORTION_DEFAULT = 0.5f;
    public static final String SETTINGS = "settings://";
    private final Map<HighlightDisplayKey, ToolDescriptors> myInitialToolDescriptors;
    private final InspectionConfigTreeNode myRoot;
    private final Alarm myAlarm;
    private final ProjectInspectionProfileManager myProjectProfileManager;
    private InspectionProfileModifiableModel myProfile;
    private JEditorPane myBrowser;
    private JPanel myOptionsPanel;
    private JPanel myInspectionProfilePanel;
    private FilterComponent myProfileFilter;
    private final InspectionsFilter myInspectionsFilter;
    private boolean myModified;
    private InspectionsConfigTreeTable myTreeTable;
    private TreeExpander myTreeExpander;
    private boolean myIsInRestore;
    private String[] myInitialScopesOrder;
    private Disposable myDisposable;

    public SingleInspectionProfilePanel(@NotNull ProjectInspectionProfileManager projectProfileManager, @NotNull InspectionProfileModifiableModel profile2) {
        if (projectProfileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectProfileManager", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel", "<init>"));
        }
        if (profile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel", "<init>"));
        }
        super(new BorderLayout());
        this.myInitialToolDescriptors = new THashMap();
        this.myRoot = new InspectionConfigTreeNode.Group(InspectionsBundle.message((String)"inspection.root.node.title", (Object[])new Object[0]));
        this.myAlarm = new Alarm();
        this.myInspectionProfilePanel = null;
        this.myInspectionsFilter = new InspectionsFilter(){

            @Override
            protected void filterChanged() {
                SingleInspectionProfilePanel.this.filterTree(SingleInspectionProfilePanel.this.myProfileFilter.getFilter());
            }
        };
        this.myModified = false;
        this.myIsInRestore = false;
        this.myDisposable = new Disposable(){

            public void dispose() {
            }
        };
        this.myProjectProfileManager = projectProfileManager;
        this.myProfile = profile2;
        this.myProfile.initInspectionTools(projectProfileManager.getProject());
    }

    public Map<HighlightDisplayKey, ToolDescriptors> getInitialToolDescriptors() {
        return this.myInitialToolDescriptors;
    }

    public boolean differsFromDefault() {
        return this.myRoot.isProperSetting();
    }

    public void performProfileReset() {
        TreeUtil.traverse((TreeNode)this.myRoot, n -> {
            InspectionConfigTreeNode node = (InspectionConfigTreeNode)n;
            Descriptor defaultDescriptor = node.getDefaultDescriptor();
            if (defaultDescriptor != null && node.isProperSetting()) {
                defaultDescriptor.loadConfig();
            }
            return true;
        });
        this.getProfile().resetToBase(this.myProjectProfileManager.getProject());
        this.loadDescriptorsConfigs(true);
        this.postProcessModification();
    }

    private static VisibleTreeState getExpandedNodes(InspectionProfileImpl profile2) {
        if (profile2.isProjectLevel()) {
            return ProjectInspectionProfilesVisibleTreeState.getInstance(((ProjectInspectionProfileManager)profile2.getProfileManager()).getProject()).getVisibleTreeState(profile2);
        }
        return AppInspectionProfilesVisibleTreeState.getInstance().getVisibleTreeState(profile2);
    }

    private static InspectionConfigTreeNode findGroupNodeByPath(@NotNull String[] path, int idx, @NotNull InspectionConfigTreeNode node) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel", "findGroupNodeByPath"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel", "findGroupNodeByPath"));
        }
        if (path.length == idx) {
            return node;
        }
        String currentKey = path[idx];
        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
            InspectionConfigTreeNode currentNode = (InspectionConfigTreeNode)node.getChildAt(i2);
            if (!Comparing.equal((String)currentNode.getGroupName(), (String)currentKey)) continue;
            return SingleInspectionProfilePanel.findGroupNodeByPath(path, ++idx, currentNode);
        }
        return null;
    }

    @Nullable
    private static InspectionConfigTreeNode findNodeByKey(String name2, InspectionConfigTreeNode root) {
        for (int i2 = 0; i2 < root.getChildCount(); ++i2) {
            InspectionConfigTreeNode child = (InspectionConfigTreeNode)root.getChildAt(i2);
            Descriptor descriptor = child.getDefaultDescriptor();
            if (descriptor != null) {
                if (!descriptor.getKey().toString().equals(name2)) continue;
                return child;
            }
            InspectionConfigTreeNode node = SingleInspectionProfilePanel.findNodeByKey(name2, child);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public static String renderSeverity(HighlightSeverity severity) {
        if (HighlightSeverity.INFORMATION.equals((Object)severity)) {
            return "No highlighting, only fix";
        }
        return StringUtil.capitalizeWords((String)severity.getName().toLowerCase(Locale.US), (boolean)true);
    }

    private static void updateUpHierarchy(InspectionConfigTreeNode parent) {
        if (parent != null) {
            parent.dropCache();
            SingleInspectionProfilePanel.updateUpHierarchy((InspectionConfigTreeNode)parent.getParent());
        }
    }

    private static boolean isDescriptorAccepted(Descriptor descriptor, @NonNls String filter, boolean forceInclude, List<Set<String>> keySetList, Set<String> quoted) {
        filter = filter.toLowerCase();
        if (StringUtil.containsIgnoreCase((String)descriptor.getText(), (String)filter)) {
            return true;
        }
        String[] groupPath = descriptor.getGroup();
        for (String group : groupPath) {
            if (!StringUtil.containsIgnoreCase((String)group, (String)filter)) continue;
            return true;
        }
        for (String string : quoted) {
            if (StringUtil.containsIgnoreCase((String)descriptor.getText(), (String)string)) {
                return true;
            }
            for (String group : groupPath) {
                if (!StringUtil.containsIgnoreCase((String)group, (String)string)) continue;
                return true;
            }
            String description = descriptor.getToolWrapper().loadDescription();
            if (description != null && StringUtil.containsIgnoreCase((String)description.toLowerCase(Locale.US), (String)string)) {
                if (forceInclude) continue;
                return true;
            }
            if (!forceInclude) continue;
            return false;
        }
        for (Set set2 : keySetList) {
            if (set2.contains(descriptor.getKey().toString())) {
                if (forceInclude) continue;
                return true;
            }
            if (!forceInclude) continue;
            return false;
        }
        return forceInclude;
    }

    private static void setConfigPanel(JPanel configPanelAnchor, ScopeToolState state) {
        configPanelAnchor.removeAll();
        JComponent additionalConfigPanel = state.getAdditionalConfigPanel();
        if (additionalConfigPanel != null) {
            if (UIUtil.hasScrollPane((Component)additionalConfigPanel)) {
                configPanelAnchor.add(additionalConfigPanel);
            } else {
                configPanelAnchor.add(ScrollPaneFactory.createScrollPane((Component)additionalConfigPanel, (int)0));
            }
        }
    }

    private static InspectionConfigTreeNode getGroupNode(InspectionConfigTreeNode root, String[] groupPath) {
        InspectionConfigTreeNode currentRoot = root;
        for (String group : groupPath) {
            currentRoot = SingleInspectionProfilePanel.getGroupNode(currentRoot, group);
        }
        return currentRoot;
    }

    private static InspectionConfigTreeNode getGroupNode(InspectionConfigTreeNode root, String group) {
        int childCount = root.getChildCount();
        for (int i2 = 0; i2 < childCount; ++i2) {
            InspectionConfigTreeNode child = (InspectionConfigTreeNode)root.getChildAt(i2);
            if (!group.equals(child.getUserObject())) continue;
            return child;
        }
        InspectionConfigTreeNode.Group child = new InspectionConfigTreeNode.Group(group);
        root.add(child);
        return child;
    }

    private static void copyUsedSeveritiesIfUndefined(InspectionProfileImpl selectedProfile, BaseInspectionProfileManager profileManager) {
        SeverityRegistrar registrar = profileManager.getSeverityRegistrar();
        Set<HighlightSeverity> severities = selectedProfile.getUsedSeverities();
        Iterator<HighlightSeverity> iterator = severities.iterator();
        while (iterator.hasNext()) {
            HighlightSeverity severity = iterator.next();
            if (!registrar.isSeverityValid(severity.getName())) continue;
            iterator.remove();
        }
        if (!severities.isEmpty()) {
            SeverityRegistrar oppositeRegister = selectedProfile.getProfileManager().getSeverityRegistrar();
            for (HighlightSeverity severity : severities) {
                TextAttributesKey attributesKey = TextAttributesKey.find((String)severity.getName());
                TextAttributes textAttributes = oppositeRegister.getTextAttributesBySeverity(severity);
                if (textAttributes == null) continue;
                HighlightInfoType.HighlightInfoTypeImpl info = new HighlightInfoType.HighlightInfoTypeImpl(severity, attributesKey);
                registrar.registerSeverity(new SeverityRegistrar.SeverityBasedTextAttributes(textAttributes.clone(), info), textAttributes.getErrorStripeColor());
            }
        }
    }

    private void initUI() {
        this.myInspectionProfilePanel = this.createInspectionProfileSettingsPanel();
        this.add((Component)this.myInspectionProfilePanel, "Center");
        UserActivityWatcher userActivityWatcher = new UserActivityWatcher();
        userActivityWatcher.addUserActivityListener(new UserActivityListener(){

            public void stateChanged() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (SingleInspectionProfilePanel.this.myProfile == null) {
                        return;
                    }
                    SingleInspectionProfilePanel.this.updateProperSettingsForSelection();
                    SingleInspectionProfilePanel.this.wereToolSettingsModified();
                });
            }
        });
        userActivityWatcher.register((Component)this.myOptionsPanel);
        this.updateSelectedProfileState();
        this.reset();
    }

    private void updateSelectedProfileState() {
        if (this.myProfile == null) {
            return;
        }
        this.restoreTreeState();
        this.repaintTableData();
        this.updateSelection();
    }

    public void updateSelection() {
        TreePath selectionPath;
        if (this.myTreeTable != null && (selectionPath = this.myTreeTable.getTree().getSelectionPath()) != null) {
            TreeUtil.selectNode((JTree)this.myTreeTable.getTree(), (TreeNode)((TreeNode)selectionPath.getLastPathComponent()));
            int rowForPath = this.myTreeTable.getTree().getRowForPath(selectionPath);
            TableUtil.selectRows((JTable)((Object)this.myTreeTable), (int[])new int[]{rowForPath});
            this.scrollToCenter();
        }
    }

    private void loadDescriptorsConfigs(boolean onlyModified) {
        for (ToolDescriptors toolDescriptors : this.myInitialToolDescriptors.values()) {
            this.loadDescriptorConfig(toolDescriptors.getDefaultDescriptor(), onlyModified);
            for (Descriptor descriptor : toolDescriptors.getNonDefaultDescriptors()) {
                this.loadDescriptorConfig(descriptor, onlyModified);
            }
        }
    }

    private void loadDescriptorConfig(Descriptor descriptor, boolean ifModifier) {
        if (!ifModifier || this.myProfile.isProperSetting(descriptor.getKey().toString())) {
            descriptor.loadConfig();
        }
    }

    private void wereToolSettingsModified() {
        for (ToolDescriptors toolDescriptor : this.myInitialToolDescriptors.values()) {
            Descriptor desc = toolDescriptor.getDefaultDescriptor();
            if (this.wereToolSettingsModified(desc, true)) {
                return;
            }
            List<Descriptor> descriptors = toolDescriptor.getNonDefaultDescriptors();
            for (Descriptor descriptor : descriptors) {
                if (!this.wereToolSettingsModified(descriptor, false)) continue;
                return;
            }
        }
        this.myModified = false;
    }

    private boolean wereToolSettingsModified(Descriptor descriptor, boolean isDefault) {
        Element oldConfig = descriptor.getConfig();
        if (oldConfig == null) {
            return false;
        }
        ScopeToolState state = null;
        if (isDefault) {
            state = this.myProfile.getToolDefaultState(descriptor.getKey().toString(), this.myProjectProfileManager.getProject());
        } else {
            for (ScopeToolState candidate : this.myProfile.getNonDefaultTools(descriptor.getKey().toString(), this.myProjectProfileManager.getProject())) {
                String scope = descriptor.getScopeName();
                if (!Comparing.equal((String)candidate.getScopeName(), (String)scope)) continue;
                state = candidate;
                break;
            }
        }
        if (state == null) {
            return true;
        }
        Element newConfig = Descriptor.createConfigElement(state.getTool());
        if (!JDOMUtil.areElementsEqual((Element)oldConfig, (Element)newConfig)) {
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(() -> this.myTreeTable.repaint(), 300);
            this.myModified = true;
            return true;
        }
        return false;
    }

    private void updateProperSettingsForSelection() {
        InspectionConfigTreeNode node;
        Descriptor descriptor;
        TreePath selectionPath = this.myTreeTable.getTree().getSelectionPath();
        if (selectionPath != null && (descriptor = (node = (InspectionConfigTreeNode)selectionPath.getLastPathComponent()).getDefaultDescriptor()) != null) {
            boolean properSetting = this.myProfile.isProperSetting(descriptor.getKey().toString());
            if (node.isProperSetting() != properSetting) {
                this.myAlarm.cancelAllRequests();
                this.myAlarm.addRequest(() -> this.myTreeTable.repaint(), 300);
                node.dropCache();
                SingleInspectionProfilePanel.updateUpHierarchy((InspectionConfigTreeNode)node.getParent());
            }
        }
    }

    private void initToolStates() {
        InspectionProfileModifiableModel profile2 = this.myProfile;
        if (profile2 == null) {
            return;
        }
        this.myInitialToolDescriptors.clear();
        Project project2 = this.myProjectProfileManager.getProject();
        for (ScopeToolState state : profile2.getDefaultStates(this.myProjectProfileManager.getProject())) {
            if (!this.accept(state.getTool())) continue;
            ToolDescriptors descriptors = ToolDescriptors.fromScopeToolState(state, profile2, project2);
            this.myInitialToolDescriptors.put(descriptors.getDefaultDescriptor().getKey(), descriptors);
        }
        this.myInitialScopesOrder = this.myProfile.getScopesOrder();
    }

    protected boolean accept(InspectionToolWrapper entry) {
        return entry.getDefaultLevel() != HighlightDisplayLevel.NON_SWITCHABLE_ERROR;
    }

    private void postProcessModification() {
        this.wereToolSettingsModified();
        for (ScopeToolState state : this.myProfile.getAllTools()) {
            state.resetConfigPanel();
        }
        this.fillTreeData(this.myProfileFilter.getFilter(), true);
        this.repaintTableData();
        this.updateOptionsAndDescriptionPanel(this.myTreeTable.getTree().getSelectionPaths());
    }

    public void setFilter(String filter) {
        this.myProfileFilter.setFilter(filter);
    }

    private void filterTree(@Nullable String filter) {
        if (this.myTreeTable != null) {
            SingleInspectionProfilePanel.getExpandedNodes(this.myProfile).saveVisibleState((Tree)this.myTreeTable.getTree());
            this.fillTreeData(filter, true);
            this.reloadModel();
            this.restoreTreeState();
            if (this.myTreeTable.getTree().getSelectionPath() == null) {
                TreeUtil.selectFirstNode((JTree)this.myTreeTable.getTree());
            }
        }
    }

    private void filterTree() {
        this.filterTree(this.myProfileFilter != null ? this.myProfileFilter.getFilter() : null);
    }

    private void reloadModel() {
        try {
            this.myIsInRestore = true;
            ((DefaultTreeModel)this.myTreeTable.getTree().getModel()).reload();
        }
        finally {
            this.myIsInRestore = false;
        }
    }

    private void restoreTreeState() {
        try {
            this.myIsInRestore = true;
            SingleInspectionProfilePanel.getExpandedNodes(this.myProfile).restoreVisibleState((Tree)this.myTreeTable.getTree());
        }
        finally {
            this.myIsInRestore = false;
        }
    }

    private ActionToolbar createTreeToolbarPanel() {
        CommonActionsManager actionManager = CommonActionsManager.getInstance();
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add((AnAction)new InspectionFilterAction(this.myProfile, this.myInspectionsFilter, this.myProjectProfileManager.getProject(), this.myProfileFilter));
        actions.addSeparator();
        actions.add(actionManager.createExpandAllAction(this.myTreeExpander, (JComponent)((Object)this.myTreeTable)));
        actions.add(actionManager.createCollapseAllAction(this.myTreeExpander, (JComponent)((Object)this.myTreeTable)));
        actions.add((AnAction)new DumbAwareAction("Reset to Empty", "Reset to empty", AllIcons.Actions.Reset_to_empty){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$4", "update"));
                }
                e.getPresentation().setEnabled(SingleInspectionProfilePanel.this.myProfile != null && SingleInspectionProfilePanel.this.myProfile.isExecutable(SingleInspectionProfilePanel.this.myProjectProfileManager.getProject()));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$4", "actionPerformed"));
                }
                SingleInspectionProfilePanel.this.myProfile.resetToEmpty(SingleInspectionProfilePanel.this.myProjectProfileManager.getProject());
                SingleInspectionProfilePanel.this.loadDescriptorsConfigs(false);
                SingleInspectionProfilePanel.this.postProcessModification();
            }
        });
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("SingleInspectionProfile", (ActionGroup)actions, true);
        actionToolbar.setTargetComponent((JComponent)this);
        return actionToolbar;
    }

    private void repaintTableData() {
        if (this.myTreeTable != null) {
            SingleInspectionProfilePanel.getExpandedNodes(this.myProfile).saveVisibleState((Tree)this.myTreeTable.getTree());
            this.reloadModel();
            this.restoreTreeState();
        }
    }

    public void selectInspectionTool(String name2) {
        this.selectNode(SingleInspectionProfilePanel.findNodeByKey(name2, this.myRoot));
    }

    public void selectInspectionGroup(String[] path) {
        InspectionConfigTreeNode node = SingleInspectionProfilePanel.findGroupNodeByPath(path, 0, this.myRoot);
        this.selectNode(node);
        if (node != null) {
            this.myTreeTable.getTree().expandPath(new TreePath(node.getPath()));
        }
    }

    private void selectNode(InspectionConfigTreeNode node) {
        if (node != null) {
            TreeUtil.selectNode((JTree)this.myTreeTable.getTree(), (TreeNode)node);
            int rowForPath = this.myTreeTable.getTree().getRowForPath(new TreePath(node.getPath()));
            TableUtil.selectRows((JTable)((Object)this.myTreeTable), (int[])new int[]{rowForPath});
            this.scrollToCenter();
        }
    }

    private void scrollToCenter() {
        ListSelectionModel selectionModel = this.myTreeTable.getSelectionModel();
        int maxSelectionIndex = selectionModel.getMaxSelectionIndex();
        int maxColumnSelectionIndex = Math.max(0, this.myTreeTable.getColumnModel().getSelectionModel().getMinSelectionIndex());
        Rectangle maxCellRect = this.myTreeTable.getCellRect(maxSelectionIndex, maxColumnSelectionIndex, false);
        Point selectPoint = maxCellRect.getLocation();
        int allHeight = this.myTreeTable.getVisibleRect().height;
        this.myTreeTable.scrollRectToVisible(new Rectangle(new Point(0, Math.max(0, selectPoint.y - allHeight / 2)), new Dimension(0, allHeight)));
    }

    private JScrollPane initTreeScrollPane() {
        this.fillTreeData(null, true);
        InspectionsConfigTreeRenderer renderer = new InspectionsConfigTreeRenderer(){

            @Override
            protected String getFilter() {
                return SingleInspectionProfilePanel.this.myProfileFilter != null ? SingleInspectionProfilePanel.this.myProfileFilter.getFilter() : null;
            }
        };
        this.myTreeTable = InspectionsConfigTreeTable.create(new InspectionsConfigTreeTable.InspectionsConfigTreeTableSettings(this.myRoot, this.myProjectProfileManager.getProject()){

            @Override
            protected void onChanged(InspectionConfigTreeNode node) {
                SingleInspectionProfilePanel.updateUpHierarchy((InspectionConfigTreeNode)node.getParent());
            }

            @Override
            public void updateRightPanel() {
                SingleInspectionProfilePanel.this.updateOptionsAndDescriptionPanel();
            }

            @Override
            public InspectionProfileImpl getInspectionProfile() {
                return SingleInspectionProfilePanel.this.myProfile;
            }
        }, this.myDisposable);
        this.myTreeTable.setTreeCellRenderer((TreeCellRenderer)((Object)renderer));
        this.myTreeTable.setRootVisible(false);
        UIUtil.setLineStyleAngled((JTree)this.myTreeTable.getTree());
        TreeUtil.installActions((JTree)this.myTreeTable.getTree());
        this.myTreeTable.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                InspectionProfileModifiableModel selected;
                if (SingleInspectionProfilePanel.this.myTreeTable.getTree().getSelectionPaths() != null) {
                    SingleInspectionProfilePanel.this.updateOptionsAndDescriptionPanel(SingleInspectionProfilePanel.this.myTreeTable.getTree().getSelectionPaths());
                } else {
                    SingleInspectionProfilePanel.this.initOptionsAndDescriptionPanel();
                }
                if (!SingleInspectionProfilePanel.this.myIsInRestore && (selected = SingleInspectionProfilePanel.this.myProfile) != null) {
                    InspectionProfileImpl baseProfile = selected.getSource();
                    SingleInspectionProfilePanel.getExpandedNodes(baseProfile).setSelectionPaths(SingleInspectionProfilePanel.this.myTreeTable.getTree().getSelectionPaths());
                    SingleInspectionProfilePanel.getExpandedNodes(selected).setSelectionPaths(SingleInspectionProfilePanel.this.myTreeTable.getTree().getSelectionPaths());
                }
            }
        });
        this.myTreeTable.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                int[] selectionRows = SingleInspectionProfilePanel.this.myTreeTable.getTree().getSelectionRows();
                if (selectionRows != null && SingleInspectionProfilePanel.this.myTreeTable.getTree().getPathForLocation(x, y) != null && Arrays.binarySearch(selectionRows, SingleInspectionProfilePanel.this.myTreeTable.getTree().getRowForLocation(x, y)) > -1) {
                    SingleInspectionProfilePanel.this.compoundPopup().show(comp, x, y);
                }
            }
        });
        new TreeSpeedSearch((Tree)this.myTreeTable.getTree(), (Convertor<TreePath, String>)((Convertor)o -> {
            InspectionConfigTreeNode node = (InspectionConfigTreeNode)o.getLastPathComponent();
            Descriptor descriptor = node.getDefaultDescriptor();
            return InspectionsConfigTreeComparator.getDisplayTextToSort(descriptor != null ? descriptor.getText() : node.getGroupName());
        }));
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTreeTable));
        this.myTreeTable.getTree().setShowsRootHandles(true);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setBorder(IdeBorderFactory.createBorder((int)11));
        TreeUtil.collapseAll((JTree)this.myTreeTable.getTree(), (int)1);
        this.myTreeTable.getTree().addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                InspectionProfileModifiableModel selected = SingleInspectionProfilePanel.this.myProfile;
                SingleInspectionProfilePanel.getExpandedNodes(selected.getSource()).saveVisibleState((Tree)SingleInspectionProfilePanel.this.myTreeTable.getTree());
                SingleInspectionProfilePanel.getExpandedNodes(selected).saveVisibleState((Tree)SingleInspectionProfilePanel.this.myTreeTable.getTree());
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                InspectionProfileModifiableModel selected = SingleInspectionProfilePanel.this.myProfile;
                if (selected != null) {
                    InspectionConfigTreeNode node = (InspectionConfigTreeNode)event.getPath().getLastPathComponent();
                    SingleInspectionProfilePanel.getExpandedNodes(selected.getSource()).expandNode(node);
                    SingleInspectionProfilePanel.getExpandedNodes(selected).expandNode(node);
                }
            }
        });
        this.myTreeExpander = new DefaultTreeExpander((JTree)this.myTreeTable.getTree()){

            public boolean canExpand() {
                return SingleInspectionProfilePanel.this.myTreeTable.isShowing();
            }

            public boolean canCollapse() {
                return SingleInspectionProfilePanel.this.myTreeTable.isShowing();
            }
        };
        this.myProfileFilter = new MyFilterComponent();
        return scrollPane;
    }

    private JPopupMenu compoundPopup() {
        DefaultActionGroup group = new DefaultActionGroup();
        SeverityRegistrar severityRegistrar = this.myProfile.getProfileManager().getOwnSeverityRegistrar();
        for (HighlightSeverity severity : LevelChooserAction.getSeverities(severityRegistrar, this.includeDoNotShow())) {
            final HighlightDisplayLevel level = HighlightDisplayLevel.find((HighlightSeverity)severity);
            group.add(new AnAction(SingleInspectionProfilePanel.renderSeverity(severity), SingleInspectionProfilePanel.renderSeverity(severity), level.getIcon()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$11", "actionPerformed"));
                    }
                    SingleInspectionProfilePanel.this.setNewHighlightingLevel(level);
                }

                public boolean isDumbAware() {
                    return true;
                }
            });
        }
        group.add((AnAction)Separator.getInstance());
        ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)group);
        return menu.getComponent();
    }

    private boolean includeDoNotShow() {
        TreePath[] paths = this.myTreeTable.getTree().getSelectionPaths();
        if (paths == null) {
            return true;
        }
        return this.includeDoNotShow(InspectionsAggregationUtil.getInspectionsNodes(paths));
    }

    private boolean includeDoNotShow(List<InspectionConfigTreeNode> nodes) {
        Project project2 = this.myProjectProfileManager.getProject();
        return nodes.stream().noneMatch(node -> {
            InspectionToolWrapper tool = this.myProfile.getToolDefaultState(node.getKey().toString(), project2).getTool();
            return tool instanceof GlobalInspectionToolWrapper && ((GlobalInspectionToolWrapper)tool).getSharedLocalInspectionToolWrapper() == null;
        });
    }

    private void fillTreeData(@Nullable String filter, boolean forceInclude) {
        Set filters;
        if (this.myProfile == null) {
            return;
        }
        this.myRoot.removeAllChildren();
        this.myRoot.dropCache();
        ArrayList<Set<String>> keySetList = new ArrayList<Set<String>>();
        HashSet<String> quoted = new HashSet<String>();
        if (filter != null && !filter.isEmpty()) {
            keySetList.addAll(SearchUtil.findKeys(filter, quoted));
        }
        Project project2 = this.myProjectProfileManager.getProject();
        boolean emptyFilter = this.myInspectionsFilter.isEmptyFilter();
        for (ToolDescriptors toolDescriptors : this.myInitialToolDescriptors.values()) {
            Descriptor descriptor = toolDescriptors.getDefaultDescriptor();
            if (filter != null && !filter.isEmpty() && !SingleInspectionProfilePanel.isDescriptorAccepted(descriptor, filter, forceInclude, keySetList, quoted)) continue;
            InspectionConfigTreeNode.Tool node = new InspectionConfigTreeNode.Tool(toolDescriptors.getDefaultDescriptor().getKey(), this);
            if (!emptyFilter && !this.myInspectionsFilter.matches(this.myProfile.getTools(toolDescriptors.getDefaultDescriptor().getKey().toString(), project2), node)) continue;
            SingleInspectionProfilePanel.getGroupNode(this.myRoot, toolDescriptors.getDefaultDescriptor().getGroup()).add(node);
            this.myRoot.dropCache();
        }
        if (filter != null && forceInclude && this.myRoot.getChildCount() == 0 && ((filters = SearchableOptionsRegistrar.getInstance().getProcessedWords(filter)).size() > 1 || !quoted.isEmpty())) {
            this.fillTreeData(filter, false);
        }
        TreeUtil.sortRecursively((MutableTreeNode)this.myRoot, (Comparator)new InspectionsConfigTreeComparator());
    }

    public static boolean readHTML(JEditorPane browser, String text2) {
        try {
            browser.read(new StringReader(text2), null);
            return true;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static String toHTML(JEditorPane browser, String text2, boolean miniFontSize) {
        HintHint hintHint = new HintHint(browser, new Point(0, 0));
        hintHint.setFont(miniFontSize ? UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL) : UIUtil.getLabelFont());
        return HintUtil.prepareHintText(text2, hintHint);
    }

    private void updateOptionsAndDescriptionPanel(TreePath ... paths) {
        if (this.myProfile == null || paths == null || paths.length == 0) {
            return;
        }
        TreePath path = paths[0];
        if (path == null) {
            return;
        }
        final List<InspectionConfigTreeNode> nodes = InspectionsAggregationUtil.getInspectionsNodes(paths);
        if (!nodes.isEmpty()) {
            double severityPanelWeightY;
            InspectionConfigTreeNode singleNode;
            InspectionConfigTreeNode inspectionConfigTreeNode = singleNode = paths.length == 1 && ((InspectionConfigTreeNode)paths[0].getLastPathComponent()).getDefaultDescriptor() != null ? (InspectionConfigTreeNode)ContainerUtil.getFirstItem(nodes) : null;
            if (singleNode != null) {
                Descriptor descriptor = singleNode.getDefaultDescriptor();
                LOG.assertTrue(descriptor != null);
                if (descriptor.loadDescription() != null) {
                    Descriptor defaultDescriptor = singleNode.getDefaultDescriptor();
                    String description = defaultDescriptor.loadDescription();
                    try {
                        if (!SingleInspectionProfilePanel.readHTML(this.myBrowser, SearchUtil.markup(SingleInspectionProfilePanel.toHTML(this.myBrowser, description, false), this.myProfileFilter.getFilter()))) {
                            SingleInspectionProfilePanel.readHTML(this.myBrowser, SingleInspectionProfilePanel.toHTML(this.myBrowser, "<b>" + UNDER_CONSTRUCTION + "</b>", false));
                        }
                    }
                    catch (Throwable t) {
                        LOG.error("Failed to load description for: " + defaultDescriptor.getToolWrapper().getTool().getClass() + "; description: " + description, t);
                    }
                } else {
                    SingleInspectionProfilePanel.readHTML(this.myBrowser, SingleInspectionProfilePanel.toHTML(this.myBrowser, "Can't find inspection description.", false));
                }
            } else {
                SingleInspectionProfilePanel.readHTML(this.myBrowser, SingleInspectionProfilePanel.toHTML(this.myBrowser, "Multiple inspections are selected. You can edit them as a single inspection.", false));
            }
            this.myOptionsPanel.removeAll();
            final Project project2 = this.myProjectProfileManager.getProject();
            JPanel severityPanel = new JPanel(new GridBagLayout());
            final JPanel configPanelAnchor = new JPanel(new GridLayout());
            THashSet scopesNames = new THashSet();
            for (InspectionConfigTreeNode node2 : nodes) {
                List<ScopeToolState> nonDefaultTools = this.myProfile.getNonDefaultTools(node2.getDefaultDescriptor().getKey().toString(), project2);
                for (ScopeToolState tool : nonDefaultTools) {
                    scopesNames.add(tool.getScopeName());
                }
            }
            if (scopesNames.isEmpty()) {
                LevelChooserAction severityLevelChooser = new LevelChooserAction(this.myProfile.getProfileManager().getOwnSeverityRegistrar(), this.includeDoNotShow(nodes)){

                    @Override
                    protected void onChosen(HighlightSeverity severity) {
                        HighlightDisplayLevel level = HighlightDisplayLevel.find((HighlightSeverity)severity);
                        SmartList toUpdate = new SmartList();
                        for (InspectionConfigTreeNode node : nodes) {
                            HighlightDisplayKey key2 = node.getDefaultDescriptor().getKey();
                            NamedScope scope = node.getDefaultDescriptor().getScope();
                            boolean doUpdate = SingleInspectionProfilePanel.this.myProfile.getErrorLevel(key2, scope, project2) != level;
                            if (!doUpdate) continue;
                            SingleInspectionProfilePanel.this.myProfile.setErrorLevel(key2, level, null, project2);
                            toUpdate.add(node);
                        }
                        SingleInspectionProfilePanel.this.updateRecursively((List)toUpdate, false);
                        SingleInspectionProfilePanel.this.myTreeTable.updateUI();
                    }
                };
                HighlightSeverity severity = ScopesAndSeveritiesTable.getSeverity(ContainerUtil.map(nodes, node -> node.getDefaultDescriptor().getState()));
                severityLevelChooser.setChosen(severity);
                ScopesChooser scopesChooser = new ScopesChooser(ContainerUtil.map(nodes, node -> node.getDefaultDescriptor()), this.myProfile, project2, null){

                    @Override
                    protected void onScopesOrderChanged() {
                        SingleInspectionProfilePanel.this.updateRecursively(nodes, true);
                    }

                    @Override
                    protected void onScopeAdded() {
                        SingleInspectionProfilePanel.this.updateRecursively(nodes, true);
                    }
                };
                severityPanel.add((Component)new JLabel(InspectionsBundle.message((String)"inspection.severity", (Object[])new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 3, (Insets)JBUI.insets((int)10, (int)0), 0, 0));
                JComponent severityLevelChooserComponent = severityLevelChooser.createCustomComponent(severityLevelChooser.getTemplatePresentation());
                severityPanel.add((Component)severityLevelChooserComponent, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 17, 1, (Insets)JBUI.insets((int)10, (int)0), 0, 0));
                JComponent scopesChooserComponent = scopesChooser.createCustomComponent(scopesChooser.getTemplatePresentation());
                severityPanel.add((Component)scopesChooserComponent, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 17, 1, (Insets)JBUI.insets((int)10, (int)0), 0, 0));
                JLabel label = new JLabel("", 4);
                severityPanel.add((Component)label, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 13, 1, (Insets)JBUI.insets((int)2, (int)0), 0, 0));
                severityPanelWeightY = 0.0;
                if (singleNode != null) {
                    SingleInspectionProfilePanel.setConfigPanel(configPanelAnchor, this.myProfile.getToolDefaultState(singleNode.getDefaultDescriptor().getKey().toString(), project2));
                }
            } else {
                if (singleNode != null) {
                    for (Descriptor descriptor : singleNode.getDescriptors().getNonDefaultDescriptors()) {
                        descriptor.loadConfig();
                    }
                }
                ScopesAndSeveritiesTable scopesAndScopesAndSeveritiesTable = new ScopesAndSeveritiesTable(new ScopesAndSeveritiesTable.TableSettings(nodes, this.myProfile, project2){

                    @Override
                    protected void onScopeChosen(@NotNull ScopeToolState state) {
                        if (state == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$14", "onScopeChosen"));
                        }
                        SingleInspectionProfilePanel.setConfigPanel(configPanelAnchor, state);
                        configPanelAnchor.revalidate();
                        configPanelAnchor.repaint();
                    }

                    @Override
                    protected void onSettingsChanged() {
                        SingleInspectionProfilePanel.this.updateRecursively(nodes, false);
                    }

                    @Override
                    protected void onScopeAdded() {
                        SingleInspectionProfilePanel.this.updateRecursively(nodes, true);
                    }

                    @Override
                    protected void onScopesOrderChanged() {
                        SingleInspectionProfilePanel.this.updateRecursively(nodes, true);
                    }

                    @Override
                    protected void onScopeRemoved(int scopesCount) {
                        SingleInspectionProfilePanel.this.updateRecursively(nodes, scopesCount == 1);
                    }
                });
                ToolbarDecorator wrappedTable = ToolbarDecorator.createDecorator((JTable)((Object)scopesAndScopesAndSeveritiesTable)).disableUpDownActions().setRemoveActionUpdater(new AnActionButtonUpdater((JTable)((Object)scopesAndScopesAndSeveritiesTable)){
                    final /* synthetic */ JTable val$scopesAndScopesAndSeveritiesTable;
                    {
                        this.val$scopesAndScopesAndSeveritiesTable = jTable;
                    }

                    public boolean isEnabled(AnActionEvent e) {
                        int selectedRow = this.val$scopesAndScopesAndSeveritiesTable.getSelectedRow();
                        int rowCount = this.val$scopesAndScopesAndSeveritiesTable.getRowCount();
                        return rowCount - 1 != selectedRow;
                    }
                });
                JPanel panel2 = wrappedTable.createPanel();
                panel2.setMinimumSize(new Dimension(this.getMinimumSize().width, 3 * ((JTable)((Object)scopesAndScopesAndSeveritiesTable)).getRowHeight()));
                severityPanel.add((Component)new JBLabel("Severity by Scope"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)5, (int)0, (int)2, (int)10), 0, 0));
                severityPanel.add((Component)panel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 1, (Insets)JBUI.insets((int)0, (int)0, (int)0, (int)0), 0, 0));
                severityPanelWeightY = 0.3;
            }
            this.myOptionsPanel.add((Component)severityPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, severityPanelWeightY, 17, 1, (Insets)JBUI.insets((int)0, (int)2, (int)0, (int)0), 0, 0));
            if (configPanelAnchor.getComponentCount() != 0) {
                configPanelAnchor.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Options", (boolean)false, (Insets)new JBInsets(7, 0, 0, 0)));
            }
            GuiUtils.enableChildren((Component)this.myOptionsPanel, (boolean)this.isThoughOneNodeEnabled(nodes), (JComponent[])new JComponent[0]);
            if (configPanelAnchor.getComponentCount() != 0 || scopesNames.isEmpty()) {
                this.myOptionsPanel.add((Component)configPanelAnchor, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, (Insets)JBUI.insets((int)0, (int)2, (int)0, (int)0), 0, 0));
            }
            this.myOptionsPanel.revalidate();
        } else {
            this.initOptionsAndDescriptionPanel();
        }
        this.myOptionsPanel.repaint();
    }

    private void updateRecursively(List<InspectionConfigTreeNode> nodes, boolean updateOptionsAndDescriptionPanel) {
        Queue q = new Queue(nodes.size());
        THashSet alreadyUpdated = new THashSet();
        for (InspectionConfigTreeNode node : nodes) {
            q.addLast((Object)node);
        }
        while (!q.isEmpty()) {
            InspectionConfigTreeNode inspectionConfigTreeNode = (InspectionConfigTreeNode)q.pullFirst();
            if (!alreadyUpdated.add(inspectionConfigTreeNode)) continue;
            inspectionConfigTreeNode.dropCache();
            TreeNode parent = inspectionConfigTreeNode.getParent();
            if (parent == null || parent.getParent() == null) continue;
            q.addLast((Object)((InspectionConfigTreeNode)parent));
        }
        this.myTreeTable.repaint();
        if (updateOptionsAndDescriptionPanel) {
            this.updateOptionsAndDescriptionPanel();
        }
    }

    private boolean isThoughOneNodeEnabled(List<InspectionConfigTreeNode> nodes) {
        Project project2 = this.myProjectProfileManager.getProject();
        for (InspectionConfigTreeNode node : nodes) {
            String toolId = node.getDefaultDescriptor().getKey().toString();
            if (!this.myProfile.getTools(toolId, project2).isEnabled()) continue;
            return true;
        }
        return false;
    }

    private void updateOptionsAndDescriptionPanel() {
        TreePath[] paths = this.myTreeTable.getTree().getSelectionPaths();
        if (paths != null) {
            this.updateOptionsAndDescriptionPanel(paths);
        } else {
            this.initOptionsAndDescriptionPanel();
        }
    }

    private void initOptionsAndDescriptionPanel() {
        this.myOptionsPanel.removeAll();
        SingleInspectionProfilePanel.readHTML(this.myBrowser, EMPTY_HTML);
        this.myOptionsPanel.validate();
        this.myOptionsPanel.repaint();
    }

    public InspectionProfileModifiableModel getProfile() {
        return this.myProfile;
    }

    private void setProfile(InspectionProfileModifiableModel modifiableModel) {
        if (this.myProfile == modifiableModel) {
            return;
        }
        this.myProfile = modifiableModel;
        this.initToolStates();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(700, 500);
    }

    public void disposeUI() {
        if (this.myInspectionProfilePanel == null) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        this.myProfileFilter.dispose();
        if (this.myProfile != null) {
            for (ScopeToolState state : this.myProfile.getAllTools()) {
                state.resetConfigPanel();
            }
        }
        this.myProfile = null;
        Disposer.dispose((Disposable)this.myDisposable);
        this.myDisposable = null;
    }

    private JPanel createInspectionProfileSettingsPanel() {
        this.myBrowser = new JEditorPane("text/html", EMPTY_HTML);
        this.myBrowser.setEditable(false);
        this.myBrowser.setBorder(IdeBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)5));
        this.myBrowser.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                String description = e.getDescription();
                if (description.startsWith(SingleInspectionProfilePanel.SETTINGS)) {
                    Settings settings;
                    String configId = description.substring(SingleInspectionProfilePanel.SETTINGS.length());
                    DataContext context = (DataContext)DataManager.getInstance().getDataContextFromFocus().getResult();
                    if (context != null && (settings = (Settings)Settings.KEY.getData(context)) != null) {
                        settings.select(settings.find(configId));
                    }
                } else {
                    BrowserUtil.browse((String)description);
                }
            }
        });
        this.initToolStates();
        this.fillTreeData(this.myProfileFilter != null ? this.myProfileFilter.getFilter() : null, true);
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)InspectionsBundle.message((String)"inspection.description.title", (Object[])new Object[0]), (boolean)false, (Insets)new JBInsets(2, 2, 0, 0)));
        descriptionPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myBrowser), "Center");
        JBSplitter rightSplitter = new JBSplitter(true, "SingleInspectionProfilePanel.HORIZONTAL_DIVIDER_PROPORTION", 0.5f);
        rightSplitter.setFirstComponent((JComponent)descriptionPanel);
        this.myOptionsPanel = new JPanel(new GridBagLayout());
        this.initOptionsAndDescriptionPanel();
        rightSplitter.setSecondComponent((JComponent)this.myOptionsPanel);
        rightSplitter.setHonorComponentsMinimumSize(true);
        JScrollPane tree = this.initTreeScrollPane();
        JPanel northPanel = new JPanel(new GridBagLayout());
        northPanel.setBorder(IdeBorderFactory.createEmptyBorder((int)2, (int)0, (int)2, (int)0));
        this.myProfileFilter.setPreferredSize(new Dimension(20, this.myProfileFilter.getPreferredSize().height));
        northPanel.add((Component)this.myProfileFilter, new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 768, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        northPanel.add((Component)this.createTreeToolbarPanel().getComponent(), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 512, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        OnePixelSplitter mainSplitter = new OnePixelSplitter(false, 0.5f, 0.01f, 0.99f);
        mainSplitter.setSplitterProportionKey("SingleInspectionProfilePanel.VERTICAL_DIVIDER_PROPORTION");
        mainSplitter.setFirstComponent((JComponent)tree);
        mainSplitter.setSecondComponent((JComponent)rightSplitter);
        mainSplitter.setHonorComponentsMinimumSize(false);
        JPanel inspectionTreePanel = new JPanel(new BorderLayout());
        inspectionTreePanel.add((Component)northPanel, "North");
        inspectionTreePanel.add((Component)mainSplitter, "Center");
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)inspectionTreePanel, "Center");
        final JBCheckBox disableNewInspectionsCheckBox = new JBCheckBox("Disable new inspections by default", this.getProfile().isProfileLocked());
        panel2.add((Component)disableNewInspectionsCheckBox, "South");
        disableNewInspectionsCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean enabled = disableNewInspectionsCheckBox.isSelected();
                InspectionProfileModifiableModel profile2 = SingleInspectionProfilePanel.this.getProfile();
                if (profile2 != null) {
                    profile2.lockProfile(enabled);
                }
            }
        });
        return panel2;
    }

    public boolean isModified() {
        if (this.myTreeTable == null) {
            return false;
        }
        if (this.myModified) {
            return true;
        }
        if (this.myProfile.isChanged()) {
            return true;
        }
        if (this.myProfile.getSource().isProjectLevel() != this.myProfile.isProjectLevel()) {
            return true;
        }
        if (!Comparing.strEqual((String)this.myProfile.getSource().getName(), (String)this.myProfile.getName())) {
            return true;
        }
        if (!Comparing.equal((Object[])this.myInitialScopesOrder, (Object[])this.myProfile.getScopesOrder())) {
            return true;
        }
        return this.descriptorsAreChanged();
    }

    public void reset() {
        this.myModified = false;
        this.setProfile(this.myProfile);
        this.filterTree();
        String filter = this.myProfileFilter.getFilter();
        this.myProfileFilter.reset();
        this.myProfileFilter.setSelectedItem(filter);
        this.myProfile.setName(this.myProfile.getSource().getName());
        this.myProfile.setProjectLevel(this.myProfile.getSource().isProjectLevel());
    }

    public void apply() {
        boolean modified = this.isModified();
        if (!modified) {
            return;
        }
        InspectionProfileModifiableModel selectedProfile = this.myProfile;
        BaseInspectionProfileManager profileManager = selectedProfile.isProjectLevel() ? this.myProjectProfileManager : (BaseInspectionProfileManager)InspectionProfileManager.getInstance();
        InspectionProfileImpl source = selectedProfile.getSource();
        if (source.getProfileManager() != profileManager) {
            source.getProfileManager().deleteProfile(source);
        }
        if (selectedProfile.getProfileManager() != profileManager) {
            SingleInspectionProfilePanel.copyUsedSeveritiesIfUndefined(selectedProfile, profileManager);
            selectedProfile.setProfileManager(profileManager);
        }
        selectedProfile.commit();
        profileManager.addProfile(source);
        profileManager.fireProfileChanged(source);
        this.myModified = false;
        this.myRoot.dropCache();
        this.initToolStates();
        this.updateOptionsAndDescriptionPanel();
    }

    private boolean descriptorsAreChanged() {
        return ContainerUtil.exists(this.myInitialToolDescriptors.values(), toolDescriptors -> SingleInspectionProfilePanel.areToolDescriptorsChanged(this.myProjectProfileManager.getProject(), this.myProfile, toolDescriptors));
    }

    public static boolean areToolDescriptorsChanged(@NotNull Project project2, @NotNull InspectionProfileModifiableModel profile2, @NotNull ToolDescriptors toolDescriptors) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel", "areToolDescriptorsChanged"));
        }
        if (profile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel", "areToolDescriptorsChanged"));
        }
        if (toolDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolDescriptors", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel", "areToolDescriptorsChanged"));
        }
        Descriptor desc = toolDescriptors.getDefaultDescriptor();
        if (profile2.isToolEnabled(desc.getKey(), null, project2) != desc.isEnabled()) {
            return true;
        }
        if (profile2.getErrorLevel(desc.getKey(), desc.getScope(), project2) != desc.getLevel()) {
            return true;
        }
        List<Descriptor> descriptors = toolDescriptors.getNonDefaultDescriptors();
        for (Descriptor descriptor : descriptors) {
            if (profile2.isToolEnabled(descriptor.getKey(), descriptor.getScope(), project2) != descriptor.isEnabled()) {
                return true;
            }
            if (profile2.getErrorLevel(descriptor.getKey(), descriptor.getScope(), project2) == descriptor.getLevel()) continue;
            return true;
        }
        List<ScopeToolState> tools = profile2.getNonDefaultTools(desc.getKey().toString(), project2);
        if (tools.size() != descriptors.size()) {
            return true;
        }
        for (int i2 = 0; i2 < tools.size(); ++i2) {
            ScopeToolState pair2 = tools.get(i2);
            if (Comparing.equal((Object)pair2.getScope(project2), (Object)descriptors.get(i2).getScope())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setVisible(boolean aFlag) {
        if (aFlag && this.myInspectionProfilePanel == null) {
            this.initUI();
        }
        super.setVisible(aFlag);
    }

    private void setNewHighlightingLevel(@NotNull HighlightDisplayLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel", "setNewHighlightingLevel"));
        }
        int[] rows = this.myTreeTable.getTree().getSelectionRows();
        boolean showOptionsAndDescriptorPanels = rows != null && rows.length == 1;
        for (int i2 = 0; rows != null && i2 < rows.length; ++i2) {
            InspectionConfigTreeNode node = (InspectionConfigTreeNode)this.myTreeTable.getTree().getPathForRow(rows[i2]).getLastPathComponent();
            InspectionConfigTreeNode parent = (InspectionConfigTreeNode)node.getParent();
            Object userObject = node.getUserObject();
            if (userObject instanceof ToolDescriptors && (node.getScopeName() != null || node.isLeaf())) {
                this.updateErrorLevel(node, showOptionsAndDescriptorPanels, level);
                SingleInspectionProfilePanel.updateUpHierarchy(parent);
                continue;
            }
            this.updateErrorLevelUpInHierarchy(level, showOptionsAndDescriptorPanels, node);
            SingleInspectionProfilePanel.updateUpHierarchy(parent);
        }
        if (rows != null) {
            this.updateOptionsAndDescriptionPanel(this.myTreeTable.getTree().getSelectionPaths());
        } else {
            this.initOptionsAndDescriptionPanel();
        }
        this.repaintTableData();
    }

    private void updateErrorLevelUpInHierarchy(@NotNull HighlightDisplayLevel level, boolean showOptionsAndDescriptorPanels, InspectionConfigTreeNode node) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel", "updateErrorLevelUpInHierarchy"));
        }
        node.dropCache();
        for (int j = 0; j < node.getChildCount(); ++j) {
            InspectionConfigTreeNode child = (InspectionConfigTreeNode)node.getChildAt(j);
            Object userObject = child.getUserObject();
            if (userObject instanceof ToolDescriptors && (child.getScopeName() != null || child.isLeaf())) {
                this.updateErrorLevel(child, showOptionsAndDescriptorPanels, level);
                continue;
            }
            this.updateErrorLevelUpInHierarchy(level, showOptionsAndDescriptorPanels, child);
        }
    }

    private void updateErrorLevel(InspectionConfigTreeNode child, boolean showOptionsAndDescriptorPanels, @NotNull HighlightDisplayLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel", "updateErrorLevel"));
        }
        HighlightDisplayKey key2 = child.getDefaultDescriptor().getKey();
        this.myProfile.setErrorLevel(key2, level, null, this.myProjectProfileManager.getProject());
        child.dropCache();
        if (showOptionsAndDescriptorPanels) {
            this.updateOptionsAndDescriptionPanel(new TreePath(child.getPath()));
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTreeTable;
    }

    private class MyFilterComponent
    extends FilterComponent {
        private MyFilterComponent() {
            super(SingleInspectionProfilePanel.INSPECTION_FILTER_HISTORY, 10);
        }

        public void filter() {
            SingleInspectionProfilePanel.this.filterTree(this.getFilter());
        }

        protected void onlineFilter() {
            if (SingleInspectionProfilePanel.this.myProfile == null) {
                return;
            }
            String filter = this.getFilter();
            SingleInspectionProfilePanel.getExpandedNodes(SingleInspectionProfilePanel.this.myProfile).saveVisibleState((Tree)SingleInspectionProfilePanel.this.myTreeTable.getTree());
            SingleInspectionProfilePanel.this.fillTreeData(filter, true);
            SingleInspectionProfilePanel.this.reloadModel();
            if (filter == null || filter.isEmpty()) {
                SingleInspectionProfilePanel.this.restoreTreeState();
            } else {
                TreeUtil.expandAll((JTree)SingleInspectionProfilePanel.this.myTreeTable.getTree());
            }
        }
    }
}

