/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project.model.impl.module.dependencies;

import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.model.JpsModelManager;
import com.intellij.project.model.impl.module.JpsRootModel;
import com.intellij.project.model.impl.module.dependencies.JpsExportableOrderEntry;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsCompositeElement;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.module.JpsLibraryDependency;
import org.jetbrains.jps.model.module.JpsModule;

public class JpsLibraryOrderEntry
extends JpsExportableOrderEntry<JpsLibraryDependency>
implements LibraryOrderEntry {
    public JpsLibraryOrderEntry(JpsRootModel rootModel, JpsLibraryDependency dependencyElement) {
        super(rootModel, dependencyElement);
    }

    public Library getLibrary() {
        JpsLibrary library = ((JpsLibraryDependency)this.myDependencyElement).getLibrary();
        if (library != null) {
            return null;
        }
        return JpsModelManager.getInstance(this.myRootModel.getProject()).getLibraryManager().getLibrary(library);
    }

    public String getLibraryName() {
        return ((JpsLibraryDependency)this.myDependencyElement).getLibraryReference().getLibraryName();
    }

    @NotNull
    public String getPresentableName() {
        String string = this.getLibraryName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsLibraryOrderEntry", "getPresentableName"));
        }
        return string;
    }

    @NotNull
    public VirtualFile[] getFiles(OrderRootType type2) {
        VirtualFile[] virtualFileArray = this.getRootFiles(type2);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsLibraryOrderEntry", "getFiles"));
        }
        return virtualFileArray;
    }

    @NotNull
    public String[] getUrls(OrderRootType rootType) {
        String[] stringArray = this.getRootUrls(rootType);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsLibraryOrderEntry", "getUrls"));
        }
        return stringArray;
    }

    @NotNull
    public VirtualFile[] getRootFiles(@NotNull OrderRootType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/project/model/impl/module/dependencies/JpsLibraryOrderEntry", "getRootFiles"));
        }
        Library library = this.getLibrary();
        VirtualFile[] virtualFileArray = library != null ? library.getFiles(type2) : VirtualFile.EMPTY_ARRAY;
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsLibraryOrderEntry", "getRootFiles"));
        }
        return virtualFileArray;
    }

    @NotNull
    public String[] getRootUrls(@NotNull OrderRootType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/project/model/impl/module/dependencies/JpsLibraryOrderEntry", "getRootUrls"));
        }
        Library library = this.getLibrary();
        String[] stringArray = library != null ? library.getUrls(type2) : ArrayUtil.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsLibraryOrderEntry", "getRootUrls"));
        }
        return stringArray;
    }

    public String getLibraryLevel() {
        JpsElementReference reference = ((JpsLibraryDependency)this.myDependencyElement).getLibraryReference().getParentReference();
        JpsCompositeElement parent = (JpsCompositeElement)reference.resolve();
        if (parent instanceof JpsGlobal) {
            return "application";
        }
        if (parent instanceof JpsProject) {
            return "project";
        }
        if (parent instanceof JpsModule) {
            return "module";
        }
        return "project";
    }

    public boolean isModuleLevel() {
        return "module".equals(this.getLibraryLevel());
    }

    public <R> R accept(RootPolicy<R> policy, @Nullable R initialValue) {
        return (R)policy.visitLibraryOrderEntry((LibraryOrderEntry)this, initialValue);
    }
}

