/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project.model.impl.module.dependencies;

import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.model.impl.module.JpsRootModel;
import com.intellij.project.model.impl.module.dependencies.JpsOrderEntry;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceDependency;

public class JpsModuleSourceOrderEntry
extends JpsOrderEntry<JpsModuleSourceDependency>
implements ModuleSourceOrderEntry {
    public JpsModuleSourceOrderEntry(JpsRootModel rootModel, JpsModuleSourceDependency dependencyElement) {
        super(rootModel, dependencyElement);
    }

    public <R> R accept(RootPolicy<R> policy, @Nullable R initialValue) {
        return (R)policy.visitModuleSourceOrderEntry((ModuleSourceOrderEntry)this, initialValue);
    }

    @NotNull
    public String getPresentableName() {
        String string = ProjectBundle.message((String)"project.root.module.source", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsModuleSourceOrderEntry", "getPresentableName"));
        }
        return string;
    }

    @NotNull
    public VirtualFile[] getFiles(OrderRootType type2) {
        if (OrderRootType.SOURCES.equals((Object)type2)) {
            VirtualFile[] virtualFileArray = this.getRootModel().getSourceRoots();
            if (virtualFileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsModuleSourceOrderEntry", "getFiles"));
            }
            return virtualFileArray;
        }
        if (VirtualFile.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsModuleSourceOrderEntry", "getFiles"));
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    @NotNull
    public String[] getUrls(OrderRootType type2) {
        ArrayList<String> result2 = new ArrayList<String>();
        if (OrderRootType.SOURCES.equals((Object)type2)) {
            ContentEntry[] content;
            for (ContentEntry contentEntry : content = this.getRootModel().getContentEntries()) {
                SourceFolder[] sourceFolders;
                for (SourceFolder sourceFolder : sourceFolders = contentEntry.getSourceFolders()) {
                    String url = sourceFolder.getUrl();
                    result2.add(url);
                }
            }
            String[] stringArray = ArrayUtil.toStringArray(result2);
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsModuleSourceOrderEntry", "getUrls"));
            }
            return stringArray;
        }
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsModuleSourceOrderEntry", "getUrls"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public ModuleRootModel getRootModel() {
        return this.myRootModel;
    }
}

