/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.projectImport;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.projectWizard.ImportFromSourcesProvider;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.projectImport.ProjectImportProvider;
import com.intellij.projectImport.ProjectImportWizardStep;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ImportChooserStep
extends ProjectImportWizardStep {
    private static final String PREFERRED = "create.project.preferred.importer";
    private final ProjectImportProvider[] myProviders;
    private final StepSequence mySequence;
    @Nullable
    private ProjectImportProvider myFromSourcesProvider;
    private JBList myList;
    private JPanel myPanel;
    private JBRadioButton myCreateFromSources;
    private JBRadioButton myImportFrom;

    public ImportChooserStep(ProjectImportProvider[] providers2, StepSequence sequence, final WizardContext context) {
        super(context);
        this.myProviders = providers2;
        this.mySequence = sequence;
        this.$$$setupUI$$$();
        this.myImportFrom.setText(ProjectBundle.message((String)"project.new.wizard.import.title", (Object[])new Object[]{context.getPresentationName()}));
        this.myCreateFromSources.setText(ProjectBundle.message((String)"project.new.wizard.from.existent.sources.title", (Object[])new Object[]{context.getPresentationName()}));
        DefaultListModel<ProjectImportProvider> model = new DefaultListModel<ProjectImportProvider>();
        for (ProjectImportProvider provider : ImportChooserStep.sorted(providers2)) {
            if (provider instanceof ImportFromSourcesProvider) {
                this.myFromSourcesProvider = provider;
                continue;
            }
            model.addElement(provider);
        }
        if (this.myFromSourcesProvider == null) {
            this.myCreateFromSources.setVisible(false);
        }
        this.myList.setModel(model);
        this.myList.setSelectionMode(0);
        this.myList.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list2, value2, index, isSelected, cellHasFocus);
                this.setText(((ProjectImportProvider)value2).getName());
                Icon icon = ((ProjectImportProvider)value2).getIcon();
                this.setIcon(icon);
                this.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon));
                return rendererComponent;
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ImportChooserStep.this.myImportFrom.isSelected()) {
                    IdeFocusManager.getInstance((Project)context.getProject()).requestFocus((Component)ImportChooserStep.this.myList, false);
                }
                ImportChooserStep.this.updateSteps();
            }
        };
        this.myImportFrom.addActionListener(actionListener);
        this.myCreateFromSources.addActionListener(actionListener);
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ImportChooserStep.this.updateSteps();
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                context.requestNextStep();
                return true;
            }
        }.installOn((Component)this.myList);
    }

    public void updateStep() {
        if (this.myList.getSelectedValue() != null) {
            return;
        }
        String id = PropertiesComponent.getInstance().getValue(PREFERRED);
        if (id == null || this.myFromSourcesProvider != null && id.equals(this.myFromSourcesProvider.getId())) {
            this.myCreateFromSources.setSelected(true);
        } else {
            this.myImportFrom.setSelected(true);
            for (ProjectImportProvider provider : this.myProviders) {
                if (!Comparing.strEqual((String)provider.getId(), (String)id)) continue;
                this.myList.setSelectedValue((Object)provider, true);
                break;
            }
        }
        if (this.myList.getSelectedValue() == null) {
            this.myList.setSelectedIndex(0);
        }
    }

    private void updateSteps() {
        this.myList.setEnabled(this.myImportFrom.isSelected());
        ProjectImportProvider provider = this.getSelectedProvider();
        if (provider != null) {
            this.mySequence.setType(provider.getId());
            PropertiesComponent.getInstance().setValue(PREFERRED, provider.getId());
            this.getWizardContext().requestWizardButtonsUpdate();
        }
    }

    private static List<ProjectImportProvider> sorted(ProjectImportProvider[] providers2) {
        ArrayList<ProjectImportProvider> result2 = new ArrayList<ProjectImportProvider>();
        Collections.addAll(result2, providers2);
        Collections.sort(result2, (l, r) -> l.getName().compareToIgnoreCase(r.getName()));
        return result2;
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCreateFromSources.isSelected() ? this.myCreateFromSources : this.myList;
    }

    public void updateDataModel() {
        ProjectImportProvider provider = this.getSelectedProvider();
        if (provider != null) {
            this.mySequence.setType(provider.getId());
            ProjectImportBuilder builder = provider.getBuilder();
            this.getWizardContext().setProjectBuilder((ProjectBuilder)builder);
            builder.setUpdate(this.getWizardContext().getProject() != null);
        }
    }

    private ProjectImportProvider getSelectedProvider() {
        ProjectImportProvider provider = this.myCreateFromSources.isSelected() ? this.myFromSourcesProvider : (ProjectImportProvider)this.myList.getSelectedValue();
        return provider;
    }

    public String getName() {
        return "Choose External Model";
    }

    @NonNls
    public String getHelpId() {
        return "reference.dialogs.new.project.import";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBList jBList;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCreateFromSources = jBRadioButton2 = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton2, ResourceBundle.getBundle("messages/ProjectBundle").getString("project.new.wizard.from.existent.sources.title"));
        jPanel.add((Component)jBRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myImportFrom = jBRadioButton = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton, ResourceBundle.getBundle("messages/ProjectBundle").getString("project.new.wizard.import.title"));
        jPanel.add((Component)jBRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0), null, 0, 0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myList = jBList = new JBList();
        jBScrollPane.setViewportView((Component)jBList);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add((AbstractButton)jBRadioButton2);
        buttonGroup2.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

