/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.file.PsiBinaryFileImpl;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

public class ClassFileViewProvider
extends SingleRootFileViewProvider {
    private static final Key<Boolean> IS_INNER_CLASS = Key.create((String)"java.is.inner.class.key");

    public ClassFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file2) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/ClassFileViewProvider", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/ClassFileViewProvider", "<init>"));
        }
        this(manager, file2, true);
    }

    public ClassFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file2, boolean eventSystemEnabled) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/ClassFileViewProvider", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/ClassFileViewProvider", "<init>"));
        }
        super(manager, file2, eventSystemEnabled, (Language)JavaLanguage.INSTANCE, JavaClassFileType.INSTANCE);
    }

    @Override
    protected PsiFile createFile(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull FileType fileType) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/ClassFileViewProvider", "createFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/ClassFileViewProvider", "createFile"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/psi/ClassFileViewProvider", "createFile"));
        }
        FileIndexFacade fileIndex = (FileIndexFacade)ServiceManager.getService((Project)project2, FileIndexFacade.class);
        if (!fileIndex.isInLibraryClasses(file2) && fileIndex.isInSource(file2)) {
            return new PsiBinaryFileImpl((PsiManagerImpl)this.getManager(), this);
        }
        try {
            if (!ClassFileViewProvider.isInnerClass(file2)) {
                return new ClsFileImpl(this);
            }
        }
        catch (Exception e) {
            Logger.getInstance(ClassFileViewProvider.class).debug(file2.getPath(), (Throwable)e);
        }
        return null;
    }

    public static boolean isInnerClass(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/ClassFileViewProvider", "isInnerClass"));
        }
        return ClassFileViewProvider.detectInnerClass(file2, null);
    }

    public static boolean isInnerClass(@NotNull VirtualFile file2, @NotNull byte[] content) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/ClassFileViewProvider", "isInnerClass"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/psi/ClassFileViewProvider", "isInnerClass"));
        }
        return ClassFileViewProvider.detectInnerClass(file2, content);
    }

    private static boolean detectInnerClass(VirtualFile file2, @Nullable byte[] content) {
        String name2 = file2.getNameWithoutExtension();
        int p = name2.lastIndexOf(36, name2.length() - 2);
        if (p <= 0) {
            return false;
        }
        Boolean isInner = (Boolean)IS_INNER_CLASS.get((UserDataHolder)file2);
        if (isInner != null) {
            return isInner;
        }
        if (content == null) {
            try {
                content = file2.contentsToByteArray(false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ClassReader reader = new ClassReader(content);
        final Ref ref = Ref.create((Object)Boolean.FALSE);
        final String className = reader.getClassName();
        reader.accept(new ClassVisitor(393216){

            public void visitOuterClass(String owner2, String name2, String desc) {
                ref.set((Object)Boolean.TRUE);
            }

            public void visitInnerClass(String name2, String outer, String inner, int access) {
                if (className.equals(name2)) {
                    ref.set((Object)Boolean.TRUE);
                }
            }
        }, ClsFileImpl.EMPTY_ATTRIBUTES, 7);
        isInner = (Boolean)ref.get();
        IS_INNER_CLASS.set((UserDataHolder)file2, (Object)isInner);
        return isInner;
    }

    @Override
    @NotNull
    public SingleRootFileViewProvider createCopy(@NotNull VirtualFile copy) {
        if (copy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copy", "com/intellij/psi/ClassFileViewProvider", "createCopy"));
        }
        ClassFileViewProvider classFileViewProvider = new ClassFileViewProvider(this.getManager(), copy, false);
        if (classFileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/ClassFileViewProvider", "createCopy"));
        }
        return classFileViewProvider;
    }

    @Override
    public PsiElement findElementAt(int offset) {
        return this.findElementAt(offset, this.getBaseLanguage());
    }

    @Override
    public PsiElement findElementAt(int offset, @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/ClassFileViewProvider", "findElementAt"));
        }
        PsiFile file2 = this.getPsi(language);
        if (file2 instanceof PsiCompiledFile) {
            file2 = ((PsiCompiledFile)file2).getDecompiledPsiFile();
        }
        return ClassFileViewProvider.findElementAt((PsiElement)file2, offset);
    }

    @Override
    public PsiReference findReferenceAt(int offset) {
        return this.findReferenceAt(offset, this.getBaseLanguage());
    }

    @Override
    @Nullable
    public PsiReference findReferenceAt(int offset, @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/ClassFileViewProvider", "findReferenceAt"));
        }
        PsiFile file2 = this.getPsi(language);
        if (file2 instanceof PsiCompiledFile) {
            file2 = ((PsiCompiledFile)file2).getDecompiledPsiFile();
        }
        return ClassFileViewProvider.findReferenceAt(file2, offset);
    }
}

