/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.engine;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementCallback;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementMoveInfo;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RestoreFoldArrangementCallback
implements ArrangementCallback {
    @NotNull
    private final Editor myEditor;

    public RestoreFoldArrangementCallback(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/codeStyle/arrangement/engine/RestoreFoldArrangementCallback", "<init>"));
        }
        this.myEditor = editor;
    }

    @Override
    public void afterArrangement(@NotNull List<ArrangementMoveInfo> moveInfos) {
        if (moveInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moveInfos", "com/intellij/psi/codeStyle/arrangement/engine/RestoreFoldArrangementCallback", "afterArrangement"));
        }
        Project project2 = this.myEditor.getProject();
        if (project2 != null) {
            FoldRegion[] regions = this.myEditor.getFoldingModel().getAllFoldRegions();
            ArrayList<FoldRegionInfo> foldRegionsInfo = new ArrayList<FoldRegionInfo>();
            for (FoldRegion region : regions) {
                FoldRegionInfo info = new FoldRegionInfo(region.getStartOffset(), region.getEndOffset(), region.isExpanded());
                foldRegionsInfo.add(info);
            }
            CodeFoldingManager foldingManager = CodeFoldingManager.getInstance(project2);
            foldingManager.updateFoldRegions(this.myEditor);
            this.myEditor.getFoldingModel().runBatchFoldingOperation(() -> {
                for (FoldRegionInfo info : foldRegionsInfo) {
                    FoldRegion foldRegion = foldingManager.findFoldRegion(this.myEditor, info.myStart, info.myEnd);
                    if (foldRegion == null) continue;
                    foldRegion.setExpanded(info.myIsExpanded);
                }
            });
        }
    }

    private static class FoldRegionInfo {
        private int myStart;
        private int myEnd;
        private boolean myIsExpanded;

        private FoldRegionInfo(int start, int end, boolean expanded) {
            this.myStart = start;
            this.myEnd = end;
            this.myIsExpanded = expanded;
        }
    }
}

