/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.controlFlow.BranchingInstruction;
import com.intellij.psi.controlFlow.CallInstruction;
import com.intellij.psi.controlFlow.ControlFlowInstructionVisitor;
import com.intellij.psi.controlFlow.ControlFlowStack;
import com.intellij.psi.controlFlow.GoToInstruction;
import org.jetbrains.annotations.NotNull;

public class ReturnInstruction
extends GoToInstruction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.controlFlow.ReturnInstruction");
    private final ControlFlowStack myStack;
    private CallInstruction myCallInstruction;
    private boolean myRethrowFromFinally;

    public ReturnInstruction(int offset, @NotNull ControlFlowStack stack, CallInstruction callInstruction) {
        if (stack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stack", "com/intellij/psi/controlFlow/ReturnInstruction", "<init>"));
        }
        super(offset, BranchingInstruction.Role.END, false);
        this.myStack = stack;
        this.myCallInstruction = callInstruction;
    }

    @Override
    public String toString() {
        return "RETURN FROM " + this.getProcBegin() + (this.offset == 0 ? "" : " TO " + this.offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(boolean pushBack) {
        ControlFlowStack controlFlowStack = this.myStack;
        synchronized (controlFlowStack) {
            int jumpTo = -1;
            if (this.myStack.size() != 0) {
                jumpTo = this.myStack.pop(pushBack);
            }
            if (this.offset != 0) {
                jumpTo = this.offset;
            }
            return jumpTo;
        }
    }

    @NotNull
    public int[] getPossibleReturnOffsets() {
        int[] nArray;
        if (this.offset == 0) {
            int[] nArray2 = new int[3];
            nArray2[0] = this.getProcBegin() - 5;
            nArray2[1] = this.getProcBegin() - 3;
            nArray = nArray2;
            nArray2[2] = this.getProcBegin() - 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = this.offset;
        }
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ReturnInstruction", "getPossibleReturnOffsets"));
        }
        return nArray;
    }

    public int getProcBegin() {
        return this.myCallInstruction.procBegin;
    }

    public int getProcEnd() {
        return this.myCallInstruction.procEnd;
    }

    public void setCallInstruction(CallInstruction callInstruction) {
        this.myCallInstruction = callInstruction;
    }

    @Override
    public int nNext() {
        return this.offset == 0 ? 3 : 1;
    }

    @Override
    public int getNext(int index, int no) {
        if (this.offset == 0) {
            switch (no) {
                case 0: {
                    return this.getProcBegin() - 5;
                }
                case 1: {
                    return this.getProcBegin() - 3;
                }
                case 2: {
                    return this.getProcBegin() - 1;
                }
            }
            LOG.assertTrue(false);
            return -1;
        }
        switch (no) {
            case 0: {
                return this.offset;
            }
        }
        LOG.assertTrue(false);
        return -1;
    }

    @Override
    public void accept(ControlFlowInstructionVisitor visitor, int offset, int nextOffset) {
        visitor.visitReturnInstruction(this, offset, nextOffset);
    }

    public ControlFlowStack getStack() {
        return this.myStack;
    }

    public void setRethrowFromFinally() {
        this.myRethrowFromFinally = true;
    }

    public boolean isRethrowFromFinally() {
        return this.myRethrowFromFinally;
    }
}

