/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.getters;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import gnu.trove.THashSet;
import org.jetbrains.annotations.NotNull;

public class ExpectedTypesGetter {
    @NotNull
    public static PsiType[] getExpectedTypes(PsiElement context, boolean defaultTypes) {
        PsiExpression expression2 = (PsiExpression)PsiTreeUtil.getContextOfType((PsiElement)context, PsiExpression.class, (boolean)true);
        if (expression2 == null) {
            if (PsiType.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/filters/getters/ExpectedTypesGetter", "getExpectedTypes"));
            }
            return PsiType.EMPTY_ARRAY;
        }
        PsiType[] psiTypeArray = ExpectedTypesGetter.extractTypes(ExpectedTypesProvider.getExpectedTypes(expression2, true), defaultTypes);
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/filters/getters/ExpectedTypesGetter", "getExpectedTypes"));
        }
        return psiTypeArray;
    }

    @NotNull
    public static PsiType[] extractTypes(ExpectedTypeInfo[] infos, boolean defaultTypes) {
        THashSet result2 = new THashSet(infos.length);
        for (ExpectedTypeInfo info : infos) {
            PsiType type2 = info.getType();
            PsiType defaultType = info.getDefaultType();
            if (!defaultTypes && !defaultType.equals(type2)) {
                result2.add(type2);
            }
            result2.add(defaultType);
        }
        PsiType[] psiTypeArray = result2.toArray(PsiType.createArray((int)result2.size()));
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/filters/getters/ExpectedTypesGetter", "extractTypes"));
        }
        return psiTypeArray;
    }
}

