/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.position;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.ReflectionUtil;

public class TokenTypeFilter
implements ElementFilter {
    private final IElementType myType;

    public TokenTypeFilter(IElementType type2) {
        this.myType = type2;
    }

    public boolean isClassAcceptable(Class hintClass) {
        return ReflectionUtil.isAssignable(PsiDocToken.class, (Class)hintClass) || ReflectionUtil.isAssignable(XmlToken.class, (Class)hintClass);
    }

    public boolean isAcceptable(Object element, PsiElement context) {
        if (element instanceof PsiElement) {
            ASTNode node = ((PsiElement)element).getNode();
            return node != null && node.getElementType() == this.myType;
        }
        if (element instanceof ASTNode) {
            return ((ASTNode)element).getElementType() == this.myType;
        }
        return false;
    }

    public String toString() {
        return "token-type(" + this.myType + ")";
    }
}

